/*
 * tnmWinPort.h --
 *
 *	This header file handles porting issues that occur because of
 *	differences between Windows and Unix. It should be the only
 *	file that contains #ifdefs to handle different flavors of OS.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNMWINPORT
#define _TNMWINPORT

#ifndef _TNMINT
#include "tnmInt.h"
#endif

/*
 * The default directory name where we will find the tnm library
 * files. This is normally overwritten in the Makefile.
 */

#ifndef TNMLIB
#define TNMLIB "c:/tcl/lib/tnm2.1.11"
#endif

#ifndef TKINEDLIB
#define TKINEDLIB "c:/tcl/lib/tkined1.4.11"
#endif

/*
 *----------------------------------------------------------------
 * Windows related defines and includes.
 *----------------------------------------------------------------
 */

#define WORDS_BIGENDIAN
#define HAVE_RPCENT

#include <malloc.h>
#include <stdio.h>

#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <time.h>

#include <io.h>
#include <winsock.h>

#ifndef IN_CLASSD
#define	IN_CLASSD(i)		(((long)(i) & 0xf0000000) == 0xe0000000)
#endif

/*
 *----------------------------------------------------------------
 * Windows does not define the access modes - we add them here.
 *----------------------------------------------------------------
 */

#ifndef F_OK
#define F_OK 00
#endif
#ifndef X_OK
#define X_OK 01
#endif
#ifndef W_OK
#define W_OK 02
#endif
#ifndef R_OK
#define R_OK 04
#endif

/*
 *----------------------------------------------------------------
 * A define that we use to create Tcl_File handles on sockets.
 *----------------------------------------------------------------
 */

#define TNM_SOCKET_FD	TCL_WIN_SOCKET

#endif /* _TNMWINPORT */
