/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Print Personal Schedule
 *
 *	% frsch [-[month/]day] [user ... | -f schedule ...]
 *		month, day -- print start date
 *		schedule   -- schedule data dase file [$HOME/.schrc]
 *
 *	Author	Masatoshi Kurihara
 *	Date	Tue Oct 29 14:49:25 JST 1985
 *	Office	Software Tools and Technology Group
 *		Software Research Associates, Inc.
 *		1-1-1 Hirakawa-cho Chiyoda-ku Tokyo, Japan
 *		03 (234) 2611 ext 153
 *		03 (234) 2615 (night only)
 *	Home	Waseda House 2A 
 *		1-9-22 Nishiwaseda Shinjuku-ku Tokyo, Japan
 *		03 (208) 3875
 *
 *	Copyright (C) 1985 - 1989 by Software Research Associates, Inc.
 */

static	char	sccsid[] = "@(#)frsch.c\t1.0 (SRA) 10/29/85";

#include <sys/types.h>
#include <pwd.h>
#include <err.h>
#include <common.h>

#include <entry.h>

#define	MAXCHR	160
#define	COLMON	0
#define	COLDAY	3
#define	COLMSG	35
#define POSBEG	7
#define	POSEND	13

#define	VT100GR	"\033(0"
#define	VT100TX	"\033(B"
#define	VT100SO	"\033[7m"
#define	VT100SE	"\033[0m"
#define	FNAME	"/.schrc"

#define	V1 "lqqqqqqqqqqqqqwqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqqqwqk"
#define	V2 "x  DATE/TIME  x 9  10  11  12   1   2   3   4   5   6   7   8   9 x"
#define	V3 "tqqqqqqqqqqqqqnqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqqqvqu"
#define	V4 "mqqqqqqqqqqqqqvqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqj"
#define	H1 "+-----------------------------------------------------------------+"
#define	H2 "|  date/time | 9  10  11  12   1   2   3   4   5   6   7   8   9 |"
#define	H3 "|-------------+-*---*---*---*---*---*---*---*---*---*---*---*---*-|"
#define	H4 "+-----------------------------------------------------------------+"
#define	FM "| %2d/%2d (%3s) |                                                   |"

/*
 * Print Personal Schedule
 *
 *	% frsch [-d [month/]day] [user ... | -f schedule ...]
 */

static void
usage()
{
	fprintf(stderr, "usage: frsch [-d month[/day]] "
		"[user ... | -f file ...]\n");
}

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct tm *tm;
	struct passwd *pwd;
	FILE *schfile;
	char *pch;
	int cnt, cntuser, indch, indCH, mon, day, sunday, today;
	int stmon, stday, edmon, edday, stpos, edpos;
	char getbuf[MAXCHR];
	char timetbl[8][80], usertbl[30][20], filetbl[20][80];
	time_t ltime;
	int vt100 = 0, maxuser = 0;
	static int montbl[] =
		{ 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 30, 31, 0 };
	static char *week[] =
		{ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
	struct sch *sch;
	int filever;
	int ch;
	extern char *optarg;
	extern int optind;
	int fileargs = 0;

	/*
	 * Date Set
	 */
	time(&ltime);
	tm = localtime(&ltime);
	if (! (tm->tm_year % 4) && (tm->tm_year % 400))
		montbl[2]++;

	stmon = tm->tm_mon + 1;
	stday = tm->tm_mday + 1;
	while ((ch = getopt(argc, argv, "d:f")) != EOF) {
		switch (ch) {
		case 'd':
			if (sscanf(optarg, "%d/%d", &stmon, &stday) == 2)
				break;
			if (sscanf(optarg, "%d", &stday) == 1) {
				stmon = tm->tm_mon + 1;
				break;
			}
			errx(1, "bad date %s", optarg);
			/*NOTREACHED*/
		case 'f':
			fileargs = 1;
			break;
		default:
			usage();
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;

	for (today = 0, cnt = 1; cnt < stmon; cnt++)
		today += montbl[cnt];
	if ((today += stday) > (sunday = tm->tm_yday - tm->tm_wday + 1))
		for (; today > sunday + 6; sunday += 7) ;
	else
		for (; today < sunday; sunday -= 7) ;
	if (sunday < 1) {
		fprintf(stderr, "frsch: can't print first week on Janualy.\n");
		exit(1);
	}
	for (stmon = 1, cnt = montbl[1]; cnt < sunday; cnt += montbl[++stmon]) ;
	stday = sunday - (cnt - montbl[stmon]);
	if (stday + 7 > montbl[stmon]) {
		edmon = stmon + 1;
		edday = 6 - (montbl[stmon] - stday);
	} else {
		edmon = stmon;
		edday = stday + 6;
	}

	/*
	 * File Set
	 */
	if (argc == 0) {
		usage();
		exit(1);
	}
	if (fileargs) {
		while (*argv != NULL) {
			strcpy(filetbl[maxuser], *argv);
			if ((pch = rindex(*argv, '/')) != NULL)
				strcpy(usertbl[maxuser], pch);
			else
				strcpy(usertbl[maxuser], *argv);
			argv++;
			maxuser++;
		}
	} else {
		cnt = 0;
		while (*argv != NULL) {
			if ((pwd = getpwnam(*argv)) != NULL) {
				strcpy(filetbl[maxuser], pwd->pw_dir);
				strcat(filetbl[maxuser], FNAME);
				strcpy(usertbl[maxuser], *argv);
			} else {
				errx(1, "unknown user %s", *argv);
				/*NOTREACHED*/
			}

			argv++;
			maxuser++;
		}
	}
	endpwent();

#ifdef	SRA
	/*
	 * Terminal Set
	 */
#define	VT(x) (! strcmp (term, x))
	term = getenv("TERM");
	if (VT ("d0" ) || VT ("ds" ) || VT ("d0b") || VT ("d0s") ||
	    VT ("dsb") || VT ("d2" ) || VT ("d2b") || VT ("d2s") ||
	    VT ("d2sb")|| VT("vt100")|| VT("vt220"))
		vt100++;
#endif

	/*
	 * Table Initialize
	 */
	for (mon = stmon, day = stday, cnt = 0; cnt < 7; cnt++) {
		sprintf(timetbl[cnt], FM, mon, day, week[cnt]);
		if (++day > montbl[mon]) {
			if (++mon > 12)
				mon = 1;
			day = 1;
		}
	}

	/*
	 * File Open
	 */
	for (cntuser = 0; cntuser < maxuser; cntuser++) {
		if ((schfile = fopen (filetbl[cntuser], "r")) == NULL) {
			fprintf(stderr, "frsch: can't open %s.\n",
				 filetbl[cntuser]);
			exit(1);
		}

		/*
		 * Get Data
		 */
		filever = 0;
		while (fgets (getbuf, MAXCHR, schfile)) {
			/*
			 * Check Date
			 */
			if ((pch = index (getbuf, '\n')) != NULL)
				*pch = NULL;

			if (filever == 0) {
				sch = sch_oparse(getbuf);
				if (sch == NULL)
					filever = 1;
			}
			if (filever == 1)
				sch = sch_parse(getbuf);

			if (sch == NULL)
				continue;

			mon = sch->month;
			day = sch->day;
			if (mon > edmon || (mon == edmon && day > edday))
				break;
			if (mon < stmon || (mon == stmon && day < stday))
				continue;

			/*
			 * Time Set
			 */
			if (mon > stmon)
				today = day + (montbl[stmon] - stday);
			else
				today = day - stday;
			stpos = 16 + (sch->sthour - 9) * 4 + (sch->stmin) / 15;
			edpos = 16 + (sch->enhour - 9) * 4 + (sch->enmin) / 15;

			/*
			 * Time and Message Save
			 */
			if (stpos >= 16) {
				indch = 'a' + cntuser;
				indCH = 'A' + cntuser;
				for (cnt = stpos; cnt < edpos; cnt++)
					if (timetbl[today][cnt] == ' ')
						timetbl[today][cnt] = indch;
					else
						timetbl[today][cnt] = indCH;
			}

			free(sch);
		}
		fclose(schfile);
	}

	/*
	 * Print Schedule
	 */
	if (vt100) {
		fputs(VT100GR, stdout);
		puts(V1);
		puts(V2);
		puts(V3);
		fputs(VT100TX, stdout);
		for (cnt = 0; cnt < 7; cnt++) {
			for (pch = timetbl[cnt]; *pch; pch++) {
				if (*pch == '|') {
					fputs(VT100GR, stdout);
					putchar('x');
					fputs(VT100TX, stdout);
				}
				else
					putchar(*pch);
			}
			putchar('\n');
		}
		fputs(VT100GR, stdout);
		puts(V4);
		fputs(VT100TX, stdout);
	}
	else {
		puts(H1);
		puts(H2);
		puts(H3);
		for (cnt = 0; cnt < 7; cnt++)
			puts(timetbl[cnt]);
		puts(H4);
	}
	putchar('\n');

	/*
	 * Print Message
	 */
	for (cnt = 0; cnt < maxuser; cnt++) {
		printf("%c: %-30.30s", 'a' + cnt, usertbl[cnt]);
		if (++cnt < maxuser)
			printf("   %c: %-30.30s\n", 'a' + cnt, usertbl[cnt]);
		else
			putchar('\n');
	}

	exit(0);
}
