/* 
 * OroboROX Window Manager
 * xinerama functions
 *
 * Copyright (C) 2004 Tony Houghton
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#ifndef __XINERAMA_H
#define __XINERAMA_H

#include "config.h"

#ifndef HAVE_XFREE_XINERAMA
typedef struct {
	int screen_number;
	short x_org;
	short y_org;
	short width;
	short height;
} XineramaScreenInfo;
#endif

/* Must be called as soon as display & screen have been initialised and when we
 * get Xrandr configure events */
void xinerama_cache_screen_info(void);

extern int xinerama_nscreens;

#ifdef HAVE_XINERAMA

#ifdef HAVE_XFREE_XINERAMA
#include <X11/extensions/Xinerama.h>
#define XINERAMA_IS_ACTIVE() XineramaIsActive(dpy)
#elif defined HAVE_SOLARIS_XINERAMA
#include <X11/extensions/xinerama.h>
#define XINERAMA_IS_ACTIVE() XineramaGetState(dpy, screen)
#endif

/* Returns 0 if Xinerama is not active or there's no monitor under point */
int xineramaGetMonitorUnderPoint(int mx, int my);

#else /* ! HAVE_XINERAMA */

#define xineramaGetMonitorUnderPoint(mx, my) 0

#endif /* HAVE_XINERAMA */

/* If Xinerama isn't enabled this still contains one valid entry and
 * xinerama_nscreens == 1 */
extern XineramaScreenInfo *xinerama_screen_info;

#endif /* __XINERAMA_H */

/***This must remain at the end of the file.***********************************************
 * vi:set sw=2 cindent cinoptions={1s,>2s,^-1s,n-1s foldmethod=marker foldmarker=,: *
 ******************************************************************************************/
