/* 
 *  Matchbox Window Manager - A lightweight window manager not for the
 *                            desktop.
 *
 *  Authored By Matthew Allum <mallum@o-hand.com>
 *
 *  Copyright (c) 2002, 2004 OpenedHand Ltd - http://o-hand.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 */

#ifndef _XERROR_H_
#define _XERROR_H_

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <X11/Xlib.h>

#ifdef DEBUG
#define dbg(txt, args... ) fprintf(stderr, "WM-DEBUG: " txt, ##args )
#else
#define dbg(txt, args... ) /* nothing */
#endif

void err(const char *fmt, ...);

int 
handle_xerror(Display *dpy, XErrorEvent *e);

int 
ignore_xerror(Display *dpy, XErrorEvent *e);

void 
misc_trap_xerrors(void);

int 
misc_untrap_xerrors(void);

#endif

