%{
#include <stdio.h>
#include <strings.h>
#include "netconfig.h"

extern struct icmp_item *ICMP_Send;
extern struct icmp_item *ICMP_Recv;
extern struct udp_item *UDP_Send;
extern struct udp_item *UDP_Recv;
extern struct tcp_item *TCP_Send;
extern struct tcp_item *TCP_Recv;
extern u_short ConfigNum;

/* Fields that might be set */
u_long sport=-1, dport=-1, seq=-1, id=-1, type=-1, code=-1, ack=-1, win=-1;
u_long nmatch=-1;

/* Data in the packet */
char *data;

/* Name of current ddos we're working on */
char ddos_name[BUFSIZE];

extern int errno;
%}

%union {
	char *string;
	u_short us;
	u_long ul;
}

%token START END SEND RECV
/* Must define the next two lines still */
%token ICMP UDP TCP
%token <ul> SPORT DPORT SEQ ID TYPE CODE DATA ACK WIN NMATCH
%token <string> QSTRING
%%
ddoses:	/* empty */
	| ddoses ddos
	;
ddos:	ddos_name ddos_contents ddos_terminator
	| ddos_name ddos_terminator
	;
ddos_contents: ddos_content 
	| ddos_contents ddos_content
	;
ddos_content: SEND proto_icmp { 
			add_icmp(&ICMP_Send); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		  }
	| SEND proto_tcp {
			add_tcp(&TCP_Send); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		}
	| SEND proto_udp {
			add_udp(&UDP_Send); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		}
	| RECV proto_udp {
			add_udp(&UDP_Recv); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		}
	| RECV proto_tcp {
			add_tcp(&TCP_Recv); data=NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		}
	| RECV proto_icmp {
			add_icmp(&ICMP_Recv); data=NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
	}
	;
proto_icmp: ICMP icmp_options 
	;
icmp_options: /* empty */
	| icmp_options icmp_option
	;
icmp_option: SEQ QSTRING { seq = atoi($2); }
	| ID QSTRING { id = atoi($2); }
	| TYPE QSTRING { type = atoi($2); }
	| CODE QSTRING { code = atoi($2); }
	| DATA QSTRING { 
	      data = malloc(strlen($2) * (sizeof(char))); 
	      if(data == NULL){
		  fprintf(stderr, "malloc error. *aborting*\n");
		  exit(FAILURE);
	      }
	     strcpy(data, $2);
	  }
	| NMATCH QSTRING { nmatch = atoi($2); }
	;
proto_udp: UDP udp_options
	;
udp_options: /* empty */
	| udp_options udp_option
	;
udp_option: SPORT QSTRING { sport = atoi($2); }
	| DPORT QSTRING { dport = atoi($2); }
	| DATA QSTRING {
		data = malloc(strlen($2) * (sizeof(char)));
		if(data == NULL){
			fprintf(stderr, "malloc error. *aborting*\n");
			exit(FAILURE);
		}
		strcpy(data, $2);
	}
	| NMATCH QSTRING { nmatch = atoi($2); }
	;
proto_tcp: TCP tcp_options
	;
tcp_options: /* empty */
	| tcp_options tcp_option
	;
tcp_option: SPORT QSTRING { sport = atoi($2); }
	| DPORT QSTRING { dport = atoi($2); }
	| DATA QSTRING {
		data = malloc(strlen($2) * (sizeof(char)));
		if(data == NULL){
			fprintf(stderr, "malloc error. *aborting*\n");
			exit(FAILURE);
		}
		strcpy(data, $2);
	}
	| NMATCH QSTRING { nmatch = atoi($2); }
	;
ddos_name: START QSTRING  { strncpy(ddos_name, ($2), sizeof(ddos_name)); }
	;
ddos_terminator: END QSTRING { ConfigNum++; 
	    bzero(ddos_name, sizeof(ddos_name));
	}
	;
%%

add_icmp(struct icmp_item **Head)
{
  struct icmp_item *current = malloc(sizeof(struct icmp_item));
  if(current==NULL){
	perror("malloc failed. aborting.\n");
	exit(FAILURE);
  }

 current->string = data;
 strncpy(current->name, ddos_name, BUFSIZE-1);
 current->type = type;
 current->id = id;
 current->code = code;
 current->seq = seq;
 current->nmatch = nmatch;
 current->Next = NULL;

 if(*Head == NULL){
   *Head = current;
 } else {
   current->Next = *Head;
   *Head = current;
 }
}

add_udp(struct udp_item **Head)
{
 struct udp_item *current = malloc(sizeof(struct udp_item));
 if(current==NULL){
    perror("malloc failed. *aborting*\n");
	exit(FAILURE);
 }
 current->sport = sport;
 current->dport = dport;
 strncpy(current->name, ddos_name, BUFSIZE-1);
 current->string = data;
 current->nmatch=nmatch;
 current->Next = NULL;
 if(*Head == NULL){
	*Head = current;
 } else {
   current->Next = *Head;
   *Head = current;
 }
}

add_tcp(struct tcp_item **Head)
{
 struct tcp_item *current = malloc(sizeof(struct tcp_item));
 if(current==NULL){
    perror("malloc failed. *aborting*\n");
	exit(FAILURE);
 }
 current->sport = sport;
 current->dport = dport;
 strncpy(current->name, ddos_name, BUFSIZE-1);
 current->string = data;
 current->nmatch=nmatch;
 current->Next = NULL;
 if(*Head == NULL){
	*Head = current;
 } else {
   current->Next = *Head;
   *Head = current;
 }
}

int yyerror(char *msg)
{
	fprintf(stderr, "rid config file error: %s\n", msg);
	exit(0);
}
