/*
 * nasd_linux_drive_colocate.c
 *
 * NASD Drive Linux Kernel Module with
 * colocation for clients
 *
 * Authors: Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999,2000.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if defined(LINUX) && defined(KERNEL) && defined(MODULE) /* should always be */

#include <linux/module.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_pdrive_client_colocate.h>

#define NASD_EXPORT_SYMBOL(_symname_) EXPORT_SYMBOL(_symname_)

#include <nasd/nasd_linux_drive_syms.ver.h>

MODULE_AUTHOR("Jim Zelenka <jimz+@cs.cmu.edu>");
MODULE_DESCRIPTION("NASD Drive with Colocation");

extern int nasd_linux_psrv_go(nasd_svinfo_t *, void *);

/* It's well-named. Really. */
extern void nasd_od_linux_evil_init(void);

/*
 * Yes, incrementing the mod count here means that if the drive
 * crashes, you can't unload the module. If we didn't, when the
 * drive crashed, unloading the module would hang the kernel.
 * ("Experimental evidence".) So don't bother trying.
 */

void
nasd_linux_drive_module_start()
{
  MOD_INC_USE_COUNT;
}

void
nasd_linux_drive_module_stop()
{
  MOD_DEC_USE_COUNT;
}

nasd_status_t
nasd_cl_colocate_linux_bind(
  nasd_drive_handle_t   handle,
  char                 *drive_name,
  char                 *portnum,
  int                   binding_type,
  void                 *binding_param,
  int                   binding_param_len)
{
  MOD_INC_USE_COUNT;
  return(NASD_SUCCESS);
}

nasd_status_t
nasd_cl_colocate_linux_unbind(
  nasd_drive_handle_t  handle)
{
  MOD_DEC_USE_COUNT;
  return(NASD_SUCCESS);
}

nasd_cl_p_rpcmod_tab_t nasd_cl_colocate_linux_mod = {
  NULL,
  NASD_RPCMOD_INIT_FAIL,

  nasd_cl_colocate_linux_bind,
  nasd_cl_colocate_linux_unbind,

  nasd_cl_colocate_null_dr,
  nasd_cl_colocate_sync_dr,
  nasd_cl_colocate_part_creat_dr,
  nasd_cl_colocate_getattr_dr,
  nasd_cl_colocate_write_simple_dr,
  NULL,
  nasd_cl_colocate_read_simple_dr,
  NULL,
  nasd_cl_colocate_tread_simple_dr,
  NULL,
  nasd_cl_colocate_flush_obj_dr,
  nasd_cl_colocate_eject_obj_dr,
  nasd_cl_colocate_remove_dr,
  nasd_cl_colocate_initialize_dr,
  nasd_cl_colocate_strt_iread_dr,
  nasd_cl_colocate_stop_iread_dr,
  nasd_cl_colocate_rshutdown_dr,
  nasd_cl_colocate_getinfo_dr,

  nasd_cl_colocate_remote_attach_dr,
  nasd_cl_colocate_remote_detach_dr,
  nasd_cl_colocate_remote_invoke_dr,

  nasd_cl_colocate_create_dr__otw_provided,
  nasd_cl_colocate_setattr_dr__otw_provided,

  nasd_cl_colocate_error_string,

  NASD_BIND_COLOCATE,
  "Colocate",
  0,

  NULL
};

void
nasd_cl_p_colocate_linux_register()
{
  nasd_cl_p_mod_register(&nasd_cl_colocate_linux_mod, 0);
}

void
nasd_cl_p_colocate_linux_unregister()
{
  nasd_cl_p_mod_unregister(&nasd_cl_colocate_linux_mod, 0);
}

int
init_module()
{
  nasd_od_linux_evil_init();
  nasd_cl_p_colocate_linux_register();
  nasd_linux_set_drive_launch(nasd_linux_psrv_go, 1);
  return(0);
}

void
cleanup_module()
{
  nasd_cl_p_colocate_linux_unregister();
  nasd_linux_set_drive_launch(NULL, 0);
}

#endif /* LINUX && KERNEL && MODULE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
