/*
 * nasd_solaris_common.h
 *
 * solaris-specific shared header file for NASD entities - basic
 * prototypes for library functions
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_SOLARIS_COMMON_H_
#define _NASD__NASD_SOLARIS_COMMON_H_

#include <errno.h>
#include <time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>

#define nasd_hton16(_v_) htons(_v_)
#define nasd_ntoh16(_v_) ntohs(_v_)
#define nasd_hton32(_v_) htonl(_v_)
#define nasd_ntoh32(_v_) ntohl(_v_)

extern int nasd_solaris_nasd_status_to_errno(nasd_status_t nasd_status);

struct hostent *gethostbyname_r(const char * name,
  struct hostent *result, char *buffer, int buflen,
  int *h_errnop);

#endif /* !_NASD__NASD_SOLARIS_COMMON_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
