/*
 * nasd_keymgmt_dr.h
 *
 * Drive key management routines.
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_KEYMGMT_DR_H_ 
#define _NASD_KEYMGMT_DR_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>

nasd_status_t nasd_sec_getkey(nasd_partnum_t partnum, nasd_uint16 type,
			      nasd_key_t out_key);
nasd_status_t nasd_sec_setkey(nasd_partnum_t partnum, nasd_uint16 type,
			      nasd_key_t in_key);
nasd_status_t nasd_sec_initialize_drive(nasd_key_t master_key,
					nasd_key_t drive_key);
nasd_status_t nasd_sec_init_keymgmt(void);

#endif /* _NASD_KEYMGMT_DR_H_ */

