/*
 * nasd_edrfs_client_msgq.h
 *
 * header for message-queue EDRFS clients
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_CLIENT_MSGQ_H_
#define _NASD__NASD_EDRFS_CLIENT_MSGQ_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_edrfs_client.h>

typedef struct nasd_edrfscli_handle_msgq_s {
  NASD_DECLARE_MUTEX(seqlock)   /* mutex for sequence number */
  int                replyq;    /* client msgq id */
  int                seqnum;	/* message sequence number */
  int                fd;
} nasd_edrfscli_handle_msgq_t;

extern void nasd_edrfscli_msgq_register(int counter_lock_held);

/* message-queue wrappers */

extern void nasd_edrfsmq_null(nasd_edrfs_handle_t handle,
  nasd_res_t *res, nasd_rpc_status_t *status);

extern void nasd_edrfsmq_mount(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mount_args_t  *in_args,
  nasd_edrfs_mount_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfsmq_fsstat(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsstat_args_t  *in_args,
  nasd_edrfs_fsstat_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_fsinfo(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsinfo_args_t  *in_args,
  nasd_edrfs_fsinfo_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_lookup_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_lookup(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_readdir(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_readdir_args_t  *in_args,
  nasd_edrfs_dirent_t        *out_entries,
  nasd_edrfs_readdir_res_t   *out_res,
  nasd_rpc_status_t          *op_status);

extern void nasd_edrfsmq_access(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_access_args_t  *in_args,
  nasd_edrfs_access_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_setattr(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_setattr_args_t  *in_args,
  nasd_edrfs_setattr_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

extern void nasd_edrfsmq_create_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_create(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_symlink(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_symlink_args_t  *in_args,
  nasd_edrfs_symlink_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

extern void nasd_edrfsmq_remove(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_remove_args_t  *in_args,
  nasd_edrfs_remove_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_mkdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mkdir_args_t  *in_args,
  nasd_edrfs_mkdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfsmq_rmdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_rmdir_args_t  *in_args,
  nasd_edrfs_rmdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfsmq_newcookie(
  nasd_edrfs_handle_t           handle,
  nasd_edrfs_newcookie_args_t  *in_args,
  nasd_edrfs_newcookie_res_t   *out_res,
  nasd_rpc_status_t            *out_status);

extern void nasd_edrfsmq_rename(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_rename_args_t  *in_args,
  nasd_edrfs_rename_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfsmq_getstats(
  nasd_edrfs_handle_t          handle,
  nasd_edrfs_getstats_res_t   *out_res,
  nasd_rpc_status_t           *out_status);

extern void nasd_edrfsmq_error_string(
  nasd_edrfs_handle_t     handle,
  nasd_rpc_status_t       status,
  nasd_error_string_t     str,
  char                   *file,
  int                     line);

#endif /* !_NASD__NASD_EDRFS_CLIENT_MSGQ_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
