/*
 * nasd_edrfs_client_kpdev.h
 *
 * defs/structs used by KPDEV clients of EDRFS
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_CLIENT_KPDEV_H_
#define _NASD__NASD_EDRFS_CLIENT_KPDEV_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_pdrive.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_drive_types.h>
#include <nasd/nasd_edrfs_client.h>
#include <nasd/nasd_pdev.h>

typedef struct nasd_edrfs_handle_kpdev_s {
  int  fd;
} nasd_edrfs_handle_kpdev_t;

typedef struct nasd_edrfs_param_kpdev_s {
  char     devname[NASD_MAXPATHLEN];
  int      binding_type;
  caddr_t  binding_param;
  int      binding_param_len;
} nasd_edrfs_param_kpdev_t;

#endif /* !_NASD__NASD_EDRFS_CLIENT_KPDEV_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
