/*
 * nasd_edrfs_client_linux_mount.h
 *
 * Mount data passed to the kernel for NASD/EDRFS.
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>
#include <nasd/nasd_pdrive_client.h>

#ifndef _NASD_EDRFS_CLIENT_LINUX_MOUNT_H
#define _NASD_EDRFS_CLIENT_LINUX_MOUNT_H

#define NASD_EDRFS_MOUNT_VERSION 1
#define NASD_EDRFS_MAX_PATHLEN 1024
#define NASD_EDRFS_MAX_HOSTLEN 256

#define NASD_EDRFS_MOUNT_RW           0x00000001
#define NASD_EDRFS_MOUNT_CHEOPS       0x00000002
#define NASD_EDRFS_MOUNT_SERVERPARSE  0x00000010

#define NASD_EDRFS_FS_IDENTIFIER "edrfs"

typedef struct nasd_edrfs_mount_data_s {
  nasd_uint32 version;
  nasd_uint32 flags;
  nasd_uint32 binding_type;
  char server[NASD_EDRFS_MAX_HOSTLEN];
  char server_ip[NASD_EDRFS_MAX_HOSTLEN];
  char partition[NASD_EDRFS_MAX_PATHLEN];
  char mountpoint[NASD_EDRFS_MAX_PATHLEN];
} nasd_edrfs_mount_data_t;

#endif /* !_NASD_EDRFS_CLIENT_LINUX_MOUNT_H */
