/*
 * nasd_pdrive_client_modinit_dux.c
 *
 * Register rpc-specific modules for dux kernel
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_pdrive_client.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
#include <nasd/nasd_pdrive_client_srpc.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
#include <nasd/nasd_pdrive_client_dce.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#include <nasd/nasd_pdrive_client_colocate.h>

nasd_drive_default_bindings_t nasd_drive_dux_bindings;
int nasd_drive_dux_bindings_handles[] = {
  NASD_BIND_COLOCATE,

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
  NASD_BIND_DCE_DIRECT_UDP
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
  NASD_BIND_SRPC
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */
};

/*
 * This is called when we initialize the client library.
 * Because of that, we hold the counter lock, so we pass
 * nonzero to all these register funcs.
 */
void
nasd_cl_p_mods_load()
{
  nasd_drive_dux_bindings.bindings = nasd_drive_dux_bindings_handles;
  nasd_drive_dux_bindings.nbindings =
    sizeof(nasd_drive_dux_bindings_handles) / sizeof(int);
  nasd_drive_default_bindings = &nasd_drive_dux_bindings;

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
  nasd_cl_p_srpc_register(1);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
  nasd_cl_p_dce_register(1);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

  nasd_cl_p_colocate_register(1);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
