/*
 * Copyright (c) 2009, 2010 Nhat Minh Lê
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef REGXML_XML_H
#define REGXML_XML_H

#include <sys/cdefs.h>

#include <stddef.h>		/* For size_t. */

enum regxml_xml_flags {
	REGXML_XML_TRIM = 1,
	REGXML_XML_EXPAND = REGXML_XML_TRIM << 1,
	REGXML_XML_TABINDENT = REGXML_XML_EXPAND << 1,
	REGXML_XML_ATTRLINE = REGXML_XML_TABINDENT << 1
};

struct regxml_xml;

__BEGIN_DECLS
int regxml_xml_create(struct regxml_xml **, struct regxml *, int);
void regxml_xml_destroy(struct regxml_xml *);

size_t regxml_xml_strerror(struct regxml_xml *, int, char *, size_t);

int regxml_xml_getbuf(struct regxml_xml *, char **, size_t);
int regxml_xml_pushraw(struct regxml_xml *, const char *, size_t);
int regxml_xml_push(struct regxml_xml *, const char *);
int regxml_xml_end(struct regxml_xml *);

int regxml_xml_setfilename(struct regxml_xml *, const char *);
void regxml_xml_setindent(struct regxml_xml *, unsigned int);
void regxml_xml_setprint(struct regxml_xml *,
    int (*)(void *, const char *, ...), void *);

int regxml_xml_print(struct regxml_xml *, const char *);
int regxml_xml_printopening(struct regxml_xml *,
    const char *, char * const *);
int regxml_xml_printclosing(struct regxml_xml *, const char *);
int regxml_xml_printempty(struct regxml_xml *, const char *, char * const *);
int regxml_xml_printtext(struct regxml_xml *, const char *);
int regxml_xml_printcomment(struct regxml_xml *, const char *);
int regxml_xml_printpi(struct regxml_xml *, const char *, const char *);

int regxml_xml_printf(void *, const char *, ...);
int regxml_xml_fprintf(void *, const char *, ...);
__END_DECLS

#endif	/* !REGXML_XML_H */
