<!-- markdownlint-disable MD041 -->

## Next Steps

Now you're up and running with Regal, take a look around some of our documentation
to get a feel for the different features and capabilities of Regal.

- [Rules](https://docs.styra.com/regal/rules)
  - [Bugs](https://docs.styra.com/regal/rules/bugs): Common mistakes, potential bugs and inefficiencies in Rego policies.
  - [Idiomatic](https://docs.styra.com/regal/rules/idiomatic): Suggestions for more idiomatic constructs.
  - [Imports](https://docs.styra.com/regal/rules/imports): Best practices for imports.
  - [Performance](https://docs.styra.com/regal/rules/performance): Rules for improving performance of policies.
  - [Style](https://docs.styra.com/regal/rules/style): Rego Style Guide rules.
  - [Testing](https://docs.styra.com/regal/rules/testing): Rules for testing and development.
  - [Custom](https://docs.styra.com/regal/rules/custom): Custom rules where enforcement can be adjusted to match your preferences.
- [Configuration](https://docs.styra.com/regal/configuration): Dig into some of the different configuration options available.
- [Editor Support](https://docs.styra.com/regal/editor-support): Get Regal integrated into your editor of choice.
  - [Language Server](https://docs.styra.com/regal/language-server): Learn more
    about Regal's advanced editor capabilities.
  - [DAP](https://docs.styra.com/regal/debug-adapter): Live debug your Rego policies with Regal's DAP support.
- [Fixing Issues](https://docs.styra.com/regal/fixing): See Regal can help you fix issues in your Rego policies automatically.
- [CI/CD](https://docs.styra.com/regal/ci-cd): Run Regal as part of your automated checks.
- [Custom Rules](https://docs.styra.com/regal/custom-rules): Learn how to write your own rules for Regal.
- [Adopters](https://docs.styra.com/regal/adopters): See who else is using Regal.
