package regal.lsp.completion.providers.snippet_test

import data.regal.lsp.completion.providers.snippet as provider
import data.regal.lsp.completion.providers.test_utils as util

# regal ignore:rule-length
test_snippet_completion_on_typing_partial_prefix if {
	policy := `package policy

import rego.v1

allow if {
	e
}`
	items := provider.items with input as util.input_with_location(policy, {"row": 6, "col": 2})
	items == {
		{
			"detail": "every key-value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every key-value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:key}, ${2:value} in ${3:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 2, "line": 5},
					"start": {"character": 1, "line": 5},
				},
			},
		},
		{
			"detail": "every value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:var} in ${2:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 2, "line": 5},
					"start": {"character": 1, "line": 5},
				},
			},
		},
	}
}

# regal ignore:rule-length
test_snippet_completion_on_typing_full_prefix if {
	policy := `package policy

import rego.v1

allow if {
	every
}`
	items := provider.items with input as util.input_with_location(policy, {"row": 6, "col": 6})
	items == {
		{
			"detail": "every key-value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every key-value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:key}, ${2:value} in ${3:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 6, "line": 5},
					"start": {"character": 1, "line": 5},
				},
			},
		},
		{
			"detail": "every value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:var} in ${2:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 6, "line": 5},
					"start": {"character": 1, "line": 5},
				},
			},
		},
	}
}

test_snippet_completion_on_typing_no_repeat if {
	policy := `package policy

import rego.v1

allow if {
	some e in [1,2,3] some
}
`
	items := provider.items with input as util.input_with_location(policy, {"row": 6, "col": 21})
	items == set()
}

# regal ignore:rule-length
test_snippet_completion_on_invoked if {
	policy := `package policy

import rego.v1

allow if `
	items := provider.items with input as util.input_with_location(policy, {"row": 5, "col": 10})
	items == {
		{
			"detail": "every key-value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every key-value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:key}, ${2:value} in ${3:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 9, "line": 4},
					"start": {"character": 9, "line": 4},
				},
			},
		},
		{
			"detail": "every value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "every value iteration (snippet)",
			"textEdit": {
				"newText": "every ${1:var} in ${2:collection} {\n\t$0\n}",
				"range": {
					"end": {"character": 9, "line": 4},
					"start": {"character": 9, "line": 4},
				},
			},
		},
		{
			"detail": "some key-value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "some key-value iteration (snippet)",
			"textEdit": {
				"newText": "some ${1:key}, ${2:value} in ${3:collection}\n$0",
				"range": {
					"end": {"character": 9, "line": 4},
					"start": {"character": 9, "line": 4},
				},
			},
		},
		{
			"detail": "some value iteration",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "some value iteration (snippet)",
			"textEdit": {
				"newText": "some ${1:var} in ${2:collection}\n$0",
				"range": {
					"end": {"character": 9, "line": 4},
					"start": {"character": 9, "line": 4},
				},
			},
		},
	}
}

# regal ignore:rule-length
test_metadata_snippet_completion if {
	policy := `package policy

import rego.v1


`
	items := provider.items with input as util.input_with_location(policy, {"row": 5, "col": 1})
	items == {
		{
			"detail": "metadata annotation",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "metadata annotation [description] (snippet)",
			"textEdit": {
				"newText": "# METADATA\n# description: ${1:description}",
				"range": {
					"end": {"character": 0, "line": 4},
					"start": {"character": 0, "line": 4},
				},
			},
		},
		{
			"detail": "metadata annotation",
			"insertTextFormat": 2,
			"kind": 15,
			"label": "metadata annotation [title, description] (snippet)",
			"textEdit": {
				"newText": "# METADATA\n# title: ${1:title}\n# description: ${2:description}",
				"range": {
					"end": {"character": 0, "line": 4},
					"start": {"character": 0, "line": 4},
				},
			},
		},
	}
}
