# METADATA
# description: |
#   completion kinds, as defined in the LSP specification
# related_resources:
#   - description: documentation
#     ref: https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#completionItemKind
package regal.lsp.completion.kind

import rego.v1

# METADATA
# description: text
text := 1

# METADATA
# description: method
method := 2

# METADATA
# description: function
function := 3

# METADATA
# description: constructor
constructor := 4

# METADATA
# description: field
field := 5

# METADATA
# description: variable
variable := 6

# METADATA
# description: class
class := 7

# METADATA
# description: interface
interface := 8

# METADATA
# description: module
module := 9

# METADATA
# description: property
property := 10

# METADATA
# description: unit
unit := 11

# METADATA
# description: value
value := 12

# METADATA
# description: enum
enum := 13

# METADATA
# description: keyword
keyword := 14

# METADATA
# description: snippet
snippet := 15

# METADATA
# description: color
color := 16

# METADATA
# description: file
file := 17

# METADATA
# description: reference
reference := 18

# METADATA
# description: folder
folder := 19

# METADATA
# description: enum number
enum_member := 20

# METADATA
# description: constant
constant := 21

# METADATA
# description: struct
struct := 22

# METADATA
# description: event
event := 23

# METADATA
# description: operator
operator := 24

# METADATA
# description: type parameter
type_parameter := 25
