/* RealBoy Emulator: Free, Fast, Yet Accurate, Game Boy/Game Boy Color Emulator.
 * Copyright (C) 2013 Sergio Andrés Gómez del Real
 *
 * This program is free software; you can redistribute it and/or modify  
 * it under the terms of the GNU General Public License as published by   
 * the Free Software Foundation; either version 2 of the License, or    
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#include "gboy.h"
#define STR_OFF 8 // string offset

extern int addr_is_hex(char *, int);
extern void str_hex_to_num(char *, int *, int);
extern void memdump32(int *, char *, char, int,	int);
extern int getch();
extern int gddb_tmp;
extern long gddb_contil;
extern long gddb_loop;
extern int gbddb;
#ifdef USE_X86_64_ASM
extern char z80_cb;
extern char z80_ldex;
extern long regs_sets;
#else
struct z80_set {
	Uint8 format[8];
	char name[16];
	long length;
	void (*func)(struct z80_set *);
};
struct regs_sets {
	union regs {
		Uint8 UByte[2];
		Sint8 SByte[2];
		Uint16 UWord;
		Sint16 SWord;
	} regs[10];
};
extern struct regs_sets regs_sets;
extern struct z80_set z80_ldex;
#endif
extern long *addr_sp_bases[];
extern long addr_sp_ptrs[16];
extern Uint8 *gboy_pc;
extern Uint8 *op_rec;

char *gddb_regs[] = { "AF = ", "BC = ", "DE = ", "HL = ", "SP = ", "PC = ", NULL };
char gddb_buf[512];

struct gddb_registers {
	char *gddb_str;
	int gddb_next;
};

struct gddb_registers gddb_ioregs[] = 
{ 
	"DIV = ", 1,
	"TIMA = ", 1,
	"TMA = ", 1,
	"TAC = ", 8,
	"IF = ", 240,
	"IE = ", 0,
	NULL, 0
};

struct gddb_registers gddb_lcdregs[] = 
{ 
	"LCDC = ", 1,
	"STAT = ", 1,
	"SCY = ", 1,
	"SCX = ", 1,
	"LY = ", 1,
	"LYC = ", 1,
	"OAM DMA = ", 1,
	"BGP = ", 1,
	"OBP0 = ", 1,
	"OBP1 = ", 1,
	"WY = ", 1,
	"WX = ", 1,
	NULL, 0
};

struct gddb_registers gddb_sndregs[] = 
{ 
	"NR10 = ", 1,
	"NR11 = ", 1,
	"NR12 = ", 1,
	"NR13 = ", 1,
	"NR14 = ", 2,
	"NR21 = ", 1,
	"NR22 = ", 1,
	"NR23 = ", 1,
	"NR24 = ", 1,
	"NR30 = ", 1,
	"NR31 = ", 1,
	"NR32 = ", 1,
	"NR33 = ", 1,
	"NR34 = ", 2,
	"NR41 = ", 1,
	"NR42 = ", 1,
	"NR43 = ", 1,
	"NR44 = ", 1,
	"NR50 = ", 1,
	"NR51 = ", 1,
	"NR52 = ", 1,
	NULL, 0
};

void
gddb_cont(int num_args, char **ptr_ptrs)
{
	gbddb=0;
	gddb_contil=-1;
	gddb_loop=0;
	gddb_tmp=0;

	printf("\n\nContinuing execution...\nPress 'g' to drop to debugger.\n\n");
}

#ifdef USE_X86_64_ASM
void
gddb_disasm(int num_ops, int rep)
{
	Uint8 *gboy_pc_local = (Uint8 *)gboy_pc;
	Uint8 *op_rec_local = (Uint8 *)op_rec;
	int i;

	long pc_temp = *((&regs_sets)+5);

	while (num_ops--) {
		if (*gboy_pc_local == 0xcb) {
			//printf("Escape to: \n");
			gboy_pc_local++;
			op_rec_local = (Uint8 *)(&z80_cb + (((int)*gboy_pc_local)<<5));
			pc_temp++;
			memdump32((int *)&pc_temp, gddb_buf, 1, 2, 16);
			printf("%s\t", gddb_buf);
			printf("%s", op_rec_local+STR_OFF);
		}
		else {
			memdump32((int *)&pc_temp, gddb_buf, 1, 2, 16);
			printf("%s\t", gddb_buf);
			if (*op_rec_local == 0xea)
			{
				printf("%s", op_rec_local+STR_OFF);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf(" (%s), ", gddb_buf);
				printf("A");
			}
			else if (*op_rec_local == 0x08)
			{
				printf("%s", op_rec_local+STR_OFF);
				printf(" SP, ");
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("*%s", gddb_buf);
			}
			else if (!strncmp((char const *)(op_rec_local+STR_OFF),"ld",255)||!strncmp((char const *)(op_rec_local+STR_OFF), "ldi", 255)||!strncmp((char const *)(op_rec_local+STR_OFF), "ldd", 255)) 
			{
				printf("%s", op_rec_local+STR_OFF);
				switch (*((int *)(op_rec_local+24))) {
					case WORD_W:
						if (*(op_rec_local+1) == REG) {
							if (*(op_rec_local+2) == AF)
								printf(" AF, ");
							else if (*(op_rec_local+2) == BC)
								printf(" BC, ");
							else if (*(op_rec_local+2) == DE)
								printf(" DE, ");
							else if (*(op_rec_local+2) == HL)
								printf(" HL, ");
							else if (*(op_rec_local+2) == SP)
								printf(" SP, ");
							else
								printf(" PC, ");
						}
						else if (*(op_rec_local+1) == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("(%s)", gddb_buf);
						}
						if (*(op_rec_local+3) == REG) {
							if (*(op_rec_local+4) == AF)
								printf("AF");
							else if (*(op_rec_local+4) == BC)
								printf("BC");
							else if (*(op_rec_local+4) == DE)
								printf("DE");
							else if (*(op_rec_local+4) == HL)
								printf("HL");
							else if (*(op_rec_local+4) == SP)
								printf("SP");
							else
								printf("PC");
						}
						else if (*(op_rec_local+3) == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("(%s)", gddb_buf);
								break;
						}
						else if (*(op_rec_local+3) == IMM) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("%s", gddb_buf);
								break;
						}
					break;
					case BYTE_B:
						if (*(op_rec_local+1) == REG) {
							if (*(op_rec_local+2) == A)
								printf(" A, ");
							else if (*(op_rec_local+2) == B)
								printf(" B, ");
							else if (*(op_rec_local+2) == D)
								printf(" D, ");
							else if (*(op_rec_local+2) == H)
								printf(" H, ");
							else if (*(op_rec_local+2) == C)
								printf(" C, ");
							else if (*(op_rec_local+2) == E)
								printf(" E, ");
							else if (*(op_rec_local+2) == L)
								printf(" L, ");
							else
								printf(" F, ");
						}
						else if (*(op_rec_local+1) == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("*%s", gddb_buf);
						}
						else if (*(op_rec_local+1) == 0x18) {
								memdump32((int *)((char *)(&regs_sets)+C), gddb_buf, 1, 1, 16);
								printf(" (0xff%s), ", gddb_buf+2);
						}
						else if (*(op_rec_local+1) == 0x1) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf(" (0xff%s), ", gddb_buf+2);
						}
						if (*(op_rec_local+3) == REG) {
							if (*(op_rec_local+4) == A)
								printf("A");
							else if (*(op_rec_local+4) == B)
								printf("B");
							else if (*(op_rec_local+4) == D)
								printf("D");
							else if (*(op_rec_local+4) == H)
								printf("H");
							else if (*(op_rec_local+4) == C)
								printf("C");
							else if (*(op_rec_local+4) == E)
								printf("E");
							else if (*(op_rec_local+4) == L)
								printf("L");
							else
								printf("F");
						}
						else if (*(op_rec_local+3) == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("*%s", gddb_buf);
								break;
						}
						else if (*(op_rec_local+3) == IMM) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("%s", gddb_buf);
								break;
						}
						else if (*(op_rec_local+3) == 0x18) {
							#ifdef USE_X86_64_ASM
								memdump32((int *)((char *)(&regs_sets)+C), gddb_buf, 1, 1, 16);
							#else
								memdump32((int *)((char *)(&regs_sets.regs[DE].UByte[E])),gddb_buf,1,1,16);
							#endif
								printf("(0xff%s)", gddb_buf+2);
								break;
						}
						else if (*(op_rec_local+3) == 0x1) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("(0xff%s)", gddb_buf+2);
								break;
						}
					}
				}
			else if (*op_rec_local == 0x18 || *op_rec_local == 0x20 || *op_rec_local == 0x28 || 
							 *op_rec_local == 0x30 || *op_rec_local == 0x38) 
			{
				printf("%s ", op_rec_local+STR_OFF);
				printf("0x%hx", (unsigned short)((pc_temp+2)+((signed char)gboy_pc_local[1])));
			}
			else if (*op_rec_local == 0xc3 || *op_rec_local == 0xca || 
					 *op_rec_local == 0xc2 || *op_rec_local == 0xd2 || 
					 *op_rec_local == 0xda || *op_rec_local == 0xdc || 
					 *op_rec_local == 0xcd || *op_rec_local == 0xcc || 
					 *op_rec_local == 0xc4 || *op_rec_local == 0xd4)
			{
				printf("%s ", op_rec_local+STR_OFF);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("%s", gddb_buf);
			}
			else if (*op_rec_local == 0xe6 || *op_rec_local == 0xee || 
					 *op_rec_local == 0xf6 || *op_rec_local == 0xfe)
			{
				printf("%s ", op_rec_local+STR_OFF);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
				printf("%s", gddb_buf);
			}
			else if (*op_rec_local == 0xe8)
			{
				printf("%s ", op_rec_local+STR_OFF);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("%s", gddb_buf);
			}
			else
				printf("%s", op_rec_local+STR_OFF);
		}
		printf("\t\t( ");
		for (i=0; i<*(op_rec_local+6); i++) {
			memdump32((int *)(gboy_pc_local+i), gddb_buf, 1, 1, 16);
			printf("%s ", gddb_buf);
		}
		printf(")");
		gboy_pc_local += *(op_rec_local+6);
		pc_temp += *(op_rec_local+6);
		op_rec_local = (Uint8 *)(&z80_ldex + (((int)*gboy_pc_local)<<5));

		printf("\n");

		if (rep == 1)
		if (num_ops == 0) {
			puts("Any key to continue; 'q' to stop...");
			rep=getch();//("%c", (char *)&rep);
			if ((char)rep != 'q')
				rep = 1, num_ops = 10;
		}
	}
}
#else
void
gddb_disasm(int num_ops, int rep)
{
	Uint8 *gboy_pc_local = (Uint8 *)gboy_pc;
	struct z80_set *op_rec_local = (struct z80_set *)op_rec;
	int i;

	long pc_temp = regs_sets.regs[PC].UWord;

	while (num_ops--) {
		if (*gboy_pc_local == 0xcb) {
			//printf("Escape to: \n");
			gboy_pc_local++;
			op_rec_local = (struct z80_set *)(&z80_ldex+256 + ((*gboy_pc_local)));
			pc_temp++;
			memdump32((int *)&pc_temp, gddb_buf, 1, 2, 16);
			printf("%s\t", gddb_buf);
			printf("%s", op_rec_local->name);
		}
		else {
			memdump32((int *)&pc_temp, gddb_buf, 1, 2, 16);
			printf("%s\t", gddb_buf);
			if (op_rec_local->format[0] == 0xea)
			{
				printf("%s", op_rec_local->name);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf(" (%s), ", gddb_buf);
				printf("A");
			}
			else if (op_rec_local->format[0] == 0x08)
			{
				printf("%s", op_rec_local->name);
				printf(" SP, ");
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("*%s", gddb_buf);
			}
			else if (!strncmp((char const *)(op_rec_local->name),"ld",255)||!strncmp((char const *)(op_rec_local->name), "ldi", 255)||!strncmp((char const *)(op_rec_local->name), "ldd", 255)) 
			{
				printf("%s", op_rec_local->name);
				switch ((int)op_rec_local->length) {
					case WORD_W:
						if (op_rec_local->format[1] == REG) {
							if (op_rec_local->format[2] == AF)
								printf(" AF, ");
							else if (op_rec_local->format[2] == BC)
								printf(" BC, ");
							else if (op_rec_local->format[2] == DE)
								printf(" DE, ");
							else if (op_rec_local->format[2] == HL)
								printf(" HL, ");
							else if (op_rec_local->format[2] == SP)
								printf(" SP, ");
							else
								printf(" PC, ");
						}
						else if (op_rec_local->format[1] == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("(%s)", gddb_buf);
						}
						if (op_rec_local->format[3] == REG) {
							if (op_rec_local->format[4] == AF)
								printf("AF");
							else if (op_rec_local->format[4] == BC)
								printf("BC");
							else if (op_rec_local->format[4] == DE)
								printf("DE");
							else if (op_rec_local->format[4] == HL)
								printf("HL");
							else if (op_rec_local->format[4] == SP)
								printf("SP");
							else
								printf("PC");
						}
						else if (op_rec_local->format[3] == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("(%s)", gddb_buf);
								break;
						}
						else if (op_rec_local->format[3] == IMM) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
								printf("%s", gddb_buf);
								break;
						}
					break;
					case BYTE_B:
						if (op_rec_local->format[1] == REG) {
							if (op_rec_local->format[2] == A)
								printf(" A, ");
							else if (op_rec_local->format[2] == B)
								printf(" B, ");
							else if (op_rec_local->format[2] == D)
								printf(" D, ");
							else if (op_rec_local->format[2] == H)
								printf(" H, ");
							else if (op_rec_local->format[2] == C)
								printf(" C, ");
							else if (op_rec_local->format[2] == E)
								printf(" E, ");
							else if (op_rec_local->format[2] == L)
								printf(" L, ");
							else
								printf(" F, ");
						}
						else if (op_rec_local->format[1] == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("*%s", gddb_buf);
						}
						else if (op_rec_local->format[1] == 0x18) {
							#ifdef USE_X86_64_ASM
								memdump32((int *)((char *)(&regs_sets)+C), gddb_buf, 1, 1, 16);
							#else
								memdump32((int *)((char *)(&regs_sets.regs[BC].UByte[C])),gddb_buf,1,1,16);
							#endif
								printf(" (0xff%s), ", gddb_buf+2);
						}
						else if (op_rec_local->format[1] == 0x1) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf(" (0xff%s), ", gddb_buf+2);
						}
						if (op_rec_local->format[3] == REG) {
							if (op_rec_local->format[4] == A)
								printf("A");
							else if (op_rec_local->format[4] == B)
								printf("B");
							else if (op_rec_local->format[4] == D)
								printf("D");
							else if (op_rec_local->format[4] == H)
								printf("H");
							else if (op_rec_local->format[4] == C)
								printf("C");
							else if (op_rec_local->format[4] == E)
								printf("E");
							else if (op_rec_local->format[4] == L)
								printf("L");
							else
								printf("F");
						}
						else if (op_rec_local->format[3] == IMM_IND) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("*%s", gddb_buf);
								break;
						}
						else if (op_rec_local->format[3] == IMM) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("%s", gddb_buf);
								break;
						}
						else if (op_rec_local->format[3] == 0x18) {
							#ifdef USE_X86_64_ASM
								memdump32((int *)((char *)(&regs_sets)+C), gddb_buf, 1, 1, 16);
							#else
								memdump32((int *)((char *)(&regs_sets.regs[DE].UByte[E])),gddb_buf,1,1,16);
							#endif
								printf("(0xff%s)", gddb_buf+2);
								break;
						}
						else if (op_rec_local->format[3] == 0x1) {
								memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
								printf("(0xff%s)", gddb_buf+2);
								break;
						}
					}
				}
			else if (op_rec_local->format[0] == 0x18 || op_rec_local->format[0] == 0x20 || op_rec_local->format[0] == 0x28 || 
							 op_rec_local->format[0] == 0x30 || op_rec_local->format[0] == 0x38) 
			{
				printf("%s ", op_rec_local->name);
				printf("0x%hx", (unsigned short)((pc_temp+2)+((signed char)gboy_pc_local[1])));
			}
			else if (op_rec_local->format[0] == 0xc3 || op_rec_local->format[0] == 0xca || 
					 op_rec_local->format[0] == 0xc2 || op_rec_local->format[0] == 0xd2 || 
					 op_rec_local->format[0] == 0xda || op_rec_local->format[0] == 0xdc || 
					 op_rec_local->format[0] == 0xcd || op_rec_local->format[0] == 0xcc || 
					 op_rec_local->format[0] == 0xc4 || op_rec_local->format[0] == 0xd4)
			{
				printf("%s ", op_rec_local->name);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("%s", gddb_buf);
			}
			else if (op_rec_local->format[0] == 0xe6 || op_rec_local->format[0] == 0xee || 
					 op_rec_local->format[0] == 0xf6 || op_rec_local->format[0] == 0xfe)
			{
				printf("%s ", op_rec_local->name);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 1, 16);
				printf("%s", gddb_buf);
			}
			else if (op_rec_local->format[0] == 0xe8)
			{
				printf("%s ", op_rec_local->name);
				memdump32((int *)(gboy_pc_local+1), gddb_buf, 1, 2, 16);
				printf("%s", gddb_buf);
			}
			else
				printf("%s", op_rec_local->name);
		}
		printf("\t\t( ");
		for (i=0; i<op_rec_local->format[6]; i++) {
			memdump32((int *)(gboy_pc_local+i), gddb_buf, 1, 1, 16);
			printf("%s ", gddb_buf);
		}
		printf(")");
		gboy_pc_local += op_rec_local->format[6];
		pc_temp += op_rec_local->format[6];
		op_rec_local = (struct z80_set *)(&z80_ldex + ((*gboy_pc_local)));

		printf("\n");

		if (rep == 1)
		if (num_ops == 0) {
			puts("Any key to continue; 'q' to stop...");
			rep=getch();//("%c", (char *)&rep);
			if ((char)rep != 'q')
				rep = 1, num_ops = 10;
		}
	}
}

#endif

void
gddb_break(int num_args, char **ptr_ptrs)
{
	long ptr_num=0;
	int str_len;

	if (num_args==2) {
		if (addr_is_hex(ptr_ptrs[1], strnlen(ptr_ptrs[1], 255)))
			str_hex_to_num(ptr_ptrs[1]+2, (int *)&ptr_num, (str_len = strnlen(ptr_ptrs[1]+2, 255)) > 4 ? 0 : str_len);
		else
			ptr_num = atoi(ptr_ptrs[1]); 
		if (ptr_num==0)
			printf("Bad address \"%s\"\n", ptr_ptrs[1]), printf("No breakpoint set\n");
		else
			gddb_contil = ptr_num, printf("Breakpoint set at: 0x%x\n", (unsigned int)gddb_contil);
	}	
	else
		printf("Usage: break 'address'\n"), gddb_contil = -1, printf("Breakpoint unset\n");
}

void
gddb_dasm(int num_args, char **ptr_ptrs)
{
	if (num_args == 1)
		gddb_disasm(10, 1);
}

void
gddb_print(int num_args, char **ptr_ptrs)
{
	long ptr_num=0;
	int str_len;

	if (num_args==2) {
		if (addr_is_hex(ptr_ptrs[1], strnlen(ptr_ptrs[1], 255)))
			str_hex_to_num(ptr_ptrs[1]+2, (int *)&ptr_num, (str_len = strnlen(ptr_ptrs[1]+2, 255)) > 4 ? 0 : str_len);
		else
			ptr_num = atoi(ptr_ptrs[1]); 
		if (ptr_num==0)
			printf("Bad address \"%s\"\n", ptr_ptrs[1]);
		else {
			printf("(0x%x) = ", (unsigned int)ptr_num);
			ptr_num = addr_sp_ptrs[(ptr_num>>12)&0x3c] + ptr_num;
			memdump32((int *)(ptr_num), gddb_buf, 1, 1, 16);
			printf("%s\n", gddb_buf);
		}
	}	
	else
		printf("Usage: print 'address'\n");

}

void
gddb_show(int num_args, char **ptr_ptrs)
{
	int i=0;
	Uint8 *ptr_addr;

	if (num_args != 2)
		printf("Usage: show [regs, ioregs, lcdregs, sndregs]\n");
	else {
		if (!strncmp("regs", ptr_ptrs[1], 255)) {
			while (gddb_regs[i] != NULL) {
				#ifdef USE_X86_64_ASM
					memdump32((int *)((&regs_sets)+i), gddb_buf, 1, 2, 16);
				#else
					memdump32((int *)((&regs_sets.regs[i*2].UWord)),gddb_buf,1,2,16);
				#endif
				printf("%s%s\n", gddb_regs[i++], gddb_buf);
			}
		}
		else if (!strncmp("ioregs", ptr_ptrs[1], 255)) {
			i=0;
			ptr_addr = addr_sp+0xff04;
			while (gddb_ioregs[i].gddb_str != NULL) {
				memdump32((int *)ptr_addr, gddb_buf, 1, 1, 16);
				printf("%s%s\n", gddb_ioregs[i].gddb_str, gddb_buf);
				ptr_addr += gddb_ioregs[i++].gddb_next;
			}
		}
		else if (!strncmp("lcdregs", ptr_ptrs[1], 255)) {
			i=0;
			ptr_addr = addr_sp+0xff40;
			while (gddb_lcdregs[i].gddb_str != NULL) {
				memdump32((int *)ptr_addr, gddb_buf, 1, 1, 16);
				printf("%s%s\n", gddb_lcdregs[i].gddb_str, gddb_buf);
				ptr_addr += gddb_lcdregs[i++].gddb_next;
			}
		}
		else if (!strncmp("sndregs", ptr_ptrs[1], 255)) {
			i=0;
			ptr_addr = addr_sp+0xff10;
			while (gddb_sndregs[i].gddb_str != NULL) {
				memdump32((int *)ptr_addr, gddb_buf, 1, 1, 16);
				printf("%s%s\n", gddb_sndregs[i].gddb_str, gddb_buf);
				ptr_addr += gddb_sndregs[i++].gddb_next;
			}
			ptr_addr = addr_sp+0xff30;
			printf("Wave Pattern Ram: ");
			memdump32((int *)ptr_addr, gddb_buf, 1, 4, 16);
			printf("%s ", gddb_buf);
			memdump32((int *)ptr_addr+4, gddb_buf, 1, 4, 16);
			printf("%s ", gddb_buf);
			memdump32((int *)ptr_addr+8, gddb_buf, 1, 4, 16);
			printf("%s ", gddb_buf);
			memdump32((int *)ptr_addr+12, gddb_buf, 1, 4, 16);
			printf("%s\n", gddb_buf);
		}
		else
			printf("Bad argument: %s\n", ptr_ptrs[1]);
	}
}

void
gddb_step(int num_args, char **ptr_ptrs)
{
	if (num_args>2)
		printf("Usage: step\n");
	else
		gddb_loop=0;
	if (num_args==2)
		gddb_tmp = atoi(ptr_ptrs[1]);
}

void
gddb_help(int num_args, char **ptr_ptrs)
{
	if (num_args > 1)
		printf("Usage: help\n");
	else
		printf("Commands: step, show, print, break, disasm\nPress enter to step...\n");
}
