#ifndef	TASKCTRL_HPP
#define	TASKCTRL_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  5/19/99
*
*****************************************************************************
*
* File Name:		TaskCtrl.hpp
* Module:
* Contributors:		Karla Summers
* Description:
* Version Control:
*
* $Revision: 4 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
#define STR_STOP_BUILD_WARNING "Stopping an Array Build in progress will cause the array to be inaccessible.  Do you wish to stop the build at this time? [yN]"
/*** TYPES ***/

enum TaskCommandOptions { List, Build, Rebuild, Verify, Stop, VerifyNoFix };

class TaskControl:public Command
	{
	public:
		TaskControl::TaskControl(SCSI_Addr_List *deviceList, TaskCommandOptions cmd);
		TaskControl(const TaskControl &new_TaskControl);
		virtual	~TaskControl();

		Dpt_Error execute(String_List **output);
		Dpt_Error ControlEachArray(DPT_TAG_T raid_Tag,
			String_List	*out);
		Command &Clone() const;

	private:
		TaskCommandOptions taskCmd;
		SCSI_Addr_List *raidsToCtrl;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
