#ifndef	STRING_LIST_HPP
#define	STRING_LIST_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/17/98
*
*****************************************************************************
*
* File Name:		StrList.hpp
* Module:
* Contributors:		Lee Page
* Description:		Encapsulates an array of C-strings.  Used as a least-common denominator
					solution in coding C++ without STL.
* Version Control:
*
* $Revision: 6 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
/*** CONSTANTS ***/
/*** TYPES ***/
class String_List
	{
	public:
		String_List();
		String_List( const String_List &right );
		~String_List();

		String_List	&operator += ( const String_List &right );
		const String_List & operator = ( const String_List &from_List );

		void	add_Item( const char *str = 0 );

		//	Fetches the nth str (0 based).  The user should not
		//	deallocate the returned string.  It is owned by the
		//	object.
		char	*get_Item( int index ) const;

		//	Fetches the next string.  The user should not deallocate
		//	the returned string.  It is owned by the object.
		char	*get_Next_Item();
		// FIFO.  Removes the first item from the list, and returns it.
		char	*shift_Item();

		//	Resets the get_Next_Str index to point to the first item.
		void	reset_Next_Index();
		int		num_Left() const;
		int		get_Num_Items() const	{ return( num_Items ); }

		void	resetString_List();
	private:
		void	Destroy_Items();
		void	Copy_Items( const String_List &right );

		int		num_Items;
		char	**items;
		int		next_Item_Index;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
#endif
/*** END OF FILE ***/
