#ifndef	SHOWINQ_HPP
#define	SHOWINQ_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  8/7/98
*
*****************************************************************************
*
* File Name:		ShowInq.hpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
class Show_Inquiry: public Command
	{
	public:
		Show_Inquiry(
				SCSI_Address	&address_to_List
				);
		Show_Inquiry( const Show_Inquiry &right );
		virtual	~Show_Inquiry();
		Dpt_Error	execute( String_List **output );
		Command		&Clone() const;

	private:
		Dpt_Error	Show_Inq_on_Dev(
						String_List		&output,
						bool			show_Controller
 						);
		Dpt_Error	Show_Inq_on_This_Dev(
						String_List		&output,
						DPT_TAG_T		this_Objs_Tag,
						get_Devs_Type	devs_Type
						);

		SCSI_Address	address;
		bool			show_Ctlr;	// if this is false, then it shows a physical device.
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
