#ifndef	QUIETMOD_HPP
#define	QUIETMOD_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/27/98
*
*****************************************************************************
*
* File Name:		QuietMod.hpp
* Module:
* Contributors:		Lee Page
* Description:		This toggles quiet mode on and off.
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
class Quiet_Mode: public Command
	{
	public:
		Quiet_Mode( bool *new_Quiet_Mode ):quiet_Mode( new_Quiet_Mode )
			{}
		Quiet_Mode( const Quiet_Mode &new_Quiet_Mode )
			{
			quiet_Mode	= new_Quiet_Mode.quiet_Mode;
			}
		// virtual	~Quiet_Mode();

		Dpt_Error	execute( String_List **output )
			{
			Dpt_Error	err;
			// toggle it
			*quiet_Mode	= !*quiet_Mode;
			return( err );
			}

		Command		&Clone() const
			{
			return( *new Quiet_Mode( *this ) );
			}

	private:
		bool	*quiet_Mode;
	};

#endif
/*** END OF FILE ***/
