#ifndef	NVRAMBIT_HPP
#define	NVRAMBIT_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  10/13/99
*
*****************************************************************************
*
* File Name:		NvramBit.hpp
* Module:
* Contributors:	Karla Summers
* Description:
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/

enum NvramOffset { Cache_Stale, Cluster, Cluster_FUA, HS_Same_Channel };

class NvramBit:public Command
	{
	public:
		NvramBit (NvramOffset offset, int hba, int new_val);
		NvramBit (const NvramBit &new_NvramBit);
		virtual ~NvramBit();
		NvramBit	&operator = (NvramBit &right);

		Dpt_Error execute (String_List **output);
		Dpt_Error DoEachHBA (String_List **output, DPT_TAG_T hba);
		Dpt_Error GetNvramValue (DPT_TAG_T hba);
		void SetNvramValue (DPT_TAG_T hba);
		Command &Clone() const;

	private:
		NvramOffset Nvram_offset;
		int whichHBA;
      int currentStatus;
      int newValue;

	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
