#ifndef         __LZSTRBUF_H
#define         __LZSTRBUF_H

/****************************************************************************
*
* Copyright (C) 2000 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  1/19/2000
*
*****************************************************************************
*
* File Name:		LzStrBuf.h
* Module:           Generic
* Contributors:		David Dillard
* Description:		Contains the declaration of the LzInStreamBuf class.
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "dynsize.h"





//Class - LzInStreamBuf
//===========================================================================
//
//Description:
//
//  This class decompresses an LZ77 compressed stream.  The class could
//  be improved by adding a constructor which allowed the caller to specify
//  the number of index bits and length bits to use when decompressing the
//  compressed input stream.  Of course, this require some changes to the
//  implementation of the class
//
//---------------------------------------------------------------------------
class LzInStreamBuf : public DynamicSizeInStreamBuf
{

public:
    //
    // Constructor
    //
    LzInStreamBuf(
        istream &stream
    );



    //
    // Destructor
    //
    ~LzInStreamBuf();



    //
    // Fills the output buffer (this is an input stream so this call always
    // fails).
    //
    int overflow(int ch = EOF)
    {
        return(EOF);
    }



    //
    // Fills the streambuf's buffer with data.
    //
    int underflow();



private:
    //
    // Determines the next index into the compression window give the current
    // index.
    //
    inline int NextWindowIndex(int index)
    {
        return(index & (WINDOW_SIZE - 1));
    }



    //
    // Get the next bit from the compressed input stream.
    //
    int GetBit();



    //
    // Get the next number of specified bits from the compressed input stream.
    //
    unsigned long GetBits(
        int bitCount
    );



private:
    //
    // Private data used to implement the class.
    //
    enum
    {
        INDEX_BIT_COUNT     =   11,     // Bits to use for indices into text window
        LENGTH_BIT_COUNT    =   2,      // Bits to use for length of an encoded phrase
        WINDOW_SIZE         =   (1 << INDEX_BIT_COUNT),
        BREAK_EVEN          =   ((1 + INDEX_BIT_COUNT + LENGTH_BIT_COUNT)/9),
        END_OF_STREAM       =   0
    };

    istream &m_Stream;
    unsigned long m_BufSize;
    unsigned long m_Rack;
    int   m_CurChar;
    int   m_CurrentIndex;
    unsigned char *m_Window;
    unsigned char m_Mask;
};


#endif
