#ifndef __LOGGER_OSD
#define __LOGGER_OSD

//File - LOG_OSD.H
//***************************************************************************
//
//Description: osd layer functions for the logger
//
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:  Bill Smith
//Date: 7/7/95
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include "osd_util.h"

//Definitions - Defines & Constants -----------------------------------------

// there are 1000 milliseconds in a second
const uLONG MILLI = 1000;

//Definitions - Structure & Typedef -----------------------------------------


//Variables - External ------------------------------------------------------


//Variables - Global --------------------------------------------------------


//Variables - File Scope ----------------------------------------------------


//Prototypes - function -----------------------------------------------------

#ifdef __cplusplus
	extern "C" {
#endif

// osd logger init stuff
uLONG osdLoggerInit();

// osd engine message handler and is the main thread,  it sends a
// MSG_LOG_REGISTER with any OSD input.  When a MSG_LOG_UNLOAD
// comes from the engine this function will send a MSG_LOG_UNREIGSTER
// and return back into main for thread clean up

// if the parameter is true then a MSG_SLOG_REGISTER is sent as well
void osdLoggerMessageHandler(uLONG);

// osd exit function
void osdLoggerExit();

// get the directory which th elogger is executing from
void osdGetExecutingDir(char *, void *);

// thread cleanup
void osdThreadCleanup();

// stops and unloads the logger, should fire off a thread to sleep
// for a few seconds after it gets control of the loggerAccessSem
// then do what it needs to stop the logger
void osdHaltLogger();

// used for time debugging
void osdStartStopWatch();
void osdStopStopWatch();

// get the name of the machine we are currently running on.  right now
// OS/2 is the only one that can not get the name
void osdGetMachineName(char *);

// checks to see if there is another instance of the logger already running, basically
// tries to create a named semaphore, if there is not one out there then it is the first
int AnotherInstance();

// shutsdown the host OS
void osdShutdownSystem();

// get the version of the OS that we are running on.  It must fit into a 10 byte NULL terminated string
void osdGetOSversion(char *);

#ifndef _DPT_OS2
// sets the exception handler for the program,  or on a thread basis
void osdSetExceptionHandler();
#else

void os2SetExceptionHandler(PEXCEPTIONREGISTRATIONRECORD err_P);

#define osdSetExceptionHandler()	{}\
									EXCEPTIONREGISTRATIONRECORD err; \
									if (runFlags & (FLG_TURN_ON_JARVIS | FLG_ENABLE_EXCEPTION_HANDLING)) \
										os2SetExceptionHandler(&err);


#endif

#ifdef _DPT_WIN_NT
void SendInformationEvent(char *);
void SendWarningEvent(char *);
void SendNTEvent(char *, uCHAR eType, uLONG eID, uLONG category);
#endif

#ifdef __cplusplus
   };
#endif


#endif
