#ifndef	FLASH_HPP
#define	FLASH_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  10/10/98
*
*****************************************************************************
*
* File Name:		Flash.hpp
* Module:
* Contributors:		Mark Salyzyn
* Description:
* Version Control:
*
* $Revision: 18 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include <iostream.h>
/*** CONSTANTS ***/
enum FlashRegion { FW, I2OBIOS, SMOR, NVRAM };

#define FLASH_FIRMWARE_OFFSET	0
#define FLASH_FIRMWARE_SIZE 	1523712L
#define FLASH_BIOS_OFFSET		(FLASH_FIRMWARE_SIZE+FLASH_FIRMWARE_OFFSET)
#define FLASH_BIOS_SIZE			32768
#define FLASH_SMOR_OFFSET		(FLASH_BIOS_SIZE+FLASH_BIOS_OFFSET)
#define FLASH_SMOR_SIZE			229376L
#define FLASH_NVRAM_OFFSET		(FLASH_SMOR_SIZE+FLASH_SMOR_OFFSET)
#define FLASH_NVRAM_SIZE		4096
#define MAX_FLASH_NVRAM_SIZE  8192 // 8K is max size for NVRAM

/* The engine can only handle this maximum transfer size */
#define BYTES_PER_TRANSFER		512

/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
class Flash: public Command
	{
	public:

		// flash an HBA with the specified image
		Flash( char * sourceFile, int resync, int hba = -1);
		Flash( const Flash &right );
		virtual	~Flash();

		Dpt_Error	execute( String_List **output );
		Command		&Clone() const;

	private:
		enum
		{
			Mode0BootSize	= 16 * 1024
		};


		Dpt_Error Flash_This_HBA(
			String_List &output,
			istream &firmwareStream
		);


        Dpt_Error PrintHBA(
            String_List &output
        );


        Dpt_Error SetFlashRegion(
            FlashRegion region
        );


		Dpt_Error ReadFlashMemory(
            void *buf,
            uLONG offset,
            uLONG bytesToRead
        );

        Dpt_Error WriteFlashMemory(
            void *buf,
            uLONG bytesToRead
        );

        Dpt_Error WriteFlashMemoryDone(
            bool failed
        );

		Dpt_Error GetFlashStatus(
			dptFlashStatus_S &flashStatus
		);

		Dpt_Error GetStartingFlashIndex(
			const FlashRegion flashRegion,
			const uLONG imageSize,
			const int flashFileProcessorFamily,
			uLONG &startingOffset
		);

		Dpt_Error WriteSeekToIndex(
			uLONG seekIndex
		);

		bool ValidFlashFileForController(
			const char *fileDescriptionModel,
			const char *controllerModel
		) const;

		int DetermineOffset(int c);
		int m_FlashFileProcessorFamily;

	    char *source;
		int hba_Num;
        DPT_TAG_T hbaTag;
        int Resync;
		unsigned long imageSize;
      unsigned long loadInfo;

		unsigned long ScanOffset, ScanSize, ScanFwId;
		unsigned short ScanYear;
		unsigned char ScanState, ScanMonth, ScanDay;
		unsigned char ScanBuild[5], ScanVersion[8], ScanType[9];
		char ScanDescriptionHba[7];
      int ScanDescrIdx;
      bool inMode0;

	};

#endif
/*** END OF FILE ***/
