/****************************************************************************
*
* Copyright (C) 2000 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  1/18/2000
*
*****************************************************************************
*
* File Name:		DynSize.cpp
* Module:
* Contributors:		David Dillard
* Description:		Contains the implementation of the DynamicSizeInStreamBuf
*                   class.
* Version Control:
*
* $Revision: 3 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "dynsize.h"





//=============================================================================
//
//Name: DynamicSizeInStreamBuf::AllocBuf
//
//Abstract: Allocates a variable size buffer, based upon available memory,
//          for buffering data.
//
//Parameters: maxSize - Maximum size, in bytes, of the buffer to be allocated
//            minSize - Minimum size, in bytes, of the buffer to be allocated
//            decrementSize - The size, in bytes, to decrement with each
//                          allocation attempt until the allocation is made or
//                          until 'minSize' is passed
//
//Return Values: The size, in bytes, of the buffer that was allocated.  If
//               there was insufficient memory to allocate a buffer of
//               'minSize' bytes then zero is returned.
//
//Error Codes: None
//
//Global Variables Affected: None
//
//Notes: None
//
//-----------------------------------------------------------------------------
size_t DynamicSizeInStreamBuf::AllocBuf(
    size_t maxSize,
    size_t minSize,
    size_t decrementSize
)
{

    size_t allocatedSize = 0;


    //
    // Loop trying to get the maximum amount of memory possible.
    //
    for ( size_t curSize = maxSize;  curSize >= minSize;  curSize -= decrementSize )
    {
        char *buf = new char[curSize];
        if ( buf != NULL )
        {
#if !defined __MWERKS__        
            setb(buf, buf + curSize, 1);
#else            
            pubsetbuf (buf, curSize);
#endif            
            setg(buf, buf, buf);
            setp(NULL, NULL);
            allocatedSize = curSize;
            break;
        }
    }



    //
    // Return the number of bytes allocated to the caller.
    //
    return(allocatedSize);
}
