#ifndef __DRV_BUSY_HPP
#define __DRV_BUSY_HPP
/*
 * Copyright (c) 1996-1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 *
 * UNIX based drive busy checking routine.
 *
 *      1999/02/11 salyzyn@dpt.com
 *              Initial creation
 */

#include "ctlr_map.hpp"

class DPTDriveBusy : public DPTControllerMap
{
#if defined _DPT_NETWARE
public:
#endif
        typedef struct DPTDriveBusyDeviceList {
                struct DPTDriveBusyDeviceList * Next;
                struct DPTDriveBusyDeviceList * Link;
                int                                                             Major;
                int                                                             Minor;
                char                                                    Name[1];
        } DPTDeviceList;
#if !defined _DPT_NETWARE
public:
#endif
        DPTDriveBusy() {}
        ~DPTDriveBusy() {}

        /* Methods */
        int drvBusy(int hba, int bus, int target, int lun);

private:
        int newDeviceList (DPTDeviceList ** List, char * name);
        void deleteDeviceList (DPTDeviceList * List);

        /* Inherited from DPTControllerMap */
        char* Strdup(char* String)
                { return DPTControllerMap::Strdup(String); }
        char* getTargetString(int hba, int bus, int target, int lun)
                { return DPTControllerMap::getTargetString(hba, bus, target, lun); }
    char* getTargetPath(int hba, int bus, int target, int lun)
                { return DPTControllerMap::getTargetPath(hba, bus, target, lun); }
        FILE * SafePopenRead(char* commands)
                { return DPTControllerMap::SafePopenRead(commands); }
    int SafePclose(FILE* fp)
                { return DPTControllerMap::SafePclose(fp); }
#if (defined(_DPT_WIN_NT))
    enum DPTControllerMap::PathExists PathExists(char* path)
                { return DPTControllerMap::PathExists(path); }
#elif defined _DPT_NETWARE
    enum PathExists_t PathExists(char*path)
                { return DPTControllerMap::PathExists(path); }
#else
    enum PathExists PathExists(char* path)
                { return DPTControllerMap::PathExists(path); }
#endif
};

extern "C" {
    extern int drv_busy(int hba, int bus, int target, int lun);
}

#endif /* __DRV_BUSY_HPP */
