#ifndef		__DPT_API_H
#define		__DPT_API_H

//File - DPT_APP.H
//***************************************************************************
//
//Description:
//
//	This file contains the function prototypes and type definitions
//for the 'C' interface to the DPT engine and the DPT communication engine.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		5/4/94
//
//Editors:
//   Mark   Date          Who    Comment
//          9/12/96       Garg   Moved typedef DPT_ENGINE_FN_T to inside
//                               of extern "C" so that it works with C++
//
//Remarks:
//
//
//***************************************************************************


  // Standard DPT stuff
#include	"osd_util.h"

  // Fundamental DPT Engine data structures
#ifdef	__cplusplus
   #include	"eng_std.hpp"
#else
   #include	"eng_std.h"
#endif

  // Engine message definitions
#include	"dpt_msg.h"
  // Engine return values and error codes
#include	"dpt_rtn.h"
  // Data structures returned by MSG_GET_INFO
#include	"dpt_info.h"
  // Engine I/O buffer structures
#include	"dpt_buff.h"
  // System information data structures
#include	"sys_info.h"
  // DPT signature structure
#include	"dptsig.h"
  // Engine entry points
#include	"engine.h"

  // HBA log structure definitions
#include	"hba_log.h"
#ifdef	__cplusplus
     // HBA log facilitator class
   #include	"hba_log.hpp"
#endif


//************************************************************************
//			External Data Declarations
//------------------------------------------------------------------------

  // Ascii representation of DPT engine messages
extern char *	DPT_Messages[];
  // Maximum engine message array index
extern uLONG	DPT_MaxMessage;
  // Ascii representation of DPT return values and error codes
extern char *	DPT_ReturnCodes[];
  // Maximum return code array index
extern uLONG	DPT_MaxReturnCode;


//************************************************************************
//			'C' Interface
//------------------------------------------------------------------------

#ifdef	__cplusplus
   extern "C" {
#endif

  // Define a pointer to a DPT engine function
  //   - So that a single pointer can be defined to point to either
  //     DPT_CallEngine() or DPT_CallCommEngine()
  // It can be used for run-time dynamic linking of engine DLL too.
typedef DPT_RTN_T (*DPT_ENGINE_FN_T)(DPT_TAG_T,DPT_MSG_T,DPT_TAG_T,void *,void *,uLONG);

//==============================
// DPT Engine Iterface Functions
//==============================

  // Initializes and loads the DPT engine
  // Returns:
  //	0		= Successful - OK to use DPT_CallEngine()
  //	Non-zero	= Failure - Do not use DPT_CallEngine()
DPT_RTN_T	DPT_OpenEngine(void);

  // Provides access to the DPT engine
  // Parameters:
  //	connTag		= Connection tag (access handle)
  //	msg		= Engine message (see DPT_MSG.H)
  //	tgtTag		= Tag of the target engine object
  //	fromEng_P	= Buffer for data transmitted from the engine to
  //			  an application (Must comply with dptBuffer_S format)
  //	toEng_P		= Buffer for data transmitted from an application
  //			  to the engine (Must comply with dptBuffer_S format)
  //	timeout		= Message timeout value (0 = No timeout)
  // Returns:
  //	See DPT_RTN.H for a list of valid return values
#if !defined(_DPT_UNIX) && !defined(_SINIX)  //__UNIX__
#ifdef	__cplusplus
inline DPT_RTN_T	DPT_CallEngine(DPT_TAG_T connTag,DPT_MSG_T msg,DPT_TAG_T tgtTag,void *fromEng_P,void *toEng_P,uLONG timeout) {
   return (DPT_Engine(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout));
}
#else
   #define DPT_CallEngine(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout) DPT_Engine(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout)
#endif
#else
	DPT_RTN_T DPT_CallEngine(DPT_TAG_T, DPT_MSG_T, DPT_TAG_T, void *, void *, uLONG);

#endif

  // Gracefully unloads the DPT engine
DPT_RTN_T	DPT_CloseEngine(void);

//=============================================
// DPT Communication Engine Interface Functions
//=============================================

#if defined(HAS_COMM_ENG) && defined(NEW_COMM_ENG)
// prototypes that were not made available in a include file from anywhere else, therefore I am forced
// to place it here.  
DPT_RTN_T DPT_IMPORT DPTCE_StartUp(char *pathname);
void DPT_IMPORT DPTCE_ShutDown();

#endif
  // Initializes and loads the DPT communication engine
  // Returns:
  //	0		= Successful - OK to use DPT_CallCommEngine()
  //	Non-zero	= Failure - Do not use DPT_CallCommEngine()
DPT_RTN_T	DPT_OpenCommEngine(void);

  // Provides access to the DPT communication engine
  // Parameters:
  //	connTag		= Connection tag (access handle)
  //	msg		= Engine or Comm. engine message (see DPT_MSG.H)
  //	tgtTag		= Tag of the target engine object
  //	fromEng_P	= Buffer for data transmitted from the engine to
  //			  an application (Must comply with dptBuffer_S format)
  //	toEng_P		= Buffer for data transmitted from an application
  //			  to the engine (Must comply with dptBuffer_S format)
  //	timeout		= Message timeout value (0 = No timeout)
  // Returns:
  //	See DPT_RTN.H for a list of valid return values
DPT_RTN_T DPT_IMPORT DPT_CallCommEng(DPT_TAG_T connTag,DPT_MSG_T msg,DPT_TAG_T tgtTag,void *fromEng_P,void *toEng_P,uLONG timeout);

#if defined(HAS_COMM_ENG) && defined(NEW_COMM_ENG)
#if !defined(_DPT_UNIX) && !defined(_SINIX)  //__UNIX__
#ifdef	__cplusplus
inline DPT_RTN_T	DPT_CallCommEngine(DPT_TAG_T connTag,DPT_MSG_T msg,DPT_TAG_T tgtTag,void *fromEng_P,void *toEng_P,uLONG timeout) {
   return (DPT_CallCommEng(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout));
}
#else
   #define DPT_CallCommEngine(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout) DPT_CallCommEng(connTag,msg,tgtTag,fromEng_P,toEng_P,timeout)
#endif
#else
	DPT_RTN_T DPT_CallCommEng(DPT_TAG_T, DPT_MSG_T, DPT_TAG_T, void *, void *, uLONG);

#endif
#endif //dz defined(HAS_COMM_ENG) && defined(NEW_COMM_ENG)

  // Gracefully unloads the DPT communication engine
DPT_RTN_T	DPT_CloseCommEngine(void);

#ifdef	__cplusplus
   };	// end - extern "C"
#endif


#endif
