#ifndef	CREATRAD_HPP
#define	CREATRAD_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/17/98
*
*****************************************************************************
*
* File Name:		CreatRad.hpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 13 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
class Create_Raid:public Command
	{
	public:
		Create_Raid(
				SCSI_Addr_List	*addresses,			// a list of addresses from which the
													// raid will be created.
				Raid_Type raid_Type,
				uLONG size_of_Stripe,
				uLONG raid_Size_in_Blocks	= 0,	// zero means use default
				bool nobuildOption = (bool)false,	// default to false (build)
				bool ignoreNonfatalErrorsOption = (bool)false,
				int numDrivesPerArray = 0,			// set to 0 if not given
				SCSI_Addr_List	*compsOmit = NULL);	// do not include in array/s

		Create_Raid (const Create_Raid &new_Create_Raid);
		virtual ~Create_Raid ();
		Create_Raid	&operator = (Create_Raid &right);

		Dpt_Error execute (String_List	**output);
		Command &Clone () const;

	private:
		Dpt_Error MakeGroupLists (String_List **output);

		//calculates total raid size
		uLONG CalculateRaidSize (Int_List* drive_List, int groupNum);

		Dpt_Error Create (Raid_Type raidType, int level, 
					 Int_List *addressList, uLONG stripeSize = 0,
					 uLONG desiredRaidSizeInBlocks = 0,
					 DPT_TAG_T * this_RAID_Tag = NULL);

		Raid_Type		raid_Type;
		uLONG			stripe_Size;
		uLONG			desired_Raid_Size_in_Blocks;
		int				targetHba;
		int				drivesPerArray;
		const bool		nobuild;
		const bool		ignoreNonfatalErrors;
		SCSI_Addr_List	*address_List;
		SCSI_Addr_List	*comps_Omit;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
