#ifndef	CONFIG_HPP
#define	CONFIG_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  12/1/1999
*
*****************************************************************************
*
* File Name:		Config.hpp
* Module:
* Contributors:	Karla Summers
* Description:		This command loads and saves controller configuration
* Version Control:
*
* $Revision: 1 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
/*** CONSTANTS ***/
enum ConfigureOption { LoadCfg, SaveCfg };
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
class Config: public Command
	{
	public:

		// configure an HBA with the specified image
		Config (char * fName, ConfigureOption option, 
         bool nobuildOption);
		Config (const Config &new_Config);
		virtual ~Config ();

		Dpt_Error execute (String_List **output);
		Command &Clone () const;

	private:

      void DeleteAllArrays(void);
      Dpt_Error SetSysConfig(void);
      Dpt_Error SaveConfig (FILE * fp);
		Dpt_Error LoadConfig (FILE * fp);
      char * fileName;
		char * image;
      bool noBuild;
      ConfigureOption configOption;

      typedef struct {
         char signature[5];
         char bullshit[3];
         uLONG compatibilityValue;
         uLONG dataSize;
      } dsmHdr_S;

      typedef struct {
         uCHAR arrayFlags;
         uCHAR raidType;
         uCHAR pad[2];
      } smUserBuff_S;
	};

#endif
/*** END OF FILE ***/
