/************************ Start of BUFIOLSB.C ************************
 *
 */
#include "osd_util.h"
#include    <stdio.h>
#include    <stdlib.h>
#include    "bufio.h"

#define  TRUE  1
#define  FALSE 0

#ifdef __cplusplus
extern "C"
{
#endif

IOBUF *OpenOutputBuf( char *buf[], int numbufs )
{
	IOBUF *iobuf;
	int i;

	iobuf = (IOBUF *) calloc( 1, sizeof( IOBUF ) );
	if ( iobuf == NULL )
		return( iobuf );
	for(i = 0; i < numbufs; i++) iobuf->buf[i] = buf[i];
	iobuf->numbufs = numbufs;
	iobuf->curbuf = 0;
	iobuf->rack = 0;
	iobuf->mask = 0x01;
	iobuf->bufptr = 0L;
	return( iobuf );
}

IOBUF *OpenInputBuf( char *buf[], int numbufs )
{
	IOBUF *iobuf;
	int i;

	iobuf = (IOBUF *) calloc( 1, sizeof( IOBUF ) );
	if ( iobuf == NULL )
		return( iobuf );
	for(i = 0; i < numbufs; i++) iobuf->buf[i] = buf[i];
	iobuf->numbufs = numbufs;
	iobuf->curbuf = 0;
	iobuf->rack = 0;
	iobuf->mask = 0x01;
	iobuf->bufptr = 0L;
	return( iobuf );
}

void CloseOutputBuf( IOBUF *iobuf )
{
	if ( iobuf->mask != 0x01 )
		putbufc( iobuf->rack, iobuf );
	free( (char *) iobuf );
}

void CloseInputBuf( IOBUF *iobuf )
{
	free( (char *) iobuf );
}

void putbufc(int c, IOBUF *iobuf)
{
	iobuf->buf[iobuf->curbuf][iobuf->bufptr++] = c;
	if(iobuf->bufptr == 64512)
	{
		iobuf->curbuf++;
		iobuf->bufptr = 0L;
	}
}

/*
void OutputBufBit( IOBUF *iobuf, int bit )
IOBUF *iobuf;
int bit;
{
	if ( bit )
		iobuf->rack |= iobuf->mask;
	iobuf->mask <<= 1;
	if ( iobuf->mask == 0 )
	{
		iobuf->buf[iobuf->bufptr++] = iobuf->rack;
		if(iobuf->bufptr == 64512)
		{
			iobuf->curbuf++;
			iobuf->bufptr = 0L;
		}
		iobuf->rack = 0;
		iobuf->mask = 0x01;
	}
}
*/
int InputBufBit( IOBUF *iobuf )
{
	int value;

	if ( iobuf->mask == 0x01 )
	{
		iobuf->rack = iobuf->buf[iobuf->curbuf][iobuf->bufptr++];
		if(iobuf->bufptr == 64512)
		{
			iobuf->curbuf++;
			iobuf->bufptr = 0L;
		}
	}
	value = iobuf->rack & iobuf->mask;
	iobuf->mask <<= 1;
	if ( iobuf->mask == 0 )
	iobuf->mask = 0x01;
	return( value ? 1 : 0 );
}

/*
void OutputBufBits( IOBUF *iobuf, unsigned long code, int count )
{
	unsigned long mask;

	mask = 1L;
	while ( count-- > 0)
	{
		if ( mask & code )
			iobuf->rack |= iobuf->mask;
		iobuf->mask <<= 1;
		if ( iobuf->mask == 0 )
		{
			iobuf->buf[iobuf->bufptr++] = iobuf->rack;
			if(iobuf->bufptr == 64512)
			{
				iobuf->curbuf++;
				iobuf->bufptr = 0L;
			}
			iobuf->rack = 0;
			iobuf->mask = 0x01;
		}
		mask <<= 1;
	}
}
*/
unsigned long InputBufBits( IOBUF *iobuf, int bit_count )
{
	unsigned long mask;
	unsigned long return_value;

	mask = 1L;
	return_value = 0;
	while ( bit_count-- > 0)
	{
		if ( iobuf->mask == 0x01 )
		{
			iobuf->rack = iobuf->buf[iobuf->curbuf][iobuf->bufptr++];
			if(iobuf->bufptr == 64512)
			{
				iobuf->curbuf++;
				iobuf->bufptr = 0L;
			}
//       if ( iobuf->rack == EOF )
//       ;
//          fatal_error( "Fatal error in InputBit!\n" );
		}
		if ( iobuf->rack & iobuf->mask )
			return_value |= mask;
		mask <<= 1;
		iobuf->mask <<= 1;
		if ( iobuf->mask == 0 )
			iobuf->mask = 0x01;
	}
	return( return_value );
}

#ifdef __cplusplus
}
#endif


