//File - DSTATLOG.CPP
//***************************************************************************
//
//Description:
//
//    This file contains the function definitions for the dptDevStatLog_C
//and dptHBAstatLog_C classes.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		6/12/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include	"stats.h"
#include	"stat_log.hpp"


//Function - dptDevStatLog_C::reverseParam() - start
//===========================================================================
//
//Description:
//
//    This function is called from reverseAllParams() to provide an
//opportunity to reverse the data portion of the log parameters.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

void	dptDevStatLog_C::reverseParam()
{

   uSHORT		i;
   DPT_UNALIGNED uLONG	*stat_P;

  // Determine the # of uLONG statistics for this parameter
uSHORT numStats = 0;
switch (code()) {
   case 1: numStats = sizeof(readStats_S)>>2;		break;
   case 3: numStats = sizeof(writeStats_S)>>2;		break;
   case 2:
   case 4: numStats = sizeof(rwSizeStats_S)>>2;		break;
   case 5: numStats = sizeof(miscDevStats_S)>>2;	break;
   case 6: numStats = sizeof(rwSizeStat2_S)>>2;		break;
   case 7: numStats = sizeof(rwSizeStat2_S)>>2;		break;
}

  // Get a pointer to the statistics data
stat_P = (uLONG *) data_P();

for (i=0;i<numStats;i++)
     // Reverse the uLONG statistic
   reverseBytes(stat_P[i]);

}
//dptDevStatLog_C::reverseParam() - end


//Function - dptHBAstatLog_C::reverseParam() - start
//===========================================================================
//
//Description:
//
//    This function is called from reverseAllParams() to provide an
//opportunity to reverse the data portion of the log parameters.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

void	dptHBAstatLog_C::reverseParam()
{

   uSHORT		i;
   DPT_UNALIGNED uLONG	*stat_P;
   uSHORT		numStats = 0;

if (code()==1)
   numStats = sizeof(hbaStats_S)>>2;

  // Get a pointer to the statistics data
stat_P = (uLONG *) data_P();

for (i=0;i<numStats;i++)
     // Reverse the uLONG statistic
   reverseBytes(stat_P[i]);

}
//dptHBAstatLog_C::reverseParam() - end


