//File - RAID.CPP
//***************************************************************************
//
//Description:
//
//    This file contains function definitions for RAID related data
//structures.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		3/25/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************
#include "allfiles.hpp"


//Function - raidParent_S::raidParent_S() - start
//===========================================================================
//Description:
//    This function is the constructor for the raidParent_S structure.
//---------------------------------------------------------------------------

raidParent_S::raidParent_S()
{

	startLBA	= 0;
	stripeSize	= 0;
	numStripes	= 0;

	dev_P = NULL;
	flags  = 0;

}
//raidParent_S::raidParent_S() - end


//Function - raidParent_S::reset() - start
//===========================================================================
//
//Description:
//
//    This function is resets the RAID parent structure.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

void	raidParent_S::reset()
{

if (dev_P) {
	dev_P->decCompCount(); // Decrement the parent device's component count
	if (dev_P->myHBA_P()) {
		dev_P->myHBA_P()->decRaidEntries(); // Decrement the HBA's RAID table entry count
		if (dev_P->getCompCount() == 0)
			dev_P->myHBA_P()->decRaidEntries(); // Decrement the RAID table entry count for the array itself
	}
}

startLBA	= 0;
stripeSize	= 0;
numStripes	= 0;

dev_P = NULL;
flags  = 0;

}
//raidParent_S::reset() - end


//Function - raidDef_S::raidDef_S - start
//===========================================================================
//
//Description:
//
//    This function is the constructor for the raidDef_S structure.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

raidDef_S::raidDef_S()
{

  // Initialize the RAID definition data
refNum		= 0;
type		= 0;
minDrives	= 2;
maxDrives	= 2;
redundants	= 1;
minStripe	= 1;
maxStripe	= 0xffffffffL;
chanCount	= 0xffff;
required	= 0;
devType		= 0;
permit		= 0;

}
//raidDef_S::raidDef_S() - end



