#ifndef         __PTRARRAY_HPP
#define         __PTRARRAY_HPP

//File - PTRARRAY.CPP
//***************************************************************************
//
//Description:
//
//    This file contains the class definition for an array that holds a
//list of pointers.  The pointers can point to any type of object, thus
//this class cannot delete the objects held in the list.
//
//Copyright Distributed Processing Technology, Corp.
//        140 Candace Dr.
//        Maitland, Fl. 32751   USA
//        Phone: (407) 830-5522  Fax: (407) 260-5366
//        All Rights Reserved
//
//Author:       Doug Anderson
//Date:         10/6/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


#include        "array.hpp"


//Class - ptrArrayList_C - start
//===========================================================================
//
//Description:
//
//   This class defines an array of pointers.  Functions are provided
//tp make the array act like a linked list of pointers.
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

class   ptrArrayList_C : public baseArray_C
{

public:
     // Current object index
    uSHORT      curIndex;
#if (!defined(MINIMAL_BUILD))
    uSHORT      reserved;
#endif

protected:

public:

// Constructor/Destructor.............................

    ptrArrayList_C();

// List Management Functions..........................

     // Point to the end of the list
    void *      end();

     // Point to one beyond the end of the list
    void        nullIt() { curIndex = getNumObjs(); }

      // Returns a pointer to the current object
    void *      cur();

     // Makes the first list object the current object and returns a
     // pointer to the first object in the list.
    void *      reset();
     // Returns a pointer to the next object in the list.
    void *      next();
     // Returns a pointer to the previous object in the list.
    void *      previous();

   // sets the current items in the list to the one specifed, if it fails the current is unchanged
    uCHAR       setCur(uSHORT);

     // Determines if the specified object is in the list.  If the
     // specified object is in the list, it is made the current object.
    uSHORT      exists(void *);

     // Add the specified pointer in front of the current object
    uSHORT      add(void *obj_P)
        {
            return (addAt((void *) &obj_P,curIndex));
        }

          // Add the specified pointer to the front of the list
    uSHORT      addFront(void *obj_P)
        {
            return (baseArray_C::addFront((void *) &obj_P));
        }

     // Add the specified pointer to the end of the list
    uSHORT      addEnd(void *obj_P)
        {
            return (baseArray_C::addEnd((void *) &obj_P));
        }

     // Removes the list element associated with the current object
     // (The object itself is not deleted, just removed from the list)
    void *      remove();
     // Removes the list element associated with the current object
     // (The object itself is not deleted, just removed from the list)
    void *      remove(void *obj_P);

     // Remove all objects from the array
    void        flush() { remAll(); }

     //
    uSHORT      swap(void * obj1_P, void * obj2_P);

// Return List Info...................................

     // Return the # of objects currently in the list
    uSHORT      size() { return (getNumObjs()); }

};
//ptrArrayList_C - end


#endif
