#ifndef		__HBA_LOG_HPP
#define         __HBA_LOG_HPP

//File - HBA_LOG.HPP
//***************************************************************************
//
//Description:
//
//    This function defines the dptHBAlog_C class.  This class is used
//to access an HBA's event log.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		6/4/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include	"dpt_log.hpp"
#include	"hba_log.h"

#ifndef NO_PACK
#if defined (_DPT_AIX)
#pragma options align=packed
#else
#pragma pack(1)
#endif  // aix
#endif

//class - dptHBAlog_C - start
//===========================================================================
//
//Description:
//
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

class	dptHBAlog_C : public dptSCSIlog_C
{

public:
			dptHBAlog_C();

// Data...............................................

     // Byte offset to next valid parameter in the log buffer
   uSHORT		fwEventBytes;
     // Byte offset to the current parameter
   uSHORT		curEventBytes;

protected:
// Virtual Functions..................................

     // Called from reverseAllParams() for each parameter encountered.
     //   - Allows the data portion of each parameter to be reversed
   virtual void		reverseParam();
     // Initialize log page specific variables
   virtual void		calcInit();
     // Calculate log page specific variables
   virtual void		calcInfo();
   virtual void		curOffsetInit();
     // Calculate the byte offset of the current parameter
   virtual void		calcCurOffset();

public:

// Return Private Data................................

     // Return the total # of FW event bytes read
   uSHORT		eventBytes() {
			   return (fwEventBytes);
			}
     // Return the byte offset of the current parameter
   uSHORT		curOffset() {
			   return (curEventBytes);
			}

};
//dptHBAlog_C - end

#ifndef NO_UNPACK
#if defined (_DPT_AIX)
#pragma options align=reset
#elif defined (UNPACK_FOUR)
#pragma pack(4)
#else
#pragma pack()
#endif  // aix
#endif

#endif
