#include "debug.h"
#ifdef _SNI_MIPS
#include <values.h>
#endif


#if SNI_DEBUG != 0
int   	Debug::debugLevel = 10;
Debug 	Debug::out;
int	Debug::count	  = 0;

ofstream fst("/tmp/debug.log");
ostream *Debug::ost = &fst;
#endif


#ifdef SNI_DEBUG_TEST

void test1();

main() {
	// debug output to "/tmp/foo.bar" instead of "/tmp/debug.log"
    //ofstream newFst("/tmp/foo.bar");
    //DEBUG_SETOUTPUT(&newFst);

	// redirect debug output to cerr
    DEBUG_SETOUTPUT(cerr);

    DEBUG_SETLEVEL(5);
    //-------------------------------------------------------------
    cout << endl;
    cout << "before test1() Test1========================" << endl;
    test1();		
    cout << "after test1() Test1" << endl;
    	// ==>output:
	//	before test1() Test1========================
	//
	//	BEGIN 0: level1-----------------
	//	<otto.C 49> otto=1234 localLevel=1 so eine Sahne
	//	END   0: level1-----------------
	//	after test1() Test1

    //-------------------------------------------------------------
    DEBUG_OFF;
    cout << endl;
    cout << "before test1() Test2========================" << endl;
    test1();
    cout << "after test1() Test2" << endl;
	// ==>output:
	//	before test1() Test2========================
	//	after test1() Test2

    //-------------------------------------------------------------
    DEBUG_ON;
    cout << endl;
    cout << "before test1() Test3========================" << endl;
    test1();
    cout << "after test1() Test3" << endl;
    	// ==>output:
	//	before test1() Test3========================
	//
	//	BEGIN 0: level1-----------------
	//	<otto.C 49> otto=1234 localLevel=1 so eine Sahne
	//	<otto.C 50> otto=1234 localLevel=6 so eine Sahne
	//	END   0: level1-----------------
	//	after test1() Test3

}

void test1()
{
    DEBUG_BEGIN(1,test1);
    int kk = 11;
    int otto = 1234;
    const char str[] = "so eine Sahne";

    DEBUG(1,"otto=" << otto << " localLevel=" << debug.GetLocalLevel() << " " << str);
    DEBUG(6,"otto=" << otto << " localLevel=" << debug.GetLocalLevel() << " " << str);
}

#endif // SNI_DEBUG_TEST
