//File - CORE_DEV.CPP
//***************************************************************************
//
//Description:
//
//    This file contains the function definitions for the dptCoreDev_C
//class.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		10/7/92
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************
#include "allfiles.hpp"

//Function - dptCoreDev_C::dptCoreDev_C() - start
//===========================================================================
//
//Description:
//
//    This function is the constructor for the dptCoreDev_C class.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

dptCoreDev_C::dptCoreDev_C()
{

  // Clear all coreFlags
coreFlags = 0;
  // Set the visible level to zero
visibleLevel = 0;
  // Indicate that this object is a device
setDevice();

}
//dptCoreDev_C::dptCoreDev_C() - end


//Function - dptCoreDev_C::supNotDesired() - start
//===========================================================================
//
//Description:
//
//    This function removes the suppression desired status from this
//device.  The device will remain intentionally suppressed only if it
//is a physical device attached to a non-bubbling manager.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

void	dptCoreDev_C::supNotDesired()
{

  // If not a physical device attached to a non-bubbling manager...
if (!(!myMgr_P()->isBubbler() && isPhysical()))
     // Clear the suppression desired flag
   coreFlags &= ~FLG_ENG_SUP_DESIRED;

}
//dptCoreDev_C::supNotDesired() - end


//Function - dptCoreDev_C::getLevel() - start
//===========================================================================
//
//Description:
//
//    This function returns the logical level of this device.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

uSHORT	dptCoreDev_C::getLevel()
{

return (myMgr_P()->getDevLevel(this));

}
//dptCoreDev_C::getLevel() - end


