#ifndef		__CORE_HPP
#define		__CORE_HPP

//File - CORE.HPP
//***************************************************************************
//
//Description:
//
//    This file contains the class definition for the most fundammental
//DPT engine class dptCore_C.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		3/25/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Class - dptCore_C - start
//===========================================================================
//
//Description:
//
//    This is the most fundamental class in the DPT class hiearchy.
//All objects in the DPT engine should have this class as the
//ultimate ancestor.
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//    1. No error checking is performed on the tag counter.
//       If the tag counter were to wrap around to zero,
//       their could potentially be objects with the same tag #
//       which could result in the wrong object recieving an
//       event.  This tag is not checked for wrap around
//       because it was originally implemented as a 32 bit counter
//       and the author assumed there would never be more than
//       4 G objects created during the course of an application.
//
//---------------------------------------------------------------------------

class	dptCore_C
{

// Friends............................................

     // Needs access to the memAllocErr structure
   friend class		dptCoreCon_C;

// Data...............................................

     // Counter used to assign object tags
   static DPT_TAG_T	tagCntr;
     // # of foundation objects in existence
   static uSHORT	classCnt;

     // Unique # assigned to this object
   DPT_TAG_T		dptTag;

//protected:

public:

// Constructor/Destructor.............................

			dptCore_C();
   virtual		~dptCore_C() { classCnt--; }

// Return private data................................

     // Return the object's tag - A unique number associated with this object
   DPT_TAG_T		tag() { return (dptTag); }
     // Return the number of foundation objects in existence
   uSHORT		numEngObjects() { return (classCnt); }

};
//dptCore_C - end


#endif

