#ifndef HEADER_QUERY
#define HEADER_QUERY

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "nick.h"
#include "defines.h"

class tquery {
 private:
    char *name;
  
  public:
    int time;
    char pathname[20];

    int operator==(tquery &nick) {
      return((strcasecmp(name,nick.name)==0)||(strcasecmp(pathname,nick.pathname)==0));
    }
    int operator>=(tquery &nick) {
      return(strcasecmp(name,nick.name)>=0);
    }

    void setname(const char *n) {
      free(name);
      name = mystrdup(n);
    }

    const char *getname(void) {
      return name;
    }

    tquery(tquery &q) {
      name = mystrdup(q.name);
      strcpy(pathname, q.pathname);
      time = q.time;
    }

    tquery(const char *something) {
      name = mystrdup(something);
      pathname[0]=0;
    }

    tquery() {
      name = mystrdup("");
    }

    ~tquery() {
      free(name);
    }
};

#endif
