###############################################################################
# These are the default popups that come with QuIRC.  Please edit the
# userpopups.tcl file to add new popups.
###############################################################################

##### Clear the popups so we don't get more and more popups each time the #####
##### file is loaded.                                                     #####

popup clear maintext ""
popup clear mainentry ""
popup clear statustext ""
popup clear statusentry ""
popup clear querytext ""
popup clear queryentry ""
popup clear chattext ""
popup clear chatentry ""
popup clear channeltext ""
popup clear channelentry ""
popup clear channelnicks ""

##### Query Text Box Popups #####

# CTCP Menu
popup add submenu querytext ".ctcp" "CTCP"
popup add item querytext ".ctcp" "Ping" {
    quote "PRIVMSG [windowname] :\001PING [microtime]\001"
}
popup add item querytext ".ctcp" "Version" {
    quote "PRIVMSG [windowname] :\001VERSION\001"
}
popup add item querytext ".ctcp" "Time" {
    quote "PRIVMSG [windowname] :\001TIME\001"
}
popup add item querytext ".ctcp" "Userinfo" {
    quote "PRIVMSG [windowname] :\001USERINFO\001"
}
popup add item querytext ".ctcp" "Finger" {
    quote "PRIVMSG [windowname] :\001FINGER\001"
}
popup add item querytext ".ctcp" "Clientinfo" {
    quote "PRIVMSG [windowname] :\001CLIENTINFO\001"
}

# DCC Chat
popup add item querytext "" "DCC Chat" {
    dcc chat [windowname]
}

# DCC Send
popup add item querytext "" "DCC Send..." {
    dccsenddialog [index] [windowname]
}

# Whois
popup add item querytext "" "Whois" {
    quote "WHOIS [windowname]"
}

# Whois Idle
popup add item querytext "" "Whois Idle" {
    quote "WHOIS [windowname] [windowname]"
}


##### Channel Text Box Popups #####

# CTCP Menu
popup add submenu channeltext ".ctcp" "CTCP"
popup add item channeltext ".ctcp" "Ping" {
    quote "PRIVMSG [channel] :\001PING [microtime]\001"
}
popup add item channeltext ".ctcp" "Version" {
    quote "PRIVMSG [channel] :\001VERSION\001"
}
popup add item channeltext ".ctcp" "Time" {
    quote "PRIVMSG [channel] :\001TIME\001"
}
popup add item channeltext ".ctcp" "Userinfo" {
    quote "PRIVMSG [channel] :\001USERINFO\001"
}
popup add item channeltext ".ctcp" "Finger" {
    quote "PRIVMSG [channel] :\001FINGER\001"
}
popup add item channeltext ".ctcp" "Clientinfo" {
    quote "PRIVMSG [channel] :\001CLIENTINFO\001"
}

# The Mode Window
popup add item channeltext "" Modes {
    set special [index][string trim [pathname channel [channel]] "."]
    set wn .modes$special
    toplevel $wn
    wm title $wn "Modes [channel] \[[index]]"
    pack [checkbutton $wn.i -text "Invite Only (+i)" -variable "modei$special"]
    if { [channelmode i [channel]] } { $wn.i select } else { $wn.i deselect }
    pack [checkbutton $wn.m -text "Moderated (+m)" -variable "modem$special"]
    if { [channelmode m [channel]] } { $wn.m select } else { $wn.m deselect }
    pack [checkbutton $wn.n -text "No External Messages Allowed (+n)" -variable "moden$special"]
    if { [channelmode n [channel]] } { $wn.n select } else { $wn.n deselect }
    pack [checkbutton $wn.p -text "Private (+p) \[Older]" -variable "modep$special"]
    if { [channelmode p [channel]] } { $wn.p select } else { $wn.p deselect }
    pack [checkbutton $wn.s -text "Secret (+s)" -variable "modes$special"]
    if { [channelmode s [channel]] } { $wn.s select } else { $wn.s deselect }
    pack [checkbutton $wn.t -text "Op Topics (+t)" -variable "modet$special"]
    if { [channelmode t [channel]] } { $wn.t select } else { $wn.t deselect }
    pack [checkbutton $wn.k -text "Keyword (+k)" -variable "modek$special"]
    if { [channelmode k [channel]]!="" } { $wn.k select } else { $wn.k deselect }
    pack [entry $wn.k_entry]
    $wn.k_entry insert end [channelmode k [channel]]
    pack [checkbutton $wn.l -text "Limit (+l)" -variable "model$special"]
    if { [channelmode l [channel]] } { $wn.l select } else { $wn.l deselect }
    pack [entry $wn.l_entry]
    if { [channelmode l [channel]]!=0 } {
	$wn.l_entry insert end [channelmode l [channel]]
    }
    pack [checkbutton $wn.bigr -text "Registered Users Only (+R)" -variable "modebigr$special"]
    if { [channelmode R [channel]] } { $wn.bigr select } else { $wn.bigr deselect }
    pack [checkbutton $wn.c -text "No Colours (+c)" -variable "modec$special"]
    if { [channelmode c [channel]] } { $wn.c select } else { $wn.c deselect }
    pack [button $wn.go -text "Change Modes!" -command "::[index]::popups::domodes [channel] $wn $special [index]"]
}

proc domodes { channel wn special index } {
    if { [channelmode i $channel] < [set ::modei$special] } { modequeue add $channel +i }
    if { [channelmode i $channel] > [set ::modei$special] } { modequeue add $channel -i }
    if { [channelmode s $channel] < [set ::modes$special] } { modequeue add $channel +s }
    if { [channelmode s $channel] > [set ::modes$special] } { modequeue add $channel -s }
    if { [channelmode p $channel] < [set ::modep$special] } { modequeue add $channel +p }
    if { [channelmode p $channel] > [set ::modep$special] } { modequeue add $channel -p }
    if { [channelmode m $channel] < [set ::modem$special] } { modequeue add $channel +m }
    if { [channelmode m $channel] > [set ::modem$special] } { modequeue add $channel -m }
    if { [channelmode n $channel] < [set ::moden$special] } { modequeue add $channel +n }
    if { [channelmode n $channel] > [set ::moden$special] } { modequeue add $channel -n }
    if { [channelmode t $channel] < [set ::modet$special] } { modequeue add $channel +t }
    if { [channelmode t $channel] > [set ::modet$special] } { modequeue add $channel -t }
    if { [channelmode R $channel] < [set ::modebigr$special] } { modequeue add $channel +R }
    if { [channelmode R $channel] > [set ::modebigr$special] } { modequeue add $channel -R }
    if { [channelmode c $channel] < [set ::modec$special] } { modequeue add $channel +c }
    if { [channelmode c $channel] > [set ::modec$special] } { modequeue add $channel -c }
    if { [channelmode l $channel] && ![set ::model$special] } { modequeue add $channel -l }
    if { [set ::model$special] && [$wn.l_entry get]!=[channelmode l $channel] } { modequeue add $channel +l [$wn.l_entry get] }
    # Check for any change at all in the key state
    set addkey ""
    if { ([channelmode k $channel]!="") != [set ::modek$special] || [channelmode k $channel] != [$wn.k_entry get] } {
	# If there's a previous key, remove it.
	set removedkey 0
	if { [channelmode k $channel]!="" } {
	    modequeue add $channel -k [channelmode k $channel]
	    set removedkey 1
	}
	# If there's key now, add it.
	if { [set ::modek$special] && [$wn.k_entry get]!="" } {
	    if { $removedkey } {
		set addkey "+k [$wn.k_entry get]"
	    } else {
		modequeue add $channel +k [$wn.k_entry get]
	    }
	}
    }
    modequeue flush $channel
    if { $addkey!="" } {
 	::template::quote $index "MODE $channel $addkey"
    }
    destroy $wn
}
# End of Mode Window Code

# Ban List
popup add item channeltext "" "Ban List" {
    /gblist
}

# Who
popup add item channeltext "" "Who" {
    quote "WHO [channel]"
}


##### Channel Nicklist Popups #####

# CTCP Menu
popup add submenu channelnicks ".ctcp" "CTCP"
popup add item channelnicks ".ctcp" "Ping" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001PING [microtime]\001"
    }
}
popup add item channelnicks ".ctcp" "Version" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001VERSION\001"
    }
}
popup add item channelnicks ".ctcp" "Time" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001TIME\001"
    }
}
popup add item channelnicks ".ctcp" "Userinfo" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001USERINFO\001"
    }
}
popup add item channelnicks ".ctcp" "Finger" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001FINGER\001"
    }
}
popup add item channelnicks ".ctcp" "Clientinfo" {
    foreach nick [selectednicks] {
	quote "PRIVMSG $nick :\001CLIENTINFO\001"
    }
}

popup add item channelnicks "" Query {foreach n [selectednicks] {createquery $n}}
popup add item channelnicks "" "DCC Chat" {foreach n [selectednicks] {dcc chat $n}}
popup add item channelnicks "" "DCC Send..." {dccsenddialog [index] [selectednicks]}
popup add item channelnicks "" BanKick {foreach n [selectednicks] {/bk $n}}
popup add item channelnicks "" KickBan {foreach n [selectednicks] {/kb $n}}
popup add item channelnicks "" Kick {foreach n [selectednicks] {quote "KICK [channel] $n"}}
popup add item channelnicks "" "Ban (+b)" {foreach n [selectednicks] {/ban $n}}
popup add item channelnicks "" "Unban (-b)" {foreach n [selectednicks] {/unban $n}}

popup add item channelnicks "" "Op (+o)" {
    foreach nick [selectednicks] {
	if {![isop $nick [channel]]} {
	    modequeue add [channel] +o $nick
	}
    }
    modequeue flush [channel]
}

popup add item channelnicks "" "DeOp (-o)" {
    foreach nick [selectednicks] {
	if {[isop $nick [channel]]} {
	    modequeue add [channel] -o $nick
	}
    }
    modequeue flush [channel]
}

popup add item channelnicks "" "Voice (+v)" {
    foreach nick [selectednicks] {
	if {![isvoice $nick [channel]]} { 
	    modequeue add [channel] +v $nick
	}
    }
    modequeue flush [channel]
}

popup add item channelnicks "" "DeVoice (-v)" {
    foreach nick [selectednicks] {
	modequeue add [channel] -v $nick
    }
    modequeue flush [channel]
}

popup add item channelnicks "" "DeVoice/Ban" {
    foreach nick [selectednicks] {
	modequeue add [channel] -v $nick
	/ban $nick
    }
    modequeue flush [channel]
}

popup add item channelnicks "" Whois {foreach n [selectednicks] {quote "whois $n"} }
popup add item channelnicks "" "Whois Idle" {foreach n [selectednicks] {quote "whois $n $n"}}

##### DCC Chat Popups #####

# DCC CTCP Menu
popup add submenu chattext ".dccctcp" "CTCP (DCC)"
popup add item chattext ".dccctcp" "Ping" {
    dccquote [windowname] "CTCP_MESSAGE \001PING [microtime]\001"
}
popup add item chattext ".dccctcp" "Version" {
    dccquote [windowname] "CTCP_MESSAGE \001VERSION\001"
}
popup add item chattext ".dccctcp" "Time" {
    dccquote [windowname] "CTCP_MESSAGE \001TIME\001"
}
popup add item chattext ".dccctcp" "Userinfo" {
    dccquote [windowname] "CTCP_MESSAGE \001USERINFO\001"
}
popup add item chattext ".dccctcp" "Finger" {
    dccquote [windowname] "CTCP_MESSAGE \001FINGER\001"
}
popup add item chattext ".dccctcp" "Clientinfo" {
    dccquote [windowname] "CTCP_MESSAGE \001CLIENTINFO\001"
}

# Server CTCP Menu
popup add submenu chattext ".ctcp" "CTCP"
popup add item chattext ".ctcp" "Ping" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001PING [microtime]\001"
}
popup add item chattext ".ctcp" "Version" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001VERSION\001"
}
popup add item chattext ".ctcp" "Time" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001TIME\001"
}
popup add item chattext ".ctcp" "Userinfo" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001USERINFO\001"
}
popup add item chattext ".ctcp" "Finger" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001FINGER\001"
}
popup add item chattext ".ctcp" "Clientinfo" {
    quote "PRIVMSG [string range [windowname] 1 end] :\001CLIENTINFO\001"
}

# Whois
popup add item chattext "" "Whois" {
    quote "WHOIS [string range [windowname] 1 end]"
}

# Whois Idle
popup add item chattext "" "Whois Idle" {
    quote "WHOIS [string range [windowname] 1 end] [string range [windowname] 1 end]"
}

##### Status Window Popups #####

popup add item statustext "" "Join a Channel \[/join #channel]" {
    QEntryBox::create "Join Channel" "Please enter the name of a channel to join:\n(Ex: #chat or #irchelp)" "evalserver [index] {/join %g}"
}

popup add item statustext "" "Start a Private Chat \[/query nick]" {
    QEntryBox::create "Start Query Session" "Please enter the nick of the user you wish to speak privately with:\n(Ex: somenick)" "evalserver [index] {/query %g}"
}

popup add item statustext "" "Server's User Stats" {
    quote "LUSERS"
}

##### Main Status Window Popups #####

popup add item maintext "" "Start a New Server <Alt-n>" {
    source $env(HOME)/.quirc/newserver.tcl
}

proc ::basicconfig {} {
    toplevel .basicconfig
    pack [label .basicconfig.lnick -text "Nick:"]
    pack [entry .basicconfig.enick -textvariable ::dynamic::default_nick] -padx 5
    pack [label .basicconfig.laltnick1 -text "Alternative Nick 1:"]
    pack [entry .basicconfig.ealtnick1 -textvariable ::dynamic::default_altnick1]
    pack [label .basicconfig.laltnick2 -text "Alternative Nick 2:"]
    pack [entry .basicconfig.ealtnick2 -textvariable ::dynamic::default_altnick2]
    pack [label .basicconfig.luser -text "User:"]
    pack [entry .basicconfig.euser -textvariable ::dynamic::default_user]
    pack [label .basicconfig.lname -text "Name/Description:"]
    pack [entry .basicconfig.ename -textvariable ::dynamic::default_desc]
    pack [label .basicconfig.lserver -text "Default Server:"]
    pack [entry .basicconfig.eserver -textvariable ::dynamic::default_server]
    pack [button .basicconfig.go -text "Ok"] -pady 5
    .basicconfig.go configure -command {
	destroy .basicconfig
	if { $::dynamic::first_time } {
	    tk_messageBox -message "Be sure to \"Store -> Variable/Alias Settings\" via the Menu.\n(This message will only appear once.)"
	    set ::dynamic::first_time 0
	    newserver
	}
    }
    focus .basicconfig.enick
}

popup add item maintext "" "Basic Configuration" {
    basicconfig
}

popup add item maintext "" "Configuration System" {
    config
}

popup add item maintext "" "Store Session (Servers/Channels)" {
    if [info exists ::dynamic::auto_start] {
	/unset auto_start
    }
    foreach server [servers] {
	evalserver $server {
	    if {[channels]!=""} {
		/set auto_start([windowname [pathname status]]) "/join [join [channels] ","]"
	    } else {
		/set auto_start([windowname [pathname status]]) " "
	    }
	}
    }
    /store
}

# Help Menu

popup add item maintext "" "Documentation <F1>" {
    doc show
}

# Store Menu

popup add submenu maintext ".store" "Store"

popup add item maintext ".store" "Variable/Alias Settings \[/store]" {
    /store
}

popup add item maintext ".store" "With Window Size/Position \[/store -geometry]" {
    /store -geometry
}

popup add item maintext ".store" "With Only Window Size \[/store -size]" {
    /store -size
}

popup add item maintext ".store" "Help on /store \[/doc /store]" {
    /doc /store
}

# QuIRC Themes

popup add submenu maintext ".themes" "Themes"

popup add item maintext ".themes" "Run QuIRC Theme Editor" {
    exec ~/.quirc/quedit &
}

popup add item maintext ".themes" "Choose a Theme" {
    destroy .themes
    toplevel .themes
    listbox .themes.list
    pack .themes.list -expand 1 -fill both
    foreach file [glob $::env(HOME)/.quirc/themes/*] {
	.themes.list insert end [file tail $file]
    }
    # FIXME - Add a button here to allow clearing of all windows.
    bind .themes.list <Double-Button-1> {
	set theme [.themes.list get [.themes.list nearest %y]]
	/set theme $theme
	source $env(HOME)/.quirc/themes/$::dynamic::theme
	foreach var [info vars ::dynamic::theme_*] {
	    if { ![array exists $var] } {
		active_set [lindex [split $var :] 4] [set $var]
	    }
	}
	/store
	fdisplay THEME_CHANGED
	destroy .themes
    }
}

popup add item maintext ".themes" "Save Current Theme Settings to custom.tcl" {
    set cust [open $::env(HOME)/.quirc/themes/custom.tcl "w"]
    foreach var [info vars ::dynamic::theme_*] {
	if { ![array exists $var] } {
	    puts $cust "set $var [string range [list "\x7d[set $var]"] 2 end]" 
	} else {
	    puts $cust "array set $var {[array get $var]}"
	}
    }
    set sty [open $::env(HOME)/.quirc/themes/default.tcl "r"]
    while { ![eof $sty] } {
	gets $sty line
	if { [string match "fset *" $line] } {
	    puts $cust $line
	}
    }
    close $sty
    close $cust
    fdisplay THEME_SAVED
}

popup add item maintext "" "Join #QuIRC on DALnet" {
    set ::[newserver irc.dal.net]::auto_start "/join #QuIRC"
}

##### Load Non-Default Popups #####

if { [file exists "$env(HOME)/.quirc/userpopups.tcl"] } {
    source "$env(HOME)/.quirc/userpopups.tcl"
}
