#ifndef Z80_H_INCLUDED
#define Z80_H_INCLUDED



/* --- Z80 CPU Υߥ졼ȹ¤ --- */

typedef struct{

  pair	AF, BC, DE, HL;			/* ѥ쥸 */
  pair	IX, IY, PC, SP;			/* ѥ쥸 */
  pair	AF1,BC1,DE1,HL1;		/*  ΢ 쥸	*/
  byte	I, R;				/* ü쥸 */
  byte	R_saved;			/* R reg - bit7 ¸ */
  Uchar	IFF,IFF2;			/* IFF1 IFF2	*/
  Uchar	IM;				/* ⡼	*/
  Uchar	HALT;				/* HALT ե饰	*/

  int	INT_active;
  int	icount;				/* γȯޤǤΥơȿ	*/
  int	state0;				/* ơȿ	*/
					/* (z80->intr_update)()ƽл˽*/

  int	skip_intr_chk;

  Uchar	log;				/* ʤǥХåѤΥϿ	*/
  Uchar	break_if_halt;			/* HALT˽롼פ鶯æ*/

  byte	(*fetch)(word);
  byte	(*mem_read)(word);		/* ꡼ɴؿ	*/
  void	(*mem_write)(word,byte);	/* 饤ȴؿ	*/
  byte	(*io_read)(byte);		/* I/O ϴؿ		*/
  void	(*io_write)(byte,byte);		/* I/O ϴؿ		*/

  void	(*intr_update)(void);		/* 󹹿ؿ	*/
  int	(*intr_ack)(void);		/* ؿ		*/

  pair  PC_prev;			/* ľ PC (˥)	*/

} z80arch;


/* IFF  */
#define INT_DISABLE	(0)
#define INT_ENABLE	(1)



/*------------------------------------------------------------------------
 * ߽ CPU ưŪ˻ߤ뤿Υޥ
 *------------------------------------------------------------------------*/

extern	int z80_state_goal;	/* stateʬ򷫤֤(0̵) */
extern	int z80_state_intchk;	/* state¹Ը塢Ƚꤹ	  */


/* PIOˤCPUػ䡢˥塼ܻʤɤˡCPUŪ */
   
#define	CPU_BREAKOFF()	do{ z80_state_intchk = 0; z80_state_goal = 1; }while(0)

/* ȯѹˡCPUŪ ʬ */

#define	CPU_REFRESH_INTERRUPT()		do{ z80_state_intchk = 0; }while(0)




extern	void	z80_reset( z80arch *z80 );
extern	int	z80_emu( z80arch *z80, int state_of_exec );
extern	void	z80_debug( z80arch *z80, char *mes );
extern	int	z80_line_disasm( z80arch *z80, word addr );

extern	void	z80_logging( z80arch *z80 );



#endif		/* Z80_H_INCLUDED */
