/***********************************************************************
 * ɽϽ (ƥ¸)
 *
 *      ܺ٤ϡ snddrv.h / mame-quasi88.h 
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef	USE_SOUND

#include "mame-quasi88.h"

#define  SNDDRV_WORK_DEFINE
#include "audio.h"



/*---------------------------------------------------------------*/
static int use_audiodevice = 1;		/* use audio-devide for audio output */
/* static int attenuation = 0;		 * ܥ塼 -320 [db] ̤ݡ */

static struct sysdep_dsp_struct *sysdep_sound_dsp = NULL;

/*===========================================================================*/
/*              QUASI88 ƤӽФ롢MAME νؿ                    */
/*===========================================================================*/

/******************************************************************************
 * ɷϥץνλؿ
 *
 * int xmame_config_init(void)
 *      config_init() ꡢץβϤ򳫻Ϥ˸ƤӽФ롣
 *      MAME¸νʤɤɬפʾϡǹԤ
 *
 * void xmame_config_exit(void)
 *      config_exit() ꡢκǸ˸ƤӽФ롣
 *      xmame_config_init() νθդɬפʤ顢ǹԤ
 *
 *****************************************************************************/
int		xmame_config_init(void)
{
	return 0;		/*OSD_OK;*/
}
void	xmame_config_exit(void)
{
}


/******************************************************************************
 * ɷϥץΥץơ֥
 *
 * const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
 *      config_init() ꡢ xmame_config_init() θ˸ƤӽФ롣
 *
 *      ɷϥץβϽˤơ QUASI88 Υץơ֥
 *      T_CONFIG_TABLE Ѥ硢Υݥ󥿤֤
 *      ȼǲϤϡ NULL ֤
 *****************************************************************************/

static	int	invalid_arg;			/* ̵ʥץѤΥߡѿ */
static	const	T_CONFIG_TABLE xmame_options[] =
{
  /* 350399: ɰ¸ץ */

  { 351, "sound",        X_FIX,  &use_sound,       TRUE,                  0,0, OPT_SAVE },
  { 351, "snd",          X_FIX,  &use_sound,       TRUE,                  0,0, 0        },
  { 351, "nosound",      X_FIX,  &use_sound,       FALSE,                 0,0, OPT_SAVE },
  { 351, "nosnd",        X_FIX,  &use_sound,       FALSE,                 0,0, 0        },

  { 352, "audio",        X_FIX,  &use_audiodevice, TRUE,                  0,0, OPT_SAVE },
  { 352, "ao",           X_FIX,  &use_audiodevice, TRUE,                  0,0, 0        },
  { 352, "noaudio",      X_FIX,  &use_audiodevice, FALSE,                 0,0, OPT_SAVE },
  { 352, "noao",         X_FIX,  &use_audiodevice, FALSE,                 0,0, 0        },

  { 353, "fmgen",        X_FIX,  &use_fmgen,       TRUE,                  0,0, OPT_SAVE },
  { 353, "nofmgen",      X_FIX,  &use_fmgen,       FALSE,                 0,0, OPT_SAVE },

/*{ 354, "volume",       X_INT,  &attenuation,     -32, 0,                  0, OPT_SAVE },*/
/*{ 354, "v",            X_INT,  &attenuation,     -32, 0,                  0, 0        },*/

  { 355, "fmvol",        X_INT,  &fmvol,           0, 100,                  0, OPT_SAVE },
  { 355, "fv",           X_INT,  &fmvol,           0, 100,                  0, 0        },
  { 356, "psgvol",       X_INT,  &psgvol,          0, 100,                  0, OPT_SAVE },
  { 356, "pv",           X_INT,  &psgvol,          0, 100,                  0, 0        },
  { 357, "beepvol",      X_INT,  &beepvol,         0, 100,                  0, OPT_SAVE },
  { 357, "bv",           X_INT,  &beepvol,         0, 100,                  0, 0        },
  { 358, "rhythmvol",    X_INT,  &rhythmvol,       0, 200,                  0, OPT_SAVE },
  { 358, "rv",           X_INT,  &rhythmvol,       0, 200,                  0, 0        },
  { 359, "adpcmvol",     X_INT,  &adpcmvol,        0, 200,                  0, OPT_SAVE },
  { 359, "av",           X_INT,  &adpcmvol,        0, 200,                  0, 0        },
  { 360, "fmgenvol",     X_INT,  &fmgenvol,        0, 100,                  0, OPT_SAVE },
  { 360, "fmv",          X_INT,  &fmgenvol,        0, 100,                  0, 0        },
  { 361, "samplevol",    X_INT,  &samplevol,       0, 100,                  0, OPT_SAVE },
  { 361, "sv",           X_INT,  &samplevol,       0, 100,                  0, 0        },

  { 362, "samplefreq",   X_INT,  &options.samplerate, 8000, 48000,          0, OPT_SAVE },
  { 362, "sf",           X_INT,  &options.samplerate, 8000, 48000,          0, 0        },

  { 363, "samples",      X_FIX,  &options.use_samples, 1,                 0,0, OPT_SAVE },
  { 363, "sam",          X_FIX,  &options.use_samples, 1,                 0,0, 0        },
  { 363, "nosamples",    X_FIX,  &options.use_samples, 0,                 0,0, OPT_SAVE },
  { 363, "nosam",        X_FIX,  &options.use_samples, 0,                 0,0, 0        },

  { 364, "sdlbufsize",   X_INT,  &sdl_buffersize,  32, 65536,               0, OPT_SAVE },
  { 365, "sdlbufnum",    X_INV,  &invalid_arg,                          0,0,0, 0        },
  { 366, "close",        X_FIX,  &close_device,    TRUE,                  0,0, OPT_SAVE },
  { 366, "noclose",      X_FIX,  &close_device,    FALSE,                 0,0, OPT_SAVE },

  /* ü */
  {   0, NULL,           X_INV,                                       0,0,0,0, 0        },
};

const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
{
	return xmame_options;
}


/******************************************************************************
 * ɷϥץΥإץåɽ
 *
 * void xmame_config_show_option(void)
 *      config_init() ꡢץ -help νκݤ˸ƤӽФ롣
 *      ɸϤ˥إץåɽ롣
 *****************************************************************************/
void	xmame_config_show_option(void)
{
  fprintf(stdout,
  "\n"
  "==========================================\n"
  "== SOUND OPTIONS ( dependent on XMAME ) ==\n"
  "==                     [ XMAME  0.106 ] ==\n"
  "==========================================\n"
  "    -[no]sound / -[no]snd   Enable/disable sound (if available) [-sound]\n"
  "    -[no]audio / -[no]ao    Enable/disable audio-device [-audio]\n"
  "    -[no]fmgen              Use/don't use cisc's fmgen library\n"
  "                                               (if compiled in)  [-nofmgen]\n"
/*"    -volume / -v <i>        Set volume to <int> db, (-32(soft) - 0(loud))\n"*/
  "    -fmvol / -fv <i>        Set FM     level to <i> %%, (0 - 100) [100]\n"
  "    -psgvol / -pv <i>       Set PSG    level to <i> %%, (0 - 100) [20]\n"
  "    -beepvol / -bv <i>      Set BEEP   level to <i> %%, (0 - 100) [60]\n"
  "    -rhythmvol / -rv <i>    Set RHYTHM level to <i> %%, (0 - 100) [100]\n"
  "    -adpcmvol / -av <i>     Set ADPCM  level to <i> %%, (0 - 100) [100]\n"
  "    -fmgenvol / -fmv <i>    Set fmgen  level to <i> %%, (0 - 100) [100]\n"
  "    -samplevol / -sv <i>    Set SAMPLE level to <i> %%, (0 - 100) [100]\n"
  "    -samplefreq / -sf <i>   Set the playback sample-frequency/rate [44100]\n"
  "    -[no]samples / -[no]sam Use/don't use samples (if available) [-nosamples]\n"
  "    -sdlbufsize <i>         buffer size of sound stream (power of 2) [2048]\n"
  "    -[no]close              Close/no close sound device in MENU mode [-noclose]\n"
  );
}


/******************************************************************************
 * ɷϥץβϽ
 *
 * int xmame_config_check_option(char *opt1, char *opt2, int priority)
 *      config_init() ꡢեβϤԤʤݤˡ
 *      ΥץΤˤפʤ硢δؿƤӽФ롣
 *
 *              opt1      ǽΰ(ʸ)
 *              opt2      Τΰ(ʸ ʤ NULL)
 *              priority  ͥ (ͤ礭ۤͥ٤⤤)
 *
 *        1   1 (opt1 Τ߽ opt2 ̤)
 *              2   2 (opt1  opt2 )
 *              0   opt1 ̤ΤΰΤᡢ opt1 opt2 Ȥ̤
 *              -1  ̿Ūʰ۾郎ȯ
 *
 *      ΰ۾ (λͤϰϳʤ) 䡢ͥ٤ˤå
 *      줿褦ʾϡǤƱͤˡ 1  2 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int		xmame_config_check_option(char *opt1, char *opt2, int priority)
{
	return 0;
}


/******************************************************************************
 * ɷϥץ¸뤿δؿ
 *
 * int  xmame_config_save_option(void (*real_write)
 *                                 (const char *opt_name, const char *opt_arg))
 *
 *      ե¸κݤˡƤӽФ롣
 *              opt_name ˥ץ opt_arg ˥ץ
 *                åȤreal_write ƤӽФ
 *              Ȥư¸ץФƷ֤Ԥʤ
 *
 *              () "-sound" ե¸
 *                      (real_write)("sound", NULL) ƤӽФ
 *              () "-fmvol 80" ե¸
 *                      (real_write)("fmvol", "80") ƤӽФ
 *
 *         0 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int		xmame_config_save_option(void (*real_write)
								   (const char *opt_name, const char *opt_arg))
{
	return 0;
}


/******************************************************************************
 * ɷϥץ˥塼ѹ뤿Υơ֥ؿ
 *
 * T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
 *
 *      ˥塼⡼ɤγϻ˸ƤӽФ롣
 *              ѹǽʥɷϥץξT_SNDDRV_CONFIG 
 *              ȤѰդƬݥ󥿤֤
 *              Ϻ5ĤޤǡˤϽüǡ򥻥åȤƤ
 *
 *              äѹǤΤ̵ NULL ֤
 *****************************************************************************/
T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
{
	static T_SNDDRV_CONFIG config[] =
	{
		{
			SNDDRV_INT,
			" Buffer size of sound (512 - 16384, power of 2) ",
			&sdl_buffersize,  32, 65536,
		},
		{
			SNDDRV_NULL, 0, 0, 0, 0,
		},
	};

	if (use_audiodevice) {
		return config;
	} else {
		return NULL;
	}
}


/******************************************************************************
 * ɵǽξؿ
 *
 * int xmame_has_audiodevice(void)
 *      ɥǥХϤβݤ֤
 *      ʤǥХϲġʤԲġ
 *
 * int xmame_has_mastervolume(void)
 *      ɥǥХβ̤ѹǽɤ֤
 *      ʤѹǽʤԲġ
 *
 *****************************************************************************/
int		xmame_has_audiodevice(void)
{
	if (use_sound) {
		if (sysdep_sound_dsp) return TRUE;
	}
	return FALSE;
}

int		xmame_has_mastervolume(void)
{
	return FALSE;
}


/*===========================================================================*/
/*              MAME νؿƤӽФ롢ƥ¸ؿ        */
/*===========================================================================*/

/******************************************************************************
 * ɥǥХ
 *      δؿϡХѿ use_sound ξϡƤӽФʤ
 *
 * int osd_start_audio_stream(int stereo)
 *      ɥǥХ롣
 *          stereo ʤ饹ƥ쥪ϡʤΥϤǽ롣
 *          (ΥϤϡŤС MAME/XMAME  YM2203 
 *           ΤߡѤƤ롣ʳϤ٤ƥƥ쥪ϤѤ롣)
 *      δؿϡߥ졼γϻ˸ƤӽФ롣
 *          ϡ1ե졼ढΥץ֤
 *          Իϡ0 ֤
 *               0 ֤ QUASI88 λƤޤΤǡ
 *              ɥǥХν˼ԤǤ⡢ɽϤʤ
 *              ʤ᤿Ȥ硢ȤˤŬ֤ͤɬפ롣
 *
 * int osd_update_audio_stream(INT16 *buffer)
 *      ɥǥХ˽Ϥ롣
 *      δؿϡ1ե졼˸ƤӽФ롣buffer ˤ1ե졼ʬ
 *      (Machine->sample_rate / Machine->drv->frames_per_second) Υ
 *      ǡǼƤ롣ǡ 16bitդǡƥ쥪ξ
 *      ȱΥץ뤬ߤ¤Ǥ롣
 *
 *      ºݤˤδؿƤӽФ줿ߥ󥰤ǥǥХ˽Ϥ뤫뤤
 *      ǥХåե󥰤ӽϤ뤫ϡǤ롣
 *
 *      ͤϡ osd_start_audio_stream() Ʊ
 *
 * void osd_stop_audio_stream(void)
 *      ɥǥХλ롣
 *      δؿϡߥ졼νλ˸ƤӽФ롣
 *      ʹߡ osd_update_audio_stream() ʤɤϸƤӽФʤߥ졼
 *      Ƴϡ osd_start_audio_stream() ƤӽФ롣
 *
 * void osd_update_video_and_audio(void)
 *      ɥǥХνϤΣ
 *      ߥŪˤϡ osd_update_audio_stream() ľ˸ƤӽФ롣
 *      XMAME 0.106 ˹碌Ƥ뤬 osd_update_audio_stream() 
 *      ȼǤ줤СδؿϥߡǤ褤
 *
 * void osd_sound_enable(int enable)
 *      ɥǥХؤνϤꡦʤꤹ롣
 *          enable ʤϤꡢʤϤʤ
 *      δؿϡХѿ close_device ξΤߡƤӽФ롣
 *          ˥塼⡼ɤäݤˡ򵶤ȤƸƤӽФ
 *          ˥塼⡼ɤФݤˡ򿿤ȤƸƤӽФ
 *      δؿϡξˡɥǥХ (close) 
 *      ξ˳ (open) 褦ʼԤƤ뤬ɥǥХ
 *      ݤޤޤˤ褦ʼǤСߡδؿǤ褤
 *      ʤɥǥХؤνϤʤξ osd_update_audio_stream() 
 *      ʤɤδؿϸƤӽФ롣
 *
 *****************************************************************************/

static float sound_bufsize = 3.0;
static int sound_samples_per_frame = 0;
static int type = -1;


/*
 * xmame-0.106/src/unix/sysdep/sysdep_dsp.c 
 */
static struct sysdep_dsp_struct *sysdep_dsp_create(
		int		*samplerate, 	/* sample_rate (==44100) */
		int		*type,	 		/* */
		float	bufsize)		/* 3.0 / 55.4 */
{
	struct sysdep_dsp_struct *dsp = NULL;
	struct sysdep_dsp_create_params params;

	/* fill the params struct */
	params.bufsize = bufsize;
	params.device = "SDL";
	params.samplerate = *samplerate;
	params.type = *type;
	params.flags = 0;	/* SYSDEP_DSP_EMULATE_TYPE | SYSDEP_DSP_O_NONBLOCK */

	/* create the instance */
	if (!(dsp = sdl_dsp_create(&params)))
	{
		return NULL;
	}

	/* calculate buf_size if not done by the plugin */
	if(!dsp->hw_info.bufsize)
		dsp->hw_info.bufsize = (int)(bufsize * dsp->hw_info.samplerate);

	return dsp;
}
/*
 * xmame-0.106/src/unix/sysdep/sysdep_dsp.c 
 */
static void sysdep_dsp_destroy(struct sysdep_dsp_struct *dsp)
{
	if(dsp->convert_buf)
		free(dsp->convert_buf);
	dsp->destroy(dsp);
}


/*
 * xmame-0.106/src/unix/sound.c
 */
int osd_start_audio_stream(int stereo)
{
	type = SYSDEP_DSP_16BIT | (stereo? SYSDEP_DSP_STEREO:SYSDEP_DSP_MONO);

	sysdep_sound_dsp    = NULL;

	osd_sound_enable(1);
	
	return sound_samples_per_frame;
}
/*
 * xmame-0.106/src/unix/sound.c
 */
int osd_update_audio_stream(INT16 *buffer)
{
	if (sysdep_sound_dsp)
		sysdep_sound_dsp->write(sysdep_sound_dsp, (unsigned char *)buffer,
				sound_samples_per_frame);

	return sound_samples_per_frame;
}
/*
 * xmame-0.106/src/unix/sound.c
 */
void osd_stop_audio_stream(void)
{
	osd_sound_enable(0);
}
/*
 * xmame-0.106/src/unix/sound.c
 */
void osd_sound_enable(int enable_it)
{
	if (use_audiodevice == 0) {
		sysdep_sound_dsp = NULL;
		sound_samples_per_frame = (int) (Machine->sample_rate / Machine->refresh_rate);
		return;
	}

	if (enable_it)
	{
		/* in case we get called twice with enable_it true
		   OR we get called when osd_start_audio stream
		   has never been called */
		if (sysdep_sound_dsp || (type==-1))
			return;
		
		if(!(sysdep_sound_dsp = sysdep_dsp_create(
						&(Machine->sample_rate),
						&type,
						sound_bufsize * (1 / Machine->refresh_rate))))
		{
			/* ǥХʤƤ⡢ˤ³ */
		}

		/* calculate samples_per_frame */
		sound_samples_per_frame = (int) (Machine->sample_rate / Machine->refresh_rate);

	}
	else
	{
		if (sysdep_sound_dsp)
		{
			sysdep_dsp_destroy(sysdep_sound_dsp);
			sysdep_sound_dsp = NULL;
		}
	}
}


/*
 * xmame-0.106/src/unix/video.c
 */
void	osd_update_video_and_audio(void)
{
	/* nothing */
}


/******************************************************************************
 * 
 *
 * void osd_set_mastervolume(int attenuation)
 *      ɥǥХβ̤ꤹ롣 attenuation  ̤ǡ -320 
 *      (ñ̤ db) ѹΤǤʤǥХǤСߡǤ褤
 *
 * int osd_get_mastervolume(void)
 *      ߤΥɥǥХβ̤롣 ͤ -320 (ñ̤ db)
 *      ѹΤǤʤǥХǤСߡǤ褤
 *
 *****************************************************************************/
void osd_set_mastervolume(int attenuation)
{
}

int osd_get_mastervolume(void)
{
	return VOL_MIN;
}

#endif	/* USE_SOUND */
