/************************************************************************/
/*									*/
/* QUASI88 ˥塼 Tool Kit						*/
/*									*/
/*	GTK+  API 򿿻ƺޤ䤳ơɥȤ	*/
/*	񤱤ޤġġġ						*/
/*									*/
/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "quasi88.h"

#include "q8tk.h"
#include "q8tk-glib.h"

#include "menu-screen.h"

#include "file-op.h"
#include "wait.h"

#include "keyboard.h"	/* mouse_x, mouse_y */
#include "event.h"
#include "menu.h"
#include "screen.h"


/*#define OLD_FOCUS_CHANGE*/


/* Хåؿΰ (Q8tkWidget*, void*) ̤Ѥξ硢
 * ˥󥰤ФݵƫΤǡ gcc ǵƤ餦 */
#if defined(__GNUC__)
#define	UNUSED_WIDGET	__attribute__((__unused__)) Q8tkWidget *dummy_0
#define	UNUSED_PARM	__attribute__((__unused__)) void *dummy_1
#else
#define	UNUSED_WIDGET	Q8tkWidget *dummy_0
#define	UNUSED_PARM	void *dummy_1
#endif



/************************************************************************/
/* ǥХå顼							*/
/************************************************************************/

#define	Q8tkAssert(e,s)		\
		((e) ? (void)0 : _Q8tkAssert(__FILE__, __LINE__, #e, s))

static	void	_Q8tkAssert(char *file, int line, char *exp, const char *s)
{
    fprintf(stderr, "Fatal Error | %s <%s:%d>\n", exp, file, line);
    fprintf(stderr, "message = %s\n",(s)?s:"---");
    quasi88_exit(-1);
}

static const char *debug_type(int type) {
    switch (type) {
    case Q8TK_TYPE_WINDOW:		return "window  :";
    case Q8TK_TYPE_BUTTON:		return "button  :";
    case Q8TK_TYPE_TOGGLE_BUTTON:	return "t-button:";
    case Q8TK_TYPE_CHECK_BUTTON:	return "c-button:";
    case Q8TK_TYPE_RADIO_BUTTON:	return "r-button:";
    case Q8TK_TYPE_FRAME:		return "frame   :";
    case Q8TK_TYPE_LABEL:		return "label   :";
    case Q8TK_TYPE_LOGO:		return "logo    :";
    case Q8TK_TYPE_NOTEBOOK:		return "notebook:";
    case Q8TK_TYPE_NOTEPAGE:		return "page    :";
    case Q8TK_TYPE_VBOX:		return "vbox    :";
    case Q8TK_TYPE_HBOX:		return "hbox    :";
    case Q8TK_TYPE_VSEPARATOR:		return "vsep    :";
    case Q8TK_TYPE_HSEPARATOR:		return "hsep    :";
    case Q8TK_TYPE_COMBO:		return "combo   :";
    case Q8TK_TYPE_LISTBOX:		return "listbox :";
    case Q8TK_TYPE_LIST_ITEM:		return "listitem:";
    case Q8TK_TYPE_ADJUSTMENT:		return "adjust  :";
    case Q8TK_TYPE_HSCALE:		return "hscale  :";
    case Q8TK_TYPE_VSCALE:		return "vscale  :";
    case Q8TK_TYPE_SCROLLED_WINDOW:	return "scrolled:";
    case Q8TK_TYPE_ENTRY:		return "entry   :";
    case Q8TK_TYPE_DIALOG:		return "dialog  :";
    case Q8TK_TYPE_FILE_SELECTION:	return "f-select:";
    }
    return "UNDEF TYPE:";
}



/************************************************************************/
/* 								*/
/************************************************************************/

static	int		MAX_WIDGET;
static	Q8tkWidget	**widget_table;


static	int		MAX_LIST;
static	Q8List		**list_table;


#define	MAX_WINDOW_LAYER	(8)
static	Q8tkWidget		*window_layer[ MAX_WINDOW_LAYER ];
static	int			window_layer_level;
static	Q8tkWidget		*focus_widget[ MAX_WINDOW_LAYER ];
#define	get_focus_widget()	(focus_widget[ window_layer_level ])



static	struct {
    int	x, y;
    int	x_old, y_old;
} mouse;


static	int	kanji_code = Q8TK_KANJI_ANK;
static	int	disp_cursor = FALSE;

static	int	now_shift_on;
static	int	now_mouse_on;

/*----------------------------------------------------------------------*/

static	void	widget_map(Q8tkWidget *widget);
static	void	widget_construct(void);
static	void	widget_signal_do(Q8tkWidget *widget, const char *name);



/************************************************************************/
/* ưŪγݡ						*/
/************************************************************************/
/*--------------------------------------------------------------
 *	Widget
 *--------------------------------------------------------------*/
static	Q8tkWidget	*malloc_widget(void)
{
    int		i;
    Q8tkWidget	**t, *w;
    int		add;

    t = NULL;
    for (i=0; i<MAX_WIDGET; i++) {
	if (widget_table[i] == NULL) {
	    t = &widget_table[i];
	    break;
	}
    }

    if (t == NULL) {
	add = 512;
	if (MAX_WIDGET == 0) {
	    widget_table = malloc((MAX_WIDGET + add) * sizeof(Q8tkWidget*));
	} else {
	    widget_table = realloc(widget_table,
				   (MAX_WIDGET + add) * sizeof(Q8tkWidget*));
	}
	if (widget_table) {
	    for (i=0; i<add; i++) {
		widget_table[ MAX_WIDGET + i ] = NULL;
	    }
	    t = &widget_table[ MAX_WIDGET ];
	    MAX_WIDGET += add;
	}
    }

    if (t) {
	w = (Q8tkWidget *)calloc(1, sizeof(Q8tkWidget));
	if (w) {
	    /* ͤ ФȤ 0 */
	    *t = w;
	    return w;
	} else {
	    Q8tkAssert(FALSE, "memory exhoused");
	}
    }

    Q8tkAssert(FALSE, "work 'widget' exhoused");
    return NULL;
}
static	void	free_widget(Q8tkWidget *w)
{
    int i;
    for (i=0; i<MAX_WIDGET; i++) {
	if (widget_table[i] == w) {
	    free(w);
	    widget_table[i] = NULL;
	    return;
	}
    }
    Q8tkAssert(FALSE, "pointer is not malloced widget");
}
/*--------------------------------------------------------------
 *	List
 *--------------------------------------------------------------*/
static	Q8List	*malloc_list(void)
{
    int		i;
    Q8List	**t, *l;
    int		add;

    t = NULL;
    for (i=0; i<MAX_LIST; i++) {
	if (list_table[i] == NULL) {
	    t = &list_table[i];
	    break;
	}
    }

    if (t == NULL) {
	add = 512;
	if (MAX_LIST == 0) {
	    list_table = malloc((MAX_LIST + add) * sizeof(Q8List*));
	} else {
	    list_table = realloc(list_table,
				 (MAX_LIST + add) * sizeof(Q8List*));
	}
	if (list_table) {
	    for (i=0; i<add; i++) {
		list_table[ MAX_LIST + i ] = NULL;
	    }
	    t = &list_table[ MAX_LIST ];
	    MAX_LIST += add;
	}
    }

    if (t) {
	l = (Q8List *)calloc(1, sizeof(Q8List));
	if (l) {
	    *t = l;
	    return l;
	} else {
	    Q8tkAssert(FALSE, "memory exhoused");
	}
    }

    Q8tkAssert(FALSE, "work 'list' exhoused");
    return NULL;
}
static	void	free_list(Q8List *l)
{
    int	i;
    for (i=0; i<MAX_LIST; i++) {
	if (list_table[i] == l) {
	    free(l);
	    list_table[i] = NULL;
	    return;
	}
    }
    Q8tkAssert(FALSE, "pointer is not malloced list");
}



#if 0
/************************************************************************/
/* Q8TK  ʸ							*/
/*	q8_strncpy(s, ct, n)						*/
/*		ʸ ct  ʸ s  ԡ롣			*/
/*		s ʸüϡɬ '\0' Ȥʤꡢs Ĺ n-1 ʸ	*/
/*		ʲ˼ޤ롣						*/
/*	q8_strncat(s, ct, n)						*/
/*		ʸ ct  ʸ s  ղä롣			*/
/*		s ʸüϡɬ '\0' Ȥʤꡢs Ĺ n-1 ʸ	*/
/*		ʲ˼ޤ롣						*/
/************************************************************************/
static	void	q8_strncpy(char *s, const char *ct, size_t n)
{
    strncpy(s, ct, n-1);
    s[ n-1 ] = '\0';
}
static	void	q8_strncat(char *s, const char *ct, size_t n)
{
    if (n > strlen(s) + 1)
	strncat(s, ct, n - strlen(s) -1);
}
#endif


/************************************************************************/
/* ꥹȽ								*/
/************************************************************************/
/*--------------------------------------------------------------
 * ꥹȤˤ餷Ǥɲ (ޤϥꥹȤ򿷵)
 *	ͤϡꥹȤƬ
 *--------------------------------------------------------------*/
Q8List	*q8_list_append(Q8List *list, void *data)
{
    Q8List	*new_list;

    new_list  = malloc_list();		/*  */

    if (list) {				/* ¸ΥꥹȤˤĤʤ */
	list = q8_list_last(list);		/* ȥ󥯤 */
	list->next     = new_list;
	new_list->prev = list;
	new_list->next = NULL;
    }else{				/* ΥꥹȤξ */
	new_list->prev = NULL;
	new_list->next = NULL;
    }
    new_list->data   = data;

    return q8_list_first(new_list);	/* ΥꥹƬ֤   */
}
/*--------------------------------------------------------------
 * ꥹȤˤ餷Ǥɲ (position==0Ƭ)
 *	ͤϡꥹȤƬ
 *--------------------------------------------------------------*/
#if 0
Q8List	*q8_list_insert(Q8List *list, void *data, int position)
{
    /* ̤ */
    return NULL;
}
#endif
/*--------------------------------------------------------------
 * ꥹȤǤҤȤĤ
 *	ͤϡꥹȤƬ
 *--------------------------------------------------------------*/
Q8List	*q8_list_remove(Q8List *list, void *data)
{
    list = q8_list_first(list);

    while (list) {			/* ꥹƬˤɤä */
	if (list->data == data) {	/* data ΰפΤõ  */
	    list->prev->next = list->next;	/* ߤĤХ󥯤 */
	    list->next->prev = list->prev;	/* ĤʤѤ       */
	    free_list(list);			/* ȤϺ         */
	    break;
	}
	list = list->next;
    }

    return q8_list_first(list);		/* ΥꥹƬ֤   */
}
/*--------------------------------------------------------------
 * ꥹȤξõ
 *--------------------------------------------------------------*/
void	q8_list_free(Q8List *list)
{
    Q8List *l;

    list = q8_list_first(list);		/* ꥹȤƬ */

    while (list) {			/* ɤʤ */
	l = list->next;
	free_list(list);
	list = l;
    }
}
/*--------------------------------------------------------------
 * ꥹƬ
 *--------------------------------------------------------------*/
Q8List	*q8_list_first(Q8List *list)
{
    if (list) {
	while (list->prev) {		/* ꥹȤˤɤ */
	    list = list->prev;
	}				/* ɤʤʤä */
    }					/* 줬Ƭ         */
    return list;
}
/*--------------------------------------------------------------
 * ꥹ
 *--------------------------------------------------------------*/
Q8List	*q8_list_last(Q8List *list)
{
    if (list) {
	while (list->next) {		/* ꥹȤˤɤ */
	    list = list->next;
	}				/* ɤʤʤä */
    }					/* 줬         */
    return list;
}
/*--------------------------------------------------------------
 * ꥹȸ
 *--------------------------------------------------------------*/
Q8List	*q8_list_find(Q8List *list, void *data)
{
    list = q8_list_first(list);		/* ꥹȤƬ   */

    while (list) {			/* ɤʤ       */
	if (list->data == data) break;	/* פΤõ */
	list = list->next;
    }
    return list;
}


/************************************************************************/
/* 								*/
/************************************************************************/
int	q8tk_set_kanjicode(int code)
{
    int ret = kanji_code;

    if (code != Q8TK_KANJI_ANK &&
	code != Q8TK_KANJI_EUC &&
	code != Q8TK_KANJI_SJIS &&
	code != Q8TK_KANJI_UTF8) {

	code = Q8TK_KANJI_ANK;
    }

    kanji_code = code;

    return ret;
}
/************************************************************************/
/* ɽ̵ͭ							*/
/************************************************************************/
void	q8tk_set_cursor(int enable)
{
    disp_cursor = (enable) ? TRUE : FALSE;
}





/************************************************************************/
/* Ƚλ								*/
/************************************************************************/

static	int		q8tk_disp_init_flag;
static	int		q8tk_main_loop_flag;
static	int		q8tk_construct_flag;

#define	set_main_loop_flag(f)	q8tk_main_loop_flag = (f)
#define	get_main_loop_flag()	q8tk_main_loop_flag
#define	set_construct_flag(f)	q8tk_construct_flag = (f)
#define	get_construct_flag()	q8tk_construct_flag


static	Q8tkWidget	*q8tk_drag_widget;
#define	set_drag_widget(w)	q8tk_drag_widget = (w)
#define	get_drag_widget()	q8tk_drag_widget



static	void		widget_focus_list_init(void);
static	Q8tkWidget	*widget_focus_list_get_next(Q8tkWidget *widget,
						    int back);



static	void	widget_scrollin_init(void);
static	void	widget_scrollin_register(Q8tkWidget *widget);
static	void	widget_scrollin_drawn(Q8tkWidget *widget);


static	int		delay_timer;
static	Q8tkWidget	*q8tk_delay_widget;
#define	set_delay_widget(w, n)	do {				\
				    if (w == NULL) {		\
					delay_timer = 0;	\
				    } else {			\
					delay_timer = n;	\
				    }				\
				    q8tk_delay_widget = w;	\
				} while (0)
#define	get_delay_widget()	q8tk_delay_widget




/*--------------------------------------------------------------
 *	
 *--------------------------------------------------------------*/
void	q8tk_init(void)
{
    int	i;

    MAX_WIDGET = 0;
    widget_table = NULL;

    MAX_LIST = 0;
    list_table = NULL;

    for (i=0; i<MAX_WINDOW_LAYER; i++) {
	window_layer[i] = NULL;
	focus_widget[i] = NULL;
    }
    window_layer_level = -1;

    set_main_loop_flag(TRUE);
    set_construct_flag(FALSE);

    set_drag_widget(NULL);
    widget_focus_list_init();
    widget_scrollin_init();


    q8gr_init();


    mouse.x_old = mouse.x = mouse_x;
    mouse.y_old = mouse.y = mouse_y;

    now_shift_on = FALSE;
    now_mouse_on = FALSE;

    q8tk_disp_init_flag = TRUE;
}
/*--------------------------------------------------------------
 *	λ
 *--------------------------------------------------------------*/
static	void	q8tk_term(void)
{
    int	i;
    for (i=0; i<MAX_WIDGET; i++) {
	if (widget_table[i]) {
	    if (widget_table[i]->name) {
		free(widget_table[i]->name);
	    }
	    free(widget_table[i]);
	}
    }
    if (widget_table) {
	free(widget_table);
    }
    widget_table = NULL;
    MAX_WIDGET = 0;

    for (i=0; i<MAX_LIST; i++) {
	if (list_table[i]) {
	    free(list_table[i]);
	}
    }
    if (list_table) {
	free(list_table);
    }
    list_table = NULL;
    MAX_LIST = 0;
}



/************************************************************************/
/* ⡼							*/
/************************************************************************/
/*--------------------------------------------------------------
 *	⡼
 *--------------------------------------------------------------*/
void	q8tk_grab_add(Q8tkWidget *widget)
{
    int i;
    Q8tkAssert(widget->type == Q8TK_TYPE_WINDOW, "grab add not window");

    for (i=0; i<MAX_WINDOW_LAYER; i++) {
	if (window_layer[i] == NULL) {
	    window_layer[i] = widget;
	    window_layer_level = i;
	    set_construct_flag(TRUE);
	    return;
	}
    }
    Q8tkAssert(FALSE, "overflow window level");
}
/*--------------------------------------------------------------
 *	⡼
 *--------------------------------------------------------------*/
void	q8tk_grab_remove(Q8tkWidget *widget)
{
    int i;

    for (i=0; i<MAX_WINDOW_LAYER; i++) {
	if (window_layer[i] == widget) {
	    break;
	}
    }
    Q8tkAssert(i < MAX_WINDOW_LAYER, "grab remove not widget");
    for (   ; i<MAX_WINDOW_LAYER-1; i++) {
	window_layer[i] = window_layer[i+1];
	focus_widget[i] = focus_widget[i+1];
    }
    window_layer[i] = NULL;
    focus_widget[i] = NULL;
    window_layer_level --;
    set_construct_flag(TRUE);
}



/********************************************************/
/* åȤκ					*/
/********************************************************/

/*---------------------------------------------------------------------------
 * ɥ (WINDOW)
 *---------------------------------------------------------------------------
 *  ƤΥåȤκǤĤˤʤ륳ƥʥåȡ
 *  ҤĻƤ롣
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ΥåȤɽˤϡq8tk_grab_add()ˤŪɽؼ롣
 *  WINDOW Ϻ硢MAX_WINDOW_LAYERĺǤ뤬ʥդΤϡ
 *    Ǹ q8tk_grab_add() ȯԤɥλ¹ΤߤǤ롣
 *  Q8TK_WINDOW_TOPLEVEL Υɥɬɬס
 *  ʥ
 *	ʤ
 *  ʥ (桼Բ)
 *	"inactivate"	ݥåץåץɥˤƥɥ򥯥åȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_window_new(int window_type)
 *	ɥ
 *	ˤꡢɥμबޤ
 *		Q8TK_WINDOW_TOPLEVEL  ִäΥɥǡͣĤΤ
 *					ǽɥȤʤ
 *		Q8TK_WINDOW_DIALOG    ФäѤäɥȤ
 *		Q8TK_WINDOW_POPUP     ñʥɥȤ
 *  -------------------------------------------------------------------------
 *	WINDOWۢ [xxxx]		ޤޤʥåȤҤ˻Ƥ
 *
 *---------------------------------------------------------------------------*/
/* ݥåץåץɥϰϳˤƥޥå顢ʥȯ */
static	void	window_event_button_on(Q8tkWidget *widget)
{
    widget_signal_do(widget, "inactivate");
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

Q8tkWidget	*q8tk_window_new(int window_type)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_WINDOW;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->stat.window.type = window_type;

    switch (window_type) {
    case Q8TK_WINDOW_TOPLEVEL:
	Q8tkAssert(window_layer[0] == NULL, "Redefine TOP window");
	q8tk_grab_add(w);
	w->stat.window.no_frame = TRUE;
	break;

    case Q8TK_WINDOW_DIALOG:
	w->stat.window.no_frame = FALSE;
	w->stat.window.shadow_type = Q8TK_SHADOW_OUT;
	break;

    case Q8TK_WINDOW_POPUP:
	w->stat.window.no_frame = FALSE;
	w->stat.window.shadow_type = Q8TK_SHADOW_ETCHED_OUT;
	w->event_button_on = window_event_button_on;
	break;
    }

    return w;
}




/*---------------------------------------------------------------------------
 * ܥ (BUTTON)
 *---------------------------------------------------------------------------
 *  ޥʤɤǥܥ򲡤Ƥ֤ϰùǡޥΥ롣
 *  ҤĻƤ롣 (â٥ʳλҤäư̤ݾ)
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ʥ
 *	"clicked"	ܥ󤬲줿ȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_button_new(void)
 *	ܥ
 *
 *  Q8tkWidget	*q8tk_button_new_with_label(const char *label)
 *	ʸ label 줿ܥ
 *	Ūˤϡܥȥ٥ꡢƻҤˤ롣
 *  -------------------------------------------------------------------------
 *	BUTTONۢ [LABEL]		٥Ҥ˻
 *
 *---------------------------------------------------------------------------*/
/* ꥿󡦥ڡ򲡤顢ʥȯ */
static	void	button_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {

#if 0		/* Τޤޤȡ֤褹ˤʤ */
	widget_signal_do(widget, "clicked");

#else		/* ֤褵Τǡ٥Ȥ٤餻 */
	widget->stat.button.active = Q8TK_BUTTON_ON;
	set_construct_flag(TRUE);
	set_delay_widget(widget, 3);		/* 3 ե졼ʬٱ */
#endif
    }
}

/* ܥޥå顢ܥޤơɥåϤȤ */
static	void	button_event_button_on(Q8tkWidget *widget)
{
    set_drag_widget(widget);

    widget->stat.button.active = Q8TK_BUTTON_ON;
    set_construct_flag(TRUE);
}

/* ɥåϡޥΰ֤˱ơܥ̱ */
static	void	button_event_dragging(Q8tkWidget *widget)
{
    if (q8gr_get_focus_screen(mouse.x/8, mouse.y/16) == widget) {
	if (widget->stat.button.active == Q8TK_BUTTON_OFF) {
	    widget->stat.button.active = Q8TK_BUTTON_ON;
	    set_construct_flag(TRUE);
	}
    } else {
	if (widget->stat.button.active == Q8TK_BUTTON_ON) {
	    widget->stat.button.active = Q8TK_BUTTON_OFF;
	    set_construct_flag(TRUE);
	}
    }
}

/* ɥåλǡܥ󤬱Ǥ顢ʥȯ */
static	void	button_event_drag_off(Q8tkWidget *widget)
{
    if (widget->stat.button.active == Q8TK_BUTTON_ON) {

#if 0	/* ޥϢǤǤΡ̤Ϣ³ɽäȸ줷 */
	widget->stat.button.active = Q8TK_BUTTON_OFF;
	widget_signal_do(widget, "clicked");
	set_construct_flag(TRUE);

#else	/* ٥Ȥ٤餻뤳ȤǡϢ³ɽʤ褦ˤ */
	widget->stat.button.active = Q8TK_BUTTON_OFF;
	set_delay_widget(widget, 3);		/* 3 ե졼ʬٱ */
	set_construct_flag(TRUE);
#endif
    }
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

Q8tkWidget	*q8tk_button_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_BUTTON;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->event_button_on = button_event_button_on;
    w->event_key_on    = button_event_key_on;
    w->event_dragging  = button_event_dragging;
    w->event_drag_off  = button_event_drag_off;

    return w;
}

Q8tkWidget	*q8tk_button_new_with_label(const char *label)
{
    Q8tkWidget *b = q8tk_button_new();
    Q8tkWidget *l = q8tk_label_new(label);

    q8tk_widget_show(l);
    q8tk_container_add(b, l);

    b->with_label = TRUE;

    return b;
}




/*---------------------------------------------------------------------------
 * ȥܥ (TOGGLE BUTTON)
 *---------------------------------------------------------------------------
 *  ޥʤɤǥܥ򲡤Ȱùࡣ⤦٥ܥ򲡤롣
 *  ҤĻƤ롣 (â٥ʳλҤäư̤ݾ)
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ʥ
 *	"clicked"	ܥ򲡤ưùȯ
 *	"toggled"	ܥξ֤Ѳȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_toggle_button_new(void)
 *	ȥܥ
 *
 *  Q8tkWidget	*q8tk_toggle_button_new_with_label(const char *label)
 *	ʸ label 줿ܥ
 *	Ūˤϡȥܥȥ٥ꡢƻҤˤ롣
 *
 *  void	q8tk_toggle_button_set_state(Q8tkWidget *widget, int status)
 *	ܥξ֤ѹ롣
 *	status ʤܥ򲡤֤ˤ (ʥ뤬ȯ)
 *	status ʤʤˤ⤷ʤ
 *  -------------------------------------------------------------------------
 *	TOGGLE BUTTONۢ [LABEL]		٥Ҥ˻
 *
 *---------------------------------------------------------------------------*/
/* ܥޥå顢ʥȯ */
static	void	toggle_button_event_button_on(Q8tkWidget *widget)
{
    if (widget->stat.button.active == Q8TK_BUTTON_ON) {
	widget->stat.button.active = Q8TK_BUTTON_OFF;
	widget_signal_do(widget, "toggled");
    } else {
	widget->stat.button.active = Q8TK_BUTTON_ON;
	widget_signal_do(widget, "clicked");
	widget_signal_do(widget, "toggled");
    }
    set_construct_flag(TRUE);
}

/* ꥿󡦥ڡ򲡤顢ޥåƱ򤹤 */
static	void	toggle_button_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {
	toggle_button_event_button_on(widget);
    }
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

Q8tkWidget	*q8tk_toggle_button_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_TOGGLE_BUTTON;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->event_button_on = toggle_button_event_button_on;
    w->event_key_on    = toggle_button_event_key_on;

    return w;
}

Q8tkWidget	*q8tk_toggle_button_new_with_label(const char *label)
{
    Q8tkWidget *b = q8tk_toggle_button_new();
    Q8tkWidget *l = q8tk_label_new(label);

    q8tk_widget_show(l);
    q8tk_container_add(b, l);

    b->with_label = TRUE;

    return b;
}

void		q8tk_toggle_button_set_state(Q8tkWidget *widget, int status)
{
    if (status) {
	if (widget->event_key_on) {
	    (*widget->event_key_on)(widget, Q8TK_KEY_SPACE);
	}
    } else {
	widget->stat.button.active = Q8TK_BUTTON_OFF;
	set_construct_flag(TRUE);
    }
}




/*---------------------------------------------------------------------------
 * åܥ (CHECK BUTTON)
 *---------------------------------------------------------------------------
 *  ܥ򲡤ȡåܥåɤĤ֤롣
 *    ⤦٥ܥ򲡤롣
 *  ҤĻƤ롣 (â٥ʳλҤäư̤ݾ)
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ʥ
 *	"clicked"	ܥ󤬲줿ȯ
 *	"toggled"	ܥξ֤Ѳȯ
 *		OFF֤ξϡ "toggled" ȯ
 *		 ON֤ξϡ "clicked"  "toggled" νȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_check_button_new(void)
 *	åܥ
 *
 *  Q8tkWidget	*q8tk_check_button_new_with_label(const char *label)
 *	ʸ label 줿åܥ
 *	Ūˤϡåܥȥ٥ꡢƻҤˤ롣
 *  -------------------------------------------------------------------------
 *	ܤϰ㤦ǽŪˤϥȥܥƱǤ롣
 *	ȥܥƱ͡q8tk_toggle_button_set_state() ˤꡢ
 *	ܥ򲡤֤ˤ뤳ȤǤ (ʥ뤬ȯ)
 *  -------------------------------------------------------------------------
 *	CHECK BUTTONۢ [LABEL]		٥Ҥ˻
 *
 *---------------------------------------------------------------------------*/
static	void	check_button_event_do(Q8tkWidget *widget)
{
    if (widget->stat.button.active == Q8TK_BUTTON_ON) {
	widget->stat.button.active = Q8TK_BUTTON_OFF;
	widget_signal_do(widget, "toggled");
    } else {
	widget->stat.button.active = Q8TK_BUTTON_ON;
	widget_signal_do(widget, "clicked");
	widget_signal_do(widget, "toggled");
    }
    set_construct_flag(TRUE);
}

/* ꥿󡦥ڡ򲡤顢ʥȯ */
static	void	check_button_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {
	check_button_event_do(widget);
    }
}

/* ܥޥå顢ɥåϤȤ */
static	void	check_button_event_button_on(Q8tkWidget *widget)
{
    set_drag_widget(widget);
    set_construct_flag(TRUE);
}

/* ɥåλǡʥȯ (ɥåϡʤˤ⤷ʤ) */
static	void	check_button_event_drag_off(Q8tkWidget *widget)
{
    if (q8gr_get_focus_screen(mouse.x/8, mouse.y/16) == widget) {
	check_button_event_do(widget);
    }
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

Q8tkWidget	*q8tk_check_button_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_CHECK_BUTTON;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->event_button_on = check_button_event_button_on;
    w->event_key_on    = check_button_event_key_on;
    w->event_drag_off  = check_button_event_drag_off;

    return w;
}

Q8tkWidget	*q8tk_check_button_new_with_label(const char *label)
{
    Q8tkWidget *b = q8tk_check_button_new();
    Q8tkWidget *l = q8tk_label_new(label);

    q8tk_widget_show(l);
    q8tk_container_add(b, l);

    b->with_label = TRUE;

    return b;
}




/*---------------------------------------------------------------------------
 * 饸ܥ (RADIO BUTTON)
 *---------------------------------------------------------------------------
 *  ĤΥ饸ܥƱΤǥ롼ԥ󥰤Ǥ롣
 *  ܥ򲡤ȥå뤬Ʊ롼ԥ󥰤줿
 *    ¾Υ饸ܥϡå롣
 *  ҤĻƤ롣 (â٥ʳλҤäư̤ݾ)
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ʥ
 *	"clicked"	ܥ󤬲줿ȯ
 *	"toggled"	ܥξ֤Ѳȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_radio_button_new(Q8tkWidget *group)
 *	饸ܥ
 *	Ʊ롼פȤ饸ܥͿ롣(ǽΥܥʤ NULL)
 *	ǽΥܥ󤬥å롣ʹߤΥܥϥå롣
 *	ʲϡ3ĤΥ饸ܥ
 *		button[0] = q8tk_radio_button_new(NULL);
 *		button[1] = q8tk_radio_button_new(button[0]);
 *		button[2] = q8tk_radio_button_new(button[1]);
 *
 *  Q8tkWidget	*q8tk_radio_button_new_with_label(Q8List *list,
 *						  const char *label)
 *	ʸ label 줿饸ܥ
 *	Ūˤϡ饸ܥȥ٥ꡢƻҤˤ롣
 *  -------------------------------------------------------------------------
 *	롼ԥ󥰤Ƥ뤬ǽŪˤϥȥܥƱǤ롣
 *	ȥܥƱ͡q8tk_toggle_button_set_state() ˤꡢ
 *	ܥ򲡤֤ˤ뤳ȤǤ롣ʤλ롼ԥ󥰤줿
 *	٤ƤΥ饸ܥ "toggled" ʥ뤬ȯ롣
 *  -------------------------------------------------------------------------
 *	RADIO BUTTONۢ [LABEL]			٥Ҥ˻
 *							LIST Ƭݻ
 *			LIST
 *					
 *	RADIO BUTTONۢ [LABEL]	á
 *					â
 *			LIST
 *
 *	ƥ饸ܥΩåȤǤ뤬ꥹȾˤꥰ롼פ
 *	ʤƤ롣ƥ饸ܥϡΥꥹȤƬݻƤ롣
 *	ܥ򲡤ȥ롼פƤåȤ˥ʥ뤬ȯ롣
 *
 *---------------------------------------------------------------------------*/
static	void	radio_button_event_do(Q8tkWidget *widget)
{
    Q8List *list;

					/* ʬȤ clicked ʥȯ */
    widget_signal_do(widget, "clicked");
    if (widget->stat.button.active == Q8TK_BUTTON_ON) return;

					/* ꥹȤ򤿤ɤäƼʬʳΥܥ  */
    list = widget->stat.button.list;	/* 򥪥դˤ toggled ʥȯ */
    while (list) {
	if (list->data != widget) {
	    ((Q8tkWidget *)(list->data))->stat.button.active = Q8TK_BUTTON_OFF;
	    widget_signal_do((Q8tkWidget *)(list->data), "toggled");
	}
	list = list->next;
    }
						/* ȤܥѲʤ */
						/* toggled ʥȯ     */
    widget->stat.button.active = Q8TK_BUTTON_ON;

    widget_signal_do(widget, "toggled");

    set_construct_flag(TRUE);
}

/* ꥿󡦥ڡ򲡤顢ʥȯ */
/* /򲡤顢/Υ饸ܥˡեư */
static	void	radio_button_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {
	radio_button_event_do(widget);
    }

#ifdef	OLD_FOCUS_CHANGE
	/* DO NOTHING */
#else	/* ʥեư */
    if (key == Q8TK_KEY_LEFT  ||
	key == Q8TK_KEY_UP    ||
	key == Q8TK_KEY_RIGHT ||
	key == Q8TK_KEY_DOWN) {

#if 0	/* OFF֤ǥեξ硢륭ǥܥ󲡲Ȥߤʤ */
	if (widget->stat.button.active == FALSE) {
	    radio_button_event_do(widget);
	}
	else
#endif
	{
	    Q8List *list = q8_list_find(widget->stat.button.list, widget);

	    if (list) {
		if (key == Q8TK_KEY_LEFT ||
		    key == Q8TK_KEY_UP) {
		    if (list->prev == NULL) list = q8_list_last(list);
		    else                    list = list->prev;
		} else {
		    if (list->next == NULL) list = q8_list_first(list);
		    else                    list = list->next;
		}
		if (list) {
		    q8tk_widget_set_focus((Q8tkWidget *)(list->data));
#if 0	/* /򲡤顢/Υ饸ܥ򲡲Ȥߤʤ */
		    radio_button_event_do((Q8tkWidget *)(list->data));
#endif
		}
	    }
	}
    }
#endif
}

/* ܥޥå顢ɥåϤȤ */
static	void	radio_button_event_button_on(Q8tkWidget *widget)
{
    set_drag_widget(widget);
    set_construct_flag(TRUE);
}

/* ɥåλǡʥȯ (ɥåϡʤˤ⤷ʤ) */
static	void	radio_button_event_drag_off(Q8tkWidget *widget)
{
    if (q8gr_get_focus_screen(mouse.x/8, mouse.y/16) == widget) {
	radio_button_event_do(widget);
    }
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

Q8tkWidget	*q8tk_radio_button_new(Q8tkWidget *group)
{
    Q8tkWidget *w;
    Q8List *list;

    w = malloc_widget();
    w->type = Q8TK_TYPE_RADIO_BUTTON;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->key_up_used    = TRUE;
    w->key_down_used  = TRUE;
    w->key_left_used  = TRUE;
    w->key_right_used = TRUE;

    w->event_button_on = radio_button_event_button_on;
    w->event_key_on    = radio_button_event_key_on;
    w->event_drag_off  = radio_button_event_drag_off;

    if (group == NULL) {				/* ǽ1 */
	list = NULL;
	w->stat.button.active = TRUE;
    } else {						/* 2ܰʹ   */
	list = group->stat.button.list;
	w->stat.button.active = FALSE;
    }
    w->stat.button.list = q8_list_append(list, w);

    return w;
}

Q8tkWidget	*q8tk_radio_button_new_with_label(Q8tkWidget *group,
						  const char *label)
{
    Q8tkWidget *b = q8tk_radio_button_new(group);
    Q8tkWidget *l = q8tk_label_new(label);

    q8tk_widget_show(l);
    q8tk_container_add(b, l);

    b->with_label = TRUE;

    return b;
}

Q8List	*q8tk_radio_button_get_list(Q8tkWidget *group)
{
    return group->stat.button.list;
}




/*---------------------------------------------------------------------------
 * ܥܥå (COMBO BOX)
 *---------------------------------------------------------------------------
 *  ȥΰġ
 *  ҤϻƤʤ
 *  q8tk_combo_append_popdown_strings() ˤꡢʸ٥˻ä
 *    ꥹȥƥ롣ϰΥݥåץåץɥ
 *    ˤɽ롣
 *  ʥ
 *	"activate"	ꥹȥƥब򤵤줿Ȥˤꡢ
 *			ȥΰʸѹäȯ
 *			ʤȥˤƥ꥿󥭡Ϥäȯ
 *	"changed"	ȥˤʸϡʸäȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_combo_new(void)
 *	ܥܥåϡϤԲĤˤʤäƤ롣
 *
 *  void	q8tk_combo_append_popdown_strings(Q8tkWidget *combo, 
 *						  const char *entry_str,
 *						  const char *disp_str)
 *	Υݥåץåץɥ뤿Ρꥹȥƥ
 *	롣Υꥹȥƥϡ disp_str ʸ٥˻ġ
 *		ΥݥåץåץɥˤƤΥꥹȥƥब
 *		줿硢 ܥܥåΥȥΰ entry_str å
 *		롣("activate"ʥ뤬ȯ)
 *	disp_str == NULL ξϡ disp_str  entry_str Ʊˤʤ롣
 *
 *  const char	*q8tk_combo_get_text(Q8tkWidget *combo)
 *	ȥΰϤƤʸ֤
 *
 *  void	q8tk_combo_set_text(Q8tkWidget *combo, const char *text)
 *	ʸ򥨥ȥΰꤹ (ʥȯʤ)
 *
 *  void	q8tk_combo_set_editable(Q8tkWidget *combo, int editable)
 *	ȥΰϲġԲĤꤹ롣 editable  ʤϲġ
 *
 *  void	q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
 *	ܥܥåɽ width ꤹ롣 height ̵
 *  -------------------------------------------------------------------------
 *	COMBO BOX
 *		
 *		ENTRY
 *
 *	q8tk_combo_append_popdown_strings ˤ LIST ITEM  LABEL 롣
 *
 *	COMBO BOX
 *	      
 *	      ENTRY
 *	    
 *	      LIST  LIST ITEMۢLABEL
 *			
 *			LIST  LIST ITEMۢLABEL
 *			
 *			LIST  LIST ITEMۢLABEL
 *			
 *
 *	ܥܥåޥǥåȡʲΤ褦ʥɥ
 *	(Q8TK_WINDOW_POPUP) ưŪΥɥ q8tk_grab_add()
 *	롣ĤޤꡢΥɥؤʳϡʤʤ롣
 *
 *	WINDOWۢLIST BOXۢLIST ITEMۢLABEL
 *	    				  
 *	    			    LIST ITEMۢLABEL
 *	    				  
 *	    			    LIST ITEMۢLABEL
 *	    				  
 *	    
 *	    ACCEL GROUPۢACCEL KEY  BUTTON(ߡ)
 *
 *	 LIST ITEM  LABEL  q8tk_combo_append_popdown_strings() ˤ
 *	ư줿ꥹȥƥ (ȥ٥) Ǥ롣
 *
 *	ꥹȥƥΤ줫Ĥ򤵤ȡǼư
 *	å(ꥹȥƥϽ)ƺ졢Ȥɽ롣
 *	λ򤷤ꥹȥƥλʸ󤬡ȥΰ
 *	åȤ졢Ʊ˥ʥ뤬ȯ롣
 *
 *	ESC줿⡢ɽ롣(ξʥʤ)
 *	¸뤿˥졼ѤƤ뤬졼
 *	ϡåȤ˥ʥ뤳ȤʤΤǡߡΥܥ
 *	(ɽ) ơΥܥ˥ʥ褦ˤƤ롣
 *	ΥܥϥʥȼȡƤΥåȤ롣
 *
 *	ꥹȤĹʤä硢ꥹȥܥåɽ̤˼ޤʤȤ
 *	Τǡξ WINDOW  LIST BOX δ֤˥ɥɥ
 *	롣(̤˼ޤ뤫ɤȽǤϷ빽ø)
 *
 *---------------------------------------------------------------------------*/

/* ݥåץåץɥǡLIST ITEM  or ESC or ɥ
   ޥåΥХåؿݥåץåץɥ */
static	void	combo_fake_callback(UNUSED_WIDGET, Q8tkWidget *parent)
{
    Q8List *l;

    l = parent->stat.combo.list;		/* l->data  LIST ITEM */
    while (l) {
	q8tk_signal_handlers_destroy((Q8tkWidget *)(l->data));
	l = l->next;
    }

    q8tk_grab_remove(parent->stat.combo.popup_window);

    if (parent->stat.combo.popup_scrolled_window)
	q8tk_widget_destroy(parent->stat.combo.popup_scrolled_window);

    /* LIST BOX Ϻ뤬 LIST ITEM Ϻ˻Ĥ */
    q8tk_widget_destroy(parent->stat.combo.popup_list);
    q8tk_widget_destroy(parent->stat.combo.popup_window);
    q8tk_widget_destroy(parent->stat.combo.popup_fake);
    q8tk_widget_destroy(parent->stat.combo.popup_accel_group);
}

/* ݥåץåץɥ LIST ITEM ޥåΥХå */
static	void	combo_event_list_callback(Q8tkWidget *list_item,
					  Q8tkWidget *parent)
{
    if (strcmp(parent->stat.combo.entry->name, list_item->child->name) == 0) {
	/* ߤϤȡ򤷤ꥹȤʸƱʤΤǡʥ̵ */
    } else {
	/* ߤϤȡ򤷤ꥹȤʸƱʤΤǡʥ̵ */
	q8tk_entry_set_text(parent->stat.combo.entry,
			    list_item->child->name);
	widget_signal_do(parent, "activate");
    }

    combo_fake_callback(NULL, parent);
}

/* ܤΰɽܥޥå顢ݥåץåץɥ */
static	void	combo_event_button_on(Q8tkWidget *widget)
{
    int selected = FALSE;
    Q8List *l;
    int scrolled = FALSE;
    int y_pos = widget->y + 1; /* ݥåץåץɥɽ */

    widget->stat.combo.popup_window = q8tk_window_new(Q8TK_WINDOW_POPUP);
    widget->stat.combo.popup_scrolled_window = NULL;
    widget->stat.combo.popup_list = q8tk_listbox_new();

    l = widget->stat.combo.list;		/* l->data  LIST ITEM */
    while (l) {
	q8tk_container_add(widget->stat.combo.popup_list,
			   (Q8tkWidget *)(l->data));

    /* ȥʸΰפꥹȥƥ֤Ȥ롣          */
    /* q8tk_listbox_select_child()ϥʥȯΤǥʥϿ˽ */
	if (selected == FALSE) {		/* l->data->child  LABEL */
	    if (strcmp(widget->stat.combo.entry->name,
		       ((Q8tkWidget*)(l->data))->child->name) == 0) {
		q8tk_listbox_select_child(widget->stat.combo.popup_list,
					  (Q8tkWidget*)(l->data));
		selected = TRUE;
	    }
	}

	q8tk_signal_connect((Q8tkWidget *)(l->data), "select",
			    combo_event_list_callback, widget);
	l = l->next;
    }


    q8tk_widget_show(widget->stat.combo.popup_list);


#if 1
    if (widget->y + widget->stat.combo.nr_items + 2 <= (24+1)) {
	/* ɽƤ⡢̤Ϥ߽Фʤ (̾ WINDOW )*/

	scrolled = FALSE;
	y_pos    = widget->y + 1;

    } else if (widget->y - widget->stat.combo.nr_items - 2 >= (0-1)) {
	/* ɽС̤Ϥ߽Фʤ (̾ WINDOW )*/

	scrolled = FALSE;
	y_pos    = widget->y - widget->stat.combo.nr_items - 2;

    } else {
	/* ɤäɽƤ⡢̤Ϥ߽Ф (SCROLLED WINDOW )*/

	if (widget->y <= 25/2) {	/* ΤۤΤǡɽ */
	    scrolled = TRUE;
	    y_pos    = widget->y + 1;
	} else {			/* ΤۤΤǡɽ */
	    scrolled = TRUE;
	    y_pos    = 0-1;
	}
    }

    if (scrolled) {	/* SCROLLED WINDOW ξ */
	int height;

	if (y_pos > widget->y) height = (24+1) - 2 - widget->y;	/*  */
	else                   height = widget->y - 2 +1;	/*  */
	if (height < 3) height = 3;		/* ꤨʤǰΰ */

	widget->stat.combo.popup_scrolled_window = 
					q8tk_scrolled_window_new(NULL, NULL);
	q8tk_container_add(widget->stat.combo.popup_scrolled_window, 
			   widget->stat.combo.popup_list);

	/* 岼ǡƥ֤ITEMɽ֤ѤƤ⤤⡣ */
	q8tk_listbox_set_placement(widget->stat.combo.popup_list, +1, +1);

	q8tk_scrolled_window_set_policy(
				widget->stat.combo.popup_scrolled_window,
				Q8TK_POLICY_AUTOMATIC, Q8TK_POLICY_ALWAYS);

	if (widget->stat.combo.width) {
	    q8tk_misc_set_size(widget->stat.combo.popup_scrolled_window, 
			       widget->stat.combo.width +3, height);
	} else {
	    q8tk_misc_set_size(widget->stat.combo.popup_scrolled_window, 
			       widget->stat.combo.length +3, height);
	}

	q8tk_widget_show(widget->stat.combo.popup_scrolled_window);
	q8tk_container_add(widget->stat.combo.popup_window, 
			   widget->stat.combo.popup_scrolled_window);

    } else {		/* Ρޥ WINDOW ξ */

	q8tk_container_add(widget->stat.combo.popup_window, 
			   widget->stat.combo.popup_list);

    }

#else
		/* ̤Ϥ߽ФʻϡSCROLLED WINDOW  */
    if (widget->y + widget->stat.combo.nr_items + 2 > (24+1)) {

	int height = (24+1) - 2 - widget->y;
	if (height < 3) height = 3;

	widget->stat.combo.popup_scrolled_window = 
					q8tk_scrolled_window_new(NULL, NULL);
	q8tk_container_add(widget->stat.combo.popup_scrolled_window, 
			   widget->stat.combo.popup_list);

	q8tk_scrolled_window_set_policy(
				widget->stat.combo.popup_scrolled_window,
				Q8TK_POLICY_AUTOMATIC, Q8TK_POLICY_ALWAYS);

	if (widget->stat.combo.width) {
	    q8tk_misc_set_size(widget->stat.combo.popup_scrolled_window, 
			       widget->stat.combo.width +3, height);
	} else {
	    q8tk_misc_set_size(widget->stat.combo.popup_scrolled_window, 
			       widget->stat.combo.length +3, height);
	}

	q8tk_widget_show(widget->stat.combo.popup_scrolled_window);
	q8tk_container_add(widget->stat.combo.popup_window, 
			   widget->stat.combo.popup_scrolled_window);

    } else {	/* ̾ϥץ WINDOW  */

	q8tk_container_add(widget->stat.combo.popup_window, 
			   widget->stat.combo.popup_list);

    }
#endif

    q8tk_widget_show(widget->stat.combo.popup_window);
    q8tk_grab_add(widget->stat.combo.popup_window);
    q8tk_widget_set_focus(widget->stat.combo.popup_list);

    if (widget->stat.combo.width) {
	q8tk_misc_set_size(widget->stat.combo.popup_list,
			   widget->stat.combo.width, 0);
    }

    widget->stat.combo.popup_window->stat.window.set_position = TRUE;
    widget->stat.combo.popup_window->stat.window.x = 
		widget->x -1 -((widget->stat.combo.popup_scrolled_window)?1:0);
    widget->stat.combo.popup_window->stat.window.y = 
		y_pos;

    q8tk_signal_connect(widget->stat.combo.popup_window,
			"inactivate", combo_fake_callback,widget);


	/* ESC 򲡤ꥹȤõ뤿Ρߡ */

    widget->stat.combo.popup_fake = q8tk_button_new();
    q8tk_signal_connect(widget->stat.combo.popup_fake, "clicked",
			combo_fake_callback, widget);

    widget->stat.combo.popup_accel_group = q8tk_accel_group_new();
    q8tk_accel_group_attach(widget->stat.combo.popup_accel_group,
			    widget->stat.combo.popup_window);
    q8tk_accel_group_add(widget->stat.combo.popup_accel_group, Q8TK_KEY_ESC,
			 widget->stat.combo.popup_fake, "clicked");
}

/* ꥿󡦥ڡ򲡤顢ɽܥޥåƱ򤹤*/
/* 򲡤Ʊ */
static	void	combo_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {
	combo_event_button_on(widget);
    }

#ifdef	OLD_FOCUS_CHANGE
	/* DO NOTHING */
#else	/* ʥեư */
    if (key == Q8TK_KEY_UP || key == Q8TK_KEY_DOWN) {
	combo_event_button_on(widget);
    }
#endif
}

/* ȥϤäȤʥȯ */
static	void	combo_event_entry_activate(UNUSED_WIDGET, Q8tkWidget *parent)
{
    widget_signal_do(parent, "activate");
}
static	void	combo_event_entry_changed(UNUSED_WIDGET, Q8tkWidget *parent)
{
    widget_signal_do(parent, "changed");
}


Q8tkWidget	*q8tk_combo_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_COMBO;
    w->sensitive = TRUE;

    w->key_up_used    = TRUE;
    w->key_down_used  = TRUE;

    w->stat.combo.entry  = q8tk_entry_new();
    w->stat.combo.list   = NULL;
    w->stat.combo.width  = 0;
    w->stat.combo.length = 0;

    w->stat.combo.entry->stat.entry.combo = w;

    q8tk_combo_set_editable(w, FALSE);
    q8tk_widget_show(w->stat.combo.entry);
    q8tk_signal_connect(w->stat.combo.entry, "activate",
			combo_event_entry_activate, w);
    q8tk_signal_connect(w->stat.combo.entry, "changed",
			combo_event_entry_changed, w);

    w->event_button_on = combo_event_button_on;
    w->event_key_on    = combo_event_key_on;

    return w;
}
void		q8tk_combo_append_popdown_strings(Q8tkWidget *combo, 
						  const char *entry_str,
						  const char *disp_str)
{
    int l0, l1, l2;
    Q8tkWidget *list_item;

    if (combo->stat.combo.list == NULL) {	/* ǰΤ */
	combo->stat.combo.length   = 0;
	combo->stat.combo.nr_items = 0;
    }

		/* ʸĹå */

    if (entry_str == NULL) entry_str = "";
    if (disp_str  == NULL) disp_str  = entry_str;

    l0 = combo->stat.combo.length;
    l1 = (disp_str) ? q8gr_strlen(kanji_code, disp_str) : 0;
    l2 = q8gr_strlen(kanji_code, entry_str)
		+ ((combo->stat.combo.entry->stat.entry.editable) ? +1 : 0);

    combo->stat.combo.length = Q8TKMAX(Q8TKMAX(l0, l1), l2);


		/* ٥դ LIST ITEM Υݥ󥿤ꥹȤݻ */

    list_item = q8tk_list_item_new_with_label(disp_str);
    q8tk_widget_show(list_item);
    q8tk_list_item_set_string(list_item, entry_str);

    combo->stat.combo.list = q8_list_append(combo->stat.combo.list, list_item);
    combo->stat.combo.nr_items ++;


		/* ܤˡʸ򥻥å */

    q8tk_entry_set_text(combo->stat.combo.entry, entry_str);

    if (combo->stat.combo.width) {
	q8tk_misc_set_size(combo->stat.combo.entry,
			   combo->stat.combo.width, 0);
    } else {
	q8tk_misc_set_size(combo->stat.combo.entry,
			   combo->stat.combo.length, 0);
    }
}

#if 0
void		q8tk_combo_clear_popdown_strings(Q8tkWidget *combo, 
						 int start, int end)
{
    /* ̤ */
}
#endif

const	char	*q8tk_combo_get_text(Q8tkWidget *combo)
{
    return combo->stat.combo.entry->name;
}

void		q8tk_combo_set_text(Q8tkWidget *combo, const char *text)
{
    q8tk_entry_set_text(combo->stat.combo.entry, text);
}

void		q8tk_combo_set_editable(Q8tkWidget *combo, int editable)
{
    q8tk_entry_set_editable(combo->stat.combo.entry, editable);
}




/*---------------------------------------------------------------------------
 * ꥹȥܥå (LIST BOX)
 *---------------------------------------------------------------------------
 *  ľܥåΤ褦ʥåȡ
 *  ʣλҤƤ롣  âꥹȥƥʳλҤäƤϤʤ
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *    Ҥϡq8tk_container_add() ƤӽФ֤˲زؤ¤Ǥ
 *  ꥹȥƥΤ줫Ĥ֤ˤ뤳ȤǤ롣
 *    (ʤˤ뤳ȤǤ뤬ʣ֤ˤ뤳ȤϤǤʤ)
 *  ʥ
 *	"selection_change"	ꥹȥƥޥå
 *				֤ȤʤäƤꥹȥƥब
 *				Ѳȯ롣
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_listbox_new(void)
 *	ꥹȥܥå
 *
 *  void    q8tk_listbox_clear_items(Q8tkWidget *wlist, int start, int end)
 *	ҤΥꥹȥƥ롣 
 *	ꥹȥƥϡq8tk_container_add()ƤӽФ 0 ֹ椬
 *	Τǡֹǡꥹȥƥꤹ롣
 *	end  start ⾮ϡƤΥꥹȥƥब롣
 *	ꥹȥƥϾǤΤǸ夫Ѥ뤳ȤϤǤʤ
 *	ѤϤҤȤĤ q8tk_container_remove() ˤƺ٤
 *
 *  void    q8tk_listbox_select_item(Q8tkWidget *wlist, int item)
 *	item ֹΥꥹȥƥ֤ˤ (ʥ뤬ȯ)
 *
 *  void    q8tk_listbox_select_child(Q8tkWidget *wlist, Q8tkWidget *child)
 *	child Υꥹȥƥ֤ˤ (ʥ뤬ȯ)
 *
 *  void    q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
 *	ꥹȥܥåɽ width ꤹ롣 height ̵
 *
 *  void    q8tk_listbox_set_placement(Q8tkWidget *widget,
 *				       int top_pos, int left_pos)
 *	ꥹȥܥåɥɥλҤǤ硢ꥹȥܥå
 *	ҤΥꥹȥƥΤƥ֤ʤΤ륤󤹤褦
 *	ɽ֤Ĵ뤬Ĵ֤ꤹ롣
 *		top_pos ξϡƥ֤ʤΤɥˡ
 *		ξϡƥ֤ʤΤɥˡɽ
 *		褦Ĵ롣ͤͤ礭ʤۤɡɥ
 *		ɽ롣
 *		left_pos ξϡꥹȥƥƬξϡ
 *		ꥹȥƥɽ褦Ĵ롣ͤͤ
 *		طʤ
 *		ͤ 0 ξ (ǥե) ϡ -1 Ȥߤʤ롣(Ĥޤꡢ
 *		ɥ˥ƥɽ褦Ĵ)
 *  -------------------------------------------------------------------------
 *	LIST BOXۢ [LIST ITEM]  [LABEL]	ꥹȥƥ (ȡ
 *	   		    			٥) Ҥ˻
 *	   	       [LIST ITEM]  [LABEL]
 *	   		    
 *	   ->      [LIST ITEM]  [LABEL]
 *		    
 *	ˤ           [LIST ITEM]  [LABEL]
 *	줫	    
 *	֤
 *	
 *	    ġġ  򤵤줿 LIST ITEM  ޥå줿Ȥˤʤ
 *
 *
 *	ꥹȥܥåɥɥλҤǤ硢
 *	ɥ˥եľ˥ꥹȥܥå˥ե
 *	ܤ롣ˤꡢꥹȥܥåϥϤĤ褦ˤʤ롣
 *
 *	Ϥˤơꥹȥƥ򤷤硢
 *	Υꥹȥƥबޥǥå줿ΤƱư򤹤롣
 *	
 *	q8tk_listbox_select_item() q8tk_listbox_select_child() 
 *	ꥹȥƥ򤷤Ȥư㤦
 *
 *---------------------------------------------------------------------------*/

static void list_scroll_adjust(Q8tkWidget *widget);

/* ʸ򲡤顢ʸƬˤĥꥹȥƥबƥ֤ˤ  */
/* 򲡤顢岼Υꥹȥƥ򥢥ƥ֤ˤ                */
/* ڡ꥿򲡤顢Υꥹȥƥ򤹤 (ʥȯ) */
static	void	list_event_key_on(Q8tkWidget *widget, int key)
{
    Q8tkWidget *w = widget->stat.listbox.active;

    if (w) {
	if (key <= 0xff &&
	    isgraph(key)) {	       /* ڡʳʸϤ줿 */

	    Q8tkWidget *active = w;
	    for (;;) {		       /* ƥ֤ʥꥹȥƥ */
		w = w->next;	       /* ΥꥹȥƥΡ(٥)   */
		if (w == NULL) {       /* ƬʸȥϤΤפ */
		    w = widget->child; /* 缡õƤꥹȥƥ */
		}		       /* μƬꡢ٤Ƥõ */

		if (w == active || w == NULL) break;   /* ʤФ */

		if (w->child) {
		    if ((w->name        && w->name[0]        == key) ||
			(w->child->name && w->child->name[0] == key)) {
							/* Ĥä      */
			widget->stat.listbox.active = w;/* 򥢥ƥ֤*/

			list_scroll_adjust(widget);	/* ɽ֤Ĵ */
			break;
		    }
		}
	    }

	} else {		       /* ڡʸϤ줿 */
	    switch (key) {

	    case Q8TK_KEY_RET:
	    case Q8TK_KEY_SPACE:
		(*w->event_button_on)(w);
		break;

	    case Q8TK_KEY_UP:
		if (w->prev) {
		    widget->stat.listbox.active = w->prev;
							/* 1򥢥ƥ */
		    list_scroll_adjust(widget);		/* ɽ֤Ĵ */
		}
		break;
	    case Q8TK_KEY_DOWN:
		if (w->next) {
		    widget->stat.listbox.active = w->next;
							/* 1ĸ򥢥ƥ */
		    list_scroll_adjust(widget);		/* ɽ֤Ĵ */
		}
		break;

	    case Q8TK_KEY_PAGE_UP:
		if (widget->parent &&
		    widget->parent->type == Q8TK_TYPE_SCROLLED_WINDOW &&
		    widget->parent->stat.scrolled.vscrollbar) {

		    int h = widget->parent->stat.scrolled.height -1;
		    if (widget->stat.scrolled.hscrollbar) h -= 3;
		    else                                  h -= 2;
		    for ( ; h>0; h--) {
			if (w->prev == NULL) break;
			w = w->prev;
		    }
		    widget->stat.listbox.active = w;
							/* 1򥢥ƥ */
		    list_scroll_adjust(widget);		/* ɽ֤Ĵ */
		}
		break;
	    case Q8TK_KEY_PAGE_DOWN:
		if (widget->parent &&
		    widget->parent->type == Q8TK_TYPE_SCROLLED_WINDOW &&
		    widget->parent->stat.scrolled.vscrollbar) {

		    int h = widget->parent->stat.scrolled.height -1;
		    if (widget->stat.scrolled.hscrollbar) h -= 3;
		    else                                  h -= 2;
		    for ( ; h>0; h--) {
			if (w->next == NULL) break;
			w = w->next;
		    }
		    widget->stat.listbox.active = w;
							/* 1Ǹ򥢥ƥ */
		    list_scroll_adjust(widget);		/* ɽ֤Ĵ */
		}
		break;
	    }
	}
    }
}



static void list_scroll_adjust(Q8tkWidget *widget)
{
    int i;
    Q8tkWidget *c;

    if (widget->parent &&
	widget->parent->type == Q8TK_TYPE_SCROLLED_WINDOW) {

	c = widget->child;
	for (i=0; c ;i++) {
	    if (c == widget->stat.listbox.active) break;
	    c = c->next;
	}

	if (i < widget->parent->stat.scrolled.child_y0) {
	    Q8TK_ADJUSTMENT(widget->parent->stat.scrolled.vadj)->value = i;
	}
	else if (i >=   widget->parent->stat.scrolled.child_y0
		      + widget->parent->stat.scrolled.child_sy) {
	    Q8TK_ADJUSTMENT(widget->parent->stat.scrolled.vadj)->value
				= i -widget->parent->stat.scrolled.child_sy +1;
	}
    }
    set_construct_flag(TRUE);
}





Q8tkWidget	*q8tk_listbox_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_LISTBOX;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->key_up_used    = TRUE;
    w->key_down_used  = TRUE;

    w->event_key_on = list_event_key_on;

    w->stat.listbox.selected = NULL;
    w->stat.listbox.active   = NULL;

    return w;
}

void		q8tk_listbox_clear_items(Q8tkWidget *wlist, int start, int end)
{
    int i, count;
    Q8tkWidget *wk, *c = wlist->child;

    if (c == NULL) return;
    if (start < 0) return;

    if (end < start) count = -1;
    else             count = end - start +1;

    for (i=0; i<start; i++) {			/* Ҥ LIST ITEM  start */
	if ((c = c->next) == NULL) return;	/* ܤޤǽˤɤ          */
    }
    while (count) {				/*  endܤޤǤ    */
	wk = c->next;				/* ڤΥ                  */
	q8tk_container_remove(wlist, c);		/* LIST ITEM  LABEL*/
	q8tk_widget_destroy(c);				/* 쵤˺  */
	if ((c = wk) == NULL) break;
	if (count > 0) count --;
    }

    set_construct_flag(TRUE);
}

static	/* LIST BOX ˷Ҥä LIST Ρ name  s ˰פΤõ */
Q8tkWidget	*q8tk_listbox_search_items(Q8tkWidget *wlist, const char *s)
{
    Q8tkWidget *c = wlist->child;

    for (;;) {
	if (c == NULL) return NULL;

	if (c->name &&
	    strcmp(c->name, s) == 0) return c;

	c = c->next;
    }
}

void		q8tk_listbox_select_item(Q8tkWidget *wlist, int item)
{
    int i;
    Q8tkWidget *c = wlist->child;

    if (c == NULL) return;

    if (item < 0) c = NULL;
    else {
	for (i=0; i<item; i++) {
	    if ((c = c->next) == NULL) break;
	}
    }

    q8tk_listbox_select_child(wlist, c);
}

void		q8tk_listbox_select_child(Q8tkWidget *wlist, Q8tkWidget *child)
{
    if (wlist->stat.listbox.selected != child) {
	wlist->stat.listbox.selected = child;
	wlist->stat.listbox.active   = child;
	widget_signal_do(wlist, "selection_changed");
	set_construct_flag(TRUE);
    }
    if (child) {
	widget_signal_do(child, "select");
	widget_scrollin_register(child);
    }
}

void		q8tk_listbox_set_placement(Q8tkWidget *widget,
					   int top_pos, int left_pos)
{
    widget->stat.listbox.scrollin_top  = top_pos;
    widget->stat.listbox.scrollin_left = left_pos;
}


/*
 * Ϥäü
 *	LIST BOX  SCROLLED WINDOW λҤξǡSCROLLED WINDOW Υ
 *	С() ư줿ȤδؿƤФ롣
 *	ǤϡSCROLLED WINDOW ɽϰϤ˱ơLIST BOX  active
 *	åȤѹƤ롣
 */
static	void	list_event_window_scrolled(Q8tkWidget *swin, int sy)
{
    Q8tkWidget *widget = swin->child;	/* == LISTBOX */

    Q8tkWidget *c = widget->child;
    int        nth = 0;

    if (c == NULL) return;

    while (c) {
	if (c == widget->stat.listbox.active) break;
	nth ++;
	c = c->next;
    }
    nth = nth - swin->stat.scrolled.vadj->stat.adj.value;

    if (0 <= nth && nth < sy) {
	/* Ok, No Adjust */
    } else {

	if (nth < 0) nth = swin->stat.scrolled.vadj->stat.adj.value;
	else         nth = swin->stat.scrolled.vadj->stat.adj.value + sy -1;

	c = widget->child;
	while (nth--) {
	    if ((c = c->next) == NULL) return;
	}
	widget->stat.listbox.active   = c;
	set_construct_flag(TRUE);

    }
}




/*---------------------------------------------------------------------------
 * ꥹȥƥ (LIST ITEM)
 *---------------------------------------------------------------------------
 *  ꥹȥܥåλҤˤʤ롣
 *  ҤĻƤ롣 (â٥ʳλҤäư̤ݾ)
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  ʸݻǤ롣
 *  ʥ
 *	"select"	å (Ǥ򤵤줿֤Ǥȯ)
 *			ƤΥꥹȥܥå֤ȤƤΤȤ̵
 *			硢˿Ƥ "selection_changed" ٥Ȥȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_list_item_new(void)
 *	ꥹȥƥ
 *
 *  Q8tkWidget	*q8tk_list_item_new_with_label(const char *label)
 *	ʸ label 줿ꥹȥƥ
 *	Ūˤϡꥹȥƥȥ٥ꡢƻҤˤ롣
 *
 *  void	q8tk_list_item_set_string(Q8tkWidget *w, const char *str)
 *	ʸ str ݻ롣
 *  -------------------------------------------------------------------------
 *	[LIST BOX]  LIST ITEMۢ [LABEL]	٥Ҥ˻
 *							Ƥϡꥹȥܥå
 *	   		    
 *	   		    
 *   "selection_change"     
 *	   		  "select"
 *	   ġġġġġ   
 *	˿Ƥ	    
 *	Ť        ܥ
 *
 *---------------------------------------------------------------------------*/
/* ꥹȥƥޥå顢ʥȯ */
static	void	list_item_event_button_on(Q8tkWidget *widget)
{
    if (widget->parent) {
	q8tk_widget_set_focus(widget->parent);

	if (widget->parent->stat.listbox.selected != widget) {
	    widget->parent->stat.listbox.selected = widget;
	    widget->parent->stat.listbox.active   = widget;

#if 0       /* Τޤޤȡ򤷤֤褹ˤʤ */
	    widget_signal_do(widget->parent, "selection_changed");

#else	    /* 򤷤֤褵Τǡ٥Ȥ٤餻 */
	    set_delay_widget(widget, 6);	/* 6 ե졼ʬٱ */
	    return;
#endif
	}
    }
    widget_signal_do(widget, "select");
    set_construct_flag(TRUE);
}

Q8tkWidget	*q8tk_list_item_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_LIST_ITEM;
    w->attr = Q8TK_ATTR_CONTAINER | Q8TK_ATTR_LABEL_CONTAINER;
    w->sensitive = TRUE;

    w->event_button_on = list_item_event_button_on;

    return w;
}

Q8tkWidget	*q8tk_list_item_new_with_label(const char *label)
{
    Q8tkWidget *i = q8tk_list_item_new();
    Q8tkWidget *l = q8tk_label_new(label);

    q8tk_widget_show(l);
    q8tk_container_add(i, l);

    i->with_label = TRUE;

    return i;
}

void		q8tk_list_item_set_string(Q8tkWidget *w, const char *str)
{
    if (w->name) free(w->name);
    w->name = (char *)malloc(strlen(str)+1);

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, str);
    w->code = kanji_code;
}




/*---------------------------------------------------------------------------
 * ٥ (LABEL)
 *---------------------------------------------------------------------------
 *  (ɽѤ)ʸݻǤ
 *  ޤޤʥƥʤλҤˤʤ롣
 *  ʥ  ̵
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_label_new(const char *label)
 *	ʸ label ĥ٥
 *
 *  void	q8tk_label_set(Q8tkWidget *w, const char *label)
 *	٥ʸ label ѹ롣
 *
 *  void	q8tk_label_set_reverse(Q8tkWidget *w, int reverse)
 *	٥ʸȿžɽꤹ롣 reverse ʤȿž롣
 *
 *  void	q8tk_label_set_color(Q8tkWidget *w, int foreground)
 *	٥ʸοꤹ롣 foreground ꤹ롣ͤ
 *	Q8GR_PALETTE_xxxx ǻꤹ롣ͤʤ顢ǥեȤο᤹
 *  -------------------------------------------------------------------------
 *	LABEL			ҤϻƤʤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_label_new(const char *label)
{
    Q8tkWidget *w;

    if (label == NULL) label = "";

    w = malloc_widget();
    w->type = Q8TK_TYPE_LABEL;
    w->name = (char *)malloc(strlen(label) + 1);
    w->sensitive = TRUE;

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, label);
    w->code = kanji_code;

    w->stat.label.foreground = Q8GR_PALETTE_FOREGROUND;
    w->stat.label.background = Q8GR_PALETTE_BACKGROUND;
    w->stat.label.reverse    = FALSE;

    return w;
}
void		q8tk_label_set(Q8tkWidget *w, const char *label)
{
    if (label == NULL) label = "";

    if (w->name) free(w->name);
    w->name = (char *)malloc(strlen(label) + 1);

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, label);
    w->code = kanji_code;

    set_construct_flag(TRUE);
}
void		q8tk_label_set_reverse(Q8tkWidget *w, int reverse)
{
    if (w->stat.label.reverse != reverse) {
	w->stat.label.reverse = reverse;
	set_construct_flag(TRUE);
    }
}
void		q8tk_label_set_color(Q8tkWidget *w, int foreground)
{
    if (foreground < 0) foreground = Q8GR_PALETTE_FOREGROUND;

    if (w->stat.label.foreground != foreground) {
	w->stat.label.foreground = foreground;
	set_construct_flag(TRUE);
    }
}


/*---------------------------------------------------------------------------
 *  (LOGO)
 *---------------------------------------------------------------------------
 *  ȥɽǤ(,ϸ)
 *  ޤޤʥƥʤλҤˤʤ롣
 *  ʥ  ̵
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_logo_new(void)
 *	
 *
 *  -------------------------------------------------------------------------
 *	LOGO			ҤϻƤʤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_logo_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_LOGO;
    w->sensitive = TRUE;

    return w;
}


/*---------------------------------------------------------------------------
 * ե졼 (FRAME)
 *---------------------------------------------------------------------------
 *  ҤҤȤĤƤ롣
 *  ҤĤˤϡq8tk_container_add() Ѥ롣
 *  (Ф)ʸݻǤ롣
 *  ʥ  ̵
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_frame_new(const char *label)
 *	ʸ label 򸫽Фˤĥե졼
 *  void       q8tk_frame_set_shadow_type(Q8tkWidget *frame, int shadow_type)
 *	ե졼μǤ롣
 *		Q8TK_SHADOW_NONE	Τʤե졼
 *		Q8TK_SHADOW_IN		Τؤե졼
 *		Q8TK_SHADOW_OUT		Τ夬äե졼
 *		Q8TK_SHADOW_ETCHED_IN	Ȥؤե졼
 *		Q8TK_SHADOW_ETCHED_OUT	Ȥ夬äե졼
 *  -------------------------------------------------------------------------
 *	FRAME  [xxxx]		ʻҤƤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_frame_new(const char *label)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_FRAME;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->stat.frame.shadow_type = Q8TK_SHADOW_OUT;

    w->name = (char *)malloc(strlen(label) + 1);

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, label);
    w->code = kanji_code;

    return w;
}

void		q8tk_frame_set_shadow_type(Q8tkWidget *frame, int shadow_type)
{
    frame->stat.frame.shadow_type = shadow_type;
}




/*---------------------------------------------------------------------------
 * ʿܥå (HBOX)
 *---------------------------------------------------------------------------
 *  ʣλҤƤ롣
 *  ҤĤˤϡq8tk_box_pack_start() / _end ()Ѥ롣
 *  ʥ  ̵
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_hbox_new(void)
 *	ʿܥå
 *  -------------------------------------------------------------------------
 *	HBOXۢ [xxxx]		ʻҤƤ
 *		      
 *		   [xxxx]
 *		      
 *		   [xxxx]
 *		      
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_hbox_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_HBOX;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    return w;
}




/*---------------------------------------------------------------------------
 * ľܥå (VBOX)
 *---------------------------------------------------------------------------
 *  ʣλҤƤ롣
 *  ҤĤˤϡq8tk_box_pack_start() / _end ()Ѥ롣
 *  ʥ  ̵
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_vbox_new(void)
 *	ľܥå
 *  -------------------------------------------------------------------------
 *	VBOXۢ [xxxx]		ʻҤƤ
 *		      
 *		   [xxxx]
 *		      
 *		   [xxxx]
 *		      
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_vbox_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_VBOX;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    return w;
}




/*---------------------------------------------------------------------------
 * Ρȥ֥å (NOTE BOOK / NOTE PAGE)
 *---------------------------------------------------------------------------
 *  ʣΥΡȥڡƤ롣
 *  ƥΡȥڡϥƥʤǤꡢҤĻƤ롣
 *  q8tk_notebook_append() ǻҤĤ٤ǥΡȥڡ
 *    줬ҤĤȤˤʤ롣
 *  NOTE PAGE ϡ(Ф)ʸݻǤ롣
 *  ʥ
 *	"switch_page"	̤Υڡڤؤäȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_notebook_new(void)
 *	Ρȥܥå
 *
 *  void	q8tk_notebook_append(Q8tkWidget *notebook,
 *				     Q8tkWidget *widget, const char *label)
 *	Ρȥ֥å noteboot  ˿ʥڡ롣
 *	Υڡ widget ɲä롣Фʸ label
 *	ŪˤϡΡȥڡꡢƻҤˤǤˡ
 *	Ρȥڡ wiget ƻҤˤ롢
 *
 *  int	q8tk_notebook_current_page(Q8tkWidget *notebook)
 *	ߤΥڡֹ롣
 *	ʤΡȥ֥å˥ڡɲäˡ0 ֹ椬롣
 *	ڡɲäƤʤ -1 
 *
 *  void	q8tk_notebook_set_page(Q8tkWidget *notebook, int page_num)
 *	Ρȥ֥åΥڡꤹ(ʥ뤬ȯ)
 *
 *  void	q8tk_notebook_next_page(Q8tkWidget *notebook)
 *	Ρȥ֥åΥڡǤˤ(ʥ뤬ȯ)
 *
 *  void	q8tk_notebook_prev_page(Q8tkWidget *notebook)
 *	Ρȥ֥åΥڡǤˤ(ʥ뤬ȯ)
 *  -------------------------------------------------------------------------
 *	NOTE BOOKۢNOTE PAGEۢ [xxxx]	ΡȥڡҤ˻
 *			      			˥Ρȥڡ
 *		       NOTE PAGEۢ [xxxx]	ʻҤƤ
 *			      
 *		       NOTE PAGEۢ [xxxx]
 *			      
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_notebook_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_NOTEBOOK;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->stat.notebook.page = NULL;

    return w;
}

/* ΡȥڡΥޥå顢ʥȯ */
static	void	notepage_event_button_on(Q8tkWidget *widget)
{
    if ((widget->parent)->stat.notebook.page != widget) {
	(widget->parent)->stat.notebook.page = widget;
	widget_signal_do(widget->parent, "switch_page");

	/* Ρȥڡľϡե(饤)ɽʤ */
	/*    ʤȤʤɽåΤǡ */
	if ((widget->parent)->stat.notebook.lost_focus) {
	    q8tk_widget_set_focus(NULL);
	}

	set_construct_flag(TRUE);
    }
}

/* ꥿󡦥ڡ򲡤顢ޥåƱ򤹤 */
/* 򲡤顢ΥڡǤΡޥåƱ򤹤 */
static	void	notepage_event_key_on(Q8tkWidget *widget, int key)
{
    if (key == Q8TK_KEY_RET || key == Q8TK_KEY_SPACE) {
	notepage_event_button_on(widget);
    }

#ifdef	OLD_FOCUS_CHANGE
	/* DO NOTHING */
#else	/* ʥեư */
    {
	Q8tkWidget *w = NULL;

	if (key == Q8TK_KEY_LEFT) {
	    if (widget->prev == NULL) {
		w = widget->next;
		if (w) {
		    while (w->next) {
			w = w->next;
		    }
		}
	    } else {
		w = widget->prev;
	    }
	}
	if (key == Q8TK_KEY_RIGHT) {
	    if (widget->next == NULL) {
		w = widget->prev;
		if (w) {
		    while (w->prev) {
			w = w->prev;
		    }
		}
	    } else {
		w = widget->next;
	    }
	}

	if (w) {
	    q8tk_widget_set_focus(w);
	    notepage_event_button_on(w);
	}
    }
#endif
}

void		q8tk_notebook_append(Q8tkWidget *notebook,
				     Q8tkWidget *widget, const char *label)
{
    Q8tkWidget *w;

    Q8tkAssert(notebook->type == Q8TK_TYPE_NOTEBOOK, NULL);

    w = malloc_widget();
    w->type = Q8TK_TYPE_NOTEPAGE;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->key_left_used  = TRUE;
    w->key_right_used = TRUE;

    w->name = (char *)malloc(strlen(label) + 1);

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, label);
    w->code = kanji_code;

    if (notebook->child == NULL) {		/* ǽ NOTE PAGE ξ*/
	notebook->stat.notebook.page = w;	/*  ֤ˤ    */
    }
    q8tk_box_pack_start(notebook, w);		/* ƥʽ BOXƱ */

    q8tk_container_add(w, widget);
    q8tk_widget_show(w);

    w->event_button_on = notepage_event_button_on;
    w->event_key_on    = notepage_event_key_on;
}

int		q8tk_notebook_current_page(Q8tkWidget *notebook)
{
    Q8tkWidget *child = notebook->child;
    int        i = 0;

    while (child) {
	if (child == notebook->stat.notebook.page) {
	    return i;
	}
	child = child->next;
	i++;
    }
    return -1;
}

void		q8tk_notebook_set_page(Q8tkWidget *notebook, int page_num)
{
    Q8tkWidget *child = notebook->child;
    int        i = 0;

    while (child) {
	if (i == page_num) {
	    if (notebook->stat.notebook.page != child) {
		q8tk_widget_set_focus(child);
		notepage_event_button_on(child);
	    }
	    break;
	} else {
	    child = child->next;
	    i++;
	}
    }
}

void		q8tk_notebook_next_page(Q8tkWidget *notebook)
{
    if (notebook->child) {
	Q8tkWidget *page = notebook->stat.notebook.page;
	if (page && page->next) {
	    q8tk_widget_set_focus(page->next);
	    notepage_event_button_on(page->next);
	}
    }
}

void		q8tk_notebook_prev_page(Q8tkWidget *notebook)
{
    if (notebook->child) {
	Q8tkWidget *page = notebook->stat.notebook.page;
	if (page && page->prev) {
	    q8tk_widget_set_focus(page->prev);
	    notepage_event_button_on(page->prev);
	}
    }
}

void		q8tk_notebook_hook_focus_lost(Q8tkWidget *notebook, 
					      int focus_lost)
{
    notebook->stat.notebook.lost_focus = focus_lost;
}



/*---------------------------------------------------------------------------
 * ľѥ졼 (VSEPARATOR)
 *---------------------------------------------------------------------------
 *  ҤϻƤʤ
 *  ĹƥåȤ礭ˤꡢưŪѤ롣
 *  ʥ  ʤ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_vseparator_new(void)
 *	ľѥ졼
 *  -------------------------------------------------------------------------
 *	VSEPARATOR			ҤϻƤʤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_vseparator_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_VSEPARATOR;
    w->sensitive = TRUE;

    return w;
}




/*---------------------------------------------------------------------------
 * ʿѥ졼 (HSEPARATOR)
 *---------------------------------------------------------------------------
 *  ҤϻƤʤ
 *  ĹƥåȤ礭ˤꡢưŪѤ롣
 *  ʥ  ʤ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_hseparator_new(void)
 *	ʿѥ졼
 *  -------------------------------------------------------------------------
 *	VSEPARATOR			ҤϻƤʤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_hseparator_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_HSEPARATOR;
    w->sensitive = TRUE;

    return w;
}




/*---------------------------------------------------------------------------
 * 㥹ȥ (ADJUSTMENT)
 *---------------------------------------------------------------------------
 *  ɽǤʤ
 *  ҤϻƤʤҤˤʤ뤳ȤǤʤ
 *  䥹ɥɥݤˡɬפȤʤ롣
 *    ñȤǤϻѤ뤳ȤϤʤ
 *  (ͤϰ)ʬ(ʬ礭ʬ2) Ĥ
 *    ˸¤롣
 *  ϡäƥ㥹ȥȤƤΤ
 *    ΤŪ
 *  ɥɥϡλ˥㥹ȥȤư
 *    ΤŪ
 *  ʥ
 *	"value_changed"		ͤѤäȯ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_adjustment_new(int value, int lower, int upper,
 *				     int step_increment, int page_increment)
 *	㥹ȥȤ
 *	ͤϰϤ lower  upper ͤ value 
 *	礭ʬ step_increment ʬ page_increment 
 *
 *  void  q8tk_adjustment_set_value(Q8tkWidget *adj, int value)
 *	㥹ȥȤθͤꤹ롣ʥȯʤ
 *
 *  void  q8tk_adjustment_clamp_page(Q8tkWidget *adj, int lower, int upper)
 *	ͤϰϤ lower  upper ꤷʤλͤϰϳξ
 *	ͤʤǾͤꤵ롣ʥȯʤ
 *
 *  void  q8tk_adjustment_set_increment(Q8tkWidget *adj,
 *				        int step_increment, int page_increment)
 *	礭ʬȡʬꤷʤ
 *
 *  void	q8tk_adjustment_set_arrow(Q8tkWidget *adj, int arrow)
 *	arrow ξ硢ɽ롣
 *	ʤå줿  step_increment ʬ롣
 *	طʬå줿  page_increment ʬ롣
 *
 *  void	q8tk_adjustment_set_length(Q8tkWidget *adj, int length)
 *
 *   ------------------------------------------------------------------------
 *	ADJUSTMENT			ҤϻƤʤҤˤʤʤ
 *
 *---------------------------------------------------------------------------*/
/* 㥹ȥȤĴ
   㥹ȥȤޥåɥåݤ˸ƤӽФ */
enum {
    ADJ_STEP_DEC,
    ADJ_STEP_INC,
    ADJ_PAGE_DEC,
    ADJ_PAGE_INC,
    ADJ_SLIDER_DRAG
};
static	void	adjustment_do(Q8tkWidget *widget, int mode)
{
    Q8Adjust *adj = &widget->stat.adj;
    int value_old = adj->value;
    int repeat = TRUE;
    static int old = -1;	/* ޥܥ󲡤äѤʤˤˡ
				   饤Ԥä褿ꤹΤɤ */

    if (now_mouse_on == FALSE) old = -1;

    switch (mode) {
    case ADJ_STEP_DEC:
	adj->value -= adj->step_increment;
	if (adj->value < adj->lower) {
	    adj->value = adj->lower;
	    repeat = FALSE;
	}
	break;
    case ADJ_STEP_INC:
	adj->value += adj->step_increment;
	if (adj->value > adj->upper) {
	    adj->value = adj->upper;
	    repeat = FALSE;
	}
	break;
    case ADJ_PAGE_DEC:
	if (old == ADJ_PAGE_INC) {
	    mode = -1;
	    repeat = FALSE;
	    break;
	}
	adj->value -= adj->page_increment;
	if (adj->value < adj->lower) {
	    adj->value = adj->lower;
	    repeat = FALSE;
	}
	break;
    case ADJ_PAGE_INC:
	if (old == ADJ_PAGE_DEC) {
	    mode = -1;
	    repeat = FALSE;
	    break;
	}
	adj->value += adj->page_increment;
	if (adj->value > adj->upper) {
	    adj->value = adj->upper;
	    repeat = FALSE;
	}
	break;
    case ADJ_SLIDER_DRAG:
	set_drag_widget(widget);
	return;
    }

    if (value_old != adj->value) {
	widget_signal_do(widget, "value_changed");
	/* 㥹ǡLISTBOX줿㳰ե饰ON */
	adj->listbox_changed = TRUE;
    }
    set_construct_flag(TRUE);

    if (repeat) now_mouse_on = TRUE;
    else        now_mouse_on = FALSE;

    old = mode;
}

/* 㥹ȥȤξˤƥޥå顢Ĵʥȯ */
static	void	adjustment_event_button_on(Q8tkWidget *widget)
{
    Q8Adjust *adj = &widget->stat.adj;
    int slider_x, slider_y;
    int arrow_lower_x, arrow_lower_y;
    int arrow_upper_x, arrow_upper_y;
    int m_x = mouse.x / 8;
    int m_y = mouse.y / 16;

    if (adj->horizontal) {			/* HORIZONTAL ADJUSTMENT */

	slider_x = adj->x + adj->pos;
	slider_y = adj->y;

	if (m_y == slider_y) {

	    if (adj->arrow) {
		arrow_lower_x = adj->x;		slider_x ++;
		arrow_upper_x = adj->x + adj->length +1;

		if        (m_x == arrow_lower_x) {
		    adjustment_do(widget, ADJ_STEP_DEC);	return;
		} else if (m_x == arrow_upper_x) {
		    adjustment_do(widget, ADJ_STEP_INC);	return;
		}
	    }

	    if        (m_x == slider_x) {
		adjustment_do(widget, ADJ_SLIDER_DRAG);		return;
	    } else if (m_x < slider_x) {
		adjustment_do(widget, ADJ_PAGE_DEC);		return;
	    } else {
		adjustment_do(widget, ADJ_PAGE_INC);		return;
	    }

	} else {
	    return;
	}

    } else {					/* VIRTICAL ADJUSTMENT */

	slider_x = adj->x;
	slider_y = adj->y + adj->pos;

	if (m_x == slider_x) {

	    if (adj->arrow) {
		arrow_lower_y = adj->y;		slider_y ++;
		arrow_upper_y = adj->y + adj->length +1;
		if        (m_y == arrow_lower_y) {
		    adjustment_do(widget, ADJ_STEP_DEC);	return;
		} else if (m_y == arrow_upper_y) {
		    adjustment_do(widget, ADJ_STEP_INC);	return;
		}
	    }

	    if        (m_y == slider_y) {
		adjustment_do(widget, ADJ_SLIDER_DRAG);		return;
	    } else if (m_y < slider_y) {
		adjustment_do(widget, ADJ_PAGE_DEC);		return;
	    } else {
		adjustment_do(widget, ADJ_PAGE_INC);		return;
	    }

	} else {
	    return;
	}

    }
}

/* 㥹ȥȤΥ饤ɥå顢Ĵʥȯ */
static	void	adjustment_event_dragging(Q8tkWidget *widget)
{
    Q8Adjust *adj = &widget->stat.adj;
    int m_x = mouse.x / 8;
    int m_y = mouse.y / 16;
    int adj_x = adj->x;
    int adj_y = adj->y;
    int slider = -1;

    if (adj->upper <= adj->lower)  return;

    if (adj->horizontal) {
	if (adj->arrow) adj_x ++;
	if (adj_x <= m_x && m_x < adj_x+adj->length) {
	    slider = m_x - adj_x;
	}
    }else{
	if (adj->arrow) adj_y ++;
	if (adj_y <= m_y && m_y < adj_y+adj->length) {
	    slider = m_y - adj_y;
	}
    }

    if (slider >= 0) {
	float val0 = (slider -1) * adj->scale   + adj->lower;
	float val1 = (slider   ) * adj->scale   + adj->lower;
	int   val;

	if      (slider <= 0)             val = adj->lower;
	else if (slider >= adj->length-1) val = adj->upper;
	else {
	    float base = (float)(adj->upper-adj->lower) / (adj->length-1);
	    int   val2 = (int) ((int)(val1 / base) * base);
	    if (val0 < val2 && val2 <= val1) val =         val2;
	    else                             val = (int) ((val0 + val1) / 2);
	}

	if (adj->value != val) {
	    adj->value = val;
	    widget_signal_do(widget, "value_changed");
	    /* 㥹ǡLISTBOX줿㳰ե饰ON */
	    adj->listbox_changed = TRUE;
	}
	set_construct_flag(TRUE);
    }
}

/* 륭ʤɤ򲡤顢ޥåƱ򤹤 */
static	void	adjustment_event_key_on(Q8tkWidget *widget, int key)
{
    Q8Adjust *adj = &widget->stat.adj;

    if (adj->horizontal) {			/* HORIZONTAL ADJUSTMENT */
	if      (key == Q8TK_KEY_LEFT)     adjustment_do(widget, ADJ_STEP_DEC);
	else if (key == Q8TK_KEY_RIGHT)    adjustment_do(widget, ADJ_STEP_INC);
    } else {					/* VIRTICAL ADJUSTMENT */
	if      (key == Q8TK_KEY_UP)       adjustment_do(widget, ADJ_STEP_DEC);
	else if (key == Q8TK_KEY_DOWN)     adjustment_do(widget, ADJ_STEP_INC);
	else if (key == Q8TK_KEY_PAGE_UP)  adjustment_do(widget, ADJ_PAGE_DEC);
	else if (key == Q8TK_KEY_PAGE_DOWN)adjustment_do(widget, ADJ_PAGE_INC);
    }

    /* 륭򲡤äѤʤˤȡ
       ޥܥβäѤʤνܤƤޤΤǡɤ */
    now_mouse_on = FALSE;
}

Q8tkWidget	*q8tk_adjustment_new(int value, int lower, int upper,
				     int step_increment, int page_increment)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_ADJUSTMENT;
    w->sensitive = TRUE;

    w->event_button_on = adjustment_event_button_on;
    w->event_dragging  = adjustment_event_dragging;
    w->event_key_on    = adjustment_event_key_on;

    w->stat.adj.value = value;
    w->stat.adj.lower = lower;
    w->stat.adj.upper = upper;
    w->stat.adj.step_increment = step_increment;
    w->stat.adj.page_increment = page_increment;

    return w;
}

void		q8tk_adjustment_set_value(Q8tkWidget *adj, int value)
{
    if (value < adj->stat.adj.lower) value = adj->stat.adj.lower;
    if (value > adj->stat.adj.upper) value = adj->stat.adj.upper;

    if (adj->stat.adj.value != value) {
	adj->stat.adj.value = value;
	/* Υ㥹ǡLISTBOX뤳Ȥ̵ϥ
	  adj->stat.adj.listbox_changed = TRUE;
	*/

	/* ʥȯʤ */
	/*
	  widget_signal_do(adj, "value_changed");
	*/

	set_construct_flag(TRUE);
    }
}

void		q8tk_adjustment_clamp_page(Q8tkWidget *adj,
					   int lower, int upper)
{
    if (upper < lower) upper = lower;

    adj->stat.adj.lower = lower;
    adj->stat.adj.upper = upper;
    if (adj->stat.adj.value < adj->stat.adj.lower)
				adj->stat.adj.value = adj->stat.adj.lower;
    if (adj->stat.adj.value > adj->stat.adj.upper)
				adj->stat.adj.value = adj->stat.adj.upper;

    /* ʥȯʤ */

    set_construct_flag(TRUE);
}

void		q8tk_adjustment_set_arrow(Q8tkWidget *adj, int arrow)
{
    if (adj->stat.adj.arrow != arrow) {
	adj->stat.adj.arrow = arrow;
	set_construct_flag(TRUE);
    }
}

void		q8tk_adjustment_set_length(Q8tkWidget *adj, int length)
{
    if (adj->stat.adj.max_length != length) {
	adj->stat.adj.max_length = length;
	set_construct_flag(TRUE);
    }
}

void		q8tk_adjustment_set_increment(Q8tkWidget *adj,
					      int step_increment,
					      int page_increment)
{
    adj->stat.adj.step_increment = step_increment;
    adj->stat.adj.page_increment = page_increment;
}



/*---------------------------------------------------------------------------
 * ʿ (HSCALE)
 *---------------------------------------------------------------------------
 *  new()ˡǥ㥹ȥȤꤹ롣
 *    Υ(ϰ)ʬϡΥ㥹ȥȤ˰¸롣
 *  new()ΰ NULL ξϡưŪ˥㥹ȥȤ뤬
 *    λΥ󥸤 010 ʬ 1  2 ˸Ǥ롣(ѹǽ)
 *  ҤϻƤʤ
 *  ʥ  ʤ
 *	㥹ȥȤϥʥ롣
 *	㥹ȥȤư硢ɤäƥʥ򥻥åȤ롩
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_hscale_new(Q8tkWidget *adjustment)
 *	ʿ
 *	ͽѤߤΥ㥹ȥ adjustment ꤹ롣 
 *	NULL ʤǼư롣
 *
 *  void	q8tk_scale_set_draw_value(Q8tkWidget *scale, int draw_value)
 *	draw_value ʤ顢ͤ򥹥饤βɽ롣
 *
 *  void	q8tk_scale_set_value_pos(Q8tkWidget *scale, int pos)
 *	ͤɽ֤롣
 *		Q8TK_POS_LEFT	饤κɽ
 *		Q8TK_POS_RIGHT	饤αɽ
 *		Q8TK_POS_TOP	饤ξɽ
 *		Q8TK_POS_BOTTOM	饤βɽ
 *  -------------------------------------------------------------------------
 *	HSCALE				ҤϻƤʤ
 *	     	ADJUSTMENT
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_hscale_new(Q8tkWidget *adjustment)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_HSCALE;
    w->sensitive = TRUE;

    if (adjustment) {
	w->stat.scale.adj = adjustment;
    } else {
	w->stat.scale.adj = q8tk_adjustment_new(0, 0, 10, 1, 2);
    }

    w->stat.scale.adj->stat.adj.horizontal = TRUE;
    w->stat.scale.adj->parent = w;

    w->stat.scale.adj->key_up_used    = FALSE;
    w->stat.scale.adj->key_down_used  = FALSE;
    w->stat.scale.adj->key_left_used  = TRUE;
    w->stat.scale.adj->key_right_used = TRUE;

    return w;
}




/*---------------------------------------------------------------------------
 * ľ (HSCALE)
 *---------------------------------------------------------------------------
 *  new()ˡǥ㥹ȥȤꤹ롣
 *    Υ(ϰ)ʬϡΥ㥹ȥȤ˰¸롣
 *  new()ΰ NULL ξϡưŪ˥㥹ȥȤ뤬
 *    λΥ󥸤 010 ʬ 1  2 ˸Ǥ롣(ѹǽ)
 *  ҤϻƤʤ
 *  ʥ  ʤ
 *	㥹ȥȤϥʥ롣
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_hscale_new(Q8tkWidget *adjustment)
 *	ľ
 *	ͽѤߤΥ㥹ȥ adjustment ꤹ롣 
 *	NULL ʤǼư롣
 *
 *  void	q8tk_scale_set_draw_value(Q8tkWidget *scale, int draw_value)
 *	ʿƱ
 *
 *  void	q8tk_scale_set_value_pos(Q8tkWidget *scale, int pos)
 *	ʿƱ
 *  -------------------------------------------------------------------------
 *	VSCALE				ҤϻƤʤ
 *	     	ADJUSTMENT
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_vscale_new(Q8tkWidget *adjustment)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_VSCALE;
    w->sensitive = TRUE;

    w->key_up_used    = TRUE;
    w->key_down_used  = TRUE;

    if (adjustment) {
	w->stat.scale.adj = adjustment;
    } else {
	w->stat.scale.adj = q8tk_adjustment_new(0, 0, 10, 1, 2);
    }

    w->stat.scale.adj->stat.adj.horizontal = FALSE;
    w->stat.scale.adj->parent = w;

    w->stat.scale.adj->key_up_used    = TRUE;
    w->stat.scale.adj->key_down_used  = TRUE;
    w->stat.scale.adj->key_left_used  = FALSE;
    w->stat.scale.adj->key_right_used = FALSE;

    return w;
}

void		q8tk_scale_set_value_pos(Q8tkWidget *scale, int pos)
{
    scale->stat.scale.value_pos = pos;
    set_construct_flag(TRUE);
}

void		q8tk_scale_set_draw_value(Q8tkWidget *scale, int draw_value)
{
    scale->stat.scale.draw_value = draw_value;
    set_construct_flag(TRUE);
}



/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * ɽΥ׻ (widget_size()⤫ƤФ)
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static	void	adjustment_size(Q8Adjust *adj, int *sx, int *sy)
{
    int i, limit;
    int range = (adj->upper - adj->lower + 1);

    if (adj->horizontal) limit = (int) (Q8GR_SCREEN_X * 0.8);
    else                 limit = (int) (Q8GR_SCREEN_Y * 0.8);

    if (adj->max_length <= 2) {
	for (i=1; ; i++) if (range / i < limit) break;
	adj->length = range / i;
    } else {
	adj->length = adj->max_length;
    }
    adj->scale = (float)(range - 1) / (adj->length - 2);
    if      (adj->value == adj->lower) adj->pos = 0;
    else if (adj->value == adj->upper) adj->pos = adj->length-1;
    else {
	adj->pos = (int) ((adj->value - adj->lower) / adj->scale) + 1;
	if (adj->pos >= adj->length-1) adj->pos = adj->length-2;
    }

    if (adj->horizontal) {
	*sx = adj->length + ((adj->arrow) ? +2 : 0);
	*sy = 1;
    }else{
	*sx = 1;
	*sy = adj->length + ((adj->arrow) ? +2 : 0);
    }
}




/*---------------------------------------------------------------------------
 * ɥɥ (SCROLLED WINDOW)
 *---------------------------------------------------------------------------
 *  new()ˡǥ㥹ȥȤꤹ뤬Υ(ϰ)
 *    ΥɥɥλҤ礭ˤäơưŪѲ롣
 *     (ʬϰѤ)
 *  new()ΰ NULL ξϡưŪ˥㥹ȥȤ롣
 *    λʬ 1  10 Ǥ롣
 *    äͳʤСNULL ˤ뼫ưñǤ롣
 *    ʤ NULL ˤȥХꤽͽ롣
 *    ʤΤǡ NULL ޤ ˥㥹ȥȤꡢȤ뤳ȡ
 *  ҤĻƤ롣
 *    (âҤ¹륦ɥĤ褦ʾư̤ݾ)
 *  ʥ  ʤ
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_scrolled_window_new(Q8tkWidget *hadjustment,
 *					  Q8tkWidget *vadjustment)
 *	ɥɥ
 *	ͽѤߤΥ㥹ȥ adjustment ꤹ롣 
 *	NULL ʤǼư롣
 *
 *  void	q8tk_scrolled_window_set_policy(Q8tkWidget *scrolledw,
 *						int hscrollbar_policy,
 *						int vscrollbar_policy)
 *	Сɽˡġ̤ꤹ롣
 *		Q8TK_POLICY_ALWAYS	ɽ
 *		Q8TK_POLICY_AUTOMATIC	ɽ礭Τɽ
 *		Q8TK_POLICY_NEVER	ɽʤ
 *
 *  void	q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
 *	ɥΥ width  height ꤹ롣
 *  -------------------------------------------------------------------------
 *	SCROLLED WINDOWۢ [xxxx]		ʻҤƤ
 *		á
 *		è	ADJUSTMENT
 *			ADJUSTMENT
 *
 *
 *
 *	SCROLLED WINDOWۢ [LISTBOX]
 *
 *	ɥɥλҤꥹȥܥåλ
 *	ɥɥ򥯥åȡꥹȥܥå
 *	եꤵ롣ĤޤꡢϤƥꥹȥܥå롣
 *
 *---------------------------------------------------------------------------*/
/* ɥޥå
   ľλҤꥹȥܥåξ˸¤äơꥹȥܥå򥢥ƥ֤ˤ */
static	void	scrolled_window_event_button_on(Q8tkWidget *widget)
{
    if (widget->child && widget->child->type == Q8TK_TYPE_LISTBOX) {
	q8tk_widget_set_focus(widget->child);
    }
}
Q8tkWidget	*q8tk_scrolled_window_new(Q8tkWidget *hadjustment,
					  Q8tkWidget *vadjustment)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_SCROLLED_WINDOW;
    w->attr = Q8TK_ATTR_CONTAINER;
    w->sensitive = TRUE;

    w->stat.scrolled.width  = 10;
    w->stat.scrolled.height = 10;
    w->stat.scrolled.hpolicy = Q8TK_POLICY_ALWAYS;
    w->stat.scrolled.vpolicy = Q8TK_POLICY_ALWAYS;
    w->stat.scrolled.hscrollbar = TRUE;
    w->stat.scrolled.vscrollbar = TRUE;

    if (hadjustment)
	w->stat.scrolled.hadj = hadjustment;
    else {
	w->stat.scrolled.hadj = q8tk_adjustment_new(0, 0, 7, 1, 10);
	w->with_label = TRUE; 
    }
    q8tk_adjustment_set_arrow(w->stat.scrolled.hadj, TRUE);
    q8tk_adjustment_set_length(w->stat.scrolled.hadj, 7);
    w->stat.scrolled.hadj->stat.adj.horizontal = TRUE;
    w->stat.scrolled.hadj->parent = w;
    w->stat.scrolled.hadj->key_up_used    = FALSE;
    w->stat.scrolled.hadj->key_down_used  = FALSE;
    w->stat.scrolled.hadj->key_left_used  = TRUE;
    w->stat.scrolled.hadj->key_right_used = TRUE;

    if (vadjustment)
	w->stat.scrolled.vadj = vadjustment;
    else {
	w->stat.scrolled.vadj = q8tk_adjustment_new(0, 0, 7, 1, 10);
	w->with_label = TRUE;
    }
    q8tk_adjustment_set_arrow(w->stat.scrolled.vadj, TRUE);
    q8tk_adjustment_set_length(w->stat.scrolled.vadj, 7);
    w->stat.scrolled.vadj->stat.adj.horizontal = FALSE;
    w->stat.scrolled.vadj->parent = w;
    w->stat.scrolled.vadj->key_up_used    = TRUE;
    w->stat.scrolled.vadj->key_down_used  = TRUE;
    w->stat.scrolled.vadj->key_left_used  = FALSE;
    w->stat.scrolled.vadj->key_right_used = FALSE;

    w->event_button_on = scrolled_window_event_button_on;

    return w;
}
void		q8tk_scrolled_window_set_policy(Q8tkWidget *scrolledw,
						int hscrollbar_policy,
						int vscrollbar_policy)
{
    scrolledw->stat.scrolled.hpolicy = hscrollbar_policy;
    scrolledw->stat.scrolled.vpolicy = vscrollbar_policy;

    if        (scrolledw->stat.scrolled.hpolicy == Q8TK_POLICY_ALWAYS) {
	scrolledw->stat.scrolled.hscrollbar = TRUE;
    } else if (scrolledw->stat.scrolled.hpolicy == Q8TK_POLICY_NEVER)  {
	scrolledw->stat.scrolled.hscrollbar = FALSE;
    }

    if        (scrolledw->stat.scrolled.vpolicy == Q8TK_POLICY_ALWAYS) {
	scrolledw->stat.scrolled.vscrollbar = TRUE;
    } else if (scrolledw->stat.scrolled.vpolicy == Q8TK_POLICY_NEVER)  {
	scrolledw->stat.scrolled.vscrollbar = FALSE;
    }

    set_construct_flag(TRUE);
}
#if 0
void		q8tk_scrolled_window_set_width_height(Q8tkWidget *w, 
						      int width, int height)
{
    w->stat.scrolled.width  = width;
    w->stat.scrolled.height = height;

    set_construct_flag(TRUE);
}
#endif






/*---------------------------------------------------------------------------
 * ȥ꡼ (ENTRY)
 *---------------------------------------------------------------------------
 *  ʸϤǽâʸ ASCIIΤߡɽϴ
 *  ҤϻƤʤ
 *  ʥ
 *	"activate"	꥿󥭡Ϥäȯ
 *	"changed"	ʸϡʸäȯ
 *  ------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_entry_new(void)
 *	ȥϲǽʸ̵¡
 *
 *  Q8tkWidget	*q8tk_entry_new_with_max_length(int max)
 *	ȥ ϲǽʸϡmax ʸޤǡ(max==0̵)
 *
 *  void	q8tk_entry_set_text(Q8tkWidget *entry, const char *text)
 *	ȥˡʸ text ꤹ롣ʥȯʤ
 *	ɽȤʤꡢɽ֤ʸƬȤʤ롣
 *	åȤƥ֤Խǽʾ硢ʸü
 *	˰ư뤬ɽ褦ɽ֤Ѳ롣
 *
 *  void	q8tk_entry_set_position(Q8tkWidget *entry, int position)
 *	ȥʸΥ֤ position ꤹ롣
 *	position == -1 ξϡɽʤ
 *	position ʸξ硢ʸɽ롣
 *	ɽ硢뤬ɽ褦ɽ֤Ѳ롣
 *
 *  void	q8tk_entry_set_max_length(Q8tkWidget *entry, int max)
 *	ȥϲǽʸ max ѹ롣(max==0̵)
 *
 *  void	q8tk_entry_set_editable(Q8tkWidget *entry, int editable)
 *	ȥΰϲġԲĤꤹ롣 editable  ʤϲġ
 *
 *  void	q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
 *	ȥɽ width ꤹ롣 height ̵
 *	ɽ硢뤬ɽ褦ɽ֤Ѳ롣
 *  -------------------------------------------------------------------------
 *	ENTRY			ҤϻƤʤ
 *
 *---------------------------------------------------------------------------*/
/*
 * strlen()η̤ strsize Ǥ褦ʸ򥻥åȲǽʥ
 */
static	void	q8tk_entry_malloc(Q8tkWidget *entry, int strsize)
{
#if 0
	/* strsize  1Х;ʬ˳ ('\0' ʬ;ʬ) */
    int malloc_size = strsize + 1;
#else
	/* 1Хñ̤Ǥʤ512Хñ̤ǳݤ褦ˤƤߤ褦 */
    int malloc_size = (((strsize + 1)/512) +1) * 512;
#endif

    if (entry->name == NULL ||
	entry->stat.entry.malloc_length < malloc_size) {
	if (entry->name == NULL) {
	    entry->name = (char *)malloc(malloc_size);
	} else {
	    entry->name = (char *)realloc(entry->name, malloc_size);
	}

	Q8tkAssert(entry->name, "memory exhoused");

	entry->stat.entry.malloc_length = malloc_size;
    }
}

/* ȥޥå顢ư (ԽǽΤ) */
static	void	entry_event_button_on(Q8tkWidget *widget)
{
    int m_x = mouse.x / 8;

    if (widget->stat.entry.editable == FALSE) return;

    if (widget->stat.entry.cursor_pos < 0) {	/* ɽʤ       */
						/* ʸ˥ư */
	q8tk_entry_set_position(widget,
				q8gr_strlen(widget->code, widget->name));

    } else					/* ɽʤ     */
    {						/* ޥ֤˥ư */
	q8tk_entry_set_position(widget,		
				m_x - widget->x + widget->stat.entry.disp_pos);
    }
    set_construct_flag(TRUE);
}

/* 򲡤顢ư           (ԽǽΤ) */
/* ʸ򲡤顢ʸԽʥȯ (ԽǽΤ) */
/* ꥿򲡤顢ʥȯ               (ԽǽΤ) */
static	void	entry_event_key_on(Q8tkWidget *widget, int key)
{
    if (widget->stat.entry.editable == FALSE) return;
    if (widget->stat.entry.cursor_pos < 0) return;

    switch (key) {
    case Q8TK_KEY_LEFT:
	if (widget->stat.entry.cursor_pos) {
	    q8tk_entry_set_position(widget, widget->stat.entry.cursor_pos - 1);
	}
	break;

    case Q8TK_KEY_RIGHT:
	{
	    int w = 1;
	    if (q8gr_strchk(widget->code, widget->name, 
			    widget->stat.entry.cursor_pos) == 1) { w = 2; }
	    q8tk_entry_set_position(widget, widget->stat.entry.cursor_pos + w);
	}
	break;

    case Q8TK_KEY_UP:
    case Q8TK_KEY_DOWN:
#ifdef	OLD_FOCUS_CHANGE
	/* DO NOTHING */
#else	/* ʥեư */
	if (widget->stat.entry.combo) {
	    Q8List *l = widget->stat.entry.combo->stat.combo.list;
	    /* ܤ۲ˤ硢ǥܤΥꥹȤ귫 */
	    while (l) {
		if (strcmp(widget->name,
			   ((Q8tkWidget*)(l->data))->child->name) == 0) {
		    if (key == Q8TK_KEY_UP) l = l->prev;
		    else                    l = l->next;
		    if (l) {
			q8tk_entry_set_text(widget,
					((Q8tkWidget*)(l->data))->child->name);
			widget_signal_do(widget, "activate");
			return;
		    } else {
			break;
		    }
		}
		l = l->next;
	    }
	    /* 귫оݤʤСꥹȤƬ()򥻥å */
	    l = widget->stat.entry.combo->stat.combo.list;
	    if (l) {
		if (key == Q8TK_KEY_UP) l = q8_list_first(l);
		else                    l = q8_list_last(l);
		if (l) {
		    q8tk_entry_set_text(widget,
					((Q8tkWidget*)(l->data))->child->name);
		    widget_signal_do(widget, "activate");
		    return;
		}
	    }
	}
#endif
	if (key == Q8TK_KEY_UP)
	    q8tk_entry_set_position(widget, 0);
	else                   
	    q8tk_entry_set_position(widget,
				    q8gr_strlen(widget->code, widget->name));
	break;

    case Q8TK_KEY_PAGE_UP:
	q8tk_entry_set_position(widget, 0);
	break;

    case Q8TK_KEY_PAGE_DOWN:
	q8tk_entry_set_position(widget,
				q8gr_strlen(widget->code, widget->name));
	break;

    case Q8TK_KEY_RET:
	widget_signal_do(widget, "activate");
	break;

    case Q8TK_KEY_BS:
	if (widget->stat.entry.cursor_pos > 0) {
	    int w = q8gr_strdel(widget->code, widget->name,
				widget->stat.entry.cursor_pos - 1);
	    /* 1ʸʬ˰ư */
	    q8tk_entry_set_position(widget, widget->stat.entry.cursor_pos - w);
	    widget_signal_do(widget, "changed");
	}
	break;

    case Q8TK_KEY_DEL:
	if (widget->stat.entry.cursor_pos < (int)q8gr_strlen(widget->code,
							     widget->name)) {
	    q8gr_strdel(widget->code, widget->name,
			widget->stat.entry.cursor_pos);
	    /* ΰư */
	    set_construct_flag(TRUE);
	    widget_signal_do(widget, "changed");
	}
	break;

    default:
	if (key <= 0xff && isprint(key)) {
	    int len = (int)strlen(widget->name) + 1;	/* 1Хʸɲ */
	    if (widget->stat.entry.max_length &&	/* ʸ¥ */
		widget->stat.entry.max_length < len) {	/* Ķ̵   */
		;
	    } else {
		q8tk_entry_malloc(widget, len);	/* ꤬­ʤʤ */

		if (q8gr_stradd(widget->code, widget->name,
				widget->stat.entry.cursor_pos, key)) {
		    /* 1ʸʬ˰ư */
		    q8tk_entry_set_position(widget,
					    widget->stat.entry.cursor_pos + 1);
		    widget_signal_do(widget, "changed");
		}
	    }
	}
	break;
    }
}

Q8tkWidget	*q8tk_entry_new(void)
{
    return q8tk_entry_new_with_max_length(0);
}

Q8tkWidget	*q8tk_entry_new_with_max_length(int max)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_ENTRY;
    w->sensitive = TRUE;

    w->key_up_used    = TRUE;
    w->key_down_used  = TRUE;
    w->key_left_used  = TRUE;
    w->key_right_used = TRUE;

    q8tk_entry_malloc(w, max);

    w->name[0] = '\0';
    w->code = kanji_code;

    w->stat.entry.max_length    = max;
/*  w->stat.entry.malloc_length = q8tk_entry_malloc()ˤѤ */
    w->stat.entry.disp_pos      = 0;
    w->stat.entry.cursor_pos    = 0;
    w->stat.entry.width         = 8;
    w->stat.entry.editable      = TRUE;
    w->stat.entry.combo         = NULL;

    w->event_button_on = entry_event_button_on;
    w->event_key_on    = entry_event_key_on;

    return w;
}

const	char	*q8tk_entry_get_text(Q8tkWidget *entry)
{
    return entry->name;
}

void		q8tk_entry_set_text(Q8tkWidget *entry, const char *text)
{
    int len = strlen(text);

    if (entry->stat.entry.max_length == 0) {	/* ¤ʤ */

	q8tk_entry_malloc(entry, len);	/* ꤬­ʤʤ顢 */
	strcpy(entry->name, text);

    } else {					/* ¤ */

	q8gr_strncpy(entry->code,
		     entry->name, text, entry->stat.entry.max_length - 1);
	entry->name[ entry->stat.entry.max_length - 1 ] = '\0';

    }

    entry->stat.entry.disp_pos = 0;		/* ʸƬɽ */
    q8tk_entry_set_position(entry, -1);		/* ɽ     */
}

void		q8tk_entry_set_position(Q8tkWidget *entry, int position)
{
    int disp_pos;
    int tail = q8gr_strlen(entry->code, entry->name);

    if (position < 0) {
	entry->stat.entry.cursor_pos = -1;
	set_construct_flag(TRUE);
	return;
    }

    if (tail < position) position = tail;
    if (q8gr_strchk(entry->code, entry->name, position) == 2) {
	position -= 1;
    }

	/* ɽϰϤ˥륻å */
    if (position < entry->stat.entry.disp_pos) {

	entry->stat.entry.disp_pos   = position;
	entry->stat.entry.cursor_pos = position;

    }	/* ɽϰϤ˥륻å */
    else if (entry->stat.entry.disp_pos + entry->stat.entry.width <= position){

	disp_pos = position - entry->stat.entry.width + 1;
	if (q8gr_strchk(entry->code, entry->name, disp_pos) == 2) {
	    disp_pos += 1;
	}
	entry->stat.entry.disp_pos   = disp_pos;
	entry->stat.entry.cursor_pos = position;

    }	/* ɽϰϤ (ʸ2Х)˥륻å */
    else if ((entry->stat.entry.disp_pos + entry->stat.entry.width - 1
								== position) &&
	     q8gr_strchk(entry->code, entry->name, position) == 1) {

	disp_pos = entry->stat.entry.disp_pos +1;
	if (q8gr_strchk(entry->code, entry->name, disp_pos) == 2) {
	    disp_pos += 1;
	}
	entry->stat.entry.disp_pos   = disp_pos;
	entry->stat.entry.cursor_pos = position;
    
    }	/* ʳ (ɽϰ˥륻å) */
    else {

	entry->stat.entry.cursor_pos = position;

    }
    q8gr_set_cursor_blink();
    set_construct_flag(TRUE);
}

void		q8tk_entry_set_max_length(Q8tkWidget *entry, int max)
{
    q8tk_entry_malloc(entry, max);	/* ꤬­ʤʤ顢 */

    entry->stat.entry.max_length = max;
}

void		q8tk_entry_set_editable(Q8tkWidget *entry, int editable)
{
    if (entry->stat.entry.editable != editable) {
	entry->stat.entry.editable = editable;
	set_construct_flag(TRUE);
    }
}





/*---------------------------------------------------------------------------
 * 졼롼 (ACCEL GROUP)
 * 졼   (ACCEL KEY)
 *---------------------------------------------------------------------------
 *  ҤϻƤʤɽǤʤ
 *  Ūˤϡ졼롼פơ졼Ҥ
 *    ֤Ȥ
 *  졼롼פ򥦥ɥ˴ϢŤ뤳Ȥǡ졼
 *    򤽤Υɥˤͭˤ뤳ȤǤ롣
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_accel_group_new(void)
 *	졼롼פ
 *
 *  void	q8tk_accel_group_attach(Q8tkWidget *accel_group, 
 *					Q8tkWidget *window)
 *	졼롼פ򡢥ɥ window ˴ϢŤ롣
 *
 *  void	q8tk_accel_group_detach(Q8tkWidget *accel_group, 
 *					Q8tkWidget *window)
 *	ɥ window ˴ϢŤ졼롼פڤΥ
 *
 *  void	q8tk_accel_group_add(Q8tkWidget *accel_group, int accel_key,
 *				     Q8tkWidget *widget, const char *signal)
 *	졼ꤹ롣
 *	졼롼 accel_group ˡ accel_key ꤹ롣
 *	Υ줿顢 å widget  ʥ signal 롣
 *  -------------------------------------------------------------------------
 *	[WINDOW]
 *	   
 *	   ACCEL GROUPۢACCEL KEY
 *					
 *				  ACCEL KEY
 *					
 *				  ACCEL KEY
 *					
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_accel_group_new(void)
{
    Q8tkWidget *w;

    w = malloc_widget();
    w->type = Q8TK_TYPE_ACCEL_GROUP;
    w->sensitive = TRUE;

    return w;
}

void		q8tk_accel_group_attach(Q8tkWidget *accel_group,
					Q8tkWidget *window)
{
    Q8tkAssert(window->type == Q8TK_TYPE_WINDOW, NULL);
    window->stat.window.accel = accel_group;
}

void		q8tk_accel_group_detach(Q8tkWidget *accel_group,
					Q8tkWidget *window)
{
    Q8tkAssert(window->type == Q8TK_TYPE_WINDOW, NULL);

    if (window->stat.window.accel == accel_group) {
	window->stat.window.accel = NULL;
    }
}

void		q8tk_accel_group_add(Q8tkWidget *accel_group, int accel_key,
				     Q8tkWidget *widget, const char *signal)
{
    Q8tkWidget *w;
    w = malloc_widget();

    if (accel_group->child) {
	Q8tkWidget *c = accel_group->child;
	while (c->next) {
	    c = c->next;
	}
	c->next = w;
	w->prev = c;
	w->next = NULL;
    } else {
	accel_group->child = w;
	w->prev = NULL;
	w->next = NULL;
    }
    w->parent = accel_group;

    w->type = Q8TK_TYPE_ACCEL_KEY;
    w->sensitive = TRUE;
    w->name = (char *)malloc(strlen(signal) + 1);

    Q8tkAssert(w->name, "memory exhoused");

    strcpy(w->name, signal);
    w->code = Q8TK_KANJI_ANK;

    w->stat.accel.key    = accel_key;
    w->stat.accel.widget = widget;
}




/*---------------------------------------------------------------------------
 *  (DIALOG)
 *---------------------------------------------------------------------------
 *  ɥ򳫤
 *		+-------------------+
 *		| WARING !          |
 *		| Quit, really?     |ʬϡvbox (ľܥå)
 *		| press button.     |
 *		| +------+ +------+ |
 *		| |  OK  | |CANCEL| |
 *		| +------+ +------+ |
 *		+-------------------+
 *		   ʬ  
 *		     action_area (ʿܥå)
 *  ϡ vbox  action_area ǤդΥåȤ
 *    Ǥ롣q8tk_box_pack_start() / end() ˤꤹ롣
 *  Υɥϥ⡼쥹ʤΤա
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_dialog_new(void)
 *	
 *
 *	 vbox ˥åȤɲä㡣
 *		d = q8tk_dialog_new();
 *		q8tk_box_pack_start(Q8TK_DIALOGE(d)->vbox, label);
 *
 *	 action_area ˥åȤɲä㡣
 *		d = q8tk_dialog_new();
 *		q8tk_box_pack_start(Q8TK_DIALOGE(d)->action_area, button);
 *  -------------------------------------------------------------------------
 *	    ġĢDIALOG
 *	    
 *	WINDOWۢFRAMEۢVBOXۢVBOX(vbox)
 *			 	                    
 *				             HBOX(action_area)
 *
 *	q8tk_dialog_new()֤ͤ WINDOW ΥåȤǤ롣
 *	⡼ˤϡΥåȤ q8tk_grab_add() 롣
 *
 *	vboxaction_area ϥ桼Ǥդ˥åȤɲäǤ롣
 *
 *	q8tk_widget_destroy() κݤϡƤΥåȤ뤬
 *	桼 vboxaction_area ɲäåȤϺʤ
 *
 *---------------------------------------------------------------------------*/
Q8tkWidget	*q8tk_dialog_new(void)
{
    Q8tkWidget *dialog, *window, *vbox, *frame;

    dialog = malloc_widget();
    dialog->type = Q8TK_TYPE_DIALOG;
    dialog->sensitive = TRUE;

    window = q8tk_window_new(Q8TK_WINDOW_DIALOG);
    window->stat.window.work = dialog;

    frame = q8tk_frame_new("");
    q8tk_container_add(window, frame);
    q8tk_widget_show(frame);
    q8tk_frame_set_shadow_type(frame, Q8TK_SHADOW_NONE);

    vbox = q8tk_vbox_new();
    q8tk_container_add(frame, vbox);
    q8tk_widget_show(vbox);

    dialog->stat.dialog.vbox = q8tk_vbox_new();
    q8tk_box_pack_start(vbox, dialog->stat.dialog.vbox);
    q8tk_widget_show(dialog->stat.dialog.vbox);

    dialog->stat.dialog.action_area = q8tk_hbox_new();
    q8tk_box_pack_start(vbox, dialog->stat.dialog.action_area);
    q8tk_widget_show(dialog->stat.dialog.action_area);

    return window;
}




/*---------------------------------------------------------------------------
 * FILE SELECTION
 *---------------------------------------------------------------------------
 *  åȤȤ߹碌ơե륻쥯Ф
 *  ե̾Ĺϡѥޤƺ
 *    Q8TK_MAX_FILENAME ޤǤǤ롣(ʸü\0ޤ)
 *  ե̾ΰϡƥ¸ؿˤƽ롣
 *  -------------------------------------------------------------------------
 *  Q8tkWidget	*q8tk_file_selection_new(const char *title, int select_ro)
 *	ե륻쥯
 *	ФɽѤʸ title ꤹ롣
 *	select_ro  1 ʤ顢Read Onlyץåܥɽ졢å
 *	롣0 ʤ顢Read Onlyץåܥɽ뤬å
 *	ʤ-1 ʤ顢Read Onlyץåܥɽʤ
 *	 (å줿ɤϡ q8tk_file_selection_get_readonly ˤ
 *	  ǤΤǡƤӽФǥ꡼ɥ꡼ǳɤꤹ)
 *
 *  const char	*q8tk_file_selection_get_filename(Q8tkWidget *fselect)
 *	()Ƥե̾롣
 *
 *  void	q8tk_file_selection_set_filename(Q8tkWidget *fselect,
 *						 const char *filename)
 *	ե̾ (ǥ쥯ȥ̾Ǥ) ꤹ롣
 *
 *  int		q8tk_file_selection_get_readonly(Q8tkWidget *fselect)
 *	 ʤ顢֥꡼ɥ꡼ǳפåƤ롣
 *  -------------------------------------------------------------------------
 *	    ġĢFILE SELECTION
 *	    
 *	WINDOWۢ
 *	
 *	VBOXۢLABEL	q8tk_file_selection_new()ΰ
 *			  
 *		      HSEPARATOR
 *			  
 *		      LABEL	ǥ쥯ȥ̾
 *			  
 *		      HBOXۢLABEL ()
 *			  	      
 *			  á    SCROLLED WINDOWۢLIST BOXۢ(A)
 *			  á	          á
 *			  á	      á    è  ADJUSTMENT
 *			  á	      á      ADJUSTMENT
 *			  á	      â
 *			  á    LABEL ()
 *			  á	      
 *			  á    VBOXۢLABEL ()
 *			  á			  
 *			  á		      LABEL ե
 *			  á			  
 *			  á		      LABEL (ޡ4)
 *			  á			  
 *			  á		      BUTTONۢLABEL
 *			  á			  		(view_button)
 *			  á			  â
 *			  á		      LABEL (ޡ2)
 *			  á			  
 *			  á		      CHECK BUTTONۢLABEL
 *			  á			  		      Read only
 *			  á			  â
 *			  á		      BUTTONۢLABEL
 *			  á			  		(ok_button)
 *			  á			  â
 *			  á		      BUTTONۢLABEL
 *			  á					(cancel_button)
 *			  â
 *		      LABEL	()
 *			  
 *		      HBOXۢLABEL	Filename(Ф)
 *				      
 *				  ENTRY	ե̾
 *
 *	q8tk_file_selection_new() ֤ͤ WINDOW ΥåȤǤ롣
 *	⡼ˤϡΥåȤ q8tk_grab_add() 롣
 *
 *	cancel_buttonok_button ϥ桼Ǥդ˥ʥǤ롣
 *
 *		fsel = q8tk_file_selection_new();
 *		q8tk_widget_show(fsel);
 *		q8tk_grab_add(fsel);
 *		q8tk_signal_connect(Q8TK_FILE_SELECTION(fsel)->ok_button,
 *		 		    "clicked", 桼ؿ桼);
 *		q8tk_signal_connect(Q8TK_FILE_SELECTION(fsel)->cancel_button,
 *		 		    "clicked", 桼ؿ桼);
 *
 *	---------------------------------------------------------------------
 *		(A)  LIST ITEMۢLABEL
 *		     	   
 *		       LIST ITEMۢLABEL
 *		     	   
 *		       LIST ITEMۢLABEL
 *		     	   
 *
 *	q8tk_file_selection_set_filename() ˤƥǥ쥯ȥ̾򥻥åȤȡ
 *	Υǥ쥯ȥΥե(νϥƥ¸)
 *	ƤΥե̾ꥹȥƥˤơꥹȥܥå˾褻롣
 *	ե̾򥻥åȤ⡢ǥ쥯ȥ̾ڤФ
 *	(ν⥷ƥ¸)Ʊͤ˥ǥ쥯ȥΥե
 *	롣ξ硢ȥˤե̾򥻥åȤ롣
 *
 *	---------------------------------------------------------------------
 *	ʲξ硢ok_button  "clicked" ʥ뤬ȯ롣
 *		OK Υܥ򥯥å
 *		ե̾ΥꥹȥƥΡƥ֤ʤΤ򥯥å
 *		  줬ǥ쥯ȥǤʤä硣
 *		ȥˤϤƥ꥿󥭡򲡲
 *		  줬ǥ쥯ȥǤʤä硣
 *
 *	Ĥޤꡢok_button  "clicked" ʥꤷƤС
 *	Ūˤե()ΤǤ롣
 *
 *	---------------------------------------------------------------------
 *	q8tk_widget_destroy() κݤϡ٤ƤΥåȤ˲롣
 *	( LIST ITEM åȤޤ)
 *
 *---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
 *	ʲδؿΰ fselect  q8tk_file_selection_new() ͤΡ
 *	ɥåȤǤ롣ե륻쥯󥦥åȤѿ
 *	(fselect->stat.fselect.ѿ̾) ˥ˤϡʲΤ褦ˤ롣
 *	Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)->ѿ̾
 *---------------------------------------------------------------------------*/

/* ե륻쥯ΥꥹȥܥåΥꥹȥƥबå줿

   ľ򤷤ƤꥹȥܥåȰ㤦Τå줿
	fsel_list_selection_changed() ("selection_changed"٥Ȥˤ)
	fsel_item_selected()          ("select"           ٥Ȥˤ)
     ν˸ƤӽФ롣

   ľ򤷤ƤꥹȥܥåƱΤå줿
	fsel_item_selected()          ("select"           ٥Ȥˤ)
     ƤӽФ롣 ("selection_changed" ٥ȤȯʤΤ)     */


static void fsel_update(Q8tkWidget *fselect, const char *filename, int type);
static int fsel_opendir(Q8tkWidget *fselect, const char *filename, int type);


/* ե̾ LIST BOX ˤơΥե뤬ѤäΥХå */
static void fsel_selection_changed_callback(UNUSED_WIDGET, void *fselect)
{
    Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)->selection_changed = TRUE;
}


/* ե̾ LIST ITEM ˤơ åΥХå */
static void fsel_selected_callback(Q8tkWidget *item, void *fselect)
{
    const char *name;
    if      (item->name)                       name = item->name;
    else if (item->child && item->child->name) name = item->child->name;
    else                                       name = "";


    if (Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)->selection_changed) {

	/* ľ fsel_selection_changed_callback() ƤӽФƤ硢
	   ĤޤȤϰ㤦٥ꥹȥƥबå줿ϡ
	   Υꥹȥƥݻե̾򡢥ȥ˥åȤ */

	Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)->selection_changed = FALSE;

	q8tk_entry_set_text(Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)
						      ->selection_entry, name);

    } else {

	/*  fsel_selected_callback() ƤӽФ줿硢
	   ĤޤƱ٥ꥹȥƥबå줿ϡ
	   Υꥹȥƥݻե̾ǡե */

	fsel_update((Q8tkWidget*)fselect, name, item->stat.any.data[0]);
    }
}


/* ե̾Ϥ ENTRY ˤơ꥿󥭡ΥХå */
static void fsel_activate_callback(Q8tkWidget *entry, void *fselect)
{
    const char *input_filename = q8tk_entry_get_text(entry);
    int   type = -1;	/* ǥ쥯ȥ꤫ɤ */

    /* Ϥե̾ꥹȤ name ˰פС
       ե륿פꤹ뤳ȤǤ롣
       (ƳꤵɬפϤʤΤǡŬ˰ץå) */

    Q8tkWidget *match_list;
    match_list = q8tk_listbox_search_items(
			 Q8TK_FILE_SELECTION((Q8tkWidget*)fselect)->file_list,
			 input_filename);

    if (match_list) type = match_list->stat.any.data[0];


    /* Ϥե̾ǡե */
    fsel_update((Q8tkWidget*)fselect, input_filename, type);
}


/* ե LIST BOX 򹹿롣 ǥ쥯ȥ̾ʤɽ
   ե̾ꤷϡOK ܥ򲡤Ȥˤ */
static void fsel_update(Q8tkWidget *fselect, const char *filename, int type)
{
    char wk[ Q8TK_MAX_FILENAME ];

    if (osd_path_join(Q8TK_FILE_SELECTION(fselect)->pathname, filename,
		      wk, Q8TK_MAX_FILENAME) == FALSE) {
	strcpy(wk, "");
    }

    if (fsel_opendir(fselect, wk, type) != FILE_STAT_DIR) {
	widget_signal_do(Q8TK_FILE_SELECTION(fselect)->ok_button, "clicked");
    }
}


/* ꤵ줿ѥ̾򡢥ǥ쥯ȥ̾ȥե̾ʬ ǥ쥯ȥ򳫤
   ꥹȤ˥ե򥻥åȡ ե̾򥨥ȥ˥åȤ */
static int fsel_opendir_sub(Q8tkWidget *fselect, const char *dirname);
static int fsel_opendir(Q8tkWidget *fselect, const char *filename, int type)
{
    int save_code = q8tk_set_kanjicode(osd_kanji_code());

    char path[ Q8TK_MAX_FILENAME ];
    char dir [ Q8TK_MAX_FILENAME ];
    char file[ Q8TK_MAX_FILENAME ];


    if (filename == NULL || filename[0] == '\0') { /* filename̵ʾ */
	filename = osd_dir_cwd();		   /* ȥǥ쥯ȥ */
	type = FILE_STAT_DIR;			   /* ˻ȤȤˤ */
    }

    if (osd_path_normalize(filename, path, Q8TK_MAX_FILENAME)	/*  */
							== FALSE) {
	strcpy(path, "");
	type = FILE_STAT_DIR;
    }


		/* filename ǥ쥯ȥ̾ȥե̾ʬΥ */

    if (type < 0) {				/* ǥ쥯ȥ꤫ɤ */
	type = osd_file_stat(path);		/* ʤ顢ޤ°   */
    }

    if (type == FILE_STAT_DIR) {		/* filename ϥǥ쥯ȥ */
	strcpy(dir,  path);
	strcpy(file, "");				/* ե̾϶ */

    } else {					/* filename ϥե餷 */
						/* ǥ쥯ȥ̾ʬΥ  */
	if (osd_path_split(path, dir, file, Q8TK_MAX_FILENAME) == FALSE) {
	    strcpy(dir,  "");				/* Ԥ     */
	    strcpy(file, path);				/* Ŭˤޤ */
	}
    }

		/* ǥ쥯ȥ̾ǥǥ쥯ȥ򳫤 */

    if (fsel_opendir_sub(fselect, dir) >= 0) {		/* Τ */

	Q8TK_FILE_SELECTION(fselect)->pathname[0] = '\0';
	strncat(Q8TK_FILE_SELECTION(fselect)->pathname, dir,
		Q8TK_MAX_FILENAME-1);

	q8tk_entry_set_text(Q8TK_FILE_SELECTION(fselect)->selection_entry,
			    file);
    } else {						/* ʤäġ */

	q8tk_entry_set_text(Q8TK_FILE_SELECTION(fselect)->selection_entry,
			    path);
    }


    q8tk_set_kanjicode(save_code);

		/* ꤵ줿ѥ̾ǥ쥯ȥäɤ֤ */
    return type;
}


static	int	fsel_opendir_sub(Q8tkWidget *fselect, const char *dirname)
{
    T_DIR_INFO	*dirp;
    T_DIR_ENTRY	*dirent;
    char	wk[ Q8TK_MAX_FILENAME ];
    int		nr, i, width;
    char	old_path[ Q8TK_MAX_FILENAME ];
    char	*old_dirname = NULL;

		/* ¸ LIST ITEM  */

    if (Q8TK_FILE_SELECTION(fselect)->file_list->child) {
	q8tk_listbox_clear_items(Q8TK_FILE_SELECTION(fselect)->file_list,0,-1);
    }
    q8tk_adjustment_set_value(Q8TK_FILE_SELECTION(fselect)->scrolled_window
						      ->stat.scrolled.hadj, 0);
    q8tk_adjustment_set_value(Q8TK_FILE_SELECTION(fselect)->scrolled_window
						      ->stat.scrolled.vadj, 0);


		/* ǥ쥯ȥĴ١ե̾ LIST ITEM ȤϿ */
		/* ǽʥե̾ʻ LIST ITEM ݻƤ */
		/* ĤǤʤΤǡեΥפ LIST ITEM ݻƤ */

    if (dirname[0] != '\0' &&
	(dirp = osd_opendir(dirname))) {

	/* ѥ̥̾ѥȥǥ쥯ȥ̾ʬΥ롣
	   ξ̥ѥ̾ȡΥѥ̾פС
	   ʬΥǥ쥯ȥ̾ФƤ */
	if (Q8TK_FILE_SELECTION(fselect)->pathname[0] != '\0' &&
	    osd_path_split(Q8TK_FILE_SELECTION(fselect)->pathname,
			   wk,
			   old_path,
			   Q8TK_MAX_FILENAME)) {
	    if (strcmp(wk, dirname) == 0) {
		old_dirname = old_path;
	    }
	}

	nr = 0;
	while ((dirent = osd_readdir(dirp))) {
	    Q8tkWidget *item;

	    wk[0] = '\0';
	    strncat(wk, dirent->str, Q8TK_MAX_FILENAME-1);

	    item = q8tk_list_item_new_with_label(wk);
	    q8tk_list_item_set_string(item, dirent->name);
	    item->stat.any.data[0] = dirent->type;
	    q8tk_container_add(Q8TK_FILE_SELECTION(fselect)->file_list, item);
	    q8tk_widget_show(item);

	    /* Фǥ쥯ȥ̾˰פ륢ƥबСƥ֤ */
	    if (old_dirname && (strcmp(old_dirname, dirent->name) == 0)) {
		q8tk_listbox_select_child(
				Q8TK_FILE_SELECTION(fselect)->file_list, item);
		old_dirname = NULL;
	    }

	    q8tk_signal_connect(item, "select",
				fsel_selected_callback, fselect);
	    nr ++;
	}
	osd_closedir(dirp);


	i = strlen(dirname);
	width = Q8TK_FILE_SELECTION(fselect)->width;
	if (i + 6 > width) {			/* 6 == sizeof("DIR = ") */
	    i = i - (width - 6 -3);		/* 3 == sizeof("...")    */
	    if (q8gr_strchk(Q8TK_FILE_SELECTION(fselect)->dir_name->code, 
			    dirname, i) == 2) { i ++; }	/* 򤱤*/
	} else {
	    i = 0;
	}
	wk[0] = '\0';
	strncat(wk, "DIR = ", Q8TK_MAX_FILENAME-1);
	if (i) {
	    strncat(wk, "...", Q8TK_MAX_FILENAME-1 -strlen(wk));
	}
	strncat(wk, &dirname[i], Q8TK_MAX_FILENAME-1 -strlen(wk));


    } else {

	nr = -1;

	wk[0] = '\0';
	strncat(wk, "DIR = non existant", Q8TK_MAX_FILENAME-1);

    }

    q8tk_label_set(Q8TK_FILE_SELECTION(fselect)->dir_name, wk);

    sprintf(wk, "%4d file(s)", (nr < 0) ? 0 : nr);
    q8tk_label_set(Q8TK_FILE_SELECTION(fselect)->nr_files, wk);


    return nr;
}




static void fsel_selection_view_callback(UNUSED_WIDGET, void *fselect)
{
    q8tk_utility_view(q8tk_file_selection_get_filename(fselect));
}



#if 0	/* ver 0.5.x ޤǤɽ */

Q8tkWidget	*q8tk_file_selection_new(const char *title, int select_ro)
{
    Q8tkWidget *fselect, *window, *vbox, *wk;
    int save_code;

    fselect = malloc_widget();
    fselect->type = Q8TK_TYPE_FILE_SELECTION;
    fselect->sensitive = TRUE;

    fselect->stat.fselect.pathname = (char *)calloc(Q8TK_MAX_FILENAME, 1);
    fselect->stat.fselect.filename = (char *)calloc(Q8TK_MAX_FILENAME, 1);
    Q8tkAssert(fselect->stat.fselect.pathname, "memory exhoused");
    Q8tkAssert(fselect->stat.fselect.filename, "memory exhoused");

    window = q8tk_window_new(Q8TK_WINDOW_DIALOG);	/* ɥ */
    window->stat.window.work = fselect;

    vbox = q8tk_vbox_new();				/* ʲ ľ˵ͤ */
    q8tk_container_add(window, vbox);
    q8tk_widget_show(vbox);

    wk = q8tk_label_new(title);				/* Ф() */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
    q8tk_misc_set_placement(wk, Q8TK_PLACEMENT_X_CENTER, Q8TK_PLACEMENT_Y_TOP);
    fselect->stat.fselect.width = MAX(q8gr_strlen(wk->code, wk->name),
				      Q8GR_SCREEN_X * 0.5);
  
    wk = q8tk_hseparator_new();				/* ---------------- */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
							/* DIR = /...       */
    fselect->stat.fselect.dir_name = q8tk_label_new("DIR =");
    q8tk_box_pack_start(vbox, fselect->stat.fselect.dir_name);
    q8tk_widget_show(fselect->stat.fselect.dir_name);
    q8tk_misc_set_placement(fselect->stat.fselect.dir_name,
			    Q8TK_PLACEMENT_X_LEFT, Q8TK_PLACEMENT_Y_TOP);

							/*     99 file(s)   */
    fselect->stat.fselect.nr_files = q8tk_label_new("0 file(s)");
    q8tk_box_pack_start(vbox, fselect->stat.fselect.nr_files);
    q8tk_widget_show(fselect->stat.fselect.nr_files);
    q8tk_misc_set_placement(fselect->stat.fselect.nr_files,
			    Q8TK_PLACEMENT_X_CENTER, Q8TK_PLACEMENT_Y_TOP);

							/* [ꥹȥܥå] */
    fselect->stat.fselect.scrolled_window=q8tk_scrolled_window_new(NULL, NULL);
    q8tk_box_pack_start(vbox, fselect->stat.fselect.scrolled_window);
    q8tk_widget_show(fselect->stat.fselect.scrolled_window);

    fselect->stat.fselect.file_list = q8tk_listbox_new();
    q8tk_container_add(fselect->stat.fselect.scrolled_window,
		       fselect->stat.fselect.file_list);
    q8tk_widget_show(fselect->stat.fselect.file_list);
    q8tk_signal_connect(fselect->stat.fselect.file_list, "selection_changed",
			fsel_selection_changed_callback, window);

    q8tk_misc_set_placement(fselect->stat.fselect.scrolled_window,
			    Q8TK_PLACEMENT_X_CENTER, Q8TK_PLACEMENT_Y_CENTER);
    q8tk_scrolled_window_set_policy(fselect->stat.fselect.scrolled_window,
				    Q8TK_POLICY_AUTOMATIC, Q8TK_POLICY_ALWAYS);
    q8tk_misc_set_size(fselect->stat.fselect.scrolled_window, 40, 14);
    q8tk_misc_set_size(fselect->stat.fselect.file_list, 40-3, 0);
    q8tk_listbox_set_placement(fselect->stat.fselect.file_list, -2, +1);

							/* File name:       */
    wk = q8tk_label_new("File name:");
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
    q8tk_misc_set_placement(wk, Q8TK_PLACEMENT_X_LEFT, Q8TK_PLACEMENT_Y_TOP);

							/* [ȥ]     */
    save_code = q8tk_set_kanjicode(osd_kanji_code());
    fselect->stat.fselect.selection_entry = q8tk_entry_new();
    q8tk_box_pack_start(vbox, fselect->stat.fselect.selection_entry);
    q8tk_widget_show(fselect->stat.fselect.selection_entry);
    q8tk_misc_set_size(fselect->stat.fselect.selection_entry,
		       fselect->stat.fselect.width, 0);
    q8tk_signal_connect(fselect->stat.fselect.selection_entry, "activate",
			fsel_activate_callback, window);
    q8tk_set_kanjicode(save_code);

    wk = q8tk_hbox_new();				/*     [OK][CANCEL] */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
    q8tk_misc_set_placement(wk, Q8TK_PLACEMENT_X_RIGHT, Q8TK_PLACEMENT_Y_TOP);

    fselect->stat.fselect.ro_button =
				q8tk_check_button_new_with_label("Read only");
    q8tk_box_pack_start(wk, fselect->stat.fselect.ro_button);
    if (select_ro >= 0) {
	if (select_ro > 0) {
	    q8tk_toggle_button_set_state(fselect->stat.fselect.ro_button,TRUE);
	}
	q8tk_widget_show(fselect->stat.fselect.ro_button);
    }
    q8tk_misc_set_placement(fselect->stat.fselect.ro_button,
			    Q8TK_PLACEMENT_X_CENTER, Q8TK_PLACEMENT_Y_CENTER);

    fselect->stat.fselect.ok_button = q8tk_button_new_with_label("  OK  ");
    q8tk_box_pack_start(wk, fselect->stat.fselect.ok_button);
    q8tk_widget_show(fselect->stat.fselect.ok_button);

    fselect->stat.fselect.cancel_button = q8tk_button_new_with_label("CANCEL");
    q8tk_box_pack_start(wk, fselect->stat.fselect.cancel_button);
    q8tk_widget_show(fselect->stat.fselect.cancel_button);

/*  q8tk_file_selection_set_filename(window, Q8TK_FILE_SELECTION(fselect)->pathname);*/

    return window;
}

#else	/* ver 0.6.0 ʹߤɽ */

Q8tkWidget	*q8tk_file_selection_new(const char *title, int select_ro)
{
    Q8tkWidget *fselect, *window, *vbox, *hbox, *vv, *wk;
    int i, save_code;

    fselect = malloc_widget();
    fselect->type = Q8TK_TYPE_FILE_SELECTION;
    fselect->sensitive = TRUE;

    fselect->stat.fselect.pathname = (char *)calloc(Q8TK_MAX_FILENAME, 1);
    fselect->stat.fselect.filename = (char *)calloc(Q8TK_MAX_FILENAME, 1);
    Q8tkAssert(fselect->stat.fselect.pathname, "memory exhoused");
    Q8tkAssert(fselect->stat.fselect.filename, "memory exhoused");

    window = q8tk_window_new(Q8TK_WINDOW_DIALOG);	/* ɥ */
    window->stat.window.work = fselect;

    vbox = q8tk_vbox_new();				/* ʲ ľ˵ͤ */
    q8tk_container_add(window, vbox);
    q8tk_widget_show(vbox);

    wk = q8tk_label_new(title);				/* Ф() */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
    q8tk_misc_set_placement(wk, Q8TK_PLACEMENT_X_CENTER, Q8TK_PLACEMENT_Y_TOP);
    fselect->stat.fselect.width = MAX(q8gr_strlen(wk->code, wk->name), 60);
  
    wk = q8tk_hseparator_new();				/* ---------------- */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);
							/* DIR = /...       */
    fselect->stat.fselect.dir_name = q8tk_label_new("DIR =");
    q8tk_box_pack_start(vbox, fselect->stat.fselect.dir_name);
    q8tk_widget_show(fselect->stat.fselect.dir_name);
    q8tk_misc_set_placement(fselect->stat.fselect.dir_name,
			    Q8TK_PLACEMENT_X_LEFT, Q8TK_PLACEMENT_Y_TOP);

    hbox = q8tk_hbox_new();
    q8tk_box_pack_start(vbox, hbox);
    q8tk_widget_show(hbox);
    {
	wk = q8tk_label_new("    ");				/*  */
	q8tk_box_pack_start(hbox, wk);
	q8tk_widget_show(wk);

								/* [ꥹ] */
	fselect->stat.fselect.scrolled_window
					= q8tk_scrolled_window_new(NULL, NULL);
	q8tk_box_pack_start(hbox, fselect->stat.fselect.scrolled_window);
	q8tk_widget_show(fselect->stat.fselect.scrolled_window);

	fselect->stat.fselect.file_list = q8tk_listbox_new();
	q8tk_container_add(fselect->stat.fselect.scrolled_window,
			   fselect->stat.fselect.file_list);
	q8tk_widget_show(fselect->stat.fselect.file_list);
	q8tk_signal_connect(fselect->stat.fselect.file_list,
			    "selection_changed",
			    fsel_selection_changed_callback, window);

	q8tk_misc_set_placement(fselect->stat.fselect.scrolled_window,
				Q8TK_PLACEMENT_X_CENTER,
				Q8TK_PLACEMENT_Y_CENTER);
	q8tk_scrolled_window_set_policy(fselect->stat.fselect.scrolled_window,
					Q8TK_POLICY_AUTOMATIC,
					Q8TK_POLICY_ALWAYS);
	q8tk_misc_set_size(fselect->stat.fselect.scrolled_window, 40, 18);
	q8tk_misc_set_size(fselect->stat.fselect.file_list, 40-3, 0);
	q8tk_listbox_set_placement(fselect->stat.fselect.file_list, -2, +1);


	wk = q8tk_label_new("  ");				/*  */
	q8tk_box_pack_start(hbox, wk);
	q8tk_widget_show(wk);


	vv = q8tk_vbox_new();
	q8tk_box_pack_start(hbox, vv);
	q8tk_widget_show(vv);
	{

	    wk = q8tk_label_new("");				/*  */
	    q8tk_box_pack_start(vv, wk);
	    q8tk_widget_show(wk);

								/* n file(s) */
	    fselect->stat.fselect.nr_files = q8tk_label_new("0000 file(s)");
	    q8tk_box_pack_start(vv, fselect->stat.fselect.nr_files);
	    q8tk_widget_show(fselect->stat.fselect.nr_files);
	    q8tk_misc_set_placement(fselect->stat.fselect.nr_files,
				    Q8TK_PLACEMENT_X_CENTER,
				    Q8TK_PLACEMENT_Y_CENTER);
#if 0
	    for (i=0; i<9; i++) {				/*  */
		wk = q8tk_label_new("");
		q8tk_box_pack_start(vv, wk);
		q8tk_widget_show(wk);
	    }
#else
	    for (i=0; i<4; i++) {				/*  */
		wk = q8tk_label_new("");
		q8tk_box_pack_start(vv, wk);
		q8tk_widget_show(wk);
	    }
								/* [VIEW] */
	    fselect->stat.fselect.view_button =
					q8tk_button_new_with_label(" VIEW ");
	    q8tk_box_pack_start(vv, fselect->stat.fselect.view_button);
	    q8tk_widget_show(fselect->stat.fselect.view_button);
	    q8tk_misc_set_placement(fselect->stat.fselect.view_button,
				    Q8TK_PLACEMENT_X_CENTER,
				    Q8TK_PLACEMENT_Y_CENTER);
	    q8tk_signal_connect(fselect->stat.fselect.view_button,  "clicked",
				fsel_selection_view_callback, window);

	    for (i=0; i<2; i++) {				/*  */
		wk = q8tk_label_new("");
		q8tk_box_pack_start(vv, wk);
		q8tk_widget_show(wk);
	    }
#endif

								/* Read only */
	    fselect->stat.fselect.ro_button =
				q8tk_check_button_new_with_label("Read only");
	    q8tk_box_pack_start(vv, fselect->stat.fselect.ro_button);
	    q8tk_misc_set_placement(fselect->stat.fselect.ro_button,
				    Q8TK_PLACEMENT_X_CENTER,
				    Q8TK_PLACEMENT_Y_CENTER);
	    if (select_ro >= 0) {
		if (select_ro > 0) {
		    q8tk_toggle_button_set_state(
					fselect->stat.fselect.ro_button, TRUE);
		}
		q8tk_widget_show(fselect->stat.fselect.ro_button);
	    }

								/* [OK] */
	    fselect->stat.fselect.ok_button = 
					q8tk_button_new_with_label("  OK  ");
	    q8tk_box_pack_start(vv, fselect->stat.fselect.ok_button);
	    q8tk_widget_show(fselect->stat.fselect.ok_button);
	    q8tk_misc_set_placement(fselect->stat.fselect.ok_button,
				    Q8TK_PLACEMENT_X_CENTER,
				    Q8TK_PLACEMENT_Y_CENTER);

								/* [CANCEL] */
	    fselect->stat.fselect.cancel_button =
					q8tk_button_new_with_label("CANCEL");
	    q8tk_box_pack_start(vv, fselect->stat.fselect.cancel_button);
	    q8tk_widget_show(fselect->stat.fselect.cancel_button);
	    q8tk_misc_set_placement(fselect->stat.fselect.cancel_button,
				    Q8TK_PLACEMENT_X_CENTER,
				    Q8TK_PLACEMENT_Y_CENTER);
	}

#if 0
	wk = q8tk_label_new(" ");				/*  */
	q8tk_box_pack_start(hbox, wk);
	q8tk_widget_show(wk);
#endif
    }


    wk = q8tk_label_new("");				/*  */
    q8tk_box_pack_start(vbox, wk);
    q8tk_widget_show(wk);

    hbox = q8tk_hbox_new();
    q8tk_box_pack_start(vbox, hbox);
    q8tk_widget_show(hbox);
    {
							/* File name:       */
	wk = q8tk_label_new("Filename ");
	q8tk_box_pack_start(hbox, wk);
	q8tk_widget_show(wk);

							/* [ȥ]     */
	save_code = q8tk_set_kanjicode(osd_kanji_code());
	fselect->stat.fselect.selection_entry = q8tk_entry_new();
	q8tk_box_pack_start(hbox, fselect->stat.fselect.selection_entry);
	q8tk_widget_show(fselect->stat.fselect.selection_entry);
	q8tk_misc_set_size(fselect->stat.fselect.selection_entry, 50, 0);
	q8tk_signal_connect(fselect->stat.fselect.selection_entry, "activate",
			    fsel_activate_callback, window);
	q8tk_set_kanjicode(save_code);
    }

/*  q8tk_file_selection_set_filename(window, Q8TK_FILE_SELECTION(fselect)->pathname);*/

    return window;
}

#endif

const	char	*q8tk_file_selection_get_filename(Q8tkWidget *fselect)
{
    if (osd_path_join(Q8TK_FILE_SELECTION(fselect)->pathname,
		      q8tk_entry_get_text(Q8TK_FILE_SELECTION(fselect)
							->selection_entry),
		      Q8TK_FILE_SELECTION(fselect)->filename,
		      Q8TK_MAX_FILENAME)
	== FALSE) {
	return "";
    }

    return Q8TK_FILE_SELECTION(fselect)->filename;
}

void		q8tk_file_selection_set_filename(Q8tkWidget *fselect,
						 const char *filename)
{
    fsel_opendir(fselect, filename, -1);
}

int		q8tk_file_selection_get_readonly(Q8tkWidget *fselect)
{
    return Q8TK_TOGGLE_BUTTON(Q8TK_FILE_SELECTION(fselect)->ro_button)->active;
}




/*---------------------------------------------------------------------------
 * FILE VIEWER
 *---------------------------------------------------------------------------
 *  ǺäեäȤߤ桼ƥƥ
 *  ƥȥեȽǤϡĥҤΤ
 *    SJIS  EUC  UTF8 ۣȽ
 *  ΤˤȤΤȤ褦ġġ
 *    Ȥ褬褯ʤ뵤ۤʤоäġġ
 *  ʤߤ˥åȤǤϤʤʤեɽ롣
 *---------------------------------------------------------------------------*/
#define	VIEW_MAX_LINE	(1000)				/* 1000Ԥɽ */
#define	VIEW_MAX_COLUMN	(80)				/* 80ʹߤɽ */
static	Q8tkWidget	*view_widget_win;
static	Q8tkWidget	*view_widget_vbox;
static	Q8tkWidget	*view_widget_swin;
static	Q8tkWidget	*view_widget_board;
static	Q8tkWidget	*view_widget_quit;
static	Q8tkWidget	*view_widget_accel;
static	Q8tkWidget	*view_string[ VIEW_MAX_LINE ];
static	int		view_string_cnt;

static	void	q8tk_utility_view_end(UNUSED_WIDGET, UNUSED_PARM);
int		q8tk_utility_view(const char *filename)
{
    int save_code, file_code, file_text;
    OSD_FILE *fp;
    Q8tkWidget *w, *swin, *x, *b, *z;

    if (filename == NULL || *filename == '\0' ||
	osd_file_stat(filename) != FILE_STAT_FILE) {
	return 0;
    }

    fp = osd_fopen(FTYPE_READ, filename, "rb");

    if (fp == NULL) {
	return 0;
    }

    {
	int l = strlen(filename);
	if (l >= 4 && ((filename[l-4] == '.') &&
		       (filename[l-3] == 'T' || filename[l-3] == 't') &&
		       (filename[l-2] == 'X' || filename[l-2] == 'x') &&
		       (filename[l-1] == 'T' || filename[l-1] == 't'))) {
	    file_text = TRUE;
	} else {
	    file_text = FALSE;
	}
    }

    if (file_text == FALSE) {		/* Хʥե */

	file_code = Q8TK_KANJI_ANK;

    } else {				/* ƥȥե */
					/* եƬ 1KB Ŭ˸  */
	int  sz;			/* ɤȽꡣۤȤŬ */
	char buf[1024];

	sz = (int)osd_fread(buf, sizeof(char), sizeof(buf), fp);
	if (osd_fseek(fp, 0, SEEK_SET) == -1) {
	    osd_fclose(fp);
	    return 0;
	}
	file_code = q8gr_strcode(buf, sz);
    }



    {						/* ᥤȤʤ륦ɥ */
	w = q8tk_window_new(Q8TK_WINDOW_DIALOG);
	view_widget_accel = q8tk_accel_group_new();
	q8tk_accel_group_attach(view_widget_accel, w);
    }
    {						/* ˥ܥå褻 */
	x = q8tk_vbox_new();
	q8tk_container_add(w, x);
	q8tk_widget_show(x);
							/* ܥåˤ     */
	{						/* SCRLɥ */
	    swin  = q8tk_scrolled_window_new(NULL, NULL);
	    q8tk_widget_show(swin);
	    q8tk_scrolled_window_set_policy(swin, Q8TK_POLICY_AUTOMATIC,
						  Q8TK_POLICY_AUTOMATIC);
	    q8tk_misc_set_size(swin, 78, 20);
	    q8tk_box_pack_start(x, swin);
	}
	{						/* λܥ */
	    b = q8tk_button_new_with_label(" O K ");
	    q8tk_box_pack_start(x, b);
	    q8tk_widget_show(b);

	    q8tk_misc_set_placement(b, Q8TK_PLACEMENT_X_CENTER,
				       Q8TK_PLACEMENT_Y_CENTER);
	    q8tk_signal_connect(b, "clicked", q8tk_utility_view_end, NULL);

	    q8tk_accel_group_add(view_widget_accel, Q8TK_KEY_ESC,
				 b, "clicked");
	}
    }

    {							/* SCRLɥ */
	z = q8tk_vbox_new();				/* VBOXä     */
	q8tk_container_add(swin, z);
	q8tk_widget_show(z);

	save_code = q8tk_set_kanjicode(file_code);	/* եƤ   */
    							/* ٥Ȥ */
	{
	    int c1, c2;
	    int column, line;
	    int end_of_line, end_of_file;
	    char src[ VIEW_MAX_COLUMN + 1 ];

	    c2 = osd_fgetc(fp);

	    line = 0;
	    end_of_file = FALSE;
	    memset(src, 0, sizeof(src));

	    while (end_of_file == FALSE) {

		if (file_text) {		/* ƥȥե */
		    column = 0;
		    end_of_line = FALSE;
		    memset(src, 0, sizeof(src));

		    while (end_of_line == FALSE) {

			c1 = c2;
			c2 = osd_fgetc(fp);
			if (c1 == '\r' &&  c2 == '\n') c2 = osd_fgetc(fp);

			if (c1 == EOF) {
			    c1 = '\0';
			    end_of_line = TRUE;
			    end_of_file = TRUE;
			}
			else if ((c1 == '\r') || (c1 == '\n')) {
			    c1 = '\0';
			    end_of_line = TRUE;
			}

			
			if (c1 == '\t') {			/* ִ */
			    int len = q8gr_strlen(file_code, src);
			    int pad = ((len + 8) / 8) * 8 - len;
			    int i;
			    for (i=0; i<pad; i++) {
				if (column < (int)sizeof(src)-1) {
				    src[ column ] = ' ';
				    column ++;
				}
			    }
			}
			else if (column < (int)sizeof(src)-1) {	/* ְʳ */
			    src[ column ] = c1;
			    column ++;
			}
		    }

		} else {			/* Хʥե */
		    int c[16];
		    char fmt[128];

		    if (c2 == EOF) {
			strcpy(src, "[EOF]");
			end_of_file = TRUE;
		    } else {
			for (column = 0; column < 16 && c2 != EOF; column ++) {
			    c[column] = c2;
			    c2 = osd_fgetc(fp);
			}

			strcpy(fmt, "%04X : ");
			while (column--) { strcat(fmt, "%02X "); }

			sprintf(src, fmt, line * 0x10,
				c[ 0], c[ 1], c[ 2], c[ 3],
				c[ 4], c[ 5], c[ 6], c[ 7],
				c[ 8], c[ 9], c[10], c[11],
				c[12], c[13], c[14], c[15]);
		    }
		}


		if (line == COUNTOF(view_string)-1)
		    strcpy(src, "........To be continued.");

		view_string[ line ] = q8tk_label_new(src);
		q8tk_widget_show(view_string[ line ]);
		q8tk_box_pack_start(z, view_string[ line ]);

		line ++;
		if (line >= COUNTOF(view_string)) break;
	    }

	    view_string_cnt = line;
	}
	q8tk_set_kanjicode(save_code);
    }

    osd_fclose(fp);


    q8tk_widget_show(w);
    q8tk_grab_add(w);

    q8tk_widget_set_focus(b);


    view_widget_win   = w;	/* ĤȤ */
    view_widget_vbox  = x;	/* åȤФƤޤ     */
    view_widget_swin  = swin;
    view_widget_board = z;
    view_widget_quit  = b;

    return 1;
}

static	void	q8tk_utility_view_end(UNUSED_WIDGET, UNUSED_PARM)
{
    int i;
    for (i=0; i<view_string_cnt; i++)
	q8tk_widget_destroy(view_string[ i ]);

    q8tk_widget_destroy(view_widget_quit);
    q8tk_widget_destroy(view_widget_board);
    q8tk_widget_destroy(view_widget_swin);
    q8tk_widget_destroy(view_widget_vbox);

    q8tk_grab_remove(view_widget_win);
    q8tk_widget_destroy(view_widget_win);
    q8tk_widget_destroy(view_widget_accel);
}




/************************************************************************/
/* ¿ʽ								*/
/************************************************************************/

/*---------------------------------------------------------------------------
 * ɽ֤ѹ
 *---------------------------------------------------------------------------
 *  HBOXVBOXľλҤΥåȤΤͭ¾̵ (̵)
 *  -------------------------------------------------------------------------
 *  void	q8tk_misc_set_placement(Q8tkWidget *widget,
 *					int placement_x, int placement_y)
 *---------------------------------------------------------------------------*/
void	q8tk_misc_set_placement(Q8tkWidget *widget,
				int placement_x, int placement_y)
{
    widget->placement_x = placement_x;
    widget->placement_y = placement_y;
}

/*---------------------------------------------------------------------------
 * ɽѹ
 *---------------------------------------------------------------------------
 *  ʲΥåȤΤͭ¾̵ (̵)
 *	COMBO		 ʸʬɽ
 *	LIST		 ʸɽ
 *	SCROLLED WINDOW	 ɥ⤵
 *	ENTRY		 ʸɽ
 *  -------------------------------------------------------------------------
 *  void	q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
 *---------------------------------------------------------------------------*/
void	q8tk_misc_set_size(Q8tkWidget *widget, int width, int height)
{
    switch (widget->type) {

    case Q8TK_TYPE_COMBO:
	if (width > 0) {
	    widget->stat.combo.width = width;
	    q8tk_misc_set_size(widget->stat.combo.entry,
			       widget->stat.combo.width, 0);
	} else {
	    widget->stat.combo.width = 0;
	    q8tk_misc_set_size(widget->stat.combo.entry,
			       widget->stat.combo.length, 0);
	}
	break;

    case Q8TK_TYPE_LISTBOX:
	if (width > 0) widget->stat.listbox.width = width;
	else           widget->stat.listbox.width = 0;
	break;

    case Q8TK_TYPE_SCROLLED_WINDOW:
	widget->stat.scrolled.width  = width;
	widget->stat.scrolled.height = height;

	if (widget->with_label) {
	    q8tk_adjustment_set_increment(widget->stat.scrolled.hadj,
					  1, MAX(10, width - 3));
	    q8tk_adjustment_set_increment(widget->stat.scrolled.vadj,
					  1, MAX(10, height - 3));
	}
	break;

    case Q8TK_TYPE_ENTRY:
	widget->stat.entry.width = width;
	q8tk_entry_set_position(widget, widget->stat.entry.cursor_pos);
	break;

    default:
	fprintf(stderr, "Cant resize widget=%s\n", debug_type(widget->type));
	Q8tkAssert(FALSE, NULL);
	return;
    }
    set_construct_flag(TRUE);
}




/************************************************************************/
/* ƥʴط								*/
/************************************************************************/
/*---------------------------------------------------------------------------
 * ƥ
 *---------------------------------------------------------------------------
 *  ƥʥåȤȥåȤƻҤˤ
 *  -------------------------------------------------------------------------
 *  void    q8tk_container_add(Q8tkWidget *container, Q8tkWidget *widget)
 *	ƥʥå container  å widget ƻҤˤ롣
 *
 *  void    q8tk_box_pack_start(Q8tkWidget *box, Q8tkWidget *widget)
 *	ʿľܥå box θˡå widget ͤ롣
 *
 *  void    q8tk_box_pack_end(Q8tkWidget *box, Q8tkWidget *widget)
 *	ʿľܥå box ˡå widget ͤ롣
 *
 *  void    q8tk_container_remove(Q8tkWidget *container, Q8tkWidget *widget)
 *	ƥʥå container  å widget ڤΥ
 *---------------------------------------------------------------------------*/
void	q8tk_container_add(Q8tkWidget *container, Q8tkWidget *widget)
{
    Q8tkAssert(container->attr & Q8TK_ATTR_CONTAINER, NULL);
    if (container->attr & Q8TK_ATTR_LABEL_CONTAINER) {
	Q8tkAssert(widget->type == Q8TK_TYPE_LABEL, NULL);
    }

    switch (container->type) {
    case Q8TK_TYPE_LISTBOX:			/* LIST BOX 㳰 */
	if (container->child == NULL) {			/* ǽ LIST ITEM */
	    container->stat.listbox.selected = widget;	/* ξϡ */
	    container->stat.listbox.active   = widget;	/* ֤ˤ   */
	}
	q8tk_box_pack_start(container, widget);		/* VBOXƱ */
	return;

    default:					/* ̾ν */
	container->child = widget;
	widget->parent = container;
	widget->prev   = NULL;
	widget->next   = NULL;
	break;
    }

    if (widget->visible) {
	widget_map(widget);
    }
}

void	q8tk_box_pack_start(Q8tkWidget *box, Q8tkWidget *widget)
{
    Q8tkAssert(box->attr & Q8TK_ATTR_CONTAINER, NULL);

    if (box->child == NULL) {
	box->child   = widget;
	widget->prev = NULL;
	widget->next = NULL;
    } else {
	Q8tkWidget *c = box->child;
	while (c->next) {
	    c = c->next;
	}
	c->next      = widget;
	widget->prev = c;
	widget->next = NULL;
    }
    widget->parent = box;

    if (widget->visible) {
	widget_map(widget);
    }
}

void	q8tk_box_pack_end(Q8tkWidget *box, Q8tkWidget *widget)
{
    Q8tkAssert(box->attr & Q8TK_ATTR_CONTAINER, NULL);

    if (box->child == NULL) {
	widget->prev = NULL;
	widget->next = NULL;
    } else {
	Q8tkWidget *c = box->child;
	Q8tkAssert(c->prev == NULL, NULL);
	c->prev      = widget;
	widget->next = c;
	widget->prev = NULL;
    }
    box->child     = widget;
    widget->parent = box;

    if (widget->visible) {
	widget_map(widget);
    }
}

void	q8tk_container_remove(Q8tkWidget *container, Q8tkWidget *widget)
{
    Q8tkAssert(container->attr & Q8TK_ATTR_CONTAINER, NULL);
    Q8tkAssert(widget->parent == container, NULL);

    if (widget->prev == NULL) {			/* ʬƤľλ */
	Q8tkWidget *n = widget->next;
	if (n) n->prev = NULL;
	container->child = n;

    } else {					/* ʤ */
	Q8tkWidget *p = widget->prev;
	Q8tkWidget *n = widget->next;
	if (n) n->prev = p;
	p->next = n;
    }

    widget->parent = NULL;
    widget->prev = NULL;
    widget->next = NULL;

    switch (container->type) {

    case Q8TK_TYPE_LISTBOX:			/* LIST BOX 㳰 */
	if (container->stat.listbox.selected == widget) {
	    container->stat.listbox.selected = NULL;
	    container->stat.listbox.active   = NULL;
	}
	break;

    }


    if (container->visible) {
	widget_map(container);
    }
}


/************************************************************************/
/* ɽط								*/
/************************************************************************/
/*---------------------------------------------------------------------------
 * Ļ벽ԲĻ벽
 *---------------------------------------------------------------------------
 *  åȤɽɽ
 *  -------------------------------------------------------------------------
 *  void	q8tk_widget_show(Q8tkWidget *widget)
 *	åȤɽ롣
 *
 *  void	q8tk_widget_hide(Q8tkWidget *widget)
 *	åȤɽˤ롣Ҥɽˤʤ롣
 *---------------------------------------------------------------------------*/
void	q8tk_widget_show(Q8tkWidget *widget)
{
    widget->visible = TRUE;
    widget_map(widget);
}
void	q8tk_widget_hide(Q8tkWidget *widget)
{
    widget->visible = FALSE;
    widget_map(widget);
}


/*---------------------------------------------------------------------------
 * 
 *---------------------------------------------------------------------------
 *  åȤ
 *  -------------------------------------------------------------------------
 *  void	q8tk_widget_set_sensitive(Q8tkWidget *widget, int sensitive)
 *	åȤǽǽˤ롣
 *	---------------------------------------------------------------------
 *	ݤϡҤ롣
 *	ǽʥåȤϡ̾Ȥϰ㤦(Ϥο)ɽȤʤ롣
 *	ȤǤʤå(٥ʤ)ФƤ⡢Ǥ롣
 *	---------------------------------------------------------------------
 *	LOGO / VSEPARATOR / HSEPARATOR ϡǽˤƤ⿧Ѳʤ
 *	(Ѳۤ?)
 *
 *	NOTEPAGE ϡǥƥ(NOTEPAGE)ưȤߤʤΤǡ
 *	ݤǤʤ (̵ꤵС
 *	q8tk_widget_set_sensitive(widget->parent, FALSE) ǤǤ뤬)
 *
 *	ADJUSTMENT ݤǤ뤬ʤɤΤۤꤹ
 *	顢ľܻꤹ뤳ȤϤʤ
 *---------------------------------------------------------------------------*/
void	q8tk_widget_set_sensitive(Q8tkWidget *widget, int sensitive)
{
    widget->sensitive = sensitive;
    widget_map(widget);
}


/************************************************************************/
/* åȤξõ							*/
/************************************************************************/
/*---------------------------------------------------------------------------
 * åȾõ
 *---------------------------------------------------------------------------
 *  åȤõ
 *		     q8tk_dialog_new ˤåƾõ
 *				vbox  action_area ˺ܤåȤϾõ
 *				ʤΤơƤӽФǾõ롣
 *
 *	ե륻쥯  ƤΥåȤõ
 *				եåȤƾõ
 *
 *	¾		      ǼưåȤ⤢碌ƾõ
 *				q8tk_xxx_new_with_label ٥䡢
 *				q8tk_scrolled_window_new Ǽư
 *				㥹ȥȤʤ
 *  -------------------------------------------------------------------------
 *  void	q8tk_widget_destroy(Q8tkWidget *widget)
 *	åȤξõʹߡ widget ϻѶػ
 *
 *---------------------------------------------------------------------------*/
static	void	widget_destroy_all(Q8tkWidget *widget);

void	q8tk_widget_destroy(Q8tkWidget *widget)
{
    Q8tkWidget *work;

    if (widget->type == Q8TK_TYPE_WINDOW &&	/* DIALOG  FILE SELECTION */
	(work = widget->stat.window.work)) {	/* 㳰		    */

	switch (work->type) {
	case Q8TK_TYPE_DIALOG:
	    Q8tkAssert(widget->child->type == Q8TK_TYPE_FRAME, NULL);
	    Q8tkAssert(widget->child->child->type == Q8TK_TYPE_VBOX, NULL);
	    q8tk_widget_destroy(Q8TK_DIALOG(widget)->action_area);
	    q8tk_widget_destroy(Q8TK_DIALOG(widget)->vbox);
	    q8tk_widget_destroy(widget->child->child);
	    q8tk_widget_destroy(widget->child);
	    q8tk_widget_destroy(work);
	    break;

	case Q8TK_TYPE_FILE_SELECTION:
	    {
		q8tk_widget_destroy(
			(Q8TK_FILE_SELECTION(widget)->scrolled_window)
							->stat.scrolled.hadj);
		q8tk_widget_destroy(
			(Q8TK_FILE_SELECTION(widget)->scrolled_window)
							->stat.scrolled.vadj);

		free(Q8TK_FILE_SELECTION(widget)->pathname);
		free(Q8TK_FILE_SELECTION(widget)->filename);

		/* طϤäꤷƤΤǡ̵ѤƤõ */
		widget_destroy_all(widget->child);
	    }
	    q8tk_widget_destroy(work);
	    break;
	}
    }

    if (widget->type == Q8TK_TYPE_COMBO) {	/* COMBO 㳰 */
	Q8List *l = widget->stat.combo.list;
	while (l) {
	    q8tk_widget_destroy((Q8tkWidget *)(widget->stat.combo.list->data));
	    l = l->next;
	}
	q8_list_free(widget->stat.combo.list);
	q8tk_widget_destroy(widget->stat.combo.entry);
    }

    if (widget->type == Q8TK_TYPE_ACCEL_GROUP &&    /* ACCEL λҤƾõ */
	widget->child) {
	/* طϤäꤷƤΤǡ̵ѤƤõ */
	widget_destroy_all(widget->child);
    }


    if (widget->with_label &&			/* XXX_new_with_label() */
	widget->child      &&			/* 줿 LABELν */
	widget->child->type == Q8TK_TYPE_LABEL) {
	q8tk_widget_destroy(widget->child);
    }
    if (widget->with_label &&			    /*  NULL 줿*/
	widget->type == Q8TK_TYPE_SCROLLED_WINDOW) {/* SCROLLED WINDOW ν*/
	q8tk_widget_destroy(widget->stat.scrolled.hadj);
	q8tk_widget_destroy(widget->stat.scrolled.vadj);
    }

    if (widget->name) {
	free(widget->name);
	widget->name = NULL;
    }
    free_widget(widget);
}


/* ȤȡҤȡ֤ƺ
   ȰʲΥåȤκˤ㳰̵Ȥ狼äƤΤ߲ */

static	void	widget_destroy_all(Q8tkWidget *widget)
{
    if (widget->next)  widget_destroy_all(widget->next);
    if (widget->child) widget_destroy_all(widget->child);

    if (widget->name) {
	free(widget->name);
	widget->name = NULL;
    }
    free_widget(widget);
}




/************************************************************************/
/* ΥåȤ˥եƤ롣				*/
/*	̾ եϡľ˥ܥ䥭Ϥʤ줿å	*/
/*	ˤʤꡢTAB ˤؤǽδؿΥå	*/
/*	˥եꤹ뤳ȤǤ롣				*/
/*	ΥåȤΰĤ WINDOW q8tk_grab_add()	*/
/*	ʤ줿ȤǤʤ̵Ǥ롣			*/
/************************************************************************/
void	q8tk_widget_set_focus(Q8tkWidget *widget)
{
    focus_widget[ window_layer_level ] = widget;
    set_construct_flag(TRUE);
}


/************************************************************************/
/* ʥط								*/
/************************************************************************/
/*
 *	ǤդΥåȤˡǤդΥʥ
 */
static	void	widget_signal_do(Q8tkWidget *widget, const char *name)
{
    switch (widget->type) {
    case Q8TK_TYPE_WINDOW:			/* ɥ		*/
	if (strcmp(name, "inactivate") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;
    case Q8TK_TYPE_BUTTON:			/* ܥ		*/
	if (strcmp(name, "clicked") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;
    case Q8TK_TYPE_TOGGLE_BUTTON:		/* ȥܥ		*/
    case Q8TK_TYPE_CHECK_BUTTON:		/* åܥ	*/
    case Q8TK_TYPE_RADIO_BUTTON:		/* 饸ܥ		*/
	if        (strcmp(name, "clicked") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	} else if (strcmp(name, "toggled") == 0) {
	    if (widget->user_event_1) {
		(*widget->user_event_1)(widget, widget->user_event_1_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_NOTEBOOK:			/* Ρȥ֥å		*/
	if (strcmp(name, "switch_page") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_COMBO:			/* ܥܥå	*/
	if        (strcmp(name, "activate") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	} else if (strcmp(name, "changed") == 0) {
	    if (widget->user_event_1) {
		(*widget->user_event_1)(widget, widget->user_event_1_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_LISTBOX:			/* ꥹȥܥå	*/
	if (strcmp(name, "selection_changed") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_LIST_ITEM:			/* ꥹȥƥ	*/
	if (strcmp(name, "select") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_ADJUSTMENT:			/* 㥹ȥ */
	if (strcmp(name, "value_changed") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	}
	break;

    case Q8TK_TYPE_ENTRY:			/* ȥ꡼		*/
	if        (strcmp(name, "activate") == 0) {
	    if (widget->user_event_0) {
		(*widget->user_event_0)(widget, widget->user_event_0_parm);
	    }
	    return;
	} else if (strcmp(name, "changed") == 0) {
	    if (widget->user_event_1) {
		(*widget->user_event_1)(widget, widget->user_event_1_parm);
	    }
	    return;
	}
	break;

    }

    fprintf(stderr, "BAD signal %s '%s'\n", debug_type(widget->type), name);
    Q8tkAssert(FALSE, NULL);
    return;
}


/*---------------------------------------------------------------------------
 * ʥꡦ
 *---------------------------------------------------------------------------
 *  åȤΥʥˡХåؿꤹ롣
 *    ƥåȤȤȯ륷ʥ뤬ޤäƤΤǡΥʥ뤬
 *    ȯ˸ƤӽФؿꤹ롣
 *  ꤹؿǼʬȤΥåȤ褦ʤȤ
 *    ƤϤʤǸưǽ롣
 *     (ܥ󥦥åȤ˸¤ꡢǽȤ롣ʤΤǡ
 *	ե륻쥯ΥܥˤơȤΤפʤϤ)
 *
 *  -------------------------------------------------------------------------
 * int	q8tk_signal_connect(Q8tkWidget *widget, const char *name,
 *			    Q8tkSignalFunc func, void *func_data)
 *	widget  name Ǽ륷ʥФ륳Хåؿ func 
 *	ꤹ롣ʥȯˤϡؿ func   widget, func_data 
 *	ȼäƸƤӽФ롣
 *	ʤͤϾ 0 ˤʤ롣
 *
 * void	q8tk_signal_handlers_destroy(Q8tkWidget *widget)
 *	widget ꤵ줿ƤΥʥΥХåؿ̵ˤ롣
 *
 *---------------------------------------------------------------------------*/
void	q8tk_signal_handlers_destroy(Q8tkWidget *widget)
{
    widget->user_event_0 = NULL;
    widget->user_event_1 = NULL;
}

int	q8tk_signal_connect(Q8tkWidget *widget, const char *name,
			    Q8tkSignalFunc func, void *func_data)
{
    switch (widget->type) {
    case Q8TK_TYPE_WINDOW:			/* ɥ		*/
	if (strcmp(name, "inactivate") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;
    case Q8TK_TYPE_BUTTON:			/* ܥ		*/
	if (strcmp(name, "clicked") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;
    case Q8TK_TYPE_TOGGLE_BUTTON:		/* ȥܥ		*/
    case Q8TK_TYPE_CHECK_BUTTON:		/* åܥ	*/
    case Q8TK_TYPE_RADIO_BUTTON:		/* 饸ܥ		*/
	if        (strcmp(name, "clicked") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	} else if (strcmp(name, "toggled") == 0) {
	    widget->user_event_1      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_1_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_NOTEBOOK:			/* Ρȥ֥å		*/
	if (strcmp(name, "switch_page") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_COMBO:			/* ܥܥå	*/
	if        (strcmp(name, "activate") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	} else if (strcmp(name, "changed") == 0) {
	    widget->user_event_1      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_1_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_LISTBOX:			/* ꥹȥܥå	*/
	if (strcmp(name, "selection_changed") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_LIST_ITEM:			/* ꥹȥƥ	*/
	if (strcmp(name, "select") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_ADJUSTMENT:			/* 㥹ȥ	*/
	if (strcmp(name, "value_changed") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	}
	break;

    case Q8TK_TYPE_ENTRY:			/* ȥ		*/
	if        (strcmp(name, "activate") == 0) {
	    widget->user_event_0      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_0_parm = func_data;
	    return 0;
	} else if (strcmp(name, "changed") == 0) {
	    widget->user_event_1      = (void (*)(Q8tkWidget*,void*))func;
	    widget->user_event_1_parm = func_data;
	    return 0;
	}
	break;

    }

    fprintf(stderr,
	    "Undefined signal %s '%s'\n", debug_type(widget->type),name);
    Q8tkAssert(FALSE, NULL);
    return 0;
}



/************************************************************************/
/* ٥ȤΥå							*/
/************************************************************************/
/*
 *	DRAGGING
 */
static	void	widget_dragging(Q8tkWidget *focus)
{
    if (focus && focus->event_dragging) {
	(*focus->event_dragging)(focus);
    }
}
/*
 *	DRAG OFF
 */
static	void	widget_drag_off(Q8tkWidget *focus)
{
    if (focus && focus->event_drag_off) {
	(*focus->event_drag_off)(focus);
    }
}

/*
 *	MOUSE BUTTON ON
 */
static	void	widget_button_on(Q8tkWidget *focus)
{
    if (focus == NULL) {
	/* åȰʳ򥯥å顢οƥɥ˥٥ */
	focus = window_layer[ window_layer_level ];
    }
    if (focus && focus->event_button_on) {
	(*focus->event_button_on)(focus);
    }
}
/*
 *	KEY ON
 */
static	void	widget_key_on(Q8tkWidget *focus, int key)
{
    if (focus && focus->event_key_on) {
	(*focus->event_key_on)(focus, key);
    }
}



/************************************************************************/
/* ᥤ								*/
/************************************************************************/
/*--------------------------------------------------------------
 *
 *--------------------------------------------------------------*/
void	q8tk_event_key_on(int code)
{
    Q8tkWidget *w;
    int change = FALSE;
    int back   = FALSE;

    now_mouse_on = FALSE;

    if (code == Q8TK_KEY_SHIFT) now_shift_on = TRUE;

    if (! get_drag_widget()) {			/* ɥå椸ʤ	*/

	w = get_focus_widget();

	switch (code) {
	case Q8TK_KEY_TAB:
	    change = TRUE;
	    if (now_shift_on) back = TRUE;
	    else              back = FALSE;
	    break;

#ifdef	OLD_FOCUS_CHANGE
	/* DO NOTHING */
#else	/* ʥեư */
	case Q8TK_KEY_UP:
	    if (w->key_up_used == FALSE) {
		change = TRUE;
		back   = TRUE;
	    }
	    break;
	case Q8TK_KEY_DOWN:
	    if (w->key_down_used == FALSE) {
		change = TRUE;
		back   = FALSE;
	    }
	    break;
	case Q8TK_KEY_LEFT:
	    if (w->key_left_used == FALSE) {
		change = TRUE;
		back   = TRUE;
	    }
	    break;
	case Q8TK_KEY_RIGHT:
	    if (w->key_right_used == FALSE) {
		change = TRUE;
		back   = FALSE;
	    }
	    break;
#endif
	}
	    
	/* [TAB][][][][] ǡΥåȤ˥եܤ */
	if (change) {

	    w = widget_focus_list_get_next(w, back);
	    q8tk_widget_set_focus(w);

	    /* եưåȤ
	       ɥɥǤġ륢ΰʤ顢
	       Ū˥륤󤵤Τǡͽ */
	    if (w && w->type != Q8TK_TYPE_ADJUSTMENT
		  && w->type != Q8TK_TYPE_LISTBOX
		  && w->type != Q8TK_TYPE_DIALOG
		  && w->type != Q8TK_TYPE_FILE_SELECTION) {
		widget_scrollin_register(w);
	    }
	} else {				/*	¾Υ */

	    /* 졼ꤵƤн */
	    if (window_layer_level >= 0) {
		w = window_layer[ window_layer_level ];
		Q8tkAssert(w->type == Q8TK_TYPE_WINDOW, NULL);

		if (w->stat.window.accel) {
		    w = (w->stat.window.accel)->child;
		    while (w) {
			if (w->stat.accel.key == code) {
			    widget_signal_do(w->stat.accel.widget, w->name);
			    break;
			}
			w = w->next;
		    }
		}
	    }

	    /* 졼ͭʤ顢ɸνϤʤۤ? */
	    widget_key_on(get_focus_widget(), code);
	}
    }
}

void	q8tk_event_key_off(int code)
{
    now_mouse_on = FALSE;

    if (code == Q8TK_KEY_SHIFT) now_shift_on = FALSE;
}

void	q8tk_event_mouse_on(int code)
{
    if (get_construct_flag()) return;	/* ɥ˴ľΥå */

    if (code == Q8TK_BUTTON_L) {		/* ܥ ON		*/
	if (! get_drag_widget()) {		/* ɥå椸ʤ	*/
	    void *focus = q8gr_get_focus_screen(mouse.x/8, mouse.y/16);
	    if        (focus == Q8GR_WIDGET_NONE) {
		widget_button_on(NULL);
	    } else if (focus == Q8GR_WIDGET_WINDOW) {
		/* DO NOTHING */ ;
	    } else {
		q8tk_widget_set_focus((Q8tkWidget *)focus);
		widget_button_on((Q8tkWidget *)focus);
	    }
	}
    } else if (code == Q8TK_BUTTON_U) {		/* ۥ UP		*/

	widget_key_on(get_focus_widget(), Q8TK_KEY_PAGE_UP);

    } else if (code == Q8TK_BUTTON_D) {		/* ۥ DOWN	*/

	widget_key_on(get_focus_widget(), Q8TK_KEY_PAGE_DOWN);
    }
}

void	q8tk_event_mouse_off(int code)
{
    now_mouse_on = FALSE;

    if (code == Q8TK_BUTTON_L) {		/* ܥ OFF		*/
	if (get_drag_widget()) {		/*  ɥå	*/
	    widget_drag_off(get_drag_widget());
	    set_drag_widget(NULL);
	}
    }
}

void	q8tk_event_mouse_moved(int x, int y)
{
    int block_moved;

    mouse.x_old = mouse.x;
    mouse.y_old = mouse.y;
    mouse.x     = x;
    mouse.y     = y;

    if (mouse.x/8  != mouse.x_old/8  ||		/* ޥ 8dotʾ ư	*/
	mouse.y/16 != mouse.y_old/16) {
	block_moved = TRUE;
	now_mouse_on = FALSE;

	if (disp_cursor) {
	    set_construct_flag(TRUE);
	}
    } else {
	block_moved = FALSE;
    }

    if (get_drag_widget()) {			/*  ɥå 	*/
	if (block_moved) {			/* ޥ 8dotʾ ư	*/
	    widget_dragging(get_drag_widget());
	}
    }
}

void	q8tk_event_quit(void)
{
    q8tk_main_quit();
}

/*--------------------------------------------------------------
 *
 *--------------------------------------------------------------*/
static	int	cursor_exist = 0;
static	int	cursor_timer = 0;

#define	Q8GR_CURSOR_BLINK		(30)
#define	Q8GR_CURSOR_CYCLE		(60)

#define	Q8GR_MOUSE_AUTO_REPEAT		(6)


void	q8gr_set_cursor_exist(int exist_flag)
{
    cursor_exist = exist_flag;
}
int	q8gr_get_cursor_exist(void)
{
    return cursor_exist;
}
int	q8gr_get_cursor_blink(void)
{
    return (cursor_timer < Q8GR_CURSOR_BLINK) ? TRUE : FALSE;
}
void	q8gr_set_cursor_blink(void)
{
    cursor_timer = 0;
}

/*--------------------------------------------------------------
 * q8tk_main_loop
 *	ͤʤ顢ȸ˲٤ǤƤӽФ
 *		  ʤ顢λ
 *--------------------------------------------------------------*/

int	q8tk_main_loop(void)
{
    static int mouse_frame = 0;

    if (get_main_loop_flag()) {

	if (get_delay_widget() == NULL) {

	    if (cursor_exist) {		/* ɽʤǥ޹ */
		cursor_timer ++;
		if (cursor_timer > Q8GR_CURSOR_CYCLE) {
		    cursor_timer = 0;
		}
	    } else {
		cursor_timer = 0;
	    }

	    event_update();		/* ٥Ȥ		  */
					/* (ɬפ˱ơǲ̹) */
					/* (λΥե饰ǥå) */

	    if (now_mouse_on) {		/* ޥܥ󥪡ȥԡȽ */
		++ mouse_frame;
		if (mouse_frame >= Q8GR_MOUSE_AUTO_REPEAT) {
		    q8tk_event_mouse_on(Q8TK_BUTTON_L);
		    mouse_frame = 0;
		}
	    } else {
		mouse_frame = 0;
	    }

	    if (cursor_exist) {		  /* ڤؤ	*/
		if (cursor_timer == 0 ||  /* ߥ󥰤å	*/
		    cursor_timer == Q8GR_CURSOR_BLINK) {
		    set_construct_flag(TRUE);
		}
	    }

	} else {
      
	    /* ٥Ȥٱ䤵뤿Ρޡ (ʤ궯) */
	    /* (ΤȤܥȥꥹȥƥΤ)              */
	    if (-- delay_timer < 0) {
		Q8tkWidget *widget = get_delay_widget();

		if (widget->type == Q8TK_TYPE_BUTTON) {
		    widget->stat.button.active = Q8TK_BUTTON_OFF;
		    widget_signal_do(widget, "clicked");
		}
		else if (widget->type == Q8TK_TYPE_LIST_ITEM) {
		    widget_signal_do(widget->parent, "selection_changed");
		    widget_signal_do(widget, "select");
		}
		set_construct_flag(TRUE);

		set_delay_widget(NULL, 0);
	    }
	}



	if (get_construct_flag()) {	/* ̹ѹϡ */

	    widget_construct();
	    set_construct_flag(FALSE);

	    if (q8tk_disp_init_flag) {
		screen_set_dirty_palette();
		q8tk_disp_init_flag = FALSE;
	    }
	    screen_set_dirty_flag(0);

#ifdef	RESET_EVENT			/* Ϥ򥭥󥻥 */
	    event_switch();
#endif
	}

    }

    /* ̤äơQ8TK λƤʤС֤	*/
    /*		¦ϡ衦ȸˤδؿٸƤӽФ	*/
    /*									*/
    /* ̤äơQ8TK λƤС֤		*/
    /*		¦ϡνܤ뤳			*/
    /*		衦ȸܤƤ⹽ʤ			*/
    /*		ְäƺٸƤӽФ硢ʤˤ˵֤	*/

    if (get_main_loop_flag()) {

	return TRUE;

    } else {

	q8tk_term();
	return FALSE;
    }
}

/*--------------------------------------------------------------
 *
 *--------------------------------------------------------------*/
void	q8tk_main_quit(void)
{
    set_main_loop_flag(FALSE);
}







/************************************************************************/
/*									*/
/*									*/
/*									*/
/*									*/
/*									*/
/*									*/
/************************************************************************/

/*------------------------------------------------------*/
/* åȤɽ
	ƥåȤĤĤå
	ƤοƥåȤĻ
	ĥåȤ WINDOW
	ξ硢 WINDOW ʲƷ׻ɽ
	褦ˡե饰򤿤Ƥ롣
	ºݤκƷ׻ɽϡq8tk_main() ǹԤʤ	*/
/*------------------------------------------------------*/
static	void	widget_map(Q8tkWidget *widget)
{
    Q8tkWidget *ancestor, *parent;
    int        size_calc = TRUE;

    if (widget->visible) {
	ancestor = widget;
	parent   = widget->parent;
	while (parent) {
	    if (parent->visible) {
		ancestor = parent;
		parent   = parent->parent;
	    } else {
		size_calc = FALSE;
		break;
	    }
	}
	if (size_calc && ancestor->type == Q8TK_TYPE_WINDOW) {
	    set_construct_flag(TRUE);
	}
    }
}


/*------------------------------------------------------*/
/* ҥåȤΥ򸵤ˡʬȤΥ׻롣
   ƵŪˡƤλҥåȤƱ˷׻롣

   *widget  ֿƤΥå
   *max_sx  ƤλҥåȤΤʤǺ祵 x
   *max_sy  ƤλҥåȤΤʤǺ祵 y
   *sum_sx  Ҥ֥åȤΥ x
   *sum_sy  Ҥ֥åȤΥ y          */
/*------------------------------------------------------*/
static	void	widget_resize(Q8tkWidget *widget, int max_sx, int max_sy);
static	void	widget_size(Q8tkWidget *widget, int *max_sx, int *max_sy,
						int *sum_sx, int *sum_sy)
{
    int n_msx, n_msy, n_ssx, n_ssy;

/*  printf("%d \n", widget->type); fflush(stdout);*/


		/* ʬȤ (next) ¸ߤСƵŪ˷׻ */
  
    if (widget->next) {
	widget_size(widget->next, &n_msx, &n_msy, &n_ssx, &n_ssy);
    } else {
	n_msx = n_msy = n_ssx = n_ssy = 0;
    }


    if (widget->visible) {

	int c_msx, c_msy, c_ssx, c_ssy;

		/* ҥåȤΥ׻(Ƶ) */

	if (widget->child) {
	    widget_size(widget->child, &c_msx, &c_msy, &c_ssx, &c_ssy);
	} else {
	    c_msx = c_msy = c_ssx = c_ssy = 0;
	}

		/* ҥåȤ򸵤ˡȤΥ׻ */

	switch (widget->type) {

	case Q8TK_TYPE_WINDOW:			/* ɥ		*/
	    if (widget->stat.window.no_frame) {
		widget->sx = c_msx;
		widget->sy = c_msy;
	    } else {
		widget->sx = c_msx +2;
		widget->sy = c_msy +2;
	    }
	    break;

	case Q8TK_TYPE_BUTTON:			/* ܥ		*/
	case Q8TK_TYPE_TOGGLE_BUTTON:		/* ȥܥ		*/
	    widget->sx = c_msx +2;
	    widget->sy = c_msy +2;
	    break;

	case Q8TK_TYPE_CHECK_BUTTON:		/* åܥ	*/
	case Q8TK_TYPE_RADIO_BUTTON:		/* 饸ܥ		*/
	    widget->sx = c_msx +3;
	    widget->sy = Q8TKMAX(c_msy, 1);
	    break;

	case Q8TK_TYPE_FRAME:			/* ե졼		*/
	    if (widget->name) {
		widget->sx = Q8TKMAX(c_msx,
				     q8gr_strlen(widget->code, widget->name))
									   + 2;
	    } else {
		widget->sx = c_msx + 2;
	    }
	    widget->sy = c_msy +2;
	    break;

	case Q8TK_TYPE_LABEL:			/* ٥		*/
	    if (widget->name) {
		widget->sx = q8gr_strlen(widget->code, widget->name);
	    } else {
		widget->sx = 0;
	    }
	    widget->sy = 1;
	    break;

	case Q8TK_TYPE_LOGO:			/* 			*/
	    widget->sx = Q8GR_LOGO_W;
	    widget->sy = Q8GR_LOGO_H;
	    break;

	case Q8TK_TYPE_NOTEBOOK:		/* Ρȥ֥å		*/
	    {
		int	len = 0;
		Q8tkWidget *n = widget->child;
		while (n) {
		    if (n ->name) {
			len += q8gr_strlen(n->code, n->name);
		    }
		    len += 1;
		    n = n->next;
		}
		len += 1;
		widget->sx = Q8TKMAX(c_msx +2, len);
	    }
	    widget->sy = c_msy + 4;
	    break;

	case Q8TK_TYPE_NOTEPAGE:		/* Ρȥ֥åΥڡ	*/
	    widget->sx = c_msx;
	    widget->sy = c_msy;
	    break;

	case Q8TK_TYPE_VBOX:			/* ľܥå		*/
	    widget->sx = c_msx;
	    widget->sy = c_ssy;
	    break;
	case Q8TK_TYPE_HBOX:			/* ʿܥå		*/
	    widget->sx = c_ssx;
	    widget->sy = c_msy;
	    break;

	case Q8TK_TYPE_VSEPARATOR:		/* ľڤ		*/
	    widget->sx = 1;
	    widget->sy = 1;
	    break;
	case Q8TK_TYPE_HSEPARATOR:		/* ʿڤ		*/
	    widget->sx = 1;
	    widget->sy = 1;
	    break;

	case Q8TK_TYPE_COMBO:			/* ܥܥå	*/
	    if (widget->stat.combo.width) {
		widget->sx = widget->stat.combo.width;
	    } else {
		if (widget->stat.combo.length) {
		    widget->sx = widget->stat.combo.length;
		} else {
		    widget->sx = 8;
		}
	    }
	    widget->sx += 3;
	    widget->sy = 1;
	    break;

	case Q8TK_TYPE_LISTBOX:			/* ꥹȥܥå	*/
	    widget->sx = Q8TKMAX(c_msx, widget->stat.listbox.width);
	    widget->sy = c_ssy;
	    break;

	case Q8TK_TYPE_LIST_ITEM:		/* ꥹȥƥ	*/
	    widget->sx = c_msx;
	    widget->sy = c_msy;
	    break;

	case Q8TK_TYPE_ADJUSTMENT:		/* 㥹ȥ	*/
	    Q8tkAssert(FALSE, NULL);
	    break;

	case Q8TK_TYPE_HSCALE:			/* ʿ		*/
	case Q8TK_TYPE_VSCALE:			/* ľ		*/
	    if (widget->stat.scale.adj) {
		int sx, sy;
		adjustment_size(&widget->stat.scale.adj->stat.adj, &sx, &sy);

		if (widget->stat.scale.draw_value) {
		    if (widget->stat.scale.value_pos == Q8TK_POS_LEFT ||
			widget->stat.scale.value_pos == Q8TK_POS_RIGHT) {
			widget->sx = sx + 4;
			widget->sy = Q8TKMAX(sy, 1);
		    } else {		/* Q8TK_POS_UP||Q8TK_POS_BOTTOM*/
			widget->sx = Q8TKMAX(sx, 3);
			widget->sy = sy + 1;
		    }
		} else {
		    widget->sx = sx;
		    widget->sy = sy;
		}
	    } else {
		widget->sx = 0;
		widget->sy = 0;
	    }
	    break;

	case Q8TK_TYPE_SCROLLED_WINDOW:		/* ɥɥ */
	    if (widget->child) {

		/* ĲСɽ뤫ɤϡ
		   child Υscrolled Υscrolled  policy
		   Ȥ߹碌ˤꡢʲ 9 ѥʬ롣

				   0)              1)              2)
				c_msx < w-2	c_msx = w-2	c_msx > w-2
				(NEVER)				(ALLWAYS)
		0)
		  c_msy < h-2				  
		  (NEVER)					  ---
		1)
		  c_msy = h-2					    |
						  --+
		2)
		  c_msy > h-2	    |		    |		    |
		  (ALLWAYS)			  --+		  --+

		*/

		int w, h, tmp;

		switch (widget->stat.scrolled.hpolicy) {
		case Q8TK_POLICY_NEVER:		w = 0;		break;
		case Q8TK_POLICY_ALWAYS:	w = 2;		break;
		default: /* AUTOMATIC */
		    if      (c_msx <  widget->stat.scrolled.width - 2) w = 0;
		    else if (c_msx == widget->stat.scrolled.width - 2) w = 1;
		    else                                               w = 2;
		}

		switch (widget->stat.scrolled.vpolicy) {
		case Q8TK_POLICY_NEVER:		h = 0;		break;
		case Q8TK_POLICY_ALWAYS:	h = 2;		break;
		default: /* AUTOMATIC */
		    if      (c_msy <  widget->stat.scrolled.height - 2) h = 0;
		    else if (c_msy == widget->stat.scrolled.height - 2) h = 1;
		    else                                                h = 2;
		}

		if        ((w == 0 || w == 1) && (h == 0 || h == 1)) {
		    widget->stat.scrolled.hscrollbar = FALSE;
		    widget->stat.scrolled.vscrollbar = FALSE;
		} else if ((w == 2) && (h == 0)) {
		    widget->stat.scrolled.hscrollbar = TRUE;
		    widget->stat.scrolled.vscrollbar = FALSE;
		} else if ((w == 0) && (h == 2)) {
		    widget->stat.scrolled.hscrollbar = FALSE;
		    widget->stat.scrolled.vscrollbar = TRUE;
		} else {
		    widget->stat.scrolled.hscrollbar = TRUE;
		    widget->stat.scrolled.vscrollbar = TRUE;
		}

		w = (widget->stat.scrolled.vscrollbar)
					? widget->stat.scrolled.width - 3
					: widget->stat.scrolled.width - 2;
		h = (widget->stat.scrolled.hscrollbar)
					? widget->stat.scrolled.height - 3
					: widget->stat.scrolled.height - 2;

		q8tk_adjustment_set_length(widget->stat.scrolled.hadj, w);
		q8tk_adjustment_clamp_page(widget->stat.scrolled.hadj,
					   0, c_msx - w);
		adjustment_size(&widget->stat.scrolled.hadj->stat.adj,
				&tmp, &tmp);

		q8tk_adjustment_set_length(widget->stat.scrolled.vadj, h);
		q8tk_adjustment_clamp_page(widget->stat.scrolled.vadj,
					   0, c_msy - h);
		adjustment_size(&widget->stat.scrolled.vadj->stat.adj,
				&tmp, &tmp);

		if (widget->child->type == Q8TK_TYPE_LISTBOX &&
		    (widget->stat.scrolled.vadj->stat.adj.listbox_changed) &&
		    (widget->stat.scrolled.vadj_value
			!= widget->stat.scrolled.vadj->stat.adj.value)) {
		    list_event_window_scrolled(widget, h);
		}
	    }
	    widget->stat.scrolled.vadj_value
			=  widget->stat.scrolled.vadj->stat.adj.value;
	    widget->stat.scrolled.vadj->stat.adj.listbox_changed = FALSE;
	    widget->sx = widget->stat.scrolled.width;
	    widget->sy = widget->stat.scrolled.height;
	    break;

	case Q8TK_TYPE_ENTRY:			/* ȥ		*/
	    widget->sx = widget->stat.entry.width;
	    widget->sy = 1;
	    break;


	case Q8TK_TYPE_DIALOG:			/* 		*/
	    Q8tkAssert(FALSE, NULL);
	    break;
	case Q8TK_TYPE_FILE_SELECTION:		/* ե륻쥯	*/
	    Q8tkAssert(FALSE, NULL);
	    break;

	default:
	    Q8tkAssert(FALSE, "Undefined type");
	}

    } else {
	widget->sx = 0;
	widget->sy = 0;
    }


		/* 󹹿 */

    *max_sx = Q8TKMAX(widget->sx, n_msx);
    *max_sy = Q8TKMAX(widget->sy, n_msy);
    *sum_sx = widget->sx + n_ssx;
    *sum_sy = widget->sy + n_ssy;


		/* ҥåȤ˥ѥ졼ޤޤϡĴ */

    widget_resize(widget, widget->sx, widget->sy);


		/* ꥹȥܥåʤɤξ硢ҥåȤΥĴ */


    if (widget->type == Q8TK_TYPE_LISTBOX) {
	Q8tkWidget *child = widget->child;
	while (child) {
	    Q8tkAssert(child->type == Q8TK_TYPE_LIST_ITEM, NULL);
	    child->sx = widget->sx;
	    if (child->next) child = child->next;
	    else             break;
	}
    }


/*printf("%s (%02d,%02d) max{ %02d,%02d } sum{ %02d,%02d }\n",debug_type(widget->type),widget->sx,widget->sy,*max_sx,*max_sy,*sum_sx,*sum_sy);fflush(stdout);*/
}


/*
 * ѥ졼ʤɡƤ礭˰¸륦åȤΥƷ׻
 */
static	void	widget_resize(Q8tkWidget *widget, int max_sx, int max_sy)
{
    if (widget->type == Q8TK_TYPE_WINDOW   ||
	widget->type == Q8TK_TYPE_NOTEPAGE ||
	widget->type == Q8TK_TYPE_VBOX     ||
	widget->type == Q8TK_TYPE_HBOX) {

	Q8tkWidget *child = widget->child;
    
	if (widget->type == Q8TK_TYPE_WINDOW &&
	    ! widget->stat.window.no_frame) {
	    max_sx -= 2;
	    max_sy -= 2;
	}
	if (child) widget_resize(child, max_sx, max_sy);

	while (child) {
	    switch (child->type) {

	    case Q8TK_TYPE_HSEPARATOR:
		if (widget->type != Q8TK_TYPE_HBOX) {
		    if (child->sx < max_sx) child->sx = max_sx;
		}
		break;

	    case Q8TK_TYPE_VSEPARATOR:
		if (widget->type != Q8TK_TYPE_VBOX) {
		    if (child->sy < max_sy) child->sy = max_sy;
		}
		break;

	    case Q8TK_TYPE_VBOX:
		if (widget->type == Q8TK_TYPE_VBOX) {
		    if (child->sx < max_sx) child->sx = max_sx;
		}
		break;

	    case Q8TK_TYPE_HBOX:
		if (widget->type == Q8TK_TYPE_HBOX) {
		    if (child->sy < max_sy) child->sy = max_sy;
		}
		break;
	    }

	    if (child->next) child = child->next;
	    else             break;
	}
    }
}



/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*------------------------------------------------------
   åȤɥɥ˴ޤޤ硢
   ֤ˤäƤϡɽʤȤ롣

   ͽᡢΥåȤʲδؿϿƤС

	widget_scrollin_register(this_widget);

   ɽκݤˡΥåȤɽ褦ˡ
   ֤Ĵ褦ˤ롣

   ɥɥˤ륦åȤɽ줿ɤϡ
   ºݤɽޤǤ狼ʤΤǡºݤɽʤ
   ꤷƼǡɽȤȤˤʤ롣

   ĤޤꡢʲΤ褦ʴˤʤ롣

	widget_scrollin_adjust_reset();    ν
	widget_draw();                     

	if (widget_scrollin_adjust()) {    Ĵ鿿
	    widget_draw();                 ĴΤǡ
	}

  ʤԤʤΤϡǽ˸Ĥä Ƥ SCROLLED WINDOW Τ
  ФƤʤΤǡSCROLLED WINDOW ҤξϤɤʤ뤫
  狼ʤ
  ------------------------------------------------------*/

/* ĴǽʥåȤοפ */
#define	MAX_WIDGET_SCROLLIN	(8)
static	struct {
    int		drawn;
    Q8tkWidget	*widget;
} widget_scrollin[ MAX_WIDGET_SCROLLIN ];

/* ν (٤Ԥ) */
static	void	widget_scrollin_init(void)
{
    int i;
    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
	widget_scrollin[i].drawn  = FALSE;
	widget_scrollin[i].widget = NULL;
    }
}
/* åȤϿ */
static	void	widget_scrollin_register(Q8tkWidget *w)
{
    int i;
    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
	if (widget_scrollin[i].widget == w) return;
    }
    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
	if (widget_scrollin[i].widget == NULL) {
	    widget_scrollin[i].drawn  = FALSE;
	    widget_scrollin[i].widget = w;
	    return;
	}
    }
}
/* åȤ˸ƤӽФ */
static	void	widget_scrollin_adjust_reset(void)
{
    int	i;
    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
	widget_scrollin[i].drawn = FALSE;
    }
}
/* ꡧƥåȤ˸ƤӽФ */
static	void	widget_scrollin_drawn(Q8tkWidget *w)
{
    int i;
    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
	if (widget_scrollin[i].widget == w) {
	    widget_scrollin[i].drawn = TRUE;
	    return;
	}
    }
}
/* ĴåȤ˸ƤӽФ */
static	int	widget_scrollin_adjust(void)
{
    int i, result = 0;

    for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {

/*printf("%d %d %s\n",i,widget_scrollin[i].drawn,(widget_scrollin[i].widget)?debug_type(widget_scrollin[i].widget->type):"NULL");*/

	if (widget_scrollin[i].widget) {

	    if (widget_scrollin[i].drawn) {

		Q8tkWidget *widget = widget_scrollin[i].widget;
		Q8tkWidget *p = widget->parent;
		/*int	x1 = widget->x;*/
		int	x1 = widget->x + widget->sx -1;
		int	y1 = widget->y + widget->sy -1;

		/*
		 SCROLLED WINDOW ˾褻륦åΤ򡢺Ȥ
		 а real_y

		 y1 = widget->y + widget->sy -1;
		 p->y + 1 - p->stat.scrolled.child_y0 + [ real_y ] = y1;
		*/

		while (p) {
		    if (p->type == Q8TK_TYPE_SCROLLED_WINDOW) {

			int d, topleft;

			/* d > 0 ʤ顢üɽ */
			/* d < 0 ʤ顢üɽ */
			if (widget->type == Q8TK_TYPE_LIST_ITEM &&
			    widget->parent->type == Q8TK_TYPE_LISTBOX) {
			    d = widget->parent->stat.listbox.scrollin_left;
			} else {
			    d = 0;
			}
			/* d == 0 ϡǥե (-1 Ȥ) */
			if (d == 0) { d = -1; }

			if (d > 0) { topleft = TRUE;    d -= 1; }
			else       { topleft = FALSE;   d += 1; }

			if (topleft) {	   /* üɽ褦˰ */
						        /* d = 0, 1, 2, 3... */
			    /* ʤкüɽΤǡΤޤ */

			} else {	   /* üɽ褦˰ */
						     /* d = 0, -1, -2, -3... */
			    if (p->x +1 <= x1 &&
				x1 < p->x +1 + p->stat.scrolled.child_sx) {
				/* Ok, Expose */
			    } else {
				Q8TK_ADJUSTMENT(p->stat.scrolled.hadj)->value
				    = x1 - (p->x+1 - p->stat.scrolled.child_x0)
					 - p->stat.scrolled.child_sx + 1;
				result = 1;
			    }
			}
			/*  d ͤˤä̤Ѥޤ٤ */


			/* d > 0 ʤ顢üɽ+1١1ʸɽ */
			/* d < 0 ʤ顢üɽ-1١1ʸɽ */
			if (widget->type == Q8TK_TYPE_LIST_ITEM &&
			    widget->parent->type == Q8TK_TYPE_LISTBOX) {
			    d = widget->parent->stat.listbox.scrollin_top;
			} else {
			    d = 0;
			}
			/* d == 0 ϡǥե (-1 Ȥ) */
			if (d == 0) { d = -1; }

			if (d > 0) { topleft = TRUE;    d -= 1; }
			else       { topleft = FALSE;   d += 1; }

			if (topleft) {	   /* üɽ褦˰ */
						        /* d = 0, 1, 2, 3... */
			    if (p->y +1 == (y1-d)) {
				/* Ok */
			    } else {
				Q8TK_ADJUSTMENT(p->stat.scrolled.vadj)->value =
				 (y1-d) - (p->y+1 - p->stat.scrolled.child_y0);
				result = 1;
			    }

			} else {	   /* üɽ褦˰ */
						     /* d = 0, -1, -2, -3... */
			    if (p->y +1 <= (y1-d) &&
				(y1-d) < p->y +1 + p->stat.scrolled.child_sy) {
				/* Ok, Expose */
			    } else {
				Q8TK_ADJUSTMENT(p->stat.scrolled.vadj)->value =
				 (y1-d) - (p->y+1 - p->stat.scrolled.child_y0)
					 - p->stat.scrolled.child_sy + 1;
				result = 1;
			    }
			}

	    /*
	    printf("  %s %d %d %d %d  %d %d %d %d\n",debug_type(p->type),
		   p->x, p->y, p->sx, p->sy,
		   p->stat.scrolled.child_x0, p->stat.scrolled.child_y0,
		   p->stat.scrolled.child_sx, p->stat.scrolled.child_sy);
	    printf("  %s %d %d %d %d\n",debug_type(widget->type),
		   widget->x, widget->y, widget->sx, widget->sy);
	    printf("  %d\n",y1);
	    if (result) printf("ADJ %d,%d\n",
			       Q8TK_ADJUSTMENT(p->stat.scrolled.vadj)->value,
			       Q8TK_ADJUSTMENT(p->stat.scrolled.hadj)->value);
	    */


			break;
		    }
		    p = p->parent;
		}
		widget_scrollin[i].drawn  = FALSE;
		widget_scrollin[i].widget = NULL;
	    }
	}
    }

    return result;
}


/*------------------------------------------------------
   åȤΥեưΥꥹȺ
   
	TAB䡢륭ˤ롢եΰư¸뤿ˡ
	оݤȤʤ륦åȤΥꥹȤ롣

		widget_focus_list_reset()   ꥹȤν
		widget_draw()               衣ǥꥹȤ

	widget_draw() ǤϡեưоݤȤåȤ
	κݤˡwidget_focus_list_append() ؿƤ֡

    TABʤɤ򲡤줿Ȥˡ˥եΰܤ륦åȤˤ
    widget_focus_list_get_next()ٴؿƤ֡
  ------------------------------------------------------*/
/* BACKTAB б  thanks! floi */

static	Q8List		*widget_focus_list;

/* ν (٤Ԥ) */
static	void	widget_focus_list_init(void)
{
    widget_focus_list = NULL;
}
/* åȤ˸ƤӽФ */
static	void	widget_focus_list_reset(void)
{
    q8_list_free(widget_focus_list);
    widget_focus_list = NULL;
}
/* ꡧեꥹȤϿ륦åȤʤ顢ƤӽФ */
static	void	widget_focus_list_append(Q8tkWidget *widget)
{
    if (widget) {
	widget_focus_list = q8_list_append(widget_focus_list, widget);
    }
}
/* եꥹȤƬåȤ */
static	Q8tkWidget *widget_focus_list_get_top(void)
{
    if (widget_focus_list) {
	return (Q8tkWidget *)(widget_focus_list->data);
    } else {
	return NULL;
    }
}
/* եꥹȤμ()ΥåȤ */
static	Q8tkWidget *widget_focus_list_get_next(Q8tkWidget *widget, int back)
{
    Q8List *list;

    if (widget == NULL) {
	return widget_focus_list_get_top();
    }

#if	defined(OLD_FOCUS_CHANGE)
    list = q8_list_find(widget_focus_list, widget);

#else	/* ʥեư */
    switch (widget->type) {
    case Q8TK_TYPE_RADIO_BUTTON:
	{
	    /*  RADIO BUTTON õơ */
	    Q8List *l = widget->stat.button.list;
	    while (l) {
		widget = (Q8tkWidget *)(l->data);
		if (widget->stat.button.active == Q8TK_BUTTON_ON) break;
		l = l->next;
	    }
	}
	list = q8_list_find(widget_focus_list, widget);
	break;

    case Q8TK_TYPE_NOTEPAGE:
	/* ΤȤեΤNOTEPAGEϾ֤
	   ʤΤǡTABդ롣ĤޤꡢˤϤʤ */
	widget = (widget->parent)->stat.notebook.page;
	list = q8_list_find(widget_focus_list, widget);
	break;

    case Q8TK_TYPE_COMBO:
	if (widget->stat.combo.entry->stat.entry.editable == FALSE) {
	    /* ENTRY ԽԲĤξϡCOMBO Ȥ */
	    list = q8_list_find(widget_focus_list, widget);
	} else {
	    /* ENTRY ԽĤξ */
	    if (back == FALSE) {
		/* COMBO μϡENTRY μƱ */
		list = q8_list_find(widget_focus_list,
				    widget->stat.combo.entry);
	    } else {
		/* COMBO ϡENTRY ΤΤˤƤޤ */
		return widget->stat.combo.entry;
	    }
	}
	break;

    default:
	list = q8_list_find(widget_focus_list, widget);
	break;
    }
#endif

    if (list) {
	if (back == FALSE) {
	    if (list->next)  return (Q8tkWidget*)((list->next)->data);
	    else             return (Q8tkWidget*)((q8_list_first(list))->data);
	} else {
	    if (list->prev)  return (Q8tkWidget*)((list->prev)->data);
	    else             return (Q8tkWidget*)((q8_list_last(list))->data);
	}
    }
    return NULL;
}




/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*------------------------------------------------------*/
/* ʬȤɽ֤Ȥˡ褷
   ƵŪˡƤλҥåȤ褹롣		*/
/*------------------------------------------------------*/

static	void	widget_draw(Q8tkWidget *widget,
			    int parent_focus, int parent_sensitive)
{
    int		x = widget->x;
    int		y = widget->y;
    Q8tkWidget	*child = widget->child;
    int		focus, sensitive;
    int		next_focus;
    Q8tkWidget	*sense_widget;

    /* Ƥե꤫Ȥեǡե֤Ȥ*/
    focus = (parent_focus || (widget == get_focus_widget())) ? TRUE : FALSE;

    /* ƤǽǡȤǽʤ顢ǽȤ */
    sensitive = (parent_sensitive && widget->sensitive) ? TRUE : FALSE;
    sense_widget = (sensitive) ? widget : NULL;

    /* ֤˥ե硢̾ʤ */
    next_focus = FALSE;



    widget_scrollin_drawn(widget);


		/* HBOXVBOX λҤξ˸¤ꡢ*/
		/* ֤㴳ѹǤ롣	*/
		/* FRAME ĤǤ˥襷Ȥ褦 */

    if (widget->parent) {
	switch ((widget->parent)->type) {
	case Q8TK_TYPE_FRAME:
	    if        (widget->placement_x == Q8TK_PLACEMENT_X_CENTER) {
		x += ((widget->parent)->sx -2 - widget->sx) / 2;
	    } else if (widget->placement_x == Q8TK_PLACEMENT_X_RIGHT) {
		x += ((widget->parent)->sx -2 - widget->sx);
	    }
	    widget->x = x;
	    break;
	case Q8TK_TYPE_VBOX:
	    if        (widget->placement_x == Q8TK_PLACEMENT_X_CENTER) {
		x += ((widget->parent)->sx - widget->sx) / 2;
	    } else if (widget->placement_x == Q8TK_PLACEMENT_X_RIGHT) {
		x += ((widget->parent)->sx - widget->sx);
	    }
	    widget->x = x;
	    break;
	case Q8TK_TYPE_HBOX:
	    if        (widget->placement_y == Q8TK_PLACEMENT_Y_CENTER) {
		y += ((widget->parent)->sy - widget->sy) / 2;
	    } else if (widget->placement_y == Q8TK_PLACEMENT_Y_BOTTOM) {
		y += ((widget->parent)->sy - widget->sy);
	    }
	    widget->y = y;
	    break;
	}
    }


		/* ʬȤ typeȤȤʤɤ񤯡*/
		/* ҤСx,y 롣		*/
		/* Ҥ(next)Ρx,y 롣	*/
		/* ľλҤФƤΤߺƵŪ˽	*/

/*printf("%s (%d,%d) %d %d\n",debug_type(widget->type),widget->sx,widget->sy,widget->x,widget->y);fflush(stdout);*/

    if (widget->visible) {

	switch (widget->type) {

	case Q8TK_TYPE_WINDOW:			/* ɥ		*/
	    if (widget->stat.window.no_frame) {
		/* no frame */
	    } else {
		q8gr_draw_window(x, y, widget->sx, widget->sy,
				 widget->stat.window.shadow_type,
				 (widget->stat.window.type
					== Q8TK_WINDOW_POPUP)
						? Q8GR_WIDGET_WINDOW : NULL);
	    }
	    if (child) {
		child->x = x  + (widget->stat.window.no_frame ? 0 : 1);
		child->y = y  + (widget->stat.window.no_frame ? 0 : 1);
		widget_draw(child, FALSE, sensitive);
	    }
	    break;

	case Q8TK_TYPE_BUTTON:			/* ܥ		*/
	case Q8TK_TYPE_TOGGLE_BUTTON:		/* ȥܥ		*/
	    widget_focus_list_append(sense_widget);
	    q8gr_draw_button(x, y, widget->sx, widget->sy,
			     widget->stat.button.active, sense_widget);
	    if (child) {
		child->x = x + 1;
		child->y = y + 1;
		widget_draw(child, focus, sensitive);
	    }
	    break;

	case Q8TK_TYPE_CHECK_BUTTON:		/* åܥ	*/
	    widget_focus_list_append(sense_widget);
	    q8gr_draw_check_button(x, y, widget->stat.button.active,
				   sense_widget);
	    if (child) {
		child->x = x + 3;
		child->y = y;
		widget_draw(child, focus, sensitive);
	    }
	    break;

	case Q8TK_TYPE_RADIO_BUTTON:		/* 饸ܥ		*/
#if	defined(OLD_FOCUS_CHANGE)
	    widget_focus_list_append(sense_widget);
#else	/* ʥեư */
	    if (widget->stat.button.active == Q8TK_BUTTON_ON) {
		widget_focus_list_append(sense_widget);
	    }
#endif
	    q8gr_draw_radio_button(x, y, widget->stat.button.active,
				   sense_widget);
	    if (child) {
		child->x = x + 3;
		child->y = y;
		widget_draw(child, focus, sensitive);
	    }
	    break;

	case Q8TK_TYPE_FRAME:			/* ե졼		*/
	    q8gr_draw_frame(x, y, widget->sx, widget->sy,
			    widget->stat.frame.shadow_type,
			    widget->code, widget->name,
			    sense_widget);
	    if (child) {
		child->x = x + 1;
		child->y = y + 1;
		widget_draw(child, FALSE, sensitive);
	    }
	    break;

	case Q8TK_TYPE_LABEL:			/* ٥		*/
	    q8gr_draw_label(x, y,
			    widget->stat.label.foreground,
			    widget->stat.label.background,
			    widget->stat.label.reverse,
			    focus,
			    (widget->name) ? (widget->code) : Q8TK_KANJI_ANK,
			    (widget->name) ? (widget->name) : "",
			    sense_widget);
	    break;

	case Q8TK_TYPE_LOGO:			/* 			*/
	    q8gr_draw_logo(x, y);
	    break;

	case Q8TK_TYPE_NOTEBOOK:		/* Ρȥ֥å		*/
	    q8gr_draw_notebook(x, y, widget->sx, widget->sy,
			       widget, sense_widget);
	    if (child) {
		child->x = x;
		child->y = y;
		widget_draw(child, FALSE, sensitive);
	    }
	    break;
	case Q8TK_TYPE_NOTEPAGE:		/* Ρȥڡ		*/
	    {
		int select_flag =
			      (widget == (widget->parent)->stat.notebook.page);

		q8gr_draw_notepage((widget->name) ? widget->code
						  : Q8TK_KANJI_ANK,
				   (widget->name) ? widget->name : "",
				   select_flag,
				   /*(select_flag) ? FALSE :*/ focus,
				   widget->parent,
				   sense_widget);
		if (child && select_flag) {
		    child->x = ((widget->parent)->x) + 1;
		    child->y = ((widget->parent)->y) + 3;
		    widget_focus_list_append(widget);
		    widget_draw(child, FALSE, sensitive);
		}
#if	defined(OLD_FOCUS_CHANGE)
		else {
		    widget_focus_list_append(sense_widget);
		}
#endif
	    }
	    break;

	case Q8TK_TYPE_VBOX:			/* ľܥå		*/
	    if (child) {
		child->x = x;	x += 0;
		child->y = y;	y += child->sy;
		while (child->next) {
		    child = child->next;
		    child->x = x;	x += 0;
		    child->y = y;	y += child->sy;
		}
		child = widget->child;
		widget_draw(child, FALSE, sensitive);
	    }
	    break;
	case Q8TK_TYPE_HBOX:			/* ʿܥå		*/
	    if (child) {
		child->x = x;	x += child->sx;
		child->y = y;	y += 0;
		while (child->next) {
		    child = child->next;
		    child->x = x;	x += child->sx;
		    child->y = y;	y += 0;
		}
		child = widget->child;
		widget_draw(child, FALSE, sensitive);
	    }
	    break;

	case Q8TK_TYPE_VSEPARATOR:		/* ľڤ		*/
	    q8gr_draw_vseparator(x, y, widget->sy);
	    break;
	case Q8TK_TYPE_HSEPARATOR:		/* ʿڤ		*/
	    q8gr_draw_hseparator(x, y, widget->sx);
	    break;

	case Q8TK_TYPE_COMBO:			/* ܥܥå	*/
	    widget->stat.combo.entry->x  = x;
	    widget->stat.combo.entry->y  = y;
	    widget->stat.combo.entry->sx = widget->sx -3;
	    widget_draw(widget->stat.combo.entry, FALSE, sensitive);

#if	defined(OLD_FOCUS_CHANGE)
	    widget_focus_list_append(sense_widget);
#else	/* ʥեư */
	    if (widget->stat.combo.entry->stat.entry.editable == FALSE) {
		widget_focus_list_append(sense_widget);
	    }
#endif
	    q8gr_draw_combo(x, y, widget->sx -3, focus, sense_widget);
	    break;

	case Q8TK_TYPE_LISTBOX:			/* ꥹȥܥå	*/
	    widget_focus_list_append(sense_widget);
	    if (child) {
		child->x = x;	x += 0;
		child->y = y;	y += child->sy;
		while (child->next) {
		    child = child->next;
		    child->x = x;	x += 0;
		    child->y = y;	y += child->sy;
		}
		child = widget->child;
		widget_draw(child, focus, sensitive);
	    }
	    break;

	case Q8TK_TYPE_LIST_ITEM:		/* ꥹȥƥ	*/
	    if (child) {
		int rev   = (widget->parent->stat.listbox.selected == widget)
								? TRUE : FALSE;
		int under = (widget->parent->stat.listbox.active == widget)
								? TRUE : FALSE;
		if (rev && under) under = FALSE;

		q8gr_draw_list_item(x, y, widget->sx, focus, rev,
				    under, child->code, child->name,
				    sense_widget);
	    }
	    next_focus = focus; 
	    break;

	case Q8TK_TYPE_ADJUSTMENT:		/* 㥹ȥ	*/
	    Q8tkAssert(FALSE, NULL);
	    break;

	case Q8TK_TYPE_HSCALE:			/* ʿ		*/
	    if (widget->stat.scale.adj) {
		int a_focus = (focus ||
			       (widget->stat.scale.adj == get_focus_widget()))
								? TRUE : FALSE;
		Q8tkWidget *a_widget = ((sensitive) ? widget->stat.scale.adj
						    : NULL);
		widget_focus_list_append(a_widget);
		widget->stat.scale.adj->x = x;
		widget->stat.scale.adj->y = y;
		q8gr_draw_hscale(x, y,
				 &(widget->stat.scale.adj->stat.adj),
				 a_focus,
				 widget->stat.scale.draw_value,
				 widget->stat.scale.value_pos,
				 a_widget);
	    }
	    break;
	case Q8TK_TYPE_VSCALE:			/* ľ		*/
	    if (widget->stat.scale.adj) {
		int a_focus = (focus ||
			       (widget->stat.scale.adj == get_focus_widget()))
								? TRUE : FALSE;
		Q8tkWidget *a_widget = ((sensitive) ? widget->stat.scale.adj
						    : NULL);
		widget_focus_list_append(a_widget);
		widget->stat.scale.adj->x = x;
		widget->stat.scale.adj->y = y;
		q8gr_draw_vscale(x, y,
				 &(widget->stat.scale.adj->stat.adj),
				 a_focus,
				 widget->stat.scale.draw_value,
				 widget->stat.scale.value_pos,
				 a_widget);
	    }
	    break;

	case Q8TK_TYPE_SCROLLED_WINDOW:		/* ɥɥ */
	    if (child) {
		int a_focus;
		Q8tkWidget *a_widget;

		int sx = widget->sx;
		int sy = widget->sy;

		if (widget->stat.scrolled.vscrollbar) { sx --; }
		if (widget->stat.scrolled.hscrollbar) { sy --; }

		q8gr_draw_scrolled_window(x, y, sx, sy,
					  Q8TK_SHADOW_ETCHED_OUT,
					  sense_widget);
		q8gr_set_screen_mask(x+1, y+1, sx-2, sy-2);
		widget->stat.scrolled.child_x0
				= widget->stat.scrolled.hadj->stat.adj.value;
		widget->stat.scrolled.child_y0
				= widget->stat.scrolled.vadj->stat.adj.value;
		widget->stat.scrolled.child_sx = sx -2;
		widget->stat.scrolled.child_sy = sy -2;

		child->x = x - widget->stat.scrolled.child_x0 +1;
		child->y = y - widget->stat.scrolled.child_y0 +1;

		widget_draw(child, FALSE, sensitive);
		q8gr_reset_screen_mask();

		if (widget->stat.scrolled.vscrollbar) {
		    a_focus = (focus ||
			(widget->stat.scrolled.vadj == get_focus_widget()))
								? TRUE : FALSE;
		    a_widget = ((sensitive) ? widget->stat.scrolled.vadj
					    : NULL);
		    /* եꥹȤˤʤۤΤǤϡ */
		    widget_focus_list_append(a_widget);
		    q8gr_draw_vscale(x + sx, y,
				     &(widget->stat.scrolled.vadj->stat.adj),
				     a_focus,
				     FALSE, 0,
				     a_widget);
		}
		if (widget->stat.scrolled.hscrollbar) {
		    a_focus = (focus ||
			(widget->stat.scrolled.hadj == get_focus_widget()))
								? TRUE : FALSE;
		    a_widget = ((sensitive) ? widget->stat.scrolled.hadj
					    : NULL);
		    /* եꥹȤˤʤۤΤǤϡ */
		    widget_focus_list_append(a_widget);
		    q8gr_draw_hscale(x, y + sy,
				     &(widget->stat.scrolled.hadj->stat.adj),
				     a_focus,
				     FALSE, 0,
				     a_widget);
		}
	    } else {
		q8gr_draw_window(x, y, widget->sx, widget->sy,
				 Q8TK_SHADOW_ETCHED_OUT,
				 NULL);
	    }
	    break;

	case Q8TK_TYPE_ENTRY:			/* ȥ		*/
	    if (widget->stat.entry.editable) {
		widget_focus_list_append(sense_widget);
	    }
	    if (focus &&
		widget->stat.entry.editable &&
		widget->stat.entry.cursor_pos < 0) {
		q8tk_entry_set_position(widget,
				      q8gr_strlen(widget->code, widget->name));
	    }

	    q8gr_draw_entry(x, y, widget->sx, widget->code, widget->name,
			    widget->stat.entry.disp_pos,
			    ((focus && widget->stat.entry.editable)
					? widget->stat.entry.cursor_pos: -1),
			    sense_widget);
	    break;

	case Q8TK_TYPE_DIALOG:			/* 		*/
	    Q8tkAssert(FALSE, NULL);
	    break;
	case Q8TK_TYPE_FILE_SELECTION:		/* ե륻쥯	*/
	    Q8tkAssert(FALSE, NULL);
	    break;

	default:
	    Q8tkAssert(FALSE, "Undefined type");
	}
    }


	/* ʬȤ (next) ¸ߤСƵŪ˽ */
  
    if (widget->next) {
	widget = widget->next;
	widget_draw(widget, next_focus, parent_sensitive);
    }
}














/*------------------------------------------------------*/
/* ꡼̤
   q8tk_grab_add() ꤵ줿 WINDOW ȥåפȤơ
   ƤλҥåȤ礭֤׻
   menu_screen[][]ˡɽƤꤹ롣
   ƱˡTAB 򲡤줿Ρեѹ
   Ƥ					*/
/*------------------------------------------------------*/

static	void	widget_construct(void)
{
    int		i, j, tmp;
    Q8tkWidget	*widget;

    q8gr_clear_screen();

    for (i=0; i<MAX_WINDOW_LAYER; i++) {

	widget = window_layer[i];

	if (widget) {
	    Q8tkAssert(widget->type == Q8TK_TYPE_WINDOW, NULL);

	    for (j=0; j<2; j++) {

		q8gr_clear_focus_screen();

		widget_size(widget, &tmp, &tmp, &tmp, &tmp);

		if (widget->stat.window.set_position == FALSE) {
		    widget->x = (Q8GR_SCREEN_X - widget->sx) / 2;
		    widget->y = (Q8GR_SCREEN_Y - widget->sy) / 2;
		} else {
		    widget->x = widget->stat.window.x;
		    widget->y = widget->stat.window.y;
		}

		widget_scrollin_adjust_reset();

		widget_focus_list_reset();
		widget_draw(widget, FALSE, widget->sensitive);

		if (widget_scrollin_adjust()) {
		    /* Redraw! */
		} else {
		    break;
		}

	    }

	} else {
	    break;
	}
    }


    if (get_focus_widget() == NULL) {
	q8tk_widget_set_focus(widget_focus_list_get_top());
    }

#if 0
    if (get_drag_widget()) {
	/* none */
    } else {
	Q8tkWidget *w;
	int exist;

	w = q8tk_tab_top_widget;

	if (w) {

	    do {			/* TAB TOP  NOTEPAGE ʳ */
		if (w->type != Q8TK_TYPE_NOTEPAGE) break;
		w = w->tab_next;
	    } while (w != q8tk_tab_top_widget);
	    q8tk_tab_top_widget = w;

	    exist = FALSE;		/* event_widget ºߤ뤫å */
	    do {			
		if (w == get_event_widget()) {
		    exist = TRUE;
		    break;
		}
		w = w->tab_next;
	    } while (w != q8tk_tab_top_widget);
	    if (! exist) {		/*    ºߤʤ NULL ˤƤ */
		set_event_widget(NULL);
	    }
	}
    }
#endif

    if (disp_cursor) {
	q8gr_draw_mouse(mouse.x/8, mouse.y/16);
    }


#if 0
{
 int i, j; const char *c; void *w;
 for (j=0; j<Q8GR_SCREEN_Y; j++) {
  for (i=0; i<Q8GR_SCREEN_X; i++) {
    w = q8gr_get_focus_screen(i, j);
    if      (w == Q8GR_WIDGET_NONE)   c = " ";
    else if (w == Q8GR_WIDGET_WINDOW) c = "*";
    else                              c = debug_type(((Q8tkWidget *)w)->type);
    printf("%c", *c);
  }
  printf("\n");
 }
 printf("\n");
 fflush(0);
}
#endif

#if 0
{
 int i;
 for (i=0; i<MAX_WIDGET_SCROLLIN; i++) {
  Q8tkWidget *w = widget_scrollin[i].widget;
  printf("%d [%s] %p\n",widget_scrollin[i].drawn,(w)?debug_type(w->type):"",w);
 }
 printf("--\n");fflush(0);
}
#endif

#if 0
 for (tmp=0,i=0; i<MAX_WIDGET; i++) { if (widget_table[i]) tmp++; }
 printf("[TOTAL WIDGET] %d/%d : ",tmp,MAX_WIDGET);
 for (tmp=0,i=0; i<MAX_LIST; i++) { if (list_table[i]) tmp++; }
 printf("[TOTAL LIST] %d/%d\n",tmp,MAX_LIST);
#endif
}
