/************************************************************************/
/*									*/
/* FDC   ǥ᡼ɤ߽				*/
/*									*/
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "quasi88.h"
#include "initval.h"
#include "drive.h"
#include "image.h"
#include "fdc.h"

#include "emu.h"		/* emu_mode			*/
#include "pc88cpu.h"

#include "file-op.h"
#include "suspend.h"
#include "status.h"
#include "event.h"
#include "snddrv.h"



static int fdc_break_flag = FALSE;

int	fdc_debug_mode = FALSE;	/* FDC ǥХå⡼ɤΥե饰		*/
int	disk_exchange = FALSE;	/* ǥؤե饰		*/
int	disk_ex_drv = 0;	/* ǥؤɥ饤		*/
				/*    drive 1 ... bit 0			*/
				/*    drive 2 ... bit 1			*/
/* 嵭ϡpeach󶡤ˤ */

int	FDC_flag = 0;			/* FDC ߿		*/
int	fdc_wait = 0;			/* FDC   0̵ 1ͭ	*/

int	fdc_ignore_readonly = FALSE;	/* ɹѻ饤Ȥ̵뤹	*/


/* FDCΥΥ
   Ϣ³ǥ硢ֳ֤ǲФ褦ˤ롣
   ϥɥ饤ΥʤΤޤ
   Υϡơȥ֤ʤ */
static	int	fdc_sound_counter;
static	int	fdc_sound_skipper = 1;	/* SEEK 4˲Ф */

#define	MAX_DRIVE	(4)		/* FDCǰɥ饤ֿ	*/
					/*  NR_DRIVE(==2)б	*/



/*
 * ǥ᡼˴ؤ (ɥ饤ñ)
 */
PC88_DRIVE_T	drive[ NR_DRIVE ];


/*
 * ǥ᡼饻ɤݤΡǼ
 */
static	struct{
  Uchar   c;			/*  ID  C	*/
  Uchar   h;			/*  ID  H	*/
  Uchar   r;			/*  ID  R	*/
  Uchar   n;			/*  ID  N	*/
  Uchar   density;		/* εϿ̩	*/
  Uchar   deleted;		/* DELETED DATA ե饰	*/
  Uchar   status;		/* PC98 BIOSΥơ*/
  Uchar   padding;
  int     sec_nr;		/* ȥåΥ	*/
  int	  size;			/* DATA 		*/

  int	  drv;			/* ξ󸵤Υɥ饤	*/
} sec_buf;


/*
 * READ / WRITE ΥǡϤ˥å
 *	WRITE ID Ǥϡ4Хȥǡߥ򤳤˥åȤ롣
 *	READ DIAGNOSTIC Ǥϡ٥ǡΥ᡼˺롣
 */

#define DATA_BUF_SIZE 0x4000	/*  2D/2DD=6250byte2HD=10416byte ? */

static	Uchar	data_buf[ DATA_BUF_SIZE ];


/*
 * FDC γƼ
 *	ۥȤäޥɡΥơϡˡ
 */
static	struct{

  int	command;		/* ޥ (enum)			*/
  int	phase;			/* PHASE (C/E/R)			*/
  int	step;			/* PAHSEν			*/
  int	counter;		/* Ƽ參				*/
  int	data_ptr;		/* ǡžΥݥ(data_buf)	*/

  int	limit;			/* ǡžॢȥ󥫥 */
  int	wait;			/* ¹ԳϤޤǤΥ		*/
  int	carry;			/* ޤǤΥȷۤʬ	*/
  int	gap3;			/* ޤǤGAP3Υʬ		*/

  enum {			/* 				*/
    SEEK_STAT_STOP = 0,		/* 		ʤ 		*/
    SEEK_STAT_MOVE,		/* 		   		*/
    SEEK_STAT_END,		/* 		λ 		*/
    SEEK_STAT_INTR		/* 		λ		*/
  }	seek_stat[MAX_DRIVE];
  int	seek_wait[MAX_DRIVE];	/* ѥ			*/

  int	srt_clk;		/* SRT (ȴ)			*/
  int	hut_clk;		/* HUT (ȴ)			*/
  int	hlt_clk;		/* HLT (ȴ)			*/
  int	hl_stat[MAX_DRIVE];	/* إåɥɾ֤ʤ顢		*/
  int	hl_wait[MAX_DRIVE];	/* إåɥѥ		*/

  int	ddam_not_skipped;	/* DDAMʤΤ˥åפʤä顢	*/

  byte	status;			/* STATUS		*/
  byte	read;			/* DATA  for  FDC->MAIN */
  byte	write;			/* DATA  for  FDC<-MAIN */
  byte	TC;			/* TC (1 or 0 )		*/

  Uchar	sk;			/* SK ӥå		*/
  Uchar	mf;			/* MF ӥå		*/
  Uchar	mt;			/* MT ӥå		*/
  Uchar	us;			/* US ֹ		*/
  Uchar	hd;			/* HD ¦		*/
  Uchar	c;			/* ID - C		*/
  Uchar	h;			/* ID - H		*/
  Uchar	r;			/* ID - R		*/
  Uchar	n;			/* ID - N		*/
  Uchar	eot;			/* EOT ֹ		*/
  Uchar	gpl;			/* GPL Ĺ		*/
  Uchar	dtl;			/* DTL Ĺ		*/
  Uchar	d;			/* D   ǡ		*/
  Uchar	sc;			/* SC  		*/
  Uchar	stp;			/* STP ֳ		*/
  Uchar	ncn[MAX_DRIVE];		/* NCN  (4ʬ)	*/
  Uchar	pcn[MAX_DRIVE];		/* PCN  (4ʬ)	*/
  Uchar	st0;			/* ST0			*/
  Uchar	st1;			/* ST1			*/
  Uchar	st2;			/* ST2			*/
  Uchar	st3;			/* ST3			*/

  Uchar c0;			/* C-Phase 1Х	*/
  Uchar c1;			/* C-Phase 2Х	*/
  Uchar cn;			/* C-Phase NCN		*/
  Uchar s0;			/* C-Phase SPECIFY	*/
  Uchar s1;			/* C-Phase SPECIFY	*/
  Uchar r0;			/* R-Phase ST0		*/
  Uchar r1;			/* R-Phase PCN		*/
  Uchar	intr_unit;		/* ȯ˥å	*/

} fdc;


/* Ƽޥ */


#define	disk_not_exist(drv)	(drive[drv].fp==NULL  || drive[drv].empty)
#define	disk_unformat(drv)	(drive[drv].sec_nr<=0 || drive[drv].empty)
#define disk_unformatable(drv)	(drive[drv].sec_nr<0  || drive[drv].empty)

#define	sector_density_mismatch()					\
		(((sec_buf.density==DISK_DENSITY_SINGLE)&&( fdc.mf))||	\
		 ((sec_buf.density==DISK_DENSITY_DOUBLE)&&(!fdc.mf)) )

#define	idr_match()							\
		( fdc.c==sec_buf.c && fdc.h==sec_buf.h &&		\
		  fdc.r==sec_buf.r && fdc.n==sec_buf.n )

#define	printf_system_error( code )					      \
    do{									      \
      if     ( code==1 ) printf("FDC Read/Write Error in DRIVE %d:\n", drv+1);\
      else if( code==2 ) printf("FDC Seek Error in DRIVE %d:\n", drv+1);      \
      else if( code==3 ) printf("FDC Over-size Error in DRIVE %d:\n", drv+1); \
      else               printf("Internal error !\n");			      \
    }while(0)


/*	------ ǥ᡼Υơ ------			*/
/*		ºݤ˰̣Τ륹ơϰʲΤȤ		*/
/*			STATUS_MA	Υ ID ̵		*/
/*			STATUS_DE	ID CRC Error			*/
/*			STATUS_MA_MD	Υ DATA ̵	*/
/*			STATUS_DE_DD	DATA CRC Error			*/
/*			STATUS_CM	 (DELETED DATA )	*/
/*			¾						*/

#define	STATUS_NORMAL	(0x00)		/* Normal End			*/
#define	STATUS_CM	(0x10)		/* Control Mark			*/
#define	STATUS_ALIGN	(0x20)		/* Alignment Error		*/
#define	STATUS_EN	(0x30)		/* End of Cylinder		*/
#define STATUS_EC	(0x40)		/* Equipment Check		*/
#define	STATUS_OR	(0x50)		/* Over Run			*/
#define	STATUS_NR	(0x60)		/* Not Ready			*/
#define	STATUS_NW	(0x70)		/* Not Writable			*/
#define	STATUS_UNDEF	(0x80)		/* Another Error		*/
#define	STATUS_TMOUT	(0x90)		/* Time out			*/
#define	STATUS_DE	(0xa0)		/* Data Error (ID)		*/
#define	STATUS_DE_DD	(0xb0)		/* Data Error (DATA)		*/
#define	STATUS_ND	(0xc0)		/* No Data			*/
#define	STATUS_BC	(0xd0)		/* Bad Cylinder			*/
#define	STATUS_MA	(0xe0)		/* Missing Address Mark (ID)	*/
#define	STATUS_MA_MD	(0xf0)		/* Missing Address Mark (DATA)	*/




/* FDC  ơ */

#define FD0_BUSY	(0x01)
#define	FD1_BUSY	(0x02)
#define	FD2_BUSY	(0x04)
#define	FD3_BUSY	(0x08)
#define FDC_BUSY	(0x10)
#define NON_DMA		(0x20)
#define DATA_IO		(0x40)
#define	REQ_MASTER	(0x80)

/* FDC  ꥶȥơ */

#define	ST0_US		(0x03)		/* Unit Select			*/
#define	ST0_HD		(0x04)		/* Head Address			*/
#define	ST0_NR		(0x08)		/* Not Ready			*/
#define	ST0_EC		(0x10)		/* Equipment Check		*/
#define	ST0_SE		(0x20)		/* Seek End			*/
#define	ST0_IC		(0xc0)		/* Interrupt Code		*/
#define	ST0_IC_NT	(0x00)		/* 	Normal Terminate	*/
#define	ST0_IC_AT	(0x40)		/* 	Abnormal Terminate	*/
#define	ST0_IC_IC	(0x80)		/* 	Invalid Command		*/
#define	ST0_IC_AI	(0xc0)		/* 	Attention Interrupt	*/

#define	ST1_MA		(0x01)		/* Missing Address Mark		*/
#define	ST1_NW		(0x02)		/* Not Writable			*/
#define	ST1_ND		(0x04)		/* No Data			*/
#define	ST1_OR		(0x10)		/* Over Run			*/
#define	ST1_DE		(0x20)		/* Data Error			*/
#define	ST1_EN		(0x80)		/* End of Cylinder		*/

#define	ST2_MD		(0x01)		/* Missing Address Mark in Data	*/
#define	ST2_BC		(0x02)		/* Bad Cylinder			*/
#define	ST2_SN		(0x04)		/* Scan Not Satisfied		*/
#define	ST2_SH		(0x08)		/* Scan Equal Hit		*/
#define	ST2_NC		(0x10)		/* No Cylinder			*/
#define	ST2_DD		(0x20)		/* Data Error in Data Files	*/
#define	ST2_CM		(0x40)		/* Control Mark			*/

#define	ST3_US		(0x03)		/* Unit Select			*/
#define	ST3_HD		(0x04)		/* Head Address			*/
#define	ST3_TS		(0x08)		/* Two Side			*/
#define	ST3_T0		(0x10)		/* Track 0			*/
#define	ST3_RY		(0x20)		/* Ready			*/
#define	ST3_WP		(0x40)		/* Write Protect		*/
#define	ST3_FT		(0x80)		/* Fault			*/



/* FDC  ޥ */

enum FdcCommand
{
  WAIT			= 0,		/* Ԥξ */
  READ_DATA,
  READ_DELETED_DATA,
  READ_DIAGNOSTIC,
  READ_ID,
  WRITE_DATA,		/* = 5 */
  WRITE_DELETED_DATA,
  WRITE_ID,
  SCAN_EQUAL,
  SCAN_LOW_OR_EQUAL,
  SCAN_HIGH_OR_EQUAL,	/* = 10 */
  SEEK,
  RECALIBRATE,
  SENSE_INT_STATUS,
  SENSE_DEVICE_STATUS,
  SPECIFY,		/* = 15 */
  INVALID,
  EndofFdcCmd
};
enum FdcPhase
{
  C_PHASE,
  E_PHASE,
  R_PHASE,
  EndofFdcPhase
};

static const char *cmd_name[] =	/* ǥХåɽǡ */
{
  "WAIT ------------------",
  "READ DATA -------------",
  "READ DELETED DATA -----",
  "READ DIAGNOSTIC -------",
  "READ ID ---------------",
  "WRITE DATA ------------",
  "WRITE DELETED DATA ----",
  "WRITE ID --------------",
  "SCAN EQUAL ------------",
  "SCAN LOW OR EQUAL -----",
  "SCAN HIGH OR EQUAL ----",
  "SEEK ------------------",
  "RECALIBRATE -----------",
  "SENSE INT STATUS ------",
  "SENSE DEVIC STATUS ----",
  "SPECIFY ---------------",
  "INVALID ---------------",
};







/************************************************************************/
/* fdc ǥХå								*/
/************************************************************************/
/*
 * FDC ǥХåϡpeachˤ󶡤ޤ
 */
void pc88fdc_break_point(void)
{
    int i;
    for(i = 0; i < NR_BP; i++){
	if (break_point_fdc[i].type != BP_NONE) {
	    fdc_break_flag = TRUE;
	    return;
	}
    }
    fdc_break_flag = FALSE;
}


#ifndef	USE_MONITOR

#define	print_fdc_status(nStatus,nDrive,nTrack,nSector)

#else	/* USE_MONITOR */

void print_fdc_status(int nStatus, int nDrive, int nTrack, int nSector)
{
    static int oDrive = -1;
    static int oTrack[2];
    static int oSector[2];
    static int oStatus;
    char c = ' ';
    int i;
    
    if (fdc_debug_mode == TRUE) {
	if (oDrive < 0 || nStatus != oStatus || nDrive != oDrive ||
	    nTrack != oTrack[nDrive])
	{
	    oStatus = nStatus;
	    oDrive = nDrive;
	    oTrack[oDrive] = nTrack;
	    oSector[oDrive] = nSector;
	    switch (nStatus) {
	    case BP_READ:  c = 'R'; break;
	    case BP_WRITE: c = 'W'; break;
	    case BP_DIAG:  c = 'D'; break;
	    }
	    printf("\n%c D:%d T:%d S:%d", c, nDrive+1, nTrack, nSector+1);
	    fflush(stdout);
	} else if (nSector != oSector[nDrive]){
	    oSector[nDrive] = nSector;
	    printf(",%d", nSector+1);
	    fflush(stdout);
	}
    }
    
    if (fdc_break_flag == TRUE) {
	for (i = 0; i < NR_BP; i++) {
	    if (break_point_fdc[i].type == nStatus &&
	        break_point_fdc[i].drive == nDrive + 1 &&
		break_point_fdc[i].track == nTrack) {
		if (break_point_fdc[i].sector == nSector + 1 ||
		    break_point_fdc[i].sector < 0) {
		    printf( "*** Break at D:%d T:%d S:%d *** ",
			    nDrive + 1, nTrack, nSector + 1);
		    switch (nStatus) {
		    case BP_READ:  printf("( Read )\n"); break;
		    case BP_WRITE: printf("( Write )\n"); break;
		    case BP_DIAG:  printf("( Diag )\n"); break;
	 	    }
		    quasi88_debug();
		    break;
		}
	    }
	}
    }
 
}
#endif	/* USE_MONITOR */

/************************************************************************/
/* ֤                                                     */
/************************************************************************/
/*
 * READ DIAG Υ֤Υǡϡpeachˤ󶡤ޤ
 */
static int fill_sector_gap(int ptr, int drv, Uchar fdc_mf);








/************************************************************************/
/* ɥ饤֤ν							*/
/************************************************************************/
static	void	fdc_init( void );
void	drive_init( void )
{
  int	i;

  fdc_init();

  for( i=0; i<NR_DRIVE; i++ ){
    drive[ i ].fp     = NULL;
    drive[ i ].sec_nr = -1;
    drive[ i ].empty  = TRUE;
    /* memset( drive[ i ].filename, 0, QUASI88_MAX_FILENAME ); */
  }
  disk_ex_drv = 0;

  sec_buf.drv = -1;
}


/************************************************************************/
/* ɥ饤֤Υꥻåȡ(ꤵƤ륤᡼˥)	*/
/************************************************************************/
void	drive_reset( void )
{
  int	i;

  fdc_init();

  for( i=0; i<NR_DRIVE; i++ ){
    if( drive[ i ].fp ){
      disk_change_image( i, drive[ i ].selected_image );
    }
  }
  disk_ex_drv = 0;
}



/************************************************************************/
/* ɥ饤֤Ū˶ˤ롿Ȥ᤹ؤ롿ɤäξ֤Τ	*/
/*	drvĥɥ饤(0/1)						*/
/************************************************************************/
void	drive_set_empty( int drv )
{
  drive[ drv ].empty  = TRUE;
}
void	drive_unset_empty( int drv )
{
  drive[ drv ].empty  = FALSE;
}
void	drive_change_empty( int drv )
{
  drive[ drv ].empty  ^= 1;
}
int	drive_check_empty( int drv )
{
  return drive[ drv ].empty;
}



/***********************************************************************
 * ɥ饤 ˥ǥ
 *	drv		ɥ饤 0 / 1
 *	filename	ե̾
 *	img		᡼ֹ 031
 *			ϰϳʤ¸ߤʤ᡼ֹξ 0 Ȥ
 *	readonly	ʤ顢꡼ɥ꡼ǥե򳫤
 *			ʤ顢꡼ɥ饤Ȥǥե򳫤
 *
 *	顼ϡǥ򥻥åȤ 1 ֤
 ************************************************************************/

/* 顼ɽ( s ϥå\n ϥ) ǥϥȤ */

#define		DISK_ERROR( s, drv )					\
  do {									\
    if (quasi88_is_menu() == FALSE) {					\
      printf( "\n" );				 			\
      printf( "[[[ %-26s ]]]\n", s );				  	\
      printf( "[[[   Eject Disk from drive %d: ]]]\n" "\n", drv+1 ); 	\
    }									\
    disk_eject( drv );							\
  } while(0)

/* ٹɽ( fmt ϡ"%s %d \n" ޤ) ǥϤΤޤ */

#define		DISK_WARNING( fmt, s, n )				\
  do {									\
    if( verbose_proc ){							\
      printf( fmt, s, n );						\
    }									\
  } while(0)




int	disk_insert( int drv, const char *filename, int img, int readonly )
{
  int	exit_flag;
  Uchar c[32];
  long	offset;
  int	num;

  int	open_as_readonly = readonly;

  		/* ߤΥǥϥ */

  disk_eject( drv );


		/* ե̾ФƤ */
  /*
  if( strlen(filename) >= QUASI88_MAX_FILENAME ){
    DISK_ERROR( "filename too long", drv );
    return 1;
  }
  strcpy( drive[ drv ].filename, filename );
  */

		/* "r+b" ǥե򳫤ʤ "rb" ǥե򳫤 */

  if( open_as_readonly == FALSE ){
    drive[ drv ].fp = osd_fopen( FTYPE_DISK, filename, "r+b" );
  }
  if( drive[ drv ].fp == NULL ){
    drive[ drv ].fp = osd_fopen( FTYPE_DISK, filename, "rb" );
    open_as_readonly = TRUE;
  }

  if( drive[ drv ].fp == NULL ){
    DISK_ERROR( "Open failed", drv );
    return 1;
  }



	/* ȿ¦Υɥ饤֤ΥեƱեä	*/
	/*			ȿ¦ɥ饤֤Υ򥳥ԡ	*/
	/* Ǥʤ	ɥ饤֤Υ	*/

  if( drive[ drv ].fp == drive[ drv^1 ].fp ){	/* ȿХɥ饤֤Ʊ */

/*  drive[ drv ].file_size           = drive[ drv^1 ].file_size;*/
    drive[ drv ].read_only           = drive[ drv^1 ].read_only;
    drive[ drv ].over_image          = drive[ drv^1 ].over_image;
    drive[ drv ].detect_broken_image = drive[ drv^1 ].detect_broken_image;
    drive[ drv ].image_nr            = drive[ drv^1 ].image_nr;
    memcpy( &drive[ drv   ].image,
	    &drive[ drv^1 ].image, sizeof(drive[ drv ].image) );

    if( drv==0 ){
      DISK_WARNING( " (( %s : Set in drive %d: <- 2: ))\n", filename, drv+1 );
    }else{
      DISK_WARNING( " (( %s : Set in drive 1: -> %d: ))\n", filename, drv+1 );
    }


  }else{					/* ȿХɥ饤֤Ȱ㤦 */


    if( open_as_readonly ){
      drive[ drv ].read_only = TRUE;

      DISK_WARNING( " (( %s : Set in drive %d: as read only ))\n", 
		    filename, drv+1 );
    }else{
      drive[ drv ].read_only = FALSE;

      DISK_WARNING( " (( %s : Set in drive %d: ))\n", filename, drv+1 );
    }

    /*
    drive[ drv ].file_size = osd_file_size( drive[ drv ].filename );
    if( drive[ drv ].file_size == -1 ){
      DISK_ERROR( "Access Error(size)", drv );
      return 1;
    }
    */

    drive[ drv ].over_image          = FALSE;
    drive[ drv ].detect_broken_image = FALSE;

    num = 0;	offset = 0;
    exit_flag = FALSE;


			/* ƥ᡼ΥإåƼ */
    while( !exit_flag ){

      switch( d88_read_header( drive[ drv ].fp, offset, c ) ){

      case D88_SUCCESS:			/* ᡼ */

	memcpy( &drive[ drv ].image[ num ].name[0], &c[0], 16 );
	drive[ drv ].image[ num ].name[16] = '\0';
	drive[ drv ].image[ num ].protect  = c[DISK_PROTECT];
	drive[ drv ].image[ num ].type     = c[DISK_TYPE];
	drive[ drv ].image[ num ].size     = READ_SIZE_IN_HEADER( c );

						/* Υ᡼ξ */
	offset += drive[ drv ].image[ num ].size;
	num ++;

	if( num >= MAX_NR_IMAGE ){		/* ᡼¿ */
	  DISK_WARNING( " (( %s : Too many images [>=%d] ))\n", 
			filename, MAX_NR_IMAGE );
	  drive[ drv ].over_image = TRUE;
	  exit_flag = TRUE;
	}
	else if( offset < 0 ){			/* ᡼礭? */
	  DISK_WARNING( " (( %s : Too big image? [%d] ))\n", filename, num+1 );
	  drive[ drv ].detect_broken_image = TRUE;
	  exit_flag = TRUE;
	}
	break;

      case D88_NO_IMAGE:		/* ʾ奤᡼ʤ */
	exit_flag = TRUE;
	break;

      case D88_BAD_IMAGE:		/* Υ᡼ϲƤ */
	DISK_WARNING( " (( %s : Image No. %d Broken? ))\n", filename, num+1 );
	drive[ drv ].detect_broken_image = TRUE;
	exit_flag = TRUE;
	break;

      default:				/* ??? */
	DISK_WARNING( " (( %s : Image No. %d Error? ))\n", filename, num+1 );
	drive[ drv ].detect_broken_image = TRUE;
	exit_flag = TRUE;
	break;

      }
    }

    if( num==0 ){
      DISK_ERROR( "Image not found", drv );
      return 1;
    }

    drive[ drv ].image_nr = num;

  }



	/* disk_top img ܤΥǥ᡼Ƭ	*/

  if( img < 0 || img >= drive[ drv ].image_nr ){
    DISK_WARNING( " (( %s : Image No. %d Not exist ))\n", filename, img+1 );
    drive_set_empty( drv );
  }else{
    disk_change_image( drv, img );
  }



  return 0;
}



/***********************************************************************
 * ȿ¦Υɥ饤֤Υ᡼򡢤äΥɥ饤֤ˤ⥻åȤ
 *	src	ȿ¦Υɥ饤 0 or 1
 *	dst	äΥɥ饤 1 or 0
 *	img	᡼ֹ -1, 031
 *		ϰϳʤ¸ߤʤ᡼ֹξϡȤ
 *
 *	顼ϡǥ򥻥åȤ 1 ֤
 ************************************************************************/
int	disk_insert_A_to_B( int src, int dst, int img )
{

  disk_eject( dst );


  if( drive[ src ].fp == NULL ){
    return 0;
  }


  /* strcpy( drive[ dst ].filename, drive[ src ].filename ); */


  drive[ dst ].fp = drive[ src ].fp;

/*drive[ dst ].file_size           = drive[ src ].file_size;*/
  drive[ dst ].read_only           = drive[ src ].read_only;
  drive[ dst ].over_image          = drive[ src ].over_image;
  drive[ dst ].detect_broken_image = drive[ src ].detect_broken_image;
  drive[ dst ].image_nr            = drive[ src ].image_nr;

  memcpy( &drive[ dst ].image, &drive[ src ].image, sizeof(drive[0].image) );


  if( img < 0 || img >= drive[ dst ].image_nr ){
    drive_set_empty( dst );
  }else{
    disk_change_image( dst, img );
  }

  return 0;
}



/************************************************************************/
/* ᡼ѹ롣							*/
/*	disk_top img ܤΥǥ᡼Ƭꤷ		*/
/*	pcn*2 ȥåƬ˰ư롣				*/
/*	drvĥɥ饤(0/1)						*/
/************************************************************************/
static void disk_now_track( int drv, int trk );

int	disk_change_image( int drv, int img )
{
  int	i;

  if( drive[ drv ].fp==NULL ){				/* ɥ饤̤å */
    return 1;
  }
  if( img < 0 || img >= drive[ drv ].image_nr ){	/* ꥤ᡼̵ */
    return -1;
  }

		/* disk_top ׻ */

  drive[ drv ].selected_image = img;
  drive[ drv ].empty          = FALSE;

  drive[ drv ].disk_top = 0;
  for( i=0; i<img; i++ ){
    drive[ drv ].disk_top += drive[ drv ].image[ i ].size;
  }
  drive[ drv ].disk_end = drive[ drv ].disk_top + drive[ drv ].image[img].size;
  drive[ drv ].protect  = drive[ drv ].image[ img ].protect;
  drive[ drv ].type     = drive[ drv ].image[ img ].type;


  if( fdc_ignore_readonly == FALSE ){

    /* ReadOnly ǥե򳫤硢̵ǥ饤ȥץƥȾ֤Ȥ */

    if( drive[ drv ].read_only ) drive[ drv ].protect = DISK_PROTECT_TRUE;

  }else{

    /* ReadOnly ǥե򳫤⡢饤ȥץƥȾ֤ϥ᡼
       °ˤΥ᡼Фƽ񤭹ߤԤʤä硢
       ºݤˤϽ񤭹ߤϹԤʤʤｪλ֤
       ( ɥ顢ߥƥ֥롼ŷȤθ2 ʤɡ ReadOnly 
         ư餷Ƥʤ򶯰˵ư롣Τ ) */
    ;
  }

		/* pcn*2 ȥåƬ˰ư */

  disk_now_track( drv, fdc.pcn[drv]*2 );

  if (disk_exchange) disk_ex_drv |= 1 << drv;	/* ǥؤ */

  return 0;
}



/************************************************************************/
/* ǥ򥤥Ȥ						*/
/*	2 ɥ饤֤ǤȸꤷȿФΥɥ饤֤Ӥ롣		*/
/*	ƱǤС㤨СեĤ		*/
/*	drvĥɥ饤(0/1)						*/
/************************************************************************/
void	disk_eject( int drv )
{
  if( drive[ drv ].fp ){
    if( drive[ drv ].fp != drive[ drv^1 ].fp ){
      osd_fclose( drive[ drv ].fp );
    }
  }
  drive[ drv ].fp = NULL;
  drive[ drv ].sec_nr = -1;
  drive[ drv ].empty  = TRUE;
  /* memset( drive[ drv ].filename, 0, QUASI88_MAX_FILENAME ); */

  sec_buf.drv = -1;
}




/*======================================================================*/
/* إåɤȥåƬ˰ư					*/
/*	drvĥɥ饤(0/1)  trkĥȥåֹ(0)			*/
/*									*/
/*	顼ФϡΥȥåϥեޥåȤˤʤ롣	*/
/*======================================================================*/
static int disk_now_sec( int drv );

static	void	disk_now_track( int drv, int trk )
{
  int	error = 0;
  Uchar c[4];
  long	track_top;



	/* ǽΥå */

  if     ( drive[ drv ].type==DISK_TYPE_2D  && trk>=84  ) trk =  83;
  else if( drive[ drv ].type==DISK_TYPE_2DD && trk>=164 ) trk = 163;
  else if( drive[ drv ].type==DISK_TYPE_2HD && trk>=158 ) trk = 157;
  else if( trk>=164 ) trk = 163; /* ޤǤΤФ 2DD/2HD бǤ */
						        /* thanks peach ! */

	/*  &  */

  drive[ drv ].track     = trk;
  drive[ drv ].sec       = 0;


	/* ȥåΥǥåǻꤵ줿ե֤ */

  if( osd_fseek( drive[ drv ].fp,
		 drive[ drv ].disk_top + DISK_TRACK + trk*4,  SEEK_SET )==0 ){
    if( osd_fread( c, sizeof(Uchar), 4, drive[ drv ].fp )==4 ){

	/* ȥåӡƬΰ֤   */
	/* ΥΥ󤪤ӡ */

      track_top = (long)c[0]+((long)c[1]<<8)+((long)c[2]<<16)+((long)c[3]<<24);
      if( track_top!=0 ){
	drive[ drv ].track_top =
	drive[ drv ].sec_pos   = drive[ drv ].disk_top + track_top;
	drive[ drv ].sec_nr    = disk_now_sec( drv );
      }else{
	drive[ drv ].track_top =
	drive[ drv ].sec_pos   = drive[ drv ].disk_top;
	drive[ drv ].sec_nr    = -1;
      }
    }
    else error = 1;
  } else error = 2;

  if( error ){					/* SEEK / READ Error */
    printf_system_error( error );
  }

	/* 顼ϡեޥå(ƥեޥåǽ)ˤơ */

  if( error ){
    drive[ drv ].track_top =
    drive[ drv ].sec_pos   = drive[ drv ].disk_top;
    drive[ drv ].sec_nr    = -1;
  }

  sec_buf.drv = drv;			/* оݤΥɥ饤֤ФƤ */
  return;
}



/*======================================================================*/
/* ꤵ줿ǥθߤΥξɤߤȤ			*/
/*	drvĥɥ饤(0/1)						*/
/*									*/
/*	顼ϡΥΤ ID CRC Error 顼ꤹ롣	*/
/*	֤ͤϡΥΡ֥(DISK_SEC_NR)פ		*/
/*======================================================================*/
static	int	disk_now_sec( int drv )
{
  int	error = 0;
  Uchar	c[16];

	/* ե sec_pos  ID ɤߡ֤ */

  if( osd_fseek( drive[ drv ].fp,  drive[ drv ].sec_pos,  SEEK_SET )==0 ){
    if( osd_fread( c, sizeof(Uchar), 16, drive[ drv ].fp )==16 ){
      sec_buf.c       = c[DISK_C];
      sec_buf.h       = c[DISK_H];
      sec_buf.r       = c[DISK_R];
      sec_buf.n       = c[DISK_N];
      sec_buf.density = c[DISK_DENSITY];
      sec_buf.deleted = c[DISK_DELETED];
      sec_buf.status  = c[DISK_STATUS];
      sec_buf.sec_nr  = c[DISK_SEC_NR] + (int)c[DISK_SEC_NR+1]*256;
      sec_buf.size    = c[DISK_SEC_SZ] + (int)c[DISK_SEC_SZ+1]*256;
      if( sec_buf.status==STATUS_CM ){
	sec_buf.deleted = DISK_DELETED_TRUE;
	sec_buf.status  = STATUS_NORMAL;
      }
    }
    else error = 1;
  } else error = 2;

  if( error ){					/* SEEK / READ Error */
    printf_system_error( error );
    status_message( 1, STATUS_WARN_TIME, "DiskI/O Read Error" );
  }



	/* Ԥ顢ID CRC Error ˤ0 (==unformat) ֤ */

  if( error ){
    sec_buf.sec_nr  = 0;
    sec_buf.status  = STATUS_DE;
  }

  return ( sec_buf.sec_nr );
}



/*======================================================================*/
/* ꤵ줿ǥμΥξɤߤȤ			*/
/*	drvĥɥ饤(0/1)						*/
/*======================================================================*/
static	void	disk_next_sec( int drv )
{
  int	overwrite_id;

	/* եޥåȻϡʤˤ⤷ʤ */

  if( disk_unformat( drv ) ) return;


	/* sec_top 򼡤ΥˡǽλϥȥåƬ */

			/* ߥå˾񤭤줿 ID ο */
			/* դΤ˥åǤʤɤ褦 */

  if( sec_buf.size == 0x80 ||		/* sec_buf.size 0x80,0x100,0x200 */
     (sec_buf.size & 0xff) == 0 ){	/* 0x400,0x800,0x1000 ξ() */
    overwrite_id = 0;
  }else{				/* ʳϡߥå  */
    overwrite_id = ( sec_buf.size - ( 128 << (sec_buf.n & 7)) ) / SZ_DISK_ID;
    if( overwrite_id < 0 ) overwrite_id = 0;
  }


  drive[ drv ].sec += ( 1 + overwrite_id );
  if( drive[ drv ].sec < drive[ drv ].sec_nr ){

    drive[ drv ].sec_pos += (sec_buf.size + SZ_DISK_ID);

  }else{

    drive[ drv ].sec = 0;
    drive[ drv ].sec_pos = drive[ drv ].track_top;

  }

	/* sec_pos  ID ɤ */

  disk_now_sec( drv );
}



/************************************************************************/
/* FDC ν								*/
/************************************************************************/
static	void	fdc_init( void )
{
  int	i;

  fdc.status  = 0 | REQ_MASTER;
  fdc.read    = 0xff;
  fdc.write   = 0xff;
  fdc.TC      = FALSE;

  fdc.command = WAIT;

  for( i=0; i<MAX_DRIVE; i++ ){
    fdc.seek_stat[ i ] = SEEK_STAT_STOP;
    fdc.seek_wait[ i ] = 0;
    fdc.ncn[ i ]  = 0;
    fdc.pcn[ i ]  = 0;
  }
  fdc.intr_unit = 4;
}



/************************************************************************/
/* CPU FDC ˥˸Ƥִؿ				*/
/*	void	fdc_write( byte data )	ġġ OUT A,(0FBH)		*/
/*	byte	fdc_read( void )	ġġ IN  A,(0FBH)		*/
/*	byte	fdc_status( void )	ġġ IN  A,(0FAH)		*/
/*	void	fdc_TC( void )		ġġ IN  A,(0F8H)		*/
/************************************************************************/
void	fdc_write( byte data )
{
  if( (fdc.status & DATA_IO)==0 ){
    fdc.status &= ~REQ_MASTER;
    fdc.write   = data;
  }
}

byte	fdc_read( void )
{
  if( (fdc.status & DATA_IO) ){
    fdc.status &= ~REQ_MASTER;
    return fdc.read;
  }else{
    return 0xff;
  }
}

byte	fdc_status( void )
{
  return fdc.status;
}

void	fdc_TC( void )
{
  fdc.TC = TRUE;
}



/* FDC CPUؤγ  */

#define	fdc_occur_interrupt()	FDC_flag = TRUE
#define	fdc_cancel_interrupt()	FDC_flag = FALSE


/* FDCȤ */

#define	ICOUNT(x)	do{  fdc.wait = (x);			      }while(0)
#define	REPEAT()	do{  if( fdc_wait==FALSE ){ fdc.wait = 0; }   }while(0)


/*#define	logfdc	printf*/
/*======================================================================
 * E-PHASE ˤơƼפ륯å򻻽Фؿޥ
 *======================================================================*/

#if 0	/* Ȥ٤򤢤褦Ȥɡʤ󤫤ٲ᤮ġ */

/* GAP3/GAP4ΥХȿʤŬ⤫ʤŬˡ		*/
/* N = 0/1/2/3/4/5/6/7 λ SC = 26/16/ 9/ 5/ 2/ 1/ 1/ 1 Ȥ	*/
static const int gap3_tbl[] = { 26, 54, 84, 116, 150, 186, 224, 264 };
static const int gap4_tbl[] = { 488, 152, 182, 94, 1584, 1760, 2242, 4144 };

#define	CLOCK_GAP0()      (128*( 80+12+(3+1)+50 ))

#define	CLOCK_ID()        (128*( 12+(3+1)+4+2+22 ))
#define	CLOCK_DATA(n)     (128*( 12+(3+1)+(128<<(n))+2+gap3_tbl[(n)&7] ))
#define	CLOCK_SECTOR(n)   ( CLOCK_ID() + CLOCK_DATA(n) )

#define	CLOCK_RID_ID()    (128*( 12+(3+1)+4+2 ))
#define	CLOCK_RID_DATA(n) (128*( 22 + 12+(3+1)+(128<<(n))+2+gap3_tbl[(n)&7] ))

#define	CLOCK_RDT_ID()    (128*( 12+(3+1)+4+2+22 + 12+(3+1) ))
#define	CLOCK_RDT_DATA(n) (128*( (128<<(n))+2+gap3_tbl[(n)&7] ))

#define	CLOCK_GAP3(n)     (128*( gap3_tbl[(n)&7] ))
#define	CLOCK_GAP4(n)     (128*( gap4_tbl[(n)&7] ))
#define	CLOCK_TRACK()     (128*( 6250 ))

/* 1ХȤž 32us */
#define	CLOCK_BYTE()      (128)
#define	CLOCK_2MS()       (8000)

#else	/* Ȥꤢ٤Ǥ */

#define	CLOCK_GAP0()      (0)
#define	CLOCK_ID()        (0)
#define	CLOCK_DATA(n)     (0)
#define	CLOCK_SECTOR(n)   ( CLOCK_ID() + CLOCK_DATA(n) )
#define	CLOCK_RID_ID()    (0)
#define	CLOCK_RID_DATA(n) (0)
#define	CLOCK_RDT_ID()    (128*( 12+(3+1)+4+2+22 + 12+(3+1) ))
#define	CLOCK_RDT_DATA(n) (0)
#define	CLOCK_GAP3(n)     (0)
#define	CLOCK_GAP4(n)     (0)
#define	CLOCK_TRACK()     (128*( 6250 ))
#define	CLOCK_BYTE()      (128)
#define	CLOCK_2MS()       (8000)
#endif


/* إåɥɡΥȤ¬뤫ɤ */
#define WAIT_FOR_HEADLOAD
#define WAIT_FOR_SEEK




/*===========================================================================
 * READ/WRITEϥޥɤǡID˥˥åȤʤɤΥåԤ
 *	ͤ 0 ξ硢ǥʤΤǡǥåȤ̵¤Ԥ
 *	ͤ 1 ξ硢̤ ST0ST2 ˥åȤ
 *			   (Υ顼ϤǤϥåȤʤ)
 *===========================================================================*/
static	int	fdc_check_unit( void )
{
  int	drv = (fdc.us);

	/* ̤³ɥ饤֤䡢ɥ饤֤ʤ顢۾ｪλ */

  if( fdc.us >= NR_DRIVE || fdc.status & (0x0f) ){
    fdc.st0 = ST0_IC_AT | ST0_NR | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = 0;
    if( fdc.command == READ_ID ){ fdc.c = fdc.h = fdc.r = fdc.n = 0xff; }
    fdc.carry = 0;
    return 1;
  }

	/* ǥ̵ϡĤޤǤäƤ⽪ʤ */

  if( disk_not_exist( drv ) ){
    fdc.wait  = CLOCK_2MS();			   /* 2msˤʤ	*/
    fdc.carry = 0;
    return 0;
  }

	/* 饤ȷϥޥɤǡ饤ȥץƥȻϡ۾ｪλ */

  if( fdc.command == WRITE_ID   ||
      fdc.command == WRITE_DATA ||
      fdc.command == WRITE_DELETED_DATA ){
    if( drive[ drv ].protect == DISK_PROTECT_TRUE ){
      fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
      fdc.st1 = ST1_NW;
      fdc.st2 = 0;
      fdc.carry = 0;
      status_message( 1, STATUS_WARN_TIME, "Disk Write Protected" );
      return 1;
    }
  }

	/* إåɤɻϡإåɥɻ֤û */

#ifdef	WAIT_FOR_HEADLOAD
  if( fdc.hl_stat[drv] == FALSE ){
    /* ɲ ? */
    if ((cpu_timing > 0) && (fdc_wait)) {
      /*logfdc("### Head Down ###\n");*/
      xmame_dev_sample_headdown();
    }
    fdc.hl_stat[drv] = TRUE;
    fdc.wait += fdc.hlt_clk;
  }
  fdc.hl_wait[drv] = 0;
#endif


	/* IDR ߤΥȥå֤Ȱ㤦ϡȥåѹ */

  if( fdc.command == READ_DIAGNOSTIC ||	    /* READ DIAGNOSTIC ޤ        */
      fdc.command == WRITE_ID        ){	    /* WRITE ID        ξ        */
					    /*    ȥåƬ */
					    /*    ɬȥåѹ (ƬФ)  */
    if( ! disk_unformat(drv)   &&
	( drive[drv].track & 1 ) == fdc.hd ){
      fdc.wait += CLOCK_TRACK()
		    * (drive[drv].sec_nr - drive[drv].sec) / drive[drv].sec_nr;
    }
    disk_now_track( drv, ((drive[drv].track & ~1)|fdc.hd) );
    fdc.carry = 0;

  }else{				    /* ʳξ                */
					    /*    ߥ֤ɤ     */

    if( sec_buf.drv != drv ){			/* ɥ饤־ο㤤*/

      disk_now_track( drv, ((drive[drv].track & ~1)|fdc.hd) );
      fdc.carry = 0;
      logfdc("\n<< sector reload >>\t\t\t");
      if( verbose_fdc )
	printf("FDC log : sec_buf reload $$$$\n" );

    }else

    if( ( drive[drv].track & 1 ) != fdc.hd ){	/* إåɰ֤ۤʤΤ  */
      int i, s = drive[drv].sec;		/* ȥåѹ          */

      disk_now_track( drv, ((drive[drv].track & ~1)|fdc.hd) );
      fdc.carry = 0;

      if( fdc_wait ){
	if( ! disk_unformat(drv) ){
	  for( i=0; i<s; i++ ){				/* ֤ư  */
	    if( drive[drv].sec >= s ) break;		/* إåɰư    */
	    disk_next_sec( drv );			/* Ʊ  */
	  }						/* ˰ư褦    */
	}
      }
    }
  }

	/* եޥåȤλϡľ˰۾ｪλ (WRITE_ID ) */

  if( fdc.command != WRITE_ID ){
    if( disk_unformat( drv ) || disk_unformatable( drv ) ){
      fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
      fdc.st1 = ST1_MA;
      fdc.st2 = 0;
      if( fdc.command == READ_ID ){ fdc.c = fdc.h = fdc.r = fdc.n = 0xff; }
      fdc.wait += CLOCK_TRACK() * 2;
      fdc.carry = CLOCK_GAP0();
      return 1;
    }
  }

	/* ۤʬΥȤϡû */

  if( fdc.carry > 0 ){
    fdc.wait += fdc.carry;
  }
  fdc.carry = 0;


	/* öλST0  NT(Normal Terminate:ｪλ) 򥻥å */

  fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
  fdc.st1 = 0;
  fdc.st2 = 0;

  return 1;
}



/*===========================================================================
 * READ/WRITEϥޥɤǡIDõ
 *	ͤ 0 ξ硢ǥʤΤǡǥåȤ̵¤Ԥ
 *	ͤ 1 ξ硢̤ ST0ST2 ˥åȤ
 *			   (Υ顼ϤǤϥåȤʤ)
 *===========================================================================*/
static	int	fdc_search_id( void )
{
  int	drv = (fdc.us);
  int	index_cnt = 0;			/* ǥåۡ븡в */
  int	exist_iam = FALSE;		/* IAM1٤Ǥ⸫Ĥä鿿 */
  int	n;

	/* ǽˡ˥åȤʤɤΥåԤ */

  if( fdc_check_unit() == 0 ){		/* ǥ̵Ȥ */
    return 0;
  }else{
    if( fdc.st0 & ST0_IC ){		/* ʤˤ۾郎   */
      return 1;				/* (Busy,Protect,Un-format) */
    }
  }

	/*  (Ĥ뤫ǥåۡ2󸡽Фǽλ) */

  if     ( sec_buf.sec_nr > 19 ) n = 0;		/* ȥåեޥåȻ */
  else if( sec_buf.sec_nr > 10 ) n = 1;		/* N Ŭ˿¬       */
  else if( sec_buf.sec_nr >  5 ) n = 2;		/* (GAP3GAP4Ĺλ)   */
  else if( sec_buf.sec_nr >  2 ) n = 3;
  else if( sec_buf.sec_nr >  1 ) n = 4;
  else                           n = 5;

  while( 1 ){

    if( sector_density_mismatch()   ||	/* Υˤ IAM ʤ         */
        sec_buf.status == STATUS_MA ){
      ;							/* Υ̵  */

    }else{				/* Υˤ IAM          */
      exist_iam = TRUE;

      if( fdc.command == READ_DIAGNOSTIC ){	/* READ DIAG ξ          */
	if( sec_buf.status == STATUS_MA_MD ){		/* DATA mark ʤ    */
	  return 0;					/*	ϥ󥰤롩 */
	}else{						/* DATA mark     */
	  break;					/*	 */
	}

      }else if( fdc.command == READ_ID ){	/* READ IDξ             */
	if( sec_buf.status == STATUS_DE ){		/* ID CRC ۾     */
	  ;						/*	 */
	}else{						/* ID CRC      */
	  break;					/*	 */
	}

      }else{					/* READ / WRITE ξ       */
	if( idr_match() ){				/* IDR ׻        */
	  if( sec_buf.status == STATUS_DE ){		    /* ID CRC ۾   */
	    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
	    fdc.st1 = ST1_DE;
	    fdc.st2 = 0;

	    fdc.wait += CLOCK_RID_ID();
	    fdc.carry = CLOCK_RID_DATA( n );
	    disk_next_sec( drv );
	    if( drive[drv].sec==0 ) fdc.carry += CLOCK_GAP4(n) + CLOCK_GAP0();
	    return 1;
	  }
	  else
	  if( sec_buf.status == STATUS_MA_MD     &&	    /* (D)DAM ʤ   */
	      (fdc.command == READ_DATA ||		    /*   (READΤ)*/
	       fdc.command == READ_DELETED_DATA) ){
	      
	    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
	    fdc.st1 = ST1_MA;
	    fdc.st2 = ST2_MD;

	    fdc.wait += CLOCK_RID_ID() + CLOCK_2MS();
	    disk_next_sec( drv );
	    if( drive[drv].sec==0 ) fdc.carry += CLOCK_GAP4(n) + CLOCK_GAP0();
	    return 1;
	  }
	  else{
	    break;					    /*   */
	  }
	}else{						/*  IDR פʤ */
	  ;						    /*   */
	}
      }
    }

					/* פʤäΤǼ򸡺 */
    fdc.wait += CLOCK_SECTOR( n );
    disk_next_sec( drv );

    if( drive[drv].sec == 0 ){		/* ǥåۡ򸡽         */
      index_cnt ++;
      fdc.wait += CLOCK_GAP4( n );

      if( index_cnt >= 2 ){			/* פǡ2󸡽Ф      */

	fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
	fdc.st1 = (exist_iam) ? ST1_ND   : ST1_MA;	    /* IAM1٤Ǥ */
	fdc.st2 = (exist_iam) ? 0 /**/ : 0;		    /* Ĥä */
	if( exist_iam ){				    /* ơ */
	  if( fdc.c != fdc.pcn[drv] ){ fdc.st2 |= ST2_NC;   /* 㴳ۤʤ   */
	  if( fdc.c == 0xff )          fdc.st2 |= ST2_BC; }
	}
	if( fdc.command == READ_ID ){ fdc.c = fdc.h = fdc.r = fdc.n = 0xff; }
	fdc.carry = CLOCK_GAP0();
	return 1;
      }

      fdc.wait += CLOCK_GAP0();
    }

  }


	/* ID̵ߤĤäΤǡ ST0  NT 򥻥åȤ */

  fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
  fdc.st1 = 0;
  fdc.st2 = 0;

  if( fdc.command == READ_ID ){		/* READ ID ξ */

    fdc.c = sec_buf.c;				/* ĤCHRN*/
    fdc.h = sec_buf.h;
    fdc.r = sec_buf.r;
    fdc.n = sec_buf.n;

    fdc.wait += CLOCK_RID_ID();
    fdc.carry = CLOCK_RID_DATA( n );

    disk_next_sec( drv );
    if( drive[drv].sec==0 ) fdc.carry += CLOCK_GAP4(n) + CLOCK_GAP0();

  }else{				/* ʳ ξ */

    fdc.wait += CLOCK_RDT_ID();
    fdc.gap3  = CLOCK_GAP3( n );

    if( fdc.command == READ_DATA ||
	fdc.command == READ_DELETED_DATA ){
      if( sec_buf.deleted == DISK_DELETED_TRUE ) fdc.st2 |= ST2_CM;
    }
  }

  return 1;
}



/*===========================================================================
 * READϥޥɤǡDATAХåեɤ߹
 *	̤ ST0ST2 ȥХåեåȤ
 *	(READ ID ξ硢δؿϸƤФʤ)
 *===========================================================================*/
static	int	fdc_read_data( void )
{
  int	drv = (fdc.us);
  int	read_size, size, ptr, error;


  print_fdc_status(( (fdc.command==READ_DIAGNOSTIC) ? BP_DIAG : BP_READ ),
		   drv, drive[drv].track, drive[drv].sec);

	/* STATUS  (READ(DELETED)DATAξ DATA CRC顼Τ) */

  if( sec_buf.status == STATUS_DE ){		/* ID CRC err */
    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = ST1_DE;
    fdc.st2 = ( (sec_buf.deleted==DISK_DELETED_TRUE)? ST2_CM: 0 );
  }
  else
  if( sec_buf.status == STATUS_DE_DD ){		/* DATA CRC err */
    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = ST1_DE;
    fdc.st2 = ST2_DD | ( (sec_buf.deleted==DISK_DELETED_TRUE)? ST2_CM: 0 );
  }
  else{						/* CRC OK */
    fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = ( (sec_buf.deleted==DISK_DELETED_TRUE)? ST2_CM: 0 );
  }
  if( ! idr_match() ){				/* IDR԰ */
    fdc.st0 |= ST0_IC_AT;
    fdc.st1 |= ST1_ND;
  }


	/* DATA ʬɤ */

  read_size = 128 << (fdc.n & 7);		/* ɤ߹ߥ       */
  ptr       = 0;				/* 񤭹߰		*/

  if( fdc.command == READ_DIAGNOSTIC ){
    if((sec_buf.size==0x80 && read_size!=0x80) ||	/*  N      */
       (sec_buf.size & 0xff00) != read_size    ){	/* IDR N㤦 */
      fdc.st0 |= ST0_IC_AT;				/* DATA CRC err      */
      fdc.st1 |= ST1_DE;
      fdc.st2 |= ST2_DD;
    }
  }

  while( read_size > 0 ){	/* -------------------ꥵʬɤ³ */

    size = MIN( read_size, sec_buf.size );
    if( osd_fseek( drive[ drv ].fp,
		   drive[ drv ].sec_pos + SZ_DISK_ID,  SEEK_SET )==0 ){
      if( osd_fread( &data_buf[ptr], sizeof(Uchar),
		     size, drive[ drv ].fp )==(size_t)size ){
	error = 0;
      }
      else error = 1;
    } else error = 2;
    if( error ){			/* OS٥Υ顼ȯ */
      printf_system_error( error );		/* DATA CRC err ˤ*/
      status_message( 1, STATUS_WARN_TIME, "DiskI/O Read Error" );
      fdc.st0 |= ST0_IC_AT;
      fdc.st1 |= ST1_DE;
      fdc.st2 |= ST2_DD;
      break;
    }

    ptr       += size;
    read_size -= size;
    if( read_size <= 0 ) break;


    fdc.st0 |= ST0_IC_AT;		/* Υ˸٤ä */
    fdc.st1 |= ST1_DE;				/* DATA CRC err ˤ */
    fdc.st2 |= ST2_DD;


	/* ֤ (DATA-CRC,GAP3,ID-SYNC,IAM,ID,ID-CRC,GAP2ʤ) */

#if 0		/* ֤Υǡʤ */
		    /* CRC  GAP3  SYNC   AM    ID  CRC GAP2 */
    if( fdc.mf ) size = 2 + 0x36 + 12 + (3+1) + 4 + 2 + 22;
    else         size = 2 + 0x2a +  6 + (1+1) + 4 + 2 + 11;

    ptr       += size;
    read_size -= size;

    disk_next_sec( drv );

#else		/* peachꡢ֥ǡ󶡤ޤ */

    size = fill_sector_gap(ptr, drv, fdc.mf);
    if (size < -1) goto FDC_READ_DATA_RETURN;

    ptr       += size;
    read_size -= size;
#endif
  }				/* ----------------------------------------- */

		/* ɤ߹߽ä顢ؿʤƤ */

  disk_next_sec( drv );


 FDC_READ_DATA_RETURN:

	/* READ DIAGNOSTIC ξ硢CRC err  IDR԰פȤƤߤ	*/
	/* (ST1, ST2ΥӥåȤϡΤޤ޻Ĥ)				*/

  if( fdc.command == READ_DIAGNOSTIC ){
    fdc.st0 &= ~ST0_IC;		/* == ST0_IC_NT     */
  }

  return 1;
}



/*===========================================================================
 * WRITEϥޥɤǡХåեDATAե˽񤭽Ф
 *	̤ ST0ST2 ȥХåեåȤ
 *
 *	ʲΤ褦ʥ᡼ä硢Υ˥ǡ饤Ȥ
 *	        +----------+----------------+----------+----------------+
 *	        |C       00|                |C       00|                |
 *	        |H       00|                |H       00|                |
 *	        |R       01|    ǡ    |R       01|    ǡ    |
 *	        |N       02|    256Х   |N       01|    256Х   |
 *	        |16|                |16|                |
 *	        | 256|                | 256|                |
 *	        +----------+----------------+----------+----------------+
 *	N=2 ʤΤǡ饤Ȥ 512 ХȡĤޤΥ˲롣
 *	        +----------+---------------------------------+----------+
 *	        |C       00|                                 |    |
 *	        |H       00|                                 |̵̣|
 *	        |R       01|            ǡ             |ߥǡ|
 *	        |N       02|            512Х            |Ȥʤ    |
 *	        |16|                                 |          |
 *	        | 528|                                 | 16Х |
 *	        +----------+---------------------------------+----------+
 *	ϡָΥΥ+16Хȡ䤹 (Ѥʤ)
 *===========================================================================*/
static	int	fdc_write_data( void )
{
  long	id_pos, write_pos;
  int	write_size, total_size, size, ptr, error=0, sys_err=0;
  int	drv = fdc.us;
  unsigned char	c[2];
  int	gap4_size  = sec_buf.size;
  int	gap4_wrote = FALSE;

  print_fdc_status(BP_WRITE, drv, drive[drv].track, drive[drv].sec);


	/* κ˥ǥ򴹤줿ꤷϡ۾ｪλ */

  if( disk_not_exist( drv ) ||				/* ǥ̵ */
      drive[ drv ].read_only ||				/* 񤭹߶ػ */
      drive[ drv ].protect == DISK_PROTECT_TRUE ||	/* 饤ȥץƥ */
      disk_unformat(drv) || disk_unformatable(drv) ){	/* եޥå */

    int write_protected = FALSE;	/* ԲĤξ硢 */
    if( ! disk_not_exist( drv ) &&
	( drive[ drv ].read_only ||
	  drive[ drv ].protect == DISK_PROTECT_TRUE ) ){
      write_protected = TRUE;
    }

    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = 0;
    if( write_protected ) fdc.st1 |= ST1_NW;
    else                  fdc.st0 |= ST0_NR;


    if( fdc_ignore_readonly &&		/* ReadOnly ̵뤹ｪλ */
	write_protected     &&
	drive[ drv ].protect != DISK_PROTECT_TRUE ){

      fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
      fdc.st1 = 0;
      fdc.st2 = ( (fdc.command==WRITE_DELETED_DATA)? ST2_CM: 0 );

      if( verbose_fdc ){
	printf("FDC %s : Drive %d Write Skipped (write protected)\n",
	       cmd_name[fdc.command],drv+1);
      }
      status_message( 1, STATUS_WARN_TIME, "Disk Write Skipped" );

    }else{

      if( verbose_fdc ){
	if( write_protected )
	  printf("FDC %s : Drive %d Write Failed (write protected)\n",
		 cmd_name[fdc.command],drv+1);
	else
	  printf("FDC %s : Drive %d Write Failed (file changed ?)\n",
		 cmd_name[fdc.command],drv+1);
      }
      status_message( 1, STATUS_WARN_TIME, "Disk Write Failed" );
    }
    return 1;
  }


	/* DATA ʬ */

  id_pos     = drive[ drv ].sec_pos;		/* IDΥե */

  write_size = 128 << (fdc.n & 7);		/* 񤭹ߥ         */
  ptr        = 0;				/* ǡΥݥ       */
  write_pos  = drive[drv].sec_pos + SZ_DISK_ID;	/* 񤭹ߤΥե */
  total_size = sec_buf.size;			/* Υǡ */

  while( write_size > 0 ){	/* -------------------ꥵʬ³ */

    size = MIN( write_size, sec_buf.size );
    if( write_pos + size <= drive[drv].disk_end ){
    if( osd_fseek( drive[ drv ].fp,
		   write_pos,  SEEK_SET )==0 ){
      if( osd_fwrite( &data_buf[ptr], sizeof(Uchar),
		      size, drive[ drv ].fp )==(size_t)size ){
	error = 0;
      }
      else error = 1;
    } else error = 2;
    } else error = 3;
    if( error ){
      printf_system_error( error );
      break;
    }

    ptr        += size;
    write_pos  += size;
    write_size -= size;

    if( write_size<=0 ) break;			/* ̤ϡȴ     */

    if( gap4_wrote == FALSE ){
      disk_next_sec( drv );			/* Υ˸٤ä   */
    }

    if( drive[drv].sec != 0 ){			/* ³륻С */
						/*	Υ˾  */
      total_size += (sec_buf.size + SZ_DISK_ID);/*	(ʬ)  */

    }else{ /* drive[drv].sec == 0 */		/* ̵(Ƭä)ʤ */
      gap4_wrote = TRUE;			/*	GAP4 ˾Ȥߤʤ */
      total_size += (gap4_size + SZ_DISK_ID);	/*	(Ŭˡ)  */
      /* ΥȥåΥǡ˲뤪줢ꡣ*/
    }

    if( verbose_fdc ){
      if( gap4_wrote == FALSE )
	printf("FDC %s : Sector Overlap in track %d (DRIVE %d:)\n",
	       cmd_name[fdc.command], drive[drv].track, drv+1);
      else
	printf("FDC %s : GAP4 Overlap in track %d (DRIVE %d:)\n",
	       cmd_name[fdc.command], drive[drv].track, drv+1);
    }

  }				/* ----------------------------------------- */


	/* ID 򹹿롣*/

  if( fdc.mf && fdc.n==0 ){
    c[0] = DISK_DELETED_FALSE;
    c[1] = STATUS_MA_MD;
  }else{
    if( fdc.command==WRITE_DATA ){
      c[0] = DISK_DELETED_FALSE;
      c[1] = (error) ? STATUS_DE_DD : STATUS_NORMAL;
    }else{
      c[0] = DISK_DELETED_TRUE;
      c[1] = (error) ? STATUS_DE_DD : STATUS_CM;
    }
  }
  if( error > 0 ) sys_err = 1;
  if( osd_fseek( drive[ drv ].fp,		/* ID ΡDAM/DDAM򹹿 */
		 id_pos + DISK_DELETED,  SEEK_SET )==0 ){
    if( osd_fwrite( &c[0], sizeof(Uchar), 2, drive[ drv ].fp )==2 ){
      error = 0;
    }
    else error = 1;
  } else error = 2;
  if( error ){
    printf_system_error( error );
    sys_err = 1;
  }


  c[0] = ( total_size >>  0  ) & 0xff;
  c[1] = ( total_size >>  8  ) & 0xff;
  if( osd_fseek( drive[ drv ].fp,		/* ID Ρ򹹿 */
		 id_pos + DISK_SEC_SZ,  SEEK_SET )==0 ){
    if( osd_fwrite( &c[0], sizeof(Uchar), 2, drive[ drv ].fp )==2 ){
      error = 0;
    }
    else error = 1;
  } else error = 2;
  if( error ){
    printf_system_error( error );
    sys_err = 1;
  }


  osd_fflush( drive[ drv ].fp );


	/* 桢ƥΥ顼ä۾ｪλ */

  if( sys_err ){
    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us | ST0_NR;
    fdc.st1 = 0;
    fdc.st2 = 0;
    status_message( 1, STATUS_WARN_TIME, "DiskI/O Write Error" );
  }else{
    fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = ( (fdc.command==WRITE_DELETED_DATA)? ST2_CM: 0 );
  }

  if( gap4_wrote == FALSE ){
    disk_next_sec( drv );
  }
  return 1;
}



/*===========================================================================
 * WRITE ID ޥɤǡХåե  IDR ˴Ťե˽񤭽Ф
 *	̤ ST0ST2 
 *===========================================================================*/
static	int	fdc_write_id( void )
{
  int	size, error, i, j, id_ptr;
  long	format_pos;
  char	id[SZ_DISK_ID],	data[128];
  int	drv = fdc.us;


	/* κ˥ǥ򴹤줿ꤷϡ۾ｪλ */

  if( disk_not_exist( drv ) ||				/* ǥ̵ */
      drive[ drv ].read_only ||				/* 񤭹߶ػ */
      drive[ drv ].protect == DISK_PROTECT_TRUE ||	/* 饤ȥץƥ */
      disk_unformatable(drv) ){				/* եޥåǽ */

    int write_protected = FALSE;	/* ԲĤξ硢 */
    if( ! disk_not_exist( drv ) &&
	( drive[ drv ].read_only ||
	  drive[ drv ].protect == DISK_PROTECT_TRUE ) ){
      write_protected = TRUE;
    }

    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = 0;
    if( write_protected ) fdc.st1 |= ST1_NW;
    else                  fdc.st0 |= ST0_NR;


    if( fdc_ignore_readonly &&		/* ReadOnly ̵뤹ｪλ */
	write_protected     &&
	drive[ drv ].protect != DISK_PROTECT_TRUE ){

      fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
      fdc.st1 = 0;
      fdc.st2 = 0;

      if( verbose_fdc ){
	printf("FDC %s : Drive %d Write Skipped (write protected)\n",
	       cmd_name[fdc.command],drv+1);
      }
      status_message( 1, STATUS_WARN_TIME, "Disk Write Skipped" );

    }else{

      if( verbose_fdc ){
	if( write_protected )
	  printf("FDC %s : Drive %d Format Failed (write protected)\n",
		 cmd_name[fdc.command],drv+1);
	else if( ! disk_not_exist( drv ) && disk_unformatable(drv) )
	  printf("FDC %s : Drive %d Format Failed (no file space)\n",
		 cmd_name[fdc.command],drv+1);
	else
	  printf("FDC %s : Drive %d Format Failed (file changed ?)\n",
		 cmd_name[fdc.command],drv+1);
      }
      status_message( 1, STATUS_WARN_TIME, "Disk Write Failed" );
    }
    return 1;
  }


	/* եޥåȥǡν */

  for( size=0; size<128; size++ ) data[size] = fdc.d;


	/*        եޥåȥѥ᡼β       */
	/* ȥå1ۤʤȽꡣۤϡ */
	/* Ǹ1˼ޤʬΤߤ WRITE ID 롣 */

  id_ptr = 0;
  {
    int	SZ_BYTE = (drive[ drv ].type==DISK_TYPE_2HD) ? 10400 : 6250;
    int	SZ_GAP0 = (fdc.mf) ? (80+12+3+1    +50) : (40+6+1+1+    50);
    int	SZ_AM   = (fdc.mf) ? (   12+3+1+4+2+22) : (   6+1+1+4+2+11);
    int	SZ_DAM  = (fdc.mf) ? (   12+3+1+0+2+ 0) : (   6+1+1+0+2+ 0);
    int	max_sec;
    SZ_GAP0 = 0; /* ȤꤢGAP0 ʬϱۤƤپʥ */
    max_sec = (SZ_BYTE-SZ_GAP0)/( SZ_AM+SZ_DAM + 128*(1<<(fdc.n&7))+ fdc.gpl );
    if( fdc.sc > max_sec ){

      if( verbose_fdc )
        printf("FDC %s : Over Sector %d -> fixed %d (DRIVE %d:)\n",
	       cmd_name[fdc.command],fdc.sc,max_sec,drv+1);

      id_ptr = (fdc.sc - max_sec) * 4;
      fdc.sc = max_sec;

    }
  }



	/* ID / DATA ե˽񤭹 */

  format_pos = drive[ drv ].track_top;
  error = 0;

  if( fdc.sc==0 ){				/* եޥåȤ */

    for( i=0; i<SZ_DISK_ID; i++ ) id[ i ] = 0;

    if( format_pos + 16 <= drive[drv].disk_end ){
    if( osd_fseek( drive[ drv ].fp,  format_pos,  SEEK_SET )==0 ){
      if( osd_fwrite( id, sizeof(Uchar), 16, drive[ drv ].fp )==16 ){
	error = 0;
      }
      else error = 1;
    } else error = 2;
    } else error = 3;

  }else for( i=0; i<fdc.sc; i++ ){		/* եޥåȤ */

    id[ DISK_C ] = data_buf[ id_ptr++ ];
    id[ DISK_H ] = data_buf[ id_ptr++ ];
    id[ DISK_R ] = data_buf[ id_ptr++ ];
    id[ DISK_N ] = data_buf[ id_ptr++ ];
    id[ DISK_SEC_NR   ] = (fdc.sc    ) & 0xff;
    id[ DISK_SEC_NR+1 ] = (fdc.sc>>8 ) & 0xff;
    id[ DISK_DENSITY ] = (fdc.mf) ? DISK_DENSITY_DOUBLE : DISK_DENSITY_SINGLE;
    id[ DISK_DELETED ] = DISK_DELETED_FALSE;
    id[ DISK_STATUS ] = STATUS_NORMAL;
    id[ DISK_RESERVED+0 ] = 0;
    id[ DISK_RESERVED+1 ] = 0;
    id[ DISK_RESERVED+2 ] = 0;
    id[ DISK_RESERVED+3 ] = 0;
    id[ DISK_RESERVED+4 ] = 0;
    id[ DISK_SEC_SZ   ] = ( 128*(1<<(fdc.n&7))      ) & 0xff;
    id[ DISK_SEC_SZ+1 ] = ( 128*(1<<(fdc.n&7)) >> 8 ) & 0xff;

    if( verbose_fdc )
      if( id[ DISK_N ] != fdc.n )
        printf("FDC %s : Mix Sector in track %d (DRIVE %d:)\n",
	       cmd_name[fdc.command],drive[drv].track,drv+1);

    if( format_pos + 16 <= drive[drv].disk_end ){
    if( osd_fseek( drive[ drv ].fp,  format_pos,  SEEK_SET )==0 ){
      if( osd_fwrite( id, sizeof(Uchar), 16, drive[ drv ].fp )==16 ){
	format_pos += 16;

	for( j=0; j<(1<<(fdc.n&7)); j++ ){

	  if( format_pos + 128 <= drive[drv].disk_end ){
	  if( osd_fseek( drive[ drv ].fp,  format_pos,  SEEK_SET )==0 ){
	    if( osd_fwrite( data, sizeof(Uchar), 128, drive[ drv ].fp )==128 ){
	      format_pos += 128;
	    }
	    else{ error = 1; break; }
	  } else{ error = 2; break; }
	  } else{ error = 3; break; }

	}

      }
      else error = 1;
    } else error = 2;
    } else error = 3;

  }

  if( error ){					/* SEEK / READ Error */
    printf_system_error( error );
  }

  osd_fflush( drive[ drv ].fp );


	/* 桢ƥΥ顼ä۾ｪλ */

  if( error ){
    fdc.st0 = ST0_IC_AT | (fdc.hd<<2) | fdc.us | ST0_NR;
    fdc.st1 = 0;
    fdc.st2 = 0;
    status_message( 1, STATUS_WARN_TIME, "DiskI/O Write Error" );
  }else{
    fdc.st0 = ST0_IC_NT | (fdc.hd<<2) | fdc.us;
    fdc.st1 = 0;
    fdc.st2 = 0;
  }

  disk_now_track( drv,   drive[drv].track );
  return 1;
}



/*===========================================================================
 * E-PHASE ｪλˡ CHRN ؤ
 *	with_TC  (TCˤｪλ) ξ硢ǽʤ  CHRN ؤ
 *	with_TC                     ξ硢ǽǤ  CHRN Τޤ
 *	ʤǽã鿿֤
 *
 *	2DD/2HD ǤƱǤ(ʤ ;_;)
 *===========================================================================*/
static	int	fdc_next_chrn( int with_TC )
{
  if( fdc.mt==0 ){		/* ޥȥå򤷤ʤ */

    if( fdc.r == fdc.eot ){		/* ǽʤ顢	*/
      if( with_TC ){
	fdc.c ++;			/* C+=1, R=1 ˤ롣	*/
	fdc.r = 1;			/* 			*/
      }
      return 1;				/* ֤ͤ  (ǽ)	*/
    }else{
      fdc.r ++;				/* ǽǤʤСR+=1	*/
      return 0;				/* ֤ͤ  (³)	*/
    }

  }else{			/* ޥȥåλ */

    if( fdc.hd==0 ){		/*   ɽ̽ */

      if( fdc.r == fdc.eot ){		/* ǽʤ顢	*/
	fdc.hd = 1;			/* ΢̤ؤơ	*/
	fdc.h ^= 1;			/* H ȿžR = 1	*/
	fdc.r  = 1;			/* ֤ͤ  (³)	*/
	return 0;
      }else{
	fdc.r ++;			/* ǽǤʤСR+=1	*/
	return 0;			/* ֤ͤ  (³)	*/
      }

    }else{			/*   ΢̽ */

      if( fdc.r == fdc.eot ){		/* ǽʤ顢	*/
	if( with_TC ){
	  fdc.h ^= 1;			/* H ȿž		*/
	  fdc.c ++;			/* C+=1, R=1 ˤ롣	*/
	  fdc.r = 1;			/* 			*/
	}
	return 1;			/* ֤ͤ  (ǽ)	*/
      }else{
	fdc.r ++;			/* ǽǤʤСR+=1	*/
	return 0;			/* ֤ͤ  (³)	*/
      }
    }
  }
}



/*===========================================================================
 * ޥɥե
 *	ۥ(CPU)ȤΥǡΤ 4clock ˽
 *	 (ĤޤꡢǡΤ˥Ȥ̵)
 *===========================================================================*/
static	void	c_phase( void )
{
  int cmd, nd, i;
  unsigned char * const table[][10] =
  {
/*WAIT */{ 0 },
/*R_DAT*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.dtl,0},
/*R_DEL*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.dtl,0},
/*R_DIA*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.dtl,0},
/*R_ID */{ &fdc.c0,&fdc.c1, 0 },
/*W_DAT*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.dtl,0},
/*W_DEL*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.dtl,0},
/*W_ID */{ &fdc.c0,&fdc.c1, &fdc.n, &fdc.sc, &fdc.gpl, &fdc.d, 0 },
/*S_EQU*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.stp,0},
/*S_LOW*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.stp,0},
/*S_HIG*/{ &fdc.c0,&fdc.c1, &fdc.c,&fdc.h,&fdc.r,&fdc.n, &fdc.eot,&fdc.gpl,&fdc.stp,0},
/*SEEK */{ &fdc.c0,&fdc.c1, &fdc.cn, 0 },
/*RECAL*/{ &fdc.c0,&fdc.c1, 0 },
/*SNS_I*/{ &fdc.c0,         0 },
/*SNS_D*/{ &fdc.c0,&fdc.c1, 0 },
/*SPECI*/{ &fdc.c0,         &fdc.s0, &fdc.s1, 0 },
/*INVAL*/{ &fdc.c0,         0 },
  };

  /* ֥ۥȤǡFDCΡפΥȤɬפʤ顢 */
  /* ǻַвԤġ(ԤäƤ֤Ͻ˴ؿ򽪤)  */
  ;


  if( fdc.status & REQ_MASTER ){	/* ۥȤΥǡ̵ */

    ICOUNT( -1 );

  }else{				/* ۥȤǡ褿 */

    *table[ fdc.command ][ fdc.step ] = fdc.write;		/*ǡ*/
    fdc.step ++;

    if( table[ fdc.command ][ fdc.step ] ){	/* ޤǡɬפʻ */

      fdc.status = (fdc.status&0x0f) | FDC_BUSY | REQ_MASTER;
      ICOUNT( -1 );

    }else{					/* ǡ괰λ */

      if( FDC_flag ){					/* ȯʤ  */
	for( i=0; i<MAX_DRIVE; i++ ){			/* λ    */
	  if( fdc.seek_stat[i]==SEEK_STAT_INTR ){	/* ɥ饤 (  */
	    fdc.seek_stat[i] = SEEK_STAT_STOP;		/* ȯ) 򸡺    */
	    fdc.status &= ~(1<<i);
	    break;
	  }
	}
	fdc.intr_unit = i;				/* Υɥ饤֤    */
	fdc_cancel_interrupt();				/* SENSE INT   */

	if( verbose_fdc )
	  if( fdc.command != SENSE_INT_STATUS )
	    printf("FDC log : Missing SENSE INT STATUS $$$$\n" );
      }


      cmd     = (fdc.c0 & 0x1f);
      fdc.sk  = (fdc.c0 & 0x20) >> 5;
      fdc.mf  = (fdc.c0 & 0x40) >> 6;
      fdc.mt  = (fdc.c0 & 0x80) >> 7;

      fdc.us  = (fdc.c1 & 0x03);			/* SENSE INTINVALID*/
      fdc.hd  = (fdc.c1 & 0x04) >> 2;			/* Ǥפʤ*/


      switch( fdc.command ){				/* ޥ̤ν  */

      case READ_DIAGNOSTIC:					/* READ */
	if( verbose_fdc ){
	  printf("FDC %s : Drive %d Track %d\n",
		 cmd_name[fdc.command],fdc.us+1,fdc.ncn[fdc.us]*2+fdc.hd);
	}
	fdc.sk = 0;
	fdc.mt = 0;	/* FALLTHROUGH */
      case READ_DATA:
      case READ_DELETED_DATA:
      case READ_ID:
	fdc.status = (fdc.status&0x0f) | FDC_BUSY | DATA_IO;
	fdc.phase  = E_PHASE;

	if( fdc.command==READ_ID ){
	  if( verbose_fdc ){
	    printf("FDC %s : Drive %d Track %d\n",
		   cmd_name[fdc.command],fdc.us+1,fdc.ncn[fdc.us]*2+fdc.hd);
	  }
	  logfdc("%s mf%d us%d hd%d\n",
		 cmd_name[fdc.command],
		 fdc.mf,fdc.us,fdc.hd);
	}else{
	  logfdc("%s sk%d mf%d mt%d us%d hd%d eot=%d gpl=%d dtl=%d\n",
		 cmd_name[fdc.command],
		 fdc.sk,fdc.mf,fdc.mt,fdc.us,fdc.hd,fdc.eot,fdc.gpl,fdc.dtl);
	}
	break;

      case WRITE_DATA:						/* WRITE */
      case WRITE_DELETED_DATA:
	fdc.sk = 0;	/* FALLTHROUGH */
      case WRITE_ID:
	fdc.status = (fdc.status&0x0f) | FDC_BUSY;
	fdc.phase  = E_PHASE;

	if( fdc.command==WRITE_ID ){
	  logfdc("%s mf%d us%d hd%d n%d sc%d gpl%d d%02x\n",
		 cmd_name[fdc.command],
		 fdc.mf,fdc.us,fdc.hd,fdc.n,fdc.sc,fdc.gpl,fdc.d);
	}else{
	  logfdc("%s sk%d mf%d mt%d us%d hd%d eot=%d gpl=%d dtl=%d\n",
		 cmd_name[fdc.command],
		 fdc.sk,fdc.mf,fdc.mt,fdc.us,fdc.hd,fdc.eot,fdc.gpl,fdc.dtl);
	}
	break;

      case SEEK:						/* SEEK */
      case RECALIBRATE:
	fdc.ncn[ fdc.us ] = (fdc.command==SEEK) ? fdc.cn : 0 ;
	fdc.status = (fdc.status&0x0f) | FDC_BUSY;
	fdc.phase  = E_PHASE;

	logfdc("%s us%d %02x (Tr.%02d,%02d=>%02d,%02d)\n", 
	       cmd_name[fdc.command],
	       fdc.us,fdc.ncn[fdc.us],fdc.pcn[fdc.us]*2,fdc.pcn[fdc.us]*2+1,
				      fdc.ncn[fdc.us]*2,fdc.ncn[fdc.us]*2+1);
	break;

      case SENSE_INT_STATUS:					/* SENSE */
      case SENSE_DEVICE_STATUS:
      case INVALID:
	fdc.status  = (fdc.status&0x0f) | FDC_BUSY | DATA_IO;
	fdc.phase   = R_PHASE;	

	if( fdc.command==SENSE_DEVICE_STATUS ){
	  logfdc("%s us%d hd%d\n",   cmd_name[fdc.command], fdc.us, fdc.hd );
	}else{
	  logfdc("%s \n",            cmd_name[fdc.command] );
	}
	break;

      case SPECIFY:						/* SPECIFY */
	fdc.srt_clk = (16-((fdc.s0>>4)&0x0f)) *  (2*4000);  /* (16-srt)x 2ms */
	fdc.hut_clk =      (fdc.s0    &0x0f)  * (32*4000);  /*     hut x32ms */
	fdc.hlt_clk =     ((fdc.s1>>1)&0x7f)  *  (4*4000);  /*     hlt x 4ms */
	nd          =       fdc.s1    &   1;
	if( fdc.hut_clk==0 ) fdc.hut_clk = 16 * (32*4000);		/* ? */

	logfdc("%s srt%dms hut%dms hlt%dms (%02X %02X)\n",
	       cmd_name[fdc.command],
	     fdc.srt_clk/4000,fdc.hut_clk/4000,fdc.hlt_clk/4000,fdc.s0,fdc.s1);

	fdc.status  = (fdc.status&0x0f) | REQ_MASTER;
	fdc.command = WAIT;
	break;

      default:							/* ¾NG */
	fprintf( stderr, "FDC unsupported %02x(%s)\n",
		 cmd, cmd_name[ fdc.command ] );
	ICOUNT( -1 );
	return;
      }

      fdc.step = 0;
      ICOUNT( 0 );
      REPEAT();
    }
  }
}



/*===========================================================================
 * ꥶȥե
 *	ۥ(CPU)ȤΥǡΤ 4clock ˽
 *	 (ĤޤꡢǡΤ˥Ȥ̵)
 *===========================================================================*/
static	void	r_phase( void )
{
  int i;
  unsigned char * const table[][8] =
  {
/*WAIT */{ 0 },
/*R_DAT*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*R_DEL*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*R_DIA*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*R_ID */{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*W_DAT*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*W_DEL*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*W_ID */{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*S_EQU*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*S_LOW*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*S_HIG*/{ &fdc.st0, &fdc.st1, &fdc.st2, &fdc.c, &fdc.h, &fdc.r, &fdc.n, 0 },
/*SEEK */{ 0 },
/*RECAL*/{ 0 },
/*SNS_I*/{ &fdc.r0, &fdc.r1, 0 },
/*SNS_D*/{ &fdc.st3, 0 },
/*SPECI*/{ 0 },
/*INVAL*/{ &fdc.r0, 0 },
  };

	/* R-PHASE ΰֺǽˡΤǡΰ */

  if( fdc.step == 0 ){

    fdc.status &= ~REQ_MASTER;		/*  */
/*  ICOUNT( 0 );*/

    switch( fdc.command ){		/* ޥ̤ν  */

    case SENSE_INT_STATUS:			/* SENSE INT STATUS          */
      i = fdc.intr_unit;				/* (ȯ)*/
      fdc.intr_unit = 4;
      if( i < MAX_DRIVE ){				/* Υɥ饤֤    */
	if( i<NR_DRIVE ) fdc.r0 = ST0_IC_NT | ST0_SE | i;
	else             fdc.r0 = ST0_IC_AT | ST0_SE | ST0_NR | i;
	fdc.r1 = fdc.pcn[ i ];
	logfdc("\t\t\t\t\t\t<st0:%02x pcn:%02x>\n",
	       fdc.r0,fdc.r1);
      }else{						/* Ĥʤ  */
	fdc.command = INVALID;				/* INVALIDȤ */
	fdc.r0 = ST0_IC_IC;
	logfdc("\t\t\t\t\t\tinvalid\n");
      }
      break;

    case SENSE_DEVICE_STATUS:			/* SENSE DEVICE STATUS    */
      if( fdc.us >= NR_DRIVE ){			/* ST3          */
	fdc.st3 = ST3_FT | ((fdc.hd<<2) & ST3_HD) | ( fdc.us & ST3_US );
      }else{
	if( disk_not_exist( fdc.us ) ||
	    (disk_ex_drv & (1 << fdc.us)) ){ /* ǥؤå */
							    /* thanks peach! */
	  disk_ex_drv ^= (1 << fdc.us); /* ɥ饤ֹΥӥåȿž */
	  fdc.st3 =((fdc.status & (1<<fdc.us)) ? 0 : ST3_RY ) |
			((fdc.pcn[fdc.us]==0) ? ST3_T0 : 0 ) |
			((fdc.hd<<2) & ST3_HD) | ( fdc.us & ST3_US );
	}else{
	  fdc.st3 =((fdc.status & (1<<fdc.us)) ? 0 : ST3_RY ) |
	      		((drive[fdc.us].protect==DISK_PROTECT_TRUE)?ST3_WP:0) |
			((fdc.pcn[fdc.us]==0) ? ST3_T0 : 0 ) | ST3_TS |
			((fdc.hd<<2) & ST3_HD) | ( fdc.us & ST3_US );
	}
      }
      logfdc("\t\t\t\t\t\t<st3:%02x>\n",
	     fdc.st3);
      break;

    case INVALID:				/* INVALID                */
      fdc.r0 = ST0_IC_IC;			/* ST0          */
      logfdc("\t\t\t\t\t\t<st0:%02x>\n",
	     fdc.r0);
      break;

    default:					/* ʳ             */
      fdc_occur_interrupt();			/* ȯ     */
      logfdc("\t\t\t\t\t\t<ST:%02x %02x %02x  CHRN:%02x %02x %02x %02x>\n",
	     fdc.st0,fdc.st1,fdc.st2,fdc.c,fdc.h,fdc.r,fdc.n);
      break;
    }
  }



  if( fdc.status & REQ_MASTER ){	/* ۥȤޤǡɤޤ */

    /* ˤꡢ fdc.step == 0 λϤˤϤʤ */
    ICOUNT( -1 );

  }else{				/* ۥȤǡɤ */

    /* ֥ۥȤǡɹFDCΡפΥȤɬפʤ顢 */
    /* ǻַвԤġ(ԤäƤ֤Ͻ˴ؿ򽪤)  */
    ;

    if( table[ fdc.command ][ fdc.step ] ){		/* ޤǡ */

      if( fdc.step != 0 ) fdc_cancel_interrupt();

      fdc.status = (fdc.status&0x0f) | FDC_BUSY | DATA_IO | REQ_MASTER;
      fdc.read   = *table[ fdc.command ][ fdc.step ];
      fdc.step ++;
      ICOUNT( -1 );

    }else{						/* ⤦ǡʤ */

      fdc.read = 0xff;
      fdc.status = (fdc.status&0x0f) | REQ_MASTER;
      fdc.command = WAIT;
      fdc.step = 0;
      ICOUNT( -1 );
    }
  }
}



/*===========================================================================
 * 塼ե
 *===========================================================================*/

/*---------------------------------------------------------------------------
 *	SEEK
 *---------------------------------------------------------------------------*/
static	void	e_phase_seek( void )
{

  fdc.status = (fdc.status&0x0f) | REQ_MASTER | (1<<fdc.us);

  if( fdc.us >= NR_DRIVE ||				/* ̤³ɥ饤 or */
      fdc.pcn[ fdc.us ] == fdc.ncn[ fdc.us ] ){		/* פξ  */

    if( sec_buf.drv != fdc.us ) sec_buf.drv = -1;

    fdc.seek_stat[ fdc.us ] = SEEK_STAT_END;
    fdc.seek_wait[ fdc.us ] = 0;
    ICOUNT( 0 );
    REPEAT();

  }else{		/* ưΥɥ饤֤٥ɤ褦 ? */

    sec_buf.drv = -1;

#ifdef	WAIT_FOR_SEEK
    if( fdc_wait == FALSE ){
#endif
      fdc.pcn[ fdc.us ] = fdc.ncn[ fdc.us ];
      fdc.seek_stat[ fdc.us ] = SEEK_STAT_END;
      fdc.seek_wait[ fdc.us ] = 0;
      ICOUNT( 0 );
      REPEAT();

#ifdef	WAIT_FOR_SEEK
    }else{
      /*  ? */
      if ((cpu_timing > 0) && (fdc_wait)) {
	fdc_sound_counter = 0;
	/*logfdc("### Seek ###\n");*/
	xmame_dev_sample_seek();
      }
      fdc.seek_stat[ fdc.us ] = SEEK_STAT_MOVE;
      if( fdc.pcn[ fdc.us ] < fdc.ncn[ fdc.us ] ) fdc.pcn[ fdc.us ] ++;
      else                                        fdc.pcn[ fdc.us ] --;
      fdc.seek_wait[ fdc.us ] = fdc.srt_clk;
      ICOUNT( -1 );
      REPEAT();
    }
#endif
  }

  fdc.command = WAIT;
  fdc.step = 0;
}



/*---------------------------------------------------------------------------
 *	READ
 *---------------------------------------------------------------------------*/

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * ID򸡺ߤĤäХåեɤ߹
 *  -1:λ(E-PHASE)  0:Τޤ  1:
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_read_search( void )
{
  int search, ret, skip_this;

  if( fdc.command != READ_ID ){
    logfdc("\t\t\tC:%02X H:%02X R:%02X N:%02X  ",fdc.c,fdc.h,fdc.r,fdc.n);
  }


  fdc.ddam_not_skipped = 0;


  search = fdc_search_id();		/* ID			*/
/*printf("<%d><%d>",fdc.wait,fdc.carry);*/
  if( search == FALSE ){		/* ǽ (ǥ̤)	*/

    ret = 0;						/* ٤ʤ  */

  }else{				/* ǽ (ǥ)	*/

    if( fdc.command == READ_ID ){	    /* READ ID ξ		     */

      ret = -1;

    }else if( fdc.st0 & ST0_IC ){	    /*  IDĤʤ */

      logfdc("-Miss\n");
      ret = -1;

    }else{				    /*  IDĤä     */

      if( ( fdc.command==READ_DATA &&		/* (D)DAM פʤʤ    */
	    ( fdc.st2 & ST2_CM )   )          ||
	  ( fdc.command==READ_DELETED_DATA &&
	    !( fdc.st2 & ST2_CM )          )  ){
							/* åץå */
	if( fdc.sk ){ skip_this = TRUE;  }
	else        { skip_this = FALSE; fdc.ddam_not_skipped = TRUE; }

      }else{					/* (D)DAM פʤ    */
						/* (READ DIAGNOSTIC λ) */
	skip_this = FALSE;				/* åפϤʤ */
      }

      if( skip_this ){				/* 򥹥åפ */
	if( fdc_next_chrn(FALSE)==0 ){			/* ˿ʤ   */
	  logfdc("Skip\n");
	  ret = 0;
	}else{						/*  EOT ä  */
	  fdc.st0 |= ST0_IC_AT;
	  fdc.st1 |= ST1_EN;
	  logfdc("Skip-EOT\n");
	  ret = -1;
	}
      }else{					/* åפɤ    */
	fdc_read_data();
	fdc.data_ptr = 0;
	if( fdc.n==0 ) fdc.counter = (128>fdc.dtl) ? 128 : fdc.dtl;
	else           fdc.counter = 128 << (fdc.n & 7);
	ret = 1;
      }
    }
    REPEAT();
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Хåե1ХȤȤۥȤž (ȯ)
 *  -1:λ(λ)  1:
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_read_send( void )
{
  int ret;

  if( fdc.TC && fdc.data_ptr ){		/* TC椢 (1ʾ塢ȯ) */

    fdc.limit = 0;
    ICOUNT( (fdc.counter + 2) * CLOCK_BYTE() );
    REPEAT();
    ret = -1;

  }else{				/* TC̵ʤ顢ȯ */
    fdc_occur_interrupt();
    fdc.status = (fdc.status&0x0f) | FDC_BUSY | NON_DMA | DATA_IO | REQ_MASTER;
    fdc.read   = data_buf[ fdc.data_ptr ++ ];
    fdc.limit  = CLOCK_BYTE();
    ICOUNT( -1 );
    ret = 1;
  }

  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * ۥȤΰǧ (ߥꥢ)
 *  -1:λ(λ) 0:Τޤ  1:(žorλ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_read_recv( int interval )
{
  int ret;

  fdc.limit -= interval;
  if( fdc.limit < 0 ){			/* ַвǥС */
    /* fdc.st1 |= ST1_OR; */
    fdc.limit = 0;
    if( verbose_fdc )
      if( fdc_wait ) printf("FDC %s : Over Run\n", cmd_name[fdc.command] );
  }

  if( fdc.TC ){				/* TC椢ξ */

    fdc_cancel_interrupt();
    fdc.limit = 0;
    ICOUNT( (fdc.counter + 2) * CLOCK_BYTE() );
    REPEAT();
    ret = -1;

  }else{				/* ǡɤߤ줿 */

    if( !( fdc.status & REQ_MASTER ) ){
      fdc_cancel_interrupt();
      -- fdc.counter;
      ICOUNT( fdc.limit );
      REPEAT();
      if( fdc.counter==0 ){ fdc.limit = 2 * CLOCK_BYTE(); }
      else                { fdc.limit = 0;                }
      ret = 1;

    }else{				/* ޤɤޤƤʤ */
      ICOUNT( -1 );
      ret = 0;
    }
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 1νλ(žλʤTC)CRC顼TCǧ
 *  -1:λ(E-PHASE) 0:Τޤ  1:(ޥ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_read_end( int interval )
{
  int ret;

  fdc.limit -= interval;
  if( fdc.limit < 0 ){
    fdc.limit = 0;
  }

  if( fdc.command != READ_DIAGNOSTIC &&
      fdc.st0 & ST0_IC ){		/* ID/DATA CRC顼ξ	*/

    logfdc("-CRC\n");
    ICOUNT( fdc.limit );
    REPEAT();
    fdc.limit = 0;
    ret = -1;							/* E-PHASE */

  }else{				/* CRCä	*/

    if( fdc.TC ){			    /* TC椬ä */

      if( fdc.ddam_not_skipped ){		/* (D)DAM԰פʤΤ˥å*/
	logfdc("TC(Noskip)\n");			/* ʤ顢ΥΤޤ*/

      }else{					/* ʳ (READ DIAG)ʤ*/
	fdc_next_chrn(TRUE);			/* ؤ            */
	logfdc("TC\n");
      }
      ICOUNT( fdc.limit );
      REPEAT();
      fdc.limit = 0;
      ret = -1;							/* E-PHASE */

    }else{				    /* TC椬ʤ */

      if( fdc.limit <= 0 ){		    /* 2Хȥв */

	if( fdc.ddam_not_skipped ){		/* (D)DAM԰פʤΤ˥å*/
	  fdc.st0 |= ST0_IC_AT;			/* ʤ顢۾ｪλ        */
	  fdc.st1 |= ST1_EN;
	  logfdc("MT-Noskip\n");
	  ret = -1;						/* E-PHASE */

	}else{					/* ʳ (READ DIAG)ʤ*/

	  if( fdc_next_chrn(FALSE)==0 ){		/* ˿ʤ   */
	    logfdc("MT\n");
	    ret = 1;
	  }else{					/*  EOT ä  */
	    fdc.st0 |= ST0_IC_AT;
	    fdc.st1 |= ST1_EN;
	    logfdc("MT-EOT\n");
	    ret = -1;
	  }
	}
	ICOUNT( 0 );
	REPEAT();

      }else{				    /* 2ХȥвԤ */
	ICOUNT( 10 );					/* Ŭʾʻ */
	ret = 0;
      }
    }
  }

  if( ret != 0 ){
    fdc.carry = fdc.gap3;
/*  printf("<%d><%d>",fdc.wait,fdc.carry);*/
  }
  return ret;
}


/*---------------------------------------------------------------------------
 *	READ/WRITE
 *---------------------------------------------------------------------------*/

static	void	e_phase_finish( void )
{
  fdc.TC = FALSE;
  fdc.status = (fdc.status&0x0f) | FDC_BUSY | DATA_IO;
  fdc.phase  = R_PHASE;
  fdc.step   = 0;
  ICOUNT( 0 );
  REPEAT();
}


/*---------------------------------------------------------------------------
 *	WRITE
 *---------------------------------------------------------------------------*/

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 񤭹߲ǽå
 *  -1:λ(E-PHASE)  0:Τޤ  1:
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_writeid_search( void )
{
  int search, ret;

  search = fdc_check_unit();		/* Ƚꤹ			*/

  if( search == FALSE ){		/* Ƚǽ (ǥ̤)	*/

    ret = 0;						/* ٤ʤ  */

  }else{				/* Ƚ			*/

    if( fdc.st0 & ST0_IC ){		    /* 񤭹ǽ */

      logfdc("-WrPro\n");
      ret = -1;

    }else{				    /* 񤭹߲ǽ */
      fdc.data_ptr = 0;
      if( fdc.sc==0 ){
	fdc.counter = 256 * 4;
	if( verbose_fdc )
	  printf("FDC %s : no sector\n",cmd_name[fdc.command]);
      }else{
	fdc.counter = fdc.sc * 4;
      }
      ret = 1;
    }
    REPEAT();
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 񤭹ID򸡺
 *  -1:λ(E-PHASE)  0:Τޤ  1:
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_write_search( void )
{
  int search, ret;

  logfdc("\t\t\tC:%02X H:%02X R:%02X N:%02X  ",fdc.c,fdc.h,fdc.r,fdc.n);


  search = fdc_search_id();		/* ID			*/

  if( search == FALSE ){		/* ǽ (ǥ̤)	*/

    ret = 0;						/* ٤ʤ  */

  }else{				/* ǽ (ǥ)	*/

    if( fdc.st0 & ST0_IC ){	    	    /*  ۾ȯ         */

      if( fdc.st1 & ST1_NW ){			/* 񤭹ǽ     */
	logfdc("-WrPro\n");
      }else{					/* IDĤʤ */
	logfdc("-Miss\n");
      }
      ret = -1;

    }else{				    /* ơ̵ID򸫤Ĥ    */
      fdc.data_ptr = 0;
      if( fdc.n==0 ) fdc.counter = (128>fdc.dtl) ? 128 : fdc.dtl;
      else           fdc.counter = 128 << (fdc.n & 7);
      ret = 1;
    }
    REPEAT();
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * ۥȤž׵ (ȯ)
 *  -1:λ(λ)  1:
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_write_request( void )
{
  int ret;

  if( fdc.TC && fdc.data_ptr ){		/* TC椢 (1ʾ塢ȯ) */

    fdc.limit = 0;
    if( fdc.command == WRITE_ID ) ICOUNT( 0 ); /* ׻ݤʤΤ 0 */
    else                          ICOUNT( (fdc.counter + 2) * CLOCK_BYTE() );
    REPEAT();
    ret = -1;

  }else{				/* TC̵ʤ顢ȯ */
    fdc_occur_interrupt();
    fdc.status = (fdc.status&0x0f) | FDC_BUSY | NON_DMA | REQ_MASTER;
    fdc.limit  = CLOCK_BYTE();
    ICOUNT( -1 );
    ret = 1;
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * ۥȤ1ХȰꡢХåե (ߥꥢ)
 *  -1:λ(λ) 0:Τޤ  1:(žorλ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_write_respond( int interval )
{
  int ret;

  fdc.limit -= interval;

  if( fdc.limit<0 ){			/* ַвǥС */
    /* fdc.st1 |= ST1_OR; */
    fdc.limit = 0;
    if( verbose_fdc )
      if( fdc_wait ) printf("FDC %s : Over Run\n", cmd_name[fdc.command] );
  }

  if( fdc.TC ){				/* TC椢ξ */

    fdc_cancel_interrupt();
    fdc.limit = 0;
    if( fdc.command == WRITE_ID ) ICOUNT( 0 ); /* ׻ݤʤΤ 0 */
    else                          ICOUNT( (fdc.counter + 2) * CLOCK_BYTE() );
    REPEAT();
    ret = -1;

  }else{				/* ǡ񤭹ޤ줿 */

    if( !( fdc.status & REQ_MASTER ) ){
      fdc_cancel_interrupt();
      data_buf[ fdc.data_ptr ++ ] = fdc.write;
      -- fdc.counter;

      if( fdc.command == WRITE_ID ){
	logfdc("%02X %s",fdc.write,((fdc.counter%4)==0)?"\n":"");

	ICOUNT( fdc.limit + ( ((fdc.counter%4)==0)? CLOCK_SECTOR(fdc.n) :0 ) );
	REPEAT();
	if( fdc.counter==0 ){ fdc.limit = CLOCK_GAP4(fdc.n); }
	else                { fdc.limit = 0; }
      }else{
	ICOUNT( fdc.limit );
	REPEAT();
	if( fdc.counter==0 ){ fdc.limit = 2 * CLOCK_BYTE(); }
	else                { fdc.limit = 0;                }
      }
      ret = 1;

    }else{				/* ޤ񤫤Ƥʤ */
      ICOUNT( -1 );
      ret = 0;
    }
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 1ȥåʬ᡼ե˽񤭽Ф
 *  1:λ(λ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_writeid_track( void )
{
  int ret;

  fdc.TC = FALSE;			/* TC椬оä */
  if( fdc.counter!=0 ){
    if( verbose_fdc ) printf("FDC %s : CHRN missing\n",cmd_name[fdc.command]);

    while( (fdc.counter%4)!=0 ){		/* 4ХȤʤ */
      data_buf[ fdc.data_ptr ++ ] = 0x00;	/* ʬ00H */
      -- fdc.counter;
    }
    fdc.sc = (4*fdc.sc - fdc.counter) /4;	/* θ SC 򹹿 */
  }

  fdc_write_id();			/* 饤Ȥ			*/
  {
    ICOUNT( fdc.limit );
    REPEAT();
    fdc.limit = 0;
    fdc.carry = 0;
    ret = 1;				
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 1ʬ᡼ե˽񤭽Ф
 *  1:λ(λ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_write_sector( void )
{
  int i, ret;

  while( fdc.counter ){			/* ʤ	*/
    data_buf[ fdc.data_ptr ++ ] = 0x00;	/*	00H		*/
    -- fdc.counter;
  }
  if( fdc.n==0 && fdc.dtl<128 ){
    for( i=0; i<128-fdc.dtl; i++ ){
      data_buf[ fdc.data_ptr ++ ] = 0x00;
    }
  }

  fdc_write_data();			/* 饤Ȥ			*/
  {
    ICOUNT( 0 );
    REPEAT();
    ret = 1;
  }
  return ret;
}



/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 1νλ(񤭹ߺ)TCǧ (顼Ϥꤨʤ)
 *  -1:λ(E-PHASE) 0:Τޤ  1:(ޥ)
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	*/ 	
static	int	e_phase_write_end( int interval )
{
  int ret;

  fdc.limit -= interval;
  if( fdc.limit < 0 ){
    fdc.limit = 0;
  }

  if( fdc.TC ){				    /* TC椬ä       */

    fdc_next_chrn(TRUE);			    /* ؤ   */
    logfdc("TC\n");
    ICOUNT( fdc.limit + CLOCK_BYTE() );
    REPEAT();
    fdc.limit = 0;
    ret = -1;							/* E-PHASE */

  }else{				    /* TC椬ʤ         */

    if( fdc.limit <= 0 ){			/* 2Хȥв    */

      if( fdc_next_chrn(FALSE)==0 ){		    /* ˿ʤ   */
	logfdc("MT\n");
	ret = 1;
      }else{					    /*  EOT ä  */
	fdc.st0 |= ST0_IC_AT;
	fdc.st1 |= ST1_EN;
	logfdc("MT-EOT\n");
	ret = -1;
      }
      ICOUNT( 0 );
      REPEAT();

    }else{					/* 2ХȥвԤ*/
      ICOUNT( 10 );				    /* Ŭʾʻ */
      ret = 0;
    }
  }

  if( ret != 0 ){
    fdc.carry = fdc.gap3;
  }
  return ret;
}







/************************************************************************/
/* FDC  ᥤ							*/
/*	 ˤδؿƤηв( 4MHzơȤ )	*/
/************************************************************************/

int	fdc_ctrl( int interval )
{
  int	i, w, rest;


  if( fdc.wait < 0 ){			/* ̵Ԥä */
    rest = 0;
    fdc.wait = 0;
    fdc.carry -= interval;
    if( fdc.carry < 0 ) fdc.carry = 0;
  }else{				/* ͭԤä */
    if( fdc.wait >= interval ){			/* ȸ */
      rest = 0;
      fdc.wait -= interval;
    }else{
      rest = interval - fdc.wait;		/* ޤʬ rest ˥å */
      fdc.wait = 0;
    }
  }

  /********************************** ư *****************************/

  for( i=0; i<NR_DRIVE; i++ ){				/* ɥ饤 01Τ */
    if( fdc.seek_stat[i] == SEEK_STAT_MOVE ){		/*  ʤ */
      fdc.seek_wait[i] -= interval;
      if( fdc.seek_wait[i] <= 0 ){
	if( fdc.ncn[i] == fdc.pcn[i] ){				/*  */
	  fdc.seek_stat[i] = SEEK_STAT_END;
	  fdc.seek_wait[i] = 0;
	}else{							/* ޤޤ */
	  /*  ? */
	  if ((cpu_timing > 0) && (fdc_wait)) {
	    fdc_sound_counter ++;
	    if (fdc_sound_counter >= fdc_sound_skipper) {
	      fdc_sound_counter = 0;
	      /*logfdc("### Seek ###\n");*/
	      xmame_dev_sample_seek();
	    }
	  }
	  if( fdc.pcn[i] < fdc.ncn[i] ) fdc.pcn[i] ++;
	  else                          fdc.pcn[i] --;
	  fdc.seek_wait[i] = fdc.srt_clk;
	}
      }
    }
  }

  /*************************** إåɥư **************************/
#ifdef	WAIT_FOR_HEADLOAD
  if( fdc.command == WAIT ||			/* ꡼/饤Ȱʳ         */
      fdc.command >= SEEK ){
    for( i=0; i<MAX_DRIVE; i++ ){
      if( fdc.hl_stat[i] ){				/* إåɥʤ*/
	fdc.hl_wait[i] += interval;				/* ֤û*/
	if( fdc.hl_wait[i] >= fdc.hut_clk ){
	  fdc.hl_stat[i] = FALSE;
	  /* ɲ ? */
	  if ((cpu_timing > 0) && (fdc_wait)) {
	    /*logfdc("### Head Up ###\n");*/
	    xmame_dev_sample_headup();
	  }
	}
      }
    }
  }
#endif

  /******* FDC Ȥʤʤ(˼)̵¤˷֤ ******/

  do {

    if( fdc.command == WAIT ){	/*========================== ޥԤ ===*/

      if( ( fdc.status & REQ_MASTER )==0 ){	/* ޥɼ	*/
	switch( fdc.write & 0x1f ){
	case 0x06:	fdc.command = READ_DATA;		break;
	case 0x0c:	fdc.command = READ_DELETED_DATA;	break;
	case 0x0a:	fdc.command = READ_ID;			break;
	case 0x0d:	fdc.command = WRITE_ID;			break;
	case 0x05:	fdc.command = WRITE_DATA;		break;
	case 0x09:	fdc.command = WRITE_DELETED_DATA;	break;
	case 0x02:	fdc.command = READ_DIAGNOSTIC;		break;
	case 0x11:	fdc.command = SCAN_EQUAL;		break;
	case 0x19:	fdc.command = SCAN_LOW_OR_EQUAL;	break;
	case 0x1d:	fdc.command = SCAN_HIGH_OR_EQUAL;	break;
	case 0x0f:	fdc.command = SEEK;			break;
	case 0x07:	fdc.command = RECALIBRATE;		break;
	case 0x08:	fdc.command = SENSE_INT_STATUS;		break;
	case 0x04:	fdc.command = SENSE_DEVICE_STATUS;	break;
	case 0x03:	fdc.command = SPECIFY;			break;
	default:	fdc.command = INVALID;			break;
	}
	fdc.phase = C_PHASE;
	fdc.step  = 0;
	fdc.TC    = FALSE;
	ICOUNT( 0 );					/* ֤ */

      }else {					/* ޥɤʤ	*/

	for( i=0; i<MAX_DRIVE; i++ ){			/* λȽ */
	  if( fdc.seek_stat[i] == SEEK_STAT_END ){
	    fdc_occur_interrupt();
	    fdc.seek_stat[i] = SEEK_STAT_INTR;
	    fdc.seek_wait[i] = 0;
	    if( i<NR_DRIVE && disk_not_exist(i)==FALSE &&
		sec_buf.drv == -1 ){
	      disk_now_track( i, fdc.ncn[ i ]*2 + fdc.hd );
	      fdc.carry = 0;
	    }
	    break;
	  }
	}
	ICOUNT( -1 );
      }
      break;

    }else{			/*========================== ޥɽ ===*/

      if( fdc.wait ) break;

      switch( fdc.phase ){
      case C_PHASE:		    /* = = = = = = = C-PHASE = = = = = = = = */
	c_phase();
	break;

      case E_PHASE:		    /* = = = = = = = E-PHASE = = = = = = = = */
	switch( fdc.command ){

	case READ_DATA:			/* ---------------------- READ DATA -*/
	case READ_DELETED_DATA:		/* -------------- READ DELETED DATA -*/
	case READ_DIAGNOSTIC:		/* ---------------- READ DIAGNOSTIC -*/
	case READ_ID:			/* ------------------------ READ ID -*/
	  switch( fdc.step ){
	  case 0:				/* ID᡼꡼ - -*/
	    switch( e_phase_read_search() ){
	    case -1:	fdc.step = 4;	break;		/* 顼ȯ   */
	    case  1:	fdc.step = 1;	break;		/* ꡼ɽ */
	    default:			break;		/* Ԥ         */
	    }	/* READ ID  case 1: Ϥꤨʤ */
	    break;

	  case 1:				/* 1Х  - - - - - - -*/
	    switch( e_phase_read_send() ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:	fdc.step = 2;	break;		/* ž */
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 2:				/* ۥȰԤ - - - - -*/
	    switch( e_phase_read_recv( interval ) ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:
	      if( fdc.counter==0 ) fdc.step = 3;	/* TC Ԥ  */
	      else                 fdc.step = 1;	/* ž */
	      break;
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 3:				/* 1λ  - - - - - - -*/
	    switch( e_phase_read_end( interval ) ){
	    case -1:	fdc.step = 4;	break;		/* λ       */
	    case  1:	fdc.step = 0;	break;		/*  */
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 4:				/* E-PHASEλ  - - - - - - -*/
	    e_phase_finish();
	    break;
	  }
	  break;


	case WRITE_ID:			/* ----------------------- WRITE ID -*/
	  switch( fdc.step ){
	  case 0:				/* ǧ - - - - - - - - -*/
	    switch( e_phase_writeid_search() ){
	    case -1:	fdc.step = 4;	break;		/* 顼ȯ   */
	    case  1:	fdc.step = 1;	break;		/* 饤Ƚ */
	    default:			break;		/* Ԥ         */
	    }
	    break;

	  case 1:				/* ۥȤ׵ - - - - - - -*/
	    switch( e_phase_write_request() ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:	fdc.step = 2;	break;		/* ž */
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 2:				/* 1Хȼ  - - - - - - -*/
	    switch( e_phase_write_respond( interval ) ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:
	      if( fdc.counter==0 ) fdc.step = 3;	/* 񤭹ߤ */
	      else                 fdc.step = 1;	/* ž */
	      break;
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 3:				/* ᡼񤭹 - - - - -*/
	    e_phase_writeid_track();
	    fdc.step = 4;	/* FALLTHROUGH */
	  case 4:				/* E-PHASEλ  - - - - - - -*/
	    e_phase_finish();
	    break;
	  }
	  break;


	case WRITE_DATA:		/* --------------------- WRITE DATA -*/
	case WRITE_DELETED_DATA:	/* ------------- WRITE DELETED DATA -*/
	  switch( fdc.step ){
	  case 0:				/* ID - - - - - - - - - -*/
	    switch( e_phase_write_search() ){
	    case -1:	fdc.step = 5;	break;		/* 顼ȯ   */
	    case  1:	fdc.step = 1;	break;		/* 饤Ƚ */
	    default:			break;		/* Ԥ         */
	    }
	    break;

	  case 1:				/* ۥȤ׵ - - - - - - -*/
	    switch( e_phase_write_request() ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:	fdc.step = 2;	break;		/* ž */
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 2:				/* 1Хȼ  - - - - - - -*/
	    switch( e_phase_write_respond( interval ) ){
	    case -1:	fdc.step = 3;	break;		/* TC     */
	    case  1:
	      if( fdc.counter==0 ) fdc.step = 3;	/* TC Ԥ  */
	      else                 fdc.step = 1;	/* ž */
	      break;
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 3:				/* ᡼񤭹 - - - - -*/
	    e_phase_write_sector();
	    fdc.step = 4;	/* FALLTHROUGH */
	  case 4:				/* 1λ  - - - - - - -*/
	    switch( e_phase_write_end( interval ) ){
	    case -1:	fdc.step = 5;	break;		/* λ       */
	    case  1:	fdc.step = 0;	break;		/*  */
	    default:			break;		/* Ԥ       */
	    }
	    break;

	  case 5:				/* E-PHASEλ  - - - - - - -*/
	    e_phase_finish();
	    break;
	  }
	  break;


	case SEEK:			/* --------------------------- SEEK -*/
	case RECALIBRATE:		/* -------------------- RECALIBRATE -*/
	  e_phase_seek();
	  break;


	case SENSE_INT_STATUS:		/* --------------- SENSE_INT_STATUS -*/
	case SENSE_DEVICE_STATUS:	/* ------------ SENSE_DEVICE_STATUS -*/
	case SPECIFY:			/* ------------------------ SPECIFY -*/
	case INVALID:			/* ------------------------ Invalid -*/
	  /* E-PHASE̵ */
	  break;


	default:			/* ----------------------------------*/
	  /* ̤бޥɡġġ */
	  break;
	}
	break;


      case R_PHASE:		    /* = = = = = = = R-PHASE = = = = = = = = */
	r_phase();
	break;
      }
    }


    if( rest > 0 ){			/* ȸκݤΤޤʬ */
      if( fdc.wait < 0 ){
	fdc.carry -= rest;
	if( fdc.carry < 0 ) fdc.carry = 0;
      }else{
	fdc.wait -= rest;
	if( fdc.wait < 0 ) fdc.wait = 0;
      }
      rest   = 0;
    }
    interval = 0;

  } while( fdc.wait==0 );


  /************  FDCޤǤԤ֤򻻽 (-1̵¤Ԥ) ************/
  w = -1;

  if( fdc.command == WAIT ){		/* ԵΤߡλ֤ǧ */
    for( i=0; i<MAX_DRIVE; i++ ){
      if( fdc.seek_stat[i] == SEEK_STAT_MOVE &&
	  fdc.seek_wait[i] >  0 ){
	if( w == -1 ) w = fdc.seek_wait[i];
	else if( w > fdc.seek_wait[i] ) w = fdc.seek_wait[i];
      }
    }
  }
  /* w ϥλޤǤκûå ޤ -1 åȤƤ */

  if( fdc_wait == FALSE ||		/* Ȥʤ ޤ          */
      fdc.wait < 0 ){			/* Ȥ̵Ԥξ */

    ;/* w (λʤ̵) ޤԤ */

  }else{				/* Ԥ֤Ѥߤξ     */
    if( w < 0 ) w = fdc.wait;
    else        w = MIN( w, fdc.wait );
  }

  return w;					
}



/************************************************************************/
/* ɥ饤֤ξ֤֤ؿ						*/
/************************************************************************/
int	get_drive_ready( int drv )
{
  if( fdc.command==WAIT ) return 1;
  else{
    if( fdc.us==drv ) return 0;
    else              return 1;
  }
}



/************************************************************************/
/* ֤                                                     */
/************************************************************************/
/*
 * READ DIAG Υ֤Υǡϡpeachˤ󶡤ޤ
 */
#define IF_WITHIN_DATA_BUF_SIZE(s)	\
if (s >= DATA_BUF_SIZE) {		\
    printf("FDC : Buffer over flow\n");	\
    fflush(stdout);			\
    return(-1);				\
} else

#define RET_GAP_ERR(cond) if (cond != TRUE) return(-1);

/*
 * GAP3 η׻
 */
INLINE
int calc_gap3_size(int n, Uchar fdc_mf)
{
    int gap3_size;

    /* GAP3 ΥϷޤäƤ櫓ǤϤʤΤǤޤɸŪ */
    switch (n) {
    case 1:	gap3_size = 27;	break;
    case 2:	gap3_size = 42;	break;
    case 3:	gap3_size = 58;	break;
    default:	gap3_size = 58; /* ¾ʬ */
    }
    if (fdc_mf) gap3_size *= 2;	/* ̩ */
    return(gap3_size);
}

INLINE
int input_safely_data(int ptr, int *ad, int data, int size)
{
    if (size == 0) return(TRUE);

    if (ptr + *ad + size < DATA_BUF_SIZE) {
	memset(&data_buf[ptr + *ad], data, size);
	*ad += size;
	return(TRUE);
    } else {
	printf("FDC : Buffer overflow\n");
	fflush(stdout);
	return(FALSE);
    }
}

static int fill_sector_gap(int ptr, int drv, Uchar fdc_mf)
{
    int   sync_size, am_size;
    int   gap0_size, gap1_size, gap2_size, gap3_size, gap4_size;
    int   track_size;
    Uchar gap;
    Uchar undel;
    int   size;
    int   tmp_size;
    
    if (fdc_mf) {
	/* ̩ */
	track_size = 6250;
	gap0_size = 80;
	sync_size = 12;
	am_size   = 3 + 1;
	gap1_size = 50;
	gap2_size = 22;
	gap = 0x4e;
	/*if      (sec_buf.sec_nr <= 8)  gap4_size = 654;
	  else if (sec_buf.sec_nr <= 15) gap4_size = 400;
	  else                           gap4_size = 598;*/
    } else {
	/* ñ̩ */
	track_size = 3100;
	gap0_size = 40;
	sync_size = 6;
	am_size = 1;
	gap1_size = 26;
	gap2_size = 11;
	gap = 0xff;
	/*if      (sec_buf.sec_nr <= 8)  gap4_size = 311;
	  else if (sec_buf.sec_nr <= 15) gap4_size = 170;
	  else                           gap4_size = 247;*/
    }
    gap3_size = calc_gap3_size(sec_buf.n, fdc_mf);

    size = 0;
    /* DATA եɤκǸ */
    size += 2;			/* DATA CRC */

    /* GAP3 */
    RET_GAP_ERR(input_safely_data(ptr, &size, gap, gap3_size));

    /* ǽʤץꥢ֥ + ݥȥ֥ */
    if (drive[drv].sec + 1 >= drive[drv].sec_nr) {
	/* ݥȥ֥ (GAP4) ΥĴ٤ */
	tmp_size = gap0_size + sync_size + am_size + gap1_size;
	/* ƤΥ GAP 򥫥 */
	do {
	    disk_next_sec(drv);
	    tmp_size += sync_size + am_size + 4 + 2; /* ID ե */
	    tmp_size += gap2_size;
	    tmp_size += sync_size + am_size + sec_buf.size + 2;
	    tmp_size += calc_gap3_size(sec_buf.n, fdc_mf);
	} while (drive[drv].sec + 1 < drive[drv].sec_nr);
	gap4_size = track_size - tmp_size;
	if (gap4_size < 0) {
	    printf("Abnormal sector\n");
	    return(-1);
	}

	
	RET_GAP_ERR(input_safely_data(ptr, &size, gap, gap4_size));
	RET_GAP_ERR(input_safely_data(ptr, &size, 0, sync_size));
	RET_GAP_ERR(input_safely_data(ptr, &size, 0xc2, am_size - 1));
	RET_GAP_ERR(input_safely_data(ptr, &size, 0xfc, 1));
	RET_GAP_ERR(input_safely_data(ptr, &size, gap, gap1_size));
    }
  
    /* Υ */
    disk_next_sec(drv);

    /* ID ե */
    RET_GAP_ERR(input_safely_data(ptr, &size, 0, sync_size));
    RET_GAP_ERR(input_safely_data(ptr, &size, 0xa1, am_size - 1));
    RET_GAP_ERR(input_safely_data(ptr, &size, 0xfe, 1));
  
    RET_GAP_ERR(input_safely_data(ptr, &size, sec_buf.c, 1));
    RET_GAP_ERR(input_safely_data(ptr, &size, sec_buf.h, 1));
    RET_GAP_ERR(input_safely_data(ptr, &size, sec_buf.r, 1));
    RET_GAP_ERR(input_safely_data(ptr, &size, sec_buf.n, 1));
    size += 2;			/* ID CRC */

    /* GAP2 */
    RET_GAP_ERR(input_safely_data(ptr, &size, gap, gap2_size));

    /* DATA ե */
    RET_GAP_ERR(input_safely_data(ptr, &size, 0, sync_size));
    RET_GAP_ERR(input_safely_data(ptr, &size, 0xa1, am_size - 1));

    if (sec_buf.deleted == DISK_DELETED_TRUE) undel = 0xf8;
    else undel = 0xfb;
    RET_GAP_ERR(input_safely_data(ptr, &size, undel, 1));
  
    return(size);
}



/***********************************************************************
 * ơȥɡơȥ
 ************************************************************************/

#define	SID		"FDC "
#define	SID_DATA	"FDC0"
#define	SID2		"FDC2"

static	T_SUSPEND_W	suspend_fdc_work[]=
{
  { TYPE_STR,	&file_disk[0][0],	},
  { TYPE_STR,	&file_disk[1][0],	},
  { TYPE_INT,	&image_disk[0],		},
  { TYPE_INT,	&image_disk[1],		},
  { TYPE_INT,	&readonly_disk[0],	},
  { TYPE_INT,	&readonly_disk[1],	},

  { TYPE_INT,	&disk_exchange,		},
  { TYPE_INT,	&disk_ex_drv,		},

  { TYPE_INT,	&FDC_flag,		},
  { TYPE_INT,	&fdc_wait,		},

  { TYPE_INT,	&fdc.command,		},
  { TYPE_INT,	&fdc.phase,		},
  { TYPE_INT,	&fdc.step,		},
  { TYPE_INT,	&fdc.counter,		},
  { TYPE_INT,	&fdc.data_ptr,		},

  { TYPE_INT,	&fdc.limit,		},
  { TYPE_INT,	&fdc.wait,		},
  { TYPE_INT,	&fdc.carry,		},
  { TYPE_INT,	&fdc.gap3,		},

  { TYPE_INT,	&fdc.seek_stat[0],	},
  { TYPE_INT,	&fdc.seek_stat[1],	},
  { TYPE_INT,	&fdc.seek_stat[2],	},
  { TYPE_INT,	&fdc.seek_stat[3],	},
  { TYPE_INT,	&fdc.seek_wait[0],	},
  { TYPE_INT,	&fdc.seek_wait[1],	},
  { TYPE_INT,	&fdc.seek_wait[2],	},
  { TYPE_INT,	&fdc.seek_wait[3],	},

  { TYPE_INT,	&fdc.srt_clk,		},
  { TYPE_INT,	&fdc.hut_clk,		},
  { TYPE_INT,	&fdc.hlt_clk,		},
  { TYPE_INT,	&fdc.hl_stat[0],	},
  { TYPE_INT,	&fdc.hl_stat[1],	},
  { TYPE_INT,	&fdc.hl_stat[2],	},
  { TYPE_INT,	&fdc.hl_stat[3],	},
  { TYPE_INT,	&fdc.hl_wait[0],	},
  { TYPE_INT,	&fdc.hl_wait[1],	},
  { TYPE_INT,	&fdc.hl_wait[2],	},
  { TYPE_INT,	&fdc.hl_wait[3],	},

  { TYPE_INT,	&fdc.ddam_not_skipped,	},

  { TYPE_BYTE,	&fdc.status,		},
  { TYPE_BYTE,	&fdc.read,		},
  { TYPE_BYTE,	&fdc.write,		},
  { TYPE_BYTE,	&fdc.TC,		},

  { TYPE_CHAR,	&fdc.sk,		},
  { TYPE_CHAR,	&fdc.mf,		},
  { TYPE_CHAR,	&fdc.mt,		},
  { TYPE_CHAR,	&fdc.us,		},
  { TYPE_CHAR,	&fdc.hd,		},
  { TYPE_CHAR,	&fdc.c,			},
  { TYPE_CHAR,	&fdc.h,			},
  { TYPE_CHAR,	&fdc.r,			},
  { TYPE_CHAR,	&fdc.n,			},
  { TYPE_CHAR,	&fdc.eot,		},
  { TYPE_CHAR,	&fdc.gpl,		},
  { TYPE_CHAR,	&fdc.dtl,		},
  { TYPE_CHAR,	&fdc.d,			},
  { TYPE_CHAR,	&fdc.sc,		},
  { TYPE_CHAR,	&fdc.stp,		},
  { TYPE_CHAR,	&fdc.ncn[0],		},
  { TYPE_CHAR,	&fdc.ncn[1],		},
  { TYPE_CHAR,	&fdc.ncn[2],		},
  { TYPE_CHAR,	&fdc.ncn[3],		},
  { TYPE_CHAR,	&fdc.pcn[0],		},
  { TYPE_CHAR,	&fdc.pcn[1],		},
  { TYPE_CHAR,	&fdc.pcn[2],		},
  { TYPE_CHAR,	&fdc.pcn[3],		},
  { TYPE_CHAR,	&fdc.st0,		},
  { TYPE_CHAR,	&fdc.st1,		},
  { TYPE_CHAR,	&fdc.st2,		},
  { TYPE_CHAR,	&fdc.st3,		},

  { TYPE_END,	0			},
};

static	T_SUSPEND_W	suspend_fdc_work2[]=
{
  { TYPE_CHAR,	&fdc.c0			},
  { TYPE_CHAR,	&fdc.c1			},
  { TYPE_CHAR,	&fdc.cn			},
  { TYPE_CHAR,	&fdc.s0			},
  { TYPE_CHAR,	&fdc.s1			},
  { TYPE_CHAR,	&fdc.r0			},
  { TYPE_CHAR,	&fdc.r1			},
  { TYPE_CHAR,	&fdc.intr_unit		},

  { TYPE_END,	0			},
};


int	statesave_fdc( void )
{
  image_disk[0] = drive[0].selected_image;
  image_disk[1] = drive[1].selected_image;

  if( statesave_table( SID, suspend_fdc_work ) != STATE_OK ) return FALSE;

  /* ǡХåե */
  if( statesave_block( SID_DATA, data_buf, DATA_BUF_SIZE ) != STATE_OK )
								return FALSE;

  if( statesave_table( SID2, suspend_fdc_work2 ) != STATE_OK ) return FALSE;

  return TRUE;
}

int	stateload_fdc( void )
{
  if( stateload_table( SID, suspend_fdc_work ) != STATE_OK ) return FALSE;

  /* ǡХåե */
  if( stateload_block( SID_DATA, data_buf, DATA_BUF_SIZE ) != STATE_OK )
								return FALSE;

  if( stateload_table( SID2, suspend_fdc_work2 ) != STATE_OK ){

    /* Сʤ顢ߤΤ */

    printf( "stateload : Statefile is old. (ver 0.6.0 or 1?)\n" );

    /* ȤΤˤʤ褦֤Բǽä */
    /* ʤΤǡɬ۾ｪλȤʤ褦ʥѥ᡼֤   */

    fdc.c0 = 0xff;	/* invalid  */
    fdc.c1 = 0xff;	/* 3rd unit */
    fdc.cn = 0xff;	/* 255 Cyl. */
    fdc.s0 = 0xda;	/* default  */
    fdc.s1 = 0x19;	/* default  */
    fdc.r0 = ST0_IC_IC;	/* invalid  */
    fdc.r1 = 0xff;	/* 255 Cyl. */
    fdc.intr_unit = 4;	/* non exist unit */

    return TRUE;

  }

  return TRUE;
}






/* ǥХåѤδؿ */
void monitor_fdc(void)
{
  printf("com = %d phs = %d  step = %d\n",fdc.command,fdc.phase,fdc.step);
  printf("FDC flag = %d\n",FDC_flag);
#if 0
  printf("\n");
  printf("fp       = %d , %d\n", drive[0].fp,       drive[1].fp      );
  printf("track    = %d , %d\n", drive[0].track,    drive[1].track   );
  printf("sec_nr   = %d , %d\n", drive[0].sec_nr,   drive[1].sec_nr  );
  printf("sec      = %d , %d\n", drive[0].sec,      drive[1].sec       );
  printf("sec_pos  = %d , %d\n", drive[0].sec_pos,  drive[1].sec_pos   );
  printf("track_top= %d , %d\n", drive[0].track_top,drive[1].track_top );
  printf("disk_top = %d , %d\n", drive[0].disk_top, drive[1].sec     );
  printf("type     = %d , %d\n", drive[0].type,     drive[1].type );
  printf("protect  = %d , %d\n", drive[0].protect,  drive[1].protect     );

  printf("\n");
  {
    int	i,j,k;
    for(k=0;k<(128<<(fdc.n&7))/256;k++){
      for(i=0;i<16;i++){
	for(j=0;j<16;j++){
	  printf("%02X ",data_buf[k*256+i*16+j]);
	}
	printf("\n");
      }
    }
  }
  printf("\n");
#endif
}
