#ifndef	EVENT_H_INCLUDED
#define	EVENT_H_INCLUDED


/***********************************************************************
 * ٥Ƚ (ƥ¸)
 ************************************************************************/

/******************************************************************************
 * ٥Ƚνλ
 *
 * void event_init(void)
 *	祤ƥå䡢ƥͭΥХǥ󥰽С
 *	ǤäƤ
 *	δؿϡư 1ƤӽФ롣
 *
 * void event_exit(void)
 *	٥ȽθԤ
 *	δؿϡλ 1ƤӽФ롣
 *
 *****************************************************************************/
void	event_init(void);
void	event_exit(void);


/******************************************************************************
 * ٥Ƚκƽ
 *
 * void	event_switch(void)
 *	ߥ塿˥塼ݡ˥⡼ɤػ˸ƤӽФ롣
 *	ƥ⡼ɤ˱ƥΥ٥Ƚν򤹤롣
 *	(ϥ٥Ƚ䡢˥塼СѤʤ)
 *
 *****************************************************************************/
void	event_switch(void);


/******************************************************************************
 * ٥Ƚμ¹
 *
 * void event_update(void)
 *	1/60 (ߥ졼 VSYNC) ˸ƤӽФ롣
 *	ǡƤΥ٥ȽԤߥ졼ؤϤ򹹿롣
 *
 *	o 
 *	  줿˱ơʲδؿƤӽФ
 *		: quasi88_key(KEY88_XXX, TRUE);
 *		: quasi88_key(KEY88_XXX, FALSE);
 *
 *	  λΡ줿 KEY88_XXX бǤ (ƥ¸) 
 *	  б򤷤Ƥʤ (ƤƤʤ) KEY88_XXX ˤĤƤϡ
 *	  QUASI88 ԲĤȤʤ롣
 *
 *	  äˡKEY_SPACE  KEY88_TILDE ƤƤʤä硢˥塼
 *	  ⡼ɤ ˳ ASCIIʸϤʤʤΤա
 *
 *	o ޥܥ󲡲
 *	  줿ܥ˱ơʲδؿƤӽФ
 *		: quasi88_mouse(KEY88_MOUSE_XXX, TRUE);
 *		: quasi88_mouse(KEY88_MOUSE_XXX, FALSE);
 *
 *	o 祤ƥå
 *	  줿ܥ˱ơʲδؿƤӽФ
 *		: quasi88_pad(KEY88_PAD_XXX, TRUE);
 *		: quasi88_pad(KEY88_PAD_XXX, FALSE);
 *
 *	o ޥư (кɸ / кɸ)
 *	  ư x, y (ʤư dx, xy) ˱ơʲδؿƤӽФ
 *		ư: quasi88_mouse_move( x,  y, TRUE);
 *		ư: quasi88_mouse_move(dx, dy, FALSE);
 *
 *	  кɸξ硢graph_setup() ͤˤƱ T_SCREEN_INFO 
 *	  width * height Фͤ򥻥åȤ뤳ȡ(ͤϰϳǤ)
 *
 *	o ե꡿ʤ
 *	  ɥե(ƥ֤ˤʤä)䡢ե
 *	  ä(󥢥ƥ֤ˤʤä)˸ƤӽФ
 *	  եʤ˥ݡ⡼ɤȤץ (-focus) 
 *	  ˻ȤäƤʤΤǡʤƤƶϤʤ
 *			quasi88_focus_in() / quasi88_focus_out()
 *
 *	o λ
 *	  ɥŪĤ줿硢ʲδؿƤӽФ
 *			quasi88_quit()
 *
 *****************************************************************************/
void	event_update(void);


/******************************************************************************
 * ¾λ¿ʴؿ
 *
 * int  event_numlock_on(void)
 * void event_numlock_off(void)
 *	եȥ NumLock ̵ͭˤݤˡƤӽФ롣
 *	ɤΥ򲡤顢ɤΥƥ󥭡򲡤ȤˤʤΤϡƥ¸
 *	ȤΤǡƥΥ˹碌ơ롣
 *	ѹǤʤʤС event_numlock_on() ͤ  ˤ롣
 *
 * void	event_get_mouse_pos(int *x, int *y)
 *	ߤΥޥкɸ򥻥åȤ롣
 *	кɸγǰʤϡǤդͤ򥻥åȤƤ褤
 *	åȤɸͤϡgraph_setup() ͤˤƱ T_SCREEN_INFO 
 *	 width * height ФͤȤ롣(ͤϰϳǤ)
 *	δؿϡ⡼ɤڤؤ˸ƤӽФ롣
 *
 * int	event_get_joystick_num(void)
 *	Ѳǽʥ祤ƥåο (02) ֤
 *
 *****************************************************************************/
int	event_numlock_on(void);
void	event_numlock_off(void);

void	event_get_mouse_pos(int *x, int *y);

int	event_get_joystick_num(void);




/******************************************************************************
 * ʲϡ嵭Υƥ¸ʴؿꡢƤӽФؿ
 *		Τ꤯ʤƤϡ
 *****************************************************************************/

/*----------------------------------------------------------------------
 * ٥Ƚн
 *----------------------------------------------------------------------*/
void	quasi88_key  (int code, int on_flag);
void	quasi88_mouse(int code, int on_flag);
void	quasi88_pad  (int code, int on_flag);
void	quasi88_mouse_move(int x, int y, int abs_flag);

#define	quasi88_key_pressed(code)	quasi88_key  (code, TRUE )
#define	quasi88_key_released(code)	quasi88_key  (code, FALSE)
#define	quasi88_mouse_pressed(code)	quasi88_mouse(code, TRUE )
#define	quasi88_mouse_released(code)	quasi88_mouse(code, FALSE)
#define	quasi88_pad_pressed(code)	quasi88_pad  (code, TRUE )
#define	quasi88_pad_released(code)	quasi88_pad  (code, FALSE)
#define	quasi88_mouse_moved_abs(x, y)	quasi88_mouse_move(x, y, TRUE)
#define	quasi88_mouse_moved_rel(x, y)	quasi88_mouse_move(x, y, FALSE)



void	quasi88_expose(void);
void	quasi88_focus_in(void);
void	quasi88_focus_out(void);


/* ʲϡ¸档ƤӽФ˾郎Ǥ */

typedef struct {
    int		boot_basic;
    int		boot_dipsw;
    int		boot_from_rom;
    int		boot_clock_4mhz;
    int		set_version;
    byte	baudrate_sw;
    int		use_extram;
    int		use_jisho_rom;
    int		sound_board;
} T_RESET_CFG;
void	quasi88_get_reset_cfg(T_RESET_CFG *cfg);
void	quasi88_reset(const T_RESET_CFG *cfg);
int	quasi88_stateload(int serial);
int	quasi88_statesave(int serial);
int	quasi88_screen_snapshot(void);
int	quasi88_waveout(int start);
int	quasi88_drag_and_drop(const char *filename);


int	quasi88_cfg_now_wait_rate(void);
void	quasi88_cfg_set_wait_rate(int rate);
int	quasi88_cfg_now_no_wait(void);
void	quasi88_cfg_set_no_wait(int enable);


int	quasi88_disk_insert_all(const char *filename, int ro);
int	quasi88_disk_insert(int drv, const char *filename, int image, int ro);
int	quasi88_disk_insert_A_to_B(int src_drv, int dst_drv, int dst_img);
void	quasi88_disk_eject_all(void);
void	quasi88_disk_eject(int drv);

void	quasi88_disk_image_select(int drv, int img);
void	quasi88_disk_image_empty(int drv);
void	quasi88_disk_image_next(int drv);
void	quasi88_disk_image_prev(int drv);

int	quasi88_load_tape_insert( const char *filename );
int	quasi88_load_tape_rewind( void );
void	quasi88_load_tape_eject( void );
int	quasi88_save_tape_insert( const char *filename );
void	quasi88_save_tape_eject( void );

int	quasi88_serial_in_connect( const char *filename );
void	quasi88_serial_in_remove( void );
int	quasi88_serial_out_connect( const char *filename );
void	quasi88_serial_out_remove( void );
int	quasi88_printer_connect( const char *filename );
void	quasi88_printer_remove( void );



#endif	/* EVENT_H_INCLUDED */
