/************************************************************************/
/*									*/
/* ߥ⡼								*/
/*									*/
/************************************************************************/

#include <stdio.h>

#include "quasi88.h"
#include "initval.h"
#include "emu.h"

#include "pc88cpu.h"

#include "screen.h"
#include "keyboard.h"
#include "intr.h"
#include "event.h"
#include "menu.h"
#include "monitor.h"
#include "pause.h"
#include "wait.h"
#include "suspend.h"
#include "status.h"
#include "graph.h"
#include "snddrv.h"




break_t		break_point[2][NR_BP];	/* ֥졼ݥ		*/
break_drive_t	break_point_fdc[NR_BP];	/* FDC ֥졼ݥ		*/


int	cpu_timing	= DEFAULT_CPU;		/* SUB-CPU ư	*/

int	select_main_cpu = TRUE;			/* -cpu 0 ¹ԤCPU	*/
						/* ʤ MAIN CPU¹*/

int	dual_cpu_count	= 0;			/* -cpu 1 ƱSTEP*/
int	CPU_1_COUNT	= 4000;			/* Ρ		*/

int	cpu_slice_us    = 5;			/* -cpu 2 ʬ(us)*/
						/* 10>SILPHEEDư*/

int	trace_counter	= 1;			/* TRACE Υ	*/



static	int	main_state   = 0;
static	int	sub_state    = 0;
#define	JACKUP	(256)


static	int	emu_mode_execute= GO;
static	int	emu_rest_step;

void	set_emu_exec_mode( int mode )
{
  emu_mode_execute = mode;
}

/***********************************************************************
 * ߥ졼ȽνϢ
 ************************************************************************/

void	emu_reset( void )
{
  select_main_cpu = TRUE;
  dual_cpu_count  = 0;

  main_state   = 0;
  sub_state    = 0;
}


void	emu_breakpoint_init( void )
{
  int	i, j;
	/* ֥졼ݥȤΥ (˥⡼) */
  for( j=0; j<2; j++ )
    for( i=0; i<NR_BP; i++ )
      break_point[j][i].type = BP_NONE;

  for( i=0; i<NR_BP; i++ )
    break_point_fdc[i].type = BP_NONE;
}




/***********************************************************************
 * CPU¹Խ (EXEC) 
 *	-cpu <n> ˱ơưѤ롣
 *
 *	STEP  ϡ1step ¹Ԥ롣
 *	TRACE ϡʬ1step ¹Ԥ롣
 *
 *	֥졼ݥȻϡ1step¹Ԥ٤ PC ֥졼ݥȤ
 *	ãɤǧ롣
 *
 ************************************************************************/

#define	INFINITY	(0)
#define	ONLY_1STEP	(1)

/*------------------------------------------------------------------------*/

/*
 * ֥졼ݥ ( PC) ̵ͭå
 */

static	int	check_break_point_PC( void )
{
  int	i, j;

  for( i=0; i<NR_BP; i++ ) if( break_point[BP_MAIN][i].type == BP_PC ) break;
  for( j=0; j<NR_BP; j++ ) if( break_point[BP_SUB][j].type  == BP_PC ) break;

  if( i==NR_BP && j==NR_BP ) return FALSE;
  else                       return TRUE;
}

/*------------------------------------------------------------------------*/

/*
 * CPU  1step ¹ԤơPC֥졼ݥȤãå
 *	֥졼ݥ(PC)̤ʤ餳δؿϻȤ鷺z80_emu()Ȥ
 */

static	int	z80_emu_with_breakpoint( z80arch *z80, int unused )
{
  int i, cpu, states;

  states = z80_emu( z80, 1 );		/* 1step ¹ */

  if( z80==&z80main_cpu ) cpu = BP_MAIN;
  else                    cpu = BP_SUB;

  for( i=0; i<NR_BP; i++ ){
    if( break_point[cpu][i].type == BP_PC     &&
	break_point[cpu][i].addr == z80->PC.W ){

      if( i==BP_NUM_FOR_SYSTEM ){
	break_point[cpu][i].type = BP_NONE;
      }

      printf( "*** Break at %04x *** ( %s[#%d] : PC )\n",
	      z80->PC.W, (cpu==BP_MAIN)?"MAIN":"SUB", i+1 );

      quasi88_debug();
    }
  }

  return states;
}

/*---------------------------------------------------------------------------*/

static	int	passed_step;		/* ¹Ԥ step */
static	int	target_step;		/*  stepãޤǼ¹Ԥ */

static	int	infinity, only_1step;
static	int	(*z80_exec)( z80arch *, int );


void	emu_init(void)
{
/*xmame_sound_update();*/
  xmame_update_video_and_audio();
  event_update();
/*keyboard_update();*/



/*screen_set_dirty_all();*/
/*screen_set_dirty_palette();*/

  /* ơꥢ */
  status_message_default(0, NULL);
  status_message_default(1, NULL);
  status_message_default(2, NULL);



	/* ֥졼ݥ̵ͭǡƤӽФؿѤ */
  if( check_break_point_PC() ) z80_exec = z80_emu_with_breakpoint;
  else                         z80_exec = z80_emu;


	/* GO/TRACE/STEP/CHANGE ˱ƽη֤ */

  passed_step = 0;

  switch( emu_mode_execute ){
  default:
  case GO:
    target_step = 0;			/* ̵¤˼¹ */
    infinity    = INFINITY;
    only_1step  = ONLY_1STEP;
    break;

  case TRACE:
    target_step = trace_counter;	/* ꥹƥå׿¹ */
    infinity    = ONLY_1STEP;
    only_1step  = ONLY_1STEP;
    break;

  case STEP:
    target_step = 1;			/* 1ƥå׼¹ */
    infinity    = ONLY_1STEP;
    only_1step  = ONLY_1STEP;
    break;

  case TRACE_CHANGE:
    target_step = 0;			/* ̵¤˼¹ */
    infinity    = ONLY_1STEP;
    only_1step  = ONLY_1STEP;
    break;
  }


  /* ¹ԤĤꥹƥå׿
	TRACE / STEP λϡꤵ줿ƥå׿
	GO / TRACE_CHANGE ʤ ̵¤ʤΤǡ 0
		ʤǥ˥塼ܤ硢Ū 1 åȤ롣
		ˤ̵¤˽Ǥ⡢롼פȴ褦ˤʤ롣 */
  emu_rest_step = target_step;
}


void	emu_main(void)
{
  int	wk;

  profiler_lapse( PROF_LAPSE_CPU );

  switch( emu_mode_execute ){

  /*------------------------------------------------------------------------*/
  case GO:				/* Ҥ¹Ԥ           */
  case TRACE:				/* ꤷƥåס¹Ԥ */
  case STEP:				/* 1ƥåפ¹Ԥ    */

    for(;;){

      switch( cpu_timing ){

      case 0:		/* select_main_cpu ǻꤵ줿ۤCPU̵¼¹ */
	if( select_main_cpu ) (z80_exec)( &z80main_cpu, infinity );
	else                  (z80_exec)( &z80sub_cpu,  infinity );
	break;

      case 1:		/* dual_cpu_count==0 ʤᥤCPU̵¼¹ԡ*/
			/*               !=0 ʤᥤ󥵥֤߼¹ */
	if( dual_cpu_count==0 ) (z80_exec)( &z80main_cpu, infinity   );
	else{
	  (z80_exec)( &z80main_cpu, only_1step );
	  (z80_exec)( &z80sub_cpu,  only_1step );
	  dual_cpu_count --;
	}
	break;

      case 2:		/* ᥤCPUCPUߤ 5us ļ¹ */
	if( main_state < 1*JACKUP  &&  sub_state < 1*JACKUP ){
	  main_state += (int) ((cpu_clock_mhz * cpu_slice_us) * JACKUP);
	  sub_state  += (int) ((3.9936        * cpu_slice_us) * JACKUP);
	}
	if( main_state >= 1*JACKUP ){
	  wk = (infinity==INFINITY) ? main_state/JACKUP : ONLY_1STEP;
	  main_state -= (z80_exec( &z80main_cpu, wk ) ) * JACKUP;
	}
	if( sub_state >= 1*JACKUP ){
	  wk = (infinity==INFINITY) ? sub_state/JACKUP : ONLY_1STEP;
	  sub_state  -= (z80_exec( &z80sub_cpu, wk ) ) * JACKUP;
	}
	break;
      }

      /* TRACE/STEP¹Իꥹƥå׼¹Դλ顢˥ܤ */
      if( emu_rest_step ){
	passed_step ++;
	if( -- emu_rest_step <= 0 ) {
	  quasi88_debug();
	}
      }

      /* ɽϥߥ󥰤ǤС */
      if (quasi88_event_flags & EVENT_AUDIO_UPDATE) {
	quasi88_event_flags &= ~EVENT_AUDIO_UPDATE;

	profiler_lapse( PROF_LAPSE_SND );

	xmame_sound_update();			/* ɽ */

	profiler_lapse( PROF_LAPSE_AUDIO );

	xmame_update_video_and_audio();		/* ɽ 2 */

	profiler_lapse( PROF_LAPSE_INPUT );

	event_update();				/* ٥Ƚ		*/
	keyboard_update();

	profiler_lapse( PROF_LAPSE_CPU2 );
      }

      /* ӥǥϥߥ󥰤ǤСCPUϰöߡ̤ȴ */
      if (quasi88_event_flags & EVENT_FRAME_UPDATE) {
	return;
      }

      /* ˥ܻ佪λϡ CPUϰöߡ̤ȴ */
      if (quasi88_event_flags & (EVENT_DEBUG | EVENT_QUIT)) {
	return;
      }

      /* ⡼ؤȯƤ⡢̤ˤȴʤӥǥϤޤԤ */
      /* (ȴȡ ߥ     ή줬Τǡ) */
    }
    break;

  /*------------------------------------------------------------------------*/

	/* äΥ֥졼Ϥޤưʤ⡦ (̤) */

  case TRACE_CHANGE:			/* CPUڤؤޤǽ򤹤 */
    if( cpu_timing >= 1 ){
      printf( "command 'trace change' can use when -cpu 0\n");
      quasi88_monitor();
      break;
    }

    wk = select_main_cpu;
    while( wk==select_main_cpu ){
      if( select_main_cpu ) (z80_exec)( &z80main_cpu, infinity );
      else                  (z80_exec)( &z80sub_cpu,  infinity );
      if( emu_rest_step ){
	passed_step ++;
	if( -- emu_rest_step <= 0 ) {
	  quasi88_debug();
	}
      }

      if (quasi88_event_flags & EVENT_AUDIO_UPDATE) {
	quasi88_event_flags &= ~EVENT_AUDIO_UPDATE;
	profiler_lapse( PROF_LAPSE_SND );
	xmame_sound_update();			/* ɽ */
	profiler_lapse( PROF_LAPSE_AUDIO );
	xmame_update_video_and_audio();		/* ɽ 2 */
	profiler_lapse( PROF_LAPSE_INPUT );
	event_update();				/* ٥Ƚ		*/
	keyboard_update();
      }

      if (quasi88_event_flags & EVENT_FRAME_UPDATE) {
	return;
      }
      if (quasi88_event_flags & (EVENT_DEBUG | EVENT_QUIT)) {
	return;
      }
    }
    quasi88_debug();
    break;
  }
  return;
}
















/***********************************************************************
 * ơȥɡơȥ
 ************************************************************************/

#define	SID	"EMU "

static	T_SUSPEND_W	suspend_emu_work[] =
{
  { TYPE_INT,	&cpu_timing,		},
  { TYPE_INT,	&select_main_cpu,	},
  { TYPE_INT,	&dual_cpu_count,	},
  { TYPE_INT,	&CPU_1_COUNT,		},
  { TYPE_INT,	&cpu_slice_us,		},
  { TYPE_INT,	&main_state,		},
  { TYPE_INT,	&sub_state,		},

  { TYPE_END,	0			},
};


int	statesave_emu( void )
{
  if( statesave_table( SID, suspend_emu_work ) == STATE_OK ) return TRUE;
  else                                                       return FALSE;
}

int	stateload_emu( void )
{
  if( stateload_table( SID, suspend_emu_work ) == STATE_OK ) return TRUE;
  else                                                       return FALSE;
}
