/***********************************************************************
 * Ĵ (ƥ¸)
 *
 *	ܺ٤ϡ wait.h 
 ************************************************************************/
#include <windows.h>
#include <mmsystem.h>

#include "quasi88.h"
#include "device.h"
#include "initval.h"
#include "wait.h"



#if	1			/* Ǿʬǽϡꤷʤ */
#define	START_APP_PRECISION()
#define	STOP_APP_PRECISION()
#define	BEGIN_PRECISION()
#define	END_PRECISION()
#elif	0			/* Ǿʬǽϡץ̤ 1ms */
#define	START_APP_PRECISION()	timeBeginPeriod(1)
#define	STOP_APP_PRECISION()	timeEndPeriod(1)
#define	BEGIN_PRECISION()
#define	END_PRECISION()
#elif	0			/* Ǿʬǽϡַ¬λΤ 1ms */
#define	START_APP_PRECISION()
#define	STOP_APP_PRECISION()
#define	BEGIN_PRECISION()	timeBeginPeriod(1)
#define	END_PRECISION()		timeEndPeriod(1)
#endif


/*---------------------------------------------------------------------------*/
static	int	wait_do_sleep;			/* idle sleep        */

static	int	wait_counter = 0;		/* Ϣ³֥С*/
static	int	wait_count_max = 10;		/* ʾϢ³С
						   ö,Ĵ */

/* Ȥ˻Ѥ֤ɽϡ usñ̤Ȥ롣 (ms٤㤤Τ) 

   WIN32 λؿ timeGetTime()  ms ñ̤ǡ DWORD֤
    1000ܤ (usѴ) Ѥȡ71ʬǷ夢դ줷ƤޤΤǡ
   ɽ __int64 ˤ褦

   ʤ timeGetTime()  49ܤä(wrap)ޤΤǡɽ⤳νִ֤
   ʤΤˤʤ (Ȼ֤Ѥˤʤ) ˤʤȤˤ롣 */

typedef	signed __int64	T_WAIT_TICK;

static	T_WAIT_TICK	next_time;		/* ե졼λ */
static	T_WAIT_TICK	delta_time;		/* 1 ե졼λ */



/* ---- ߻ (usecñ) ---- */

#define	GET_TICK()	((T_WAIT_TICK)timeGetTime() * 1000)





/****************************************************************************
 * Ĵνλ
 *****************************************************************************/
int	wait_vsync_init(void)
{
    START_APP_PRECISION();
    return TRUE;
}

void	wait_vsync_exit(void)
{
    STOP_APP_PRECISION();
}



/****************************************************************************
 * Ĵ
 *****************************************************************************/
void	wait_vsync_setup(long vsync_cycle_us, int do_sleep)
{
    wait_counter = 0;


    delta_time = (T_WAIT_TICK) vsync_cycle_us;		/* 1ե졼 */

    BEGIN_PRECISION();		/* ٤1msˤ(timeGetTime, Sleepʤ) */

    next_time  = GET_TICK() + delta_time;		/* ե졼 */

    END_PRECISION();		/* ٤᤹ */

    wait_do_sleep = do_sleep;				/* Sleep ̵ͭ */
}



/****************************************************************************
 * Ĵμ¹
 *****************************************************************************/
int	wait_vsync_update(void)
{
    int on_time = FALSE;
    T_WAIT_TICK diff_ms;


    BEGIN_PRECISION();		/* ٤1msˤ(timeGetTime, Sleepʤ) */

    diff_ms = (next_time - GET_TICK()) / 1000;

    if (diff_ms > 0) {			/* ٤Ƥʤ(֤;äƤ)ʤ */
					/* diff_ms ߥáȤ     */

	if (wait_do_sleep) {		/* ֤ޤ sleep  */

	    Sleep((DWORD)diff_ms);		/* diff_ms ߥáǥ쥤 */

	} else {			/* ֤ޤTickƻ뤹 */

	    while (GET_TICK() <= next_time)
		;				/* ӥ */
	}

	on_time = TRUE;
    }

    END_PRECISION();		/* ٤᤹ */


    /* ե졼򻻽 */
    next_time += delta_time;


    if (on_time) {			/* ˽Ǥ */
	wait_counter = 0;
    } else {				/* ˽ǤƤʤ */
	wait_counter ++;
	if (wait_counter >= wait_count_max) {	/* ٤줬Ҥɤ */
	    wait_vsync_setup((long) delta_time,	/* Ȥ   */
			     wait_do_sleep);
	}
    }

#if 0
    {
	static int x = 0, y = 0;
	if (++x == 55) {
	    y++;
	    x = 0;
	    fprintf(debugfp, "wait %d\n", y);
	}
    }
#endif

    if (on_time) return WAIT_JUST;
    else         return WAIT_OVER;
}
