/***********************************************************************
 * ɽϽ (ƥ¸)
 *
 *      ܺ٤ϡ snddrv.h / mame-quasi88.h 
 ************************************************************************/

#include "quasi88.h"
#include "device.h"

#include "snddrv.h"

#ifdef	USE_SOUND

#include "mame-quasi88.h"

	int g_pcm_bufsize = 100;	/* PCM Хåե [ms] */
static	int use_audiodevice = 1;	/* use audio-devide for audio output */

static int device_opened = FALSE;	/* ǥХѤߤʤ鿿 */

/*===========================================================================*/
/*              QUASI88 ƤӽФ롢MAME νؿ                    */
/*===========================================================================*/

/******************************************************************************
 * ɷϥץνλؿ
 *
 * int xmame_config_init(void)
 *      config_init() ꡢץβϤ򳫻Ϥ˸ƤӽФ롣
 *      MAME¸νʤɤɬפʾϡǹԤ
 *
 * void xmame_config_exit(void)
 *      config_exit() ꡢκǸ˸ƤӽФ롣
 *      xmame_config_init() νθդɬפʤ顢ǹԤ
 *
 *****************************************************************************/
int	xmame_config_init(void)
{
    return 0;		/*OSD_OK;*/
}
void	xmame_config_exit(void)
{
}


/******************************************************************************
 * ɷϥץΥץơ֥
 *
 * const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
 *      config_init() ꡢ xmame_config_init() θ˸ƤӽФ롣
 *
 *      ɷϥץβϽˤơ QUASI88 Υץơ֥
 *      T_CONFIG_TABLE Ѥ硢Υݥ󥿤֤
 *      ȼǲϤϡ NULL ֤
 *****************************************************************************/
static	int	invalid_arg;			/* ̵ʥץѤΥߡѿ */
static	const	T_CONFIG_TABLE xmame_options[] =
{
  /* 350399: ɰ¸ץ */

  { 351, "sound",        X_FIX,  &use_sound,       TRUE,                  0,0, OPT_SAVE },
  { 351, "nosound",      X_FIX,  &use_sound,       FALSE,                 0,0, OPT_SAVE },

  { 352, "audio",        X_FIX,  &use_audiodevice, TRUE,                  0,0, OPT_SAVE },
  { 352, "noaudio",      X_FIX,  &use_audiodevice, FALSE,                 0,0, OPT_SAVE },

  { 353, "fmgen",        X_FIX,  &use_fmgen,       TRUE,                  0,0, OPT_SAVE },
  { 353, "nofmgen",      X_FIX,  &use_fmgen,       FALSE,                 0,0, OPT_SAVE },

  { 354, "volume",       X_INV,  &invalid_arg,                          0,0,0, 0        },

  { 355, "fmvol",        X_INT,  &fmvol,           0, 100,                  0, OPT_SAVE },
  { 356, "psgvol",       X_INT,  &psgvol,          0, 100,                  0, OPT_SAVE },
  { 357, "beepvol",      X_INT,  &beepvol,         0, 100,                  0, OPT_SAVE },
  { 358, "rhythmvol",    X_INT,  &rhythmvol,       0, 200,                  0, OPT_SAVE },
  { 359, "adpcmvol",     X_INT,  &adpcmvol,        0, 200,                  0, OPT_SAVE },
  { 360, "fmgenvol",     X_INT,  &fmgenvol,        0, 100,                  0, OPT_SAVE },
  { 361, "samplevol",    X_INT,  &samplevol,       0, 100,                  0, OPT_SAVE },

  { 362, "samplefreq",   X_INT,  &options.samplerate, 8000, 48000,          0, OPT_SAVE },

  { 363, "samples",      X_FIX,  &options.use_samples, 1,                 0,0, OPT_SAVE },
  { 363, "nosamples",    X_FIX,  &options.use_samples, 0,                 0,0, OPT_SAVE },

  { 364, "pcmbufsize",   X_INT,  &g_pcm_bufsize,   10, 1000,                0, OPT_SAVE },

  /* ü */
  {   0, NULL,           X_INV,                                       0,0,0,0, 0        },
};

const T_CONFIG_TABLE *xmame_config_get_opt_tbl(void)
{
    return xmame_options;
}


/******************************************************************************
 * ɷϥץΥإץåɽ
 *
 * void xmame_config_show_option(void)
 *      config_init() ꡢץ -help νκݤ˸ƤӽФ롣
 *      ɸϤ˥إץåɽ롣
 *****************************************************************************/
#ifdef	XMAME_SNDDRV_071
#define	XMAME_VER "0.71.1"
#else	/* ver 0.106 */
#define	XMAME_VER " 0.106"
#endif

void	xmame_config_show_option(void)
{
  fprintf(stdout,
  "\n"
  "==========================================\n"
  "== SOUND OPTIONS ( dependent on XMAME ) ==\n"
  "==                     [ XMAME " XMAME_VER " ] ==\n"
  "==========================================\n"
  "    -[no]sound              Enable/disable sound (if available) [-sound]\n"
  "    -[no]fmgen              Use/don't use cisc's fmgen library\n"
  "                                               (if compiled in)  [-nofmgen]\n"
  "    -volume <n>             Set volume to <n> db, (-32 (soft) - 0(loud))\n"
  "                                                             <NOT SUPPORT>\n"
  "    -fmvol <level>          Set FM     level to <level> %%, (0 - 100) [100]\n"
  "    -psgvol <level>         Set PSG    level to <level> %%, (0 - 100) [20]\n"
  "    -beepvol <level>        Set BEEP   level to <level> %%, (0 - 100) [60]\n"
  "    -rhythmvol <level>      Set RHYTHM level to <level> %%, (0 - 100) [100]\n"
  "    -adpcmvol <level>       Set ADPCM  level to <level> %%, (0 - 100) [100]\n"
  "    -fmgenvol <level>       Set fmgen  level to <level> %%, (0 - 100) [100]\n"
  "    -samplevol <level>      Set SAMPLE level to <level> %%, (0 - 100) [100]\n"
  "    -samplefreq <rate>      Set the playback sample-frequency/rate [44100]\n"
  "    -[no]samples            Use/don't use samples (if available) [-nosamples]\n"
  "    -pcmbufsize <n>         Set sound-buffer-size to <n> ms (10 - 1000) [100]\n"
  );
}


/******************************************************************************
 * ɷϥץβϽ
 *
 * int xmame_config_check_option(char *opt1, char *opt2, int priority)
 *      config_init() ꡢեβϤԤʤݤˡ
 *      ΥץΤˤפʤ硢δؿƤӽФ롣
 *
 *              opt1      ǽΰ(ʸ)
 *              opt2      Τΰ(ʸ ʤ NULL)
 *              priority  ͥ (ͤ礭ۤͥ٤⤤)
 *
 *        1   1 (opt1 Τ߽ opt2 ̤)
 *              2   2 (opt1  opt2 )
 *              0   opt1 ̤ΤΰΤᡢ opt1 opt2 Ȥ̤
 *              -1  ̿Ūʰ۾郎ȯ
 *
 *      ΰ۾ (λͤϰϳʤ) 䡢ͥ٤ˤå
 *      줿褦ʾϡǤƱͤˡ 1  2 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int	xmame_config_check_option(char *opt1, char *opt2, int priority)
{
    return 0;
}


/******************************************************************************
 * ɷϥץ¸뤿δؿ
 *
 * int  xmame_config_save_option(void (*real_write)
 *                                 (const char *opt_name, const char *opt_arg))
 *
 *      ե¸κݤˡƤӽФ롣
 *              opt_name ˥ץ opt_arg ˥ץ
 *                åȤreal_write ƤӽФ
 *              Ȥư¸ץФƷ֤Ԥʤ
 *
 *              () "-sound" ե¸
 *                      (real_write)("sound", NULL) ƤӽФ
 *              () "-fmvol 80" ե¸
 *                      (real_write)("fmvol", "80") ƤӽФ
 *
 *         0 ֤
 *
 *       δؿϡȼǥץϤ뤿δؿʤΤǡ
 *         ץơ֥ T_CONFIG_TABLE ѤϡߡǤ褤
 *****************************************************************************/
int	xmame_config_save_option(void (*real_write)
				   (const char *opt_name, const char *opt_arg))
{
    return 0;
}


/******************************************************************************
 * ɷϥץ˥塼ѹ뤿Υơ֥ؿ
 *
 * T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
 *
 *      ˥塼⡼ɤγϻ˸ƤӽФ롣
 *              ѹǽʥɷϥץξT_SNDDRV_CONFIG 
 *              ȤѰդƬݥ󥿤֤
 *              Ϻ5ĤޤǡˤϽüǡ򥻥åȤƤ
 *
 *              äѹǤΤ̵ NULL ֤
 *****************************************************************************/
T_SNDDRV_CONFIG *xmame_config_get_sndopt_tbl(void)
{
    static T_SNDDRV_CONFIG config[] =
    {
	{
	    SNDDRV_INT,
#if 0
	    " Buffer size of PCM data (10 - 1000[ms])    ",
#else
	    " PCM ХåեΥ  (10 - 1000[ms])      ",
#endif
	    &g_pcm_bufsize,  10, 1000,
	},
	{
	    SNDDRV_NULL, 0, 0, 0, 0,
	},
    };

    if (use_audiodevice) {
	return config;
    } else {
	return NULL;
    }
}


/******************************************************************************
 * ɵǽξؿ
 *
 * int xmame_has_audiodevice(void)
 *      ɥǥХϤβݤ֤
 *      ʤǥХϲġʤԲġ
 *
 * int xmame_has_mastervolume(void)
 *      ɥǥХβ̤ѹǽɤ֤
 *      ʤѹǽʤԲġ
 *
 *****************************************************************************/
int	xmame_has_audiodevice(void)
{
    if (use_sound) {
	if (device_opened) return TRUE;
    }
    return FALSE;
}

int	xmame_has_mastervolume(void)
{
    return FALSE;
}


/*===========================================================================*/
/*              MAME νؿƤӽФ롢ƥ¸ؿ        */
/*===========================================================================*/

/******************************************************************************
 * ɥǥХ
 *      δؿϡХѿ use_sound ξϡƤӽФʤ
 *
 * int osd_start_audio_stream(int stereo)
 *      ɥǥХ롣
 *          stereo ʤ饹ƥ쥪ϡʤΥϤǽ롣
 *          (ΥϤϡŤС MAME/XMAME  YM2203 
 *           ΤߡѤƤ롣ʳϤ٤ƥƥ쥪ϤѤ롣)
 *      δؿϡߥ졼γϻ˸ƤӽФ롣
 *          ϡ1ե졼ढΥץ֤
 *          Իϡ0 ֤
 *               0 ֤ QUASI88 λƤޤΤǡ
 *              ɥǥХν˼ԤǤ⡢ɽϤʤ
 *              ʤ᤿Ȥ硢ȤˤŬ֤ͤɬפ롣
 *
 * int osd_update_audio_stream(INT16 *buffer)
 *      ɥǥХ˽Ϥ롣
 *      δؿϡ1ե졼˸ƤӽФ롣buffer ˤ1ե졼ʬ
 *      (Machine->sample_rate / Machine->drv->frames_per_second) Υ
 *      ǡǼƤ롣ǡ 16bitդǡƥ쥪ξ
 *      ȱΥץ뤬ߤ¤Ǥ롣
 *
 *      ºݤˤδؿƤӽФ줿ߥ󥰤ǥǥХ˽Ϥ뤫뤤
 *      ǥХåե󥰤ӽϤ뤫ϡǤ롣
 *
 *      ͤϡ osd_start_audio_stream() Ʊ
 *
 * void osd_stop_audio_stream(void)
 *      ɥǥХλ롣
 *      δؿϡߥ졼νλ˸ƤӽФ롣
 *      ʹߡ osd_update_audio_stream() ʤɤϸƤӽФʤߥ졼
 *      Ƴϡ osd_start_audio_stream() ƤӽФ롣
 *
 * void osd_update_video_and_audio(void)
 *      ɥǥХνϤΣ
 *      ߥŪˤϡ osd_update_audio_stream() ľ˸ƤӽФ롣
 *      XMAME 0.106 ˹碌Ƥ뤬 osd_update_audio_stream() 
 *      ȼǤ줤СδؿϥߡǤ褤
 *
 * void osd_sound_enable(int enable)
 *      ɥǥХؤνϤꡦʤꤹ롣
 *          enable ʤϤꡢʤϤʤ
 *      δؿϡХѿ close_device ξΤߡƤӽФ롣
 *          ˥塼⡼ɤäݤˡ򵶤ȤƸƤӽФ
 *          ˥塼⡼ɤФݤˡ򿿤ȤƸƤӽФ
 *      δؿϡξˡɥǥХ (close) 
 *      ξ˳ (open) 褦ʼԤƤ뤬ɥǥХ
 *      ݤޤޤˤ褦ʼǤСߡδؿǤ褤
 *      ʤɥǥХؤνϤʤξ osd_update_audio_stream() 
 *      ʤɤδؿϸƤӽФ롣
 *
 *****************************************************************************/

static	int	create_sound_device(int stereo);
static	void	destroy_sound_device(void);
static	void	write_sound_device(unsigned char *data, int count);

static int samples_per_frame = 0;


int	osd_start_audio_stream(int stereo)
{
    if (use_audiodevice) {
	if (!(device_opened = create_sound_device(stereo))) {
	    /* ǥХʤƤ⡢ˤ³ */
	}
    } else {
	device_opened = FALSE;
    }

    /* calculate samples_per_frame */
#ifdef	XMAME_SNDDRV_071
    samples_per_frame =(int)(Machine->sample_rate / Machine->drv->frames_per_second);
#else	/* ver 0.106 */
    samples_per_frame =(int)(Machine->sample_rate / Machine->refresh_rate);
#endif

    return samples_per_frame;
}

int	osd_update_audio_stream(INT16 *buffer)
{
    if (device_opened) {
	write_sound_device((unsigned char *)buffer, samples_per_frame);
    }

    return samples_per_frame;
}

void	osd_stop_audio_stream(void)
{
    if (device_opened) {
	destroy_sound_device();
	device_opened = FALSE;
    }
}

void	osd_update_video_and_audio(void)
{
    /* DO NOTHING */
}

void	osd_sound_enable(int enable)
{
    /* DO NOTHING */
}


/******************************************************************************
 * 
 *
 * void osd_set_mastervolume(int attenuation)
 *      ɥǥХβ̤ꤹ롣 attenuation  ̤ǡ -320 
 *      (ñ̤ db) ѹΤǤʤǥХǤСߡǤ褤
 *
 * int osd_get_mastervolume(void)
 *      ߤΥɥǥХβ̤롣 ͤ -320 (ñ̤ db)
 *      ѹΤǤʤǥХǤСߡǤ褤
 *
 *****************************************************************************/
void	osd_set_mastervolume(int attenuation)
{
    /* waveOutSetVolume */
}

int	osd_get_mastervolume(void)
{
    /* waveOutGetVolume */

    return VOL_MIN;
}


/*===========================================================================*/
/*									     */
/*===========================================================================*/
/* #define	USE_WAVE_OUT_PROC */

#ifdef	USE_WAVE_OUT_PROC
static void CALLBACK waveOutProc(HWAVEOUT hwo , UINT msg,         
				 DWORD dwInstance,  
				 DWORD dwParam1, DWORD dwParam2);
#endif

static HWAVEOUT hWaveOut;		/* ǥХѥϥɥ */

#define	BUFFER_NUM	(2)		/* ֥Хåեǽʬ餷 */
static WAVEHDR whdr[BUFFER_NUM];

static int byte_per_sample = 4;		/* 1ץ뤢ΥХȿ	*/
					/* (Хåե׻η)	*/
					/* 4 = Stereo, 16bit		*/
					/* 2 = Mono,   16bit		*/

/*
  PCMǡΥ塼ϡ XMAME 0.106 򻲹ͤˤޤ

  ͥ xmame-0.106/src/unix/sysdep/dsp-drivers/sdl.c
  Copyright 2001 Jack Burton aka Stefano Ceccherini
*/
  
static struct {
    unsigned char	*data;
    int			dataSize;
    int			amountRemain;
    int			amountWrite;
    int			amountRead;
    int			tmp;
    unsigned long	soundlen;
    int			sound_n_pos;
    int			sound_w_pos;
    int			sound_r_pos;
} sample; 



static	int	create_sound_device(int stereo)
{
    int i, err, bufsize;
    WAVEFORMATEX f;

    if (stereo) byte_per_sample = 4;
    else        byte_per_sample = 2;

    /* PCMη */
    memset(&f, 0, sizeof(f));

    f.wFormatTag	= WAVE_FORMAT_PCM;		/* PCM	*/
    f.nChannels		= (stereo) ? 2 : 1;		/* stereo/mono	*/
    f.wBitsPerSample	= 16;				/* ̻Ҳ bit	*/
    f.nSamplesPerSec	= Machine->sample_rate;		/* ɸܲȿ	*/
    f.nBlockAlign	= f.nChannels * f.wBitsPerSample / 8;
    f.nAvgBytesPerSec	= f.nSamplesPerSec * f.nBlockAlign;
    f.cbSize		= 0;

    /* ǥХ򳫤 */
    memset(&hWaveOut, 0, sizeof(hWaveOut));

    if (waveOutOpen(&hWaveOut,		/* ˡϥɥ뤬֤	     */
		    WAVE_MAPPER,	/* ǥХϡ桼ΤΤ*/
		    &f,			/* PCMη			     */
#ifdef	USE_WAVE_OUT_PROC
		    (DWORD)waveOutProc,	/* Хåؿ		     */
		    0,			/* Хåؿΰǡ	     */
		    CALLBACK_FUNCTION	/* Хåؿ	     */
#else
		    (DWORD)g_hWnd,	/* ɥϥɥ		     */
		    0,			/* ̤			     */
		    CALLBACK_WINDOW	/* ɥϥɥ	     */
#endif
				) != MMSYSERR_NOERROR) {

	fprintf(stderr, "failed opening audio device\n");
	return FALSE;

	/* ϡ MM_WOM_OPEN / WOM_OPEN ȯ */
    }

    /* WAVХåե */
    memset(&whdr, 0, sizeof(whdr));

    err = FALSE;
    bufsize = Machine->sample_rate * byte_per_sample * g_pcm_bufsize / 1000;
    /* Хåեλ (2Τ٤ȤͤȤ) ̵Ρ */
    for (i=0; i<BUFFER_NUM; i++) {
	whdr[i].lpData		= (LPSTR)calloc(1, bufsize);
	whdr[i].dwBufferLength	= bufsize;
	whdr[i].dwFlags		= WHDR_BEGINLOOP | WHDR_ENDLOOP;
	whdr[i].dwLoops		= 1;
	whdr[i].dwUser		= FALSE;    /* FALSE = Started, Need to Write*/

	if (whdr[i].lpData == NULL) { err = TRUE; }
    }

    /* WAVХåե˥ǡ뤿Ρ֥Хåե */
    /* ֥ХåեϡWAVХåե礭ʤȤʤ   */
    if (err == FALSE) {
	memset(&sample, 0, sizeof(sample));

	sample.dataSize = bufsize * 4;	/* Хåե4ܤݡͤǤ?*/
	if (!(sample.data = calloc(1, sample.dataSize))) {
	    err = TRUE;
	}
    }

    /* ޤǤ˥顼ФƤ顢λ */
    if (err){
	for (i=0; i<BUFFER_NUM; i++) {
	    if (whdr[i].lpData) { free(whdr[i].lpData); }
	}
	waveOutClose(hWaveOut);
	return FALSE;
    }


    if (verbose_proc)
	printf("  waveOutOpen=16bit, %s, %dHz : buf-size=%d\n",
	       (stereo) ? "stereo" : "mono",
	       f.nSamplesPerSec, bufsize / byte_per_sample);

    /* WAVХåե (̵)  */
    for (i=0; i<BUFFER_NUM; i++) {
	if (waveOutPrepareHeader(hWaveOut, &whdr[i], sizeof(WAVEHDR))
							== MMSYSERR_NOERROR) {

	    waveOutWrite(hWaveOut, &whdr[i], sizeof(WAVEHDR));
	    /* BUFFER_NUM 󡢽˺뤬Τκλ
	       MM_WOM_DONE / WOM_DONE ȯ */
	}
    }

    return TRUE;
}

static	void	destroy_sound_device(void)
{
    int i;

    for (i=0; i<BUFFER_NUM; i++) {
	whdr[i].dwUser = TRUE;		    /* TRUE = Stopped, Never Write */
    }
    waveOutReset(hWaveOut);
    /* BUFFER_NUM  MM_WOM_DONE / WOM_DONE ȯ */

    for (i=0; i<BUFFER_NUM; i++) {
	waveOutUnprepareHeader(hWaveOut, &whdr[i], sizeof(WAVEHDR));
    }
    waveOutClose(hWaveOut);
    /* MM_WOM_CLOSE / WOM_CLOSE ȯ */

    for (i=0; i<BUFFER_NUM; i++) {
	free(whdr[i].lpData);
    }

    if (sample.data) {
	free(sample.data);
    }
    memset(&sample, 0, sizeof(sample));
    sample.data = NULL;
}

/*
 * ֥ХåեˡPCMǡ򥻥åȤ롣
 * (ɥǥХ˽Ϥ櫓ǤϤʤ)
 * δؿϡQUASI88ꡢ1ե졼˸ƤӽФ(Ϥ)
 *
 *  sdl_dsp_write()
 */
static	void	write_sound_device(unsigned char *data, int count)
{
    /* sound_n_pos = normal position
       sound_r_pos = read position
       and so on.			*/
    unsigned char *src;
    int bytes_written = 0;
    /* Lock */

    sample.amountRemain = sample.dataSize - sample.sound_n_pos;
    sample.amountWrite = count * byte_per_sample;

    if(sample.amountRemain <= 0) {
	/* Unlock */
	return;
    }

    if(sample.amountRemain < sample.amountWrite) sample.amountWrite = sample.amountRemain;
    sample.sound_n_pos += sample.amountWrite;
		
    src = (unsigned char *)data;
    sample.tmp = sample.dataSize - sample.sound_w_pos;
		
    if(sample.tmp < sample.amountWrite){
	memcpy(sample.data + sample.sound_w_pos, src, sample.tmp);
	bytes_written += sample.tmp;
	sample.amountWrite -= sample.tmp;
	src += sample.tmp;
	memcpy(sample.data, src, sample.amountWrite);			
	bytes_written += sample.amountWrite;
	sample.sound_w_pos = sample.amountWrite;
    }
    else{
	memcpy( sample.data + sample.sound_w_pos, src, sample.amountWrite);
	bytes_written += sample.amountWrite;
	sample.sound_w_pos += sample.amountWrite;
    }
    /* Unlock */
		
    return;
}

/*
 * ֥Хåե PCM ǡ򡢥ǥХ˽Ϥ롣
 *
 *
 *  sdl_fill_sound()
 */
#ifdef	USE_WAVE_OUT_PROC
/* waveOutProc ǡ WaveOutAPIƤӽФΤϤ餷
   ȤȤϡδؿϻȤʤ?  WndProc ƤӽФ? */
static void CALLBACK waveOutProc(HWAVEOUT hwo,
				 UINT msg,
				 DWORD dwInstance,
				 DWORD dwParam1, DWORD dwParam2)
{
    /* hwo      == hWaveOut                          */
    /* dwParam1 == whdr[n]  ٥ȯΥХåե */

    switch (msg) {
    case WOM_OPEN:
	wave_event_open(hwo);
	break;

    case WOM_DONE:
	wave_event_done(hwo, (LPWAVEHDR)dwParam1);
	break;

    case WOM_CLOSE:
	wave_event_close(hwo);
	break;
    }
}
#endif

/*
 * MM_WOM_OPEN / WOM_OPEN ȯ˸ƤӽФؿ
 */
void	wave_event_open(HWAVEOUT hwo)
{
    /* printf("S:open\n"); */
}

/*
 * MM_WOM_DONE / WOM_DONW ȯ˸ƤӽФؿ
 */
void	wave_event_done(HWAVEOUT hwo, LPWAVEHDR lpwhdr)
{
    if (lpwhdr->dwUser) {		    /* TRUE = Stopped, Never Write */
	/* printf("S:break\n"); */
	/* DO NOTHING */
    } else {				    /* FALSE = Started, Need to Write*/

	int result;
	unsigned char *dst = (unsigned char *) (lpwhdr->lpData);
	int len = lpwhdr->dwBufferLength;

	/* int i; for (i=0; i<BUFFER_NUM; i++) if (lpwhdr == &whdr[i]) break;*/
	/* printf("S:done %d\n",i); */

	sample.amountRead = len;
	if(sample.sound_n_pos <= 0) {
	    /* ֥Хåեʤ顢褦ʤΤ̵񤭹 */
	    memset(lpwhdr->lpData, 0, len);
/*
	    fprintf(debugfp, "sound empty\n");
*/
	} else {
	    if(sample.sound_n_pos<sample.amountRead) sample.amountRead = sample.sound_n_pos;
	    result = (int)sample.amountRead;
	    sample.sound_n_pos -= sample.amountRead;

	    sample.tmp = sample.dataSize - sample.sound_r_pos;
	    if(sample.tmp<sample.amountRead){
		memcpy( dst, sample.data + sample.sound_r_pos, sample.tmp);
		sample.amountRead -= sample.tmp;
		dst += sample.tmp;
		memcpy( dst, sample.data, sample.amountRead);	
		sample.sound_r_pos = sample.amountRead;
	    }
	    else{
		memcpy( dst, sample.data + sample.sound_r_pos, sample.amountRead);
		sample.sound_r_pos += sample.amountRead;
	    }
	}

	if (waveOutPrepareHeader(hWaveOut, lpwhdr, sizeof(WAVEHDR))
							== MMSYSERR_NOERROR) {
	    waveOutWrite(hWaveOut, lpwhdr, sizeof(WAVEHDR));
	    /*   MM_WOM_DONE / WOM_DONE ȯ */
	}
    }
}

/*
 * MM_WOM_CLOSE / WOM_CLOSE ȯ˸ƤӽФؿ
 */
void	wave_event_close(HWAVEOUT hwo)
{
    /* printf("S:close\n"); */
}

#endif	/* USE_SOUND */
