/***********************************************************************
 * Ĵ (ƥ¸)
 *
 *      ܺ٤ϡ wait.h 
 ************************************************************************/

#include "quasi88.h"

#include "device.h"
#include <OSUtils.h>

#include "wait.h"



/*---------------------------------------------------------------------------*/
static	int	wait_counter = 0;		/* Ϣ³֥С*/
static	int	wait_count_max = 10;		/* ʾϢ³С
						   ö,Ĵ */

/* Ȥ˻Ѥ֤ɽϡ usñ̤Ȥ롣 (ms٤㤤Τ) 

   ToolBox λؿ TickCount()  1/60s ñ̤֤ͤ
    us ѴƻѤ뤳Ȥˤ롣
   ɽ long ˤȡ71ʬǷ夢դ(wrap)򵯤Ƥޤνִ֤
   ʤΤˤʤ (Ȼ֤Ѥˤʤ) 
   Ǥ 64bit(long long)ˤɡɤƤʤ ? */

#if	0
typedef	long long	T_WAIT_TICK;
#else
typedef	long		T_WAIT_TICK;
#endif

static	T_WAIT_TICK	next_time;		/* ե졼λ */
static	T_WAIT_TICK	delta_time;		/* 1 ե졼λ */



/* ---- ߻ (usecñ) ---- */

#define	GET_TICK()	( (T_WAIT_TICK)TickCount() * 1000000/60 )





/****************************************************************************
 * Ĵνλ
 *****************************************************************************/
int	wait_vsync_init(void)
{
    return TRUE;
}

void	wait_vsync_exit(void)
{
}



/****************************************************************************
 * Ĵ
 *****************************************************************************/
void	wait_vsync_setup(long vsync_cycle_us, int do_sleep)
{
    wait_counter = 0;


    delta_time = (T_WAIT_TICK)(1000000.0 / 60.0);	/* 1ե졼 */
    next_time  = GET_TICK() + delta_time;		/* ե졼 */


    /*  vsync_cycle_us, do_sleep ̵뤹 */
}



/****************************************************************************
 * Ĵμ¹
 *****************************************************************************/
int	wait_vsync_update(void)
{
    int on_time = FALSE;
    T_WAIT_TICK diff_us;


    diff_us = next_time - GET_TICK();

    if (diff_us > 0) {			/* ٤Ƥʤ(֤;äƤ)ʤ */

#if 0					/* ӥȤȤ롩  */
	while (GET_TICK() <= next_time)
	    ;

#else					/* Delay Ƥߤ롦 */
	UInt32 unused;
	diff_us = diff_us * 60 / 1000000;
	if (diff_us) {
	    Delay(diff_us,&unused);
	}
#endif

	on_time = TRUE;
    }


    /* ե졼򻻽 */
    next_time += delta_time;


    if (on_time) {			/* ˽Ǥ */
	wait_counter = 0;
    } else {				/* ˽ǤƤʤ */
	wait_counter ++;
	if (wait_counter >= wait_count_max) {	/* ٤줬Ҥɤ */
	    wait_vsync_setup(0,0);		/* Ȥ   */
	}
    }

    if (on_time) return WAIT_JUST;
    else         return WAIT_OVER;
}
