/************************************************************************/
/*									*/
/*				QUASI88					*/
/*									*/
/************************************************************************/

/*----------------------------------------------------------------------*
 * ClassicСΥɤʬϡ                          *
 * Koichi NISHIDA  Classic iP6 PC-6001/mk2/6601 emulator Υ *
 * ͤˤƤޤ                                         *
 *                                                   (c) Koichi NISHIDA *
 *----------------------------------------------------------------------*/

#include "quasi88.h"
#include "device.h"

#include "getconf.h"	/* config_init */
#include "keyboard.h"	/* romaji_type */
#include "suspend.h"	/* stateload_system */
#include "menu.h"	/* menu_about_osd_msg */

#include "intr.h"
#include "screen.h"


/***********************************************************************
 * ץ
 ************************************************************************/
static	int	invalid_arg;
static	const	T_CONFIG_TABLE classic_options[] =
{
  /* 300349: ƥ¸ץ */

  /*  -- GRAPHIC -- */
  { 300, "8bpp",         X_FIX,  &mac_8bpp,        TRUE,                  0,0, 0        },
  { 300, "15bpp",        X_FIX,  &mac_8bpp,        FALSE,                 0,0, 0        },
  { 300, "16bpp",        X_FIX,  &mac_8bpp,        FALSE,                 0,0, 0        },

  /*  -- ̵ -- (¾ƥΰĤץ) */
  {   0, "cmap",         X_INV,  &invalid_arg,                          0,0,0, 0        },
  {   0, "keyboard",     X_INV,  &invalid_arg,                          0,0,0, 0        },
  {   0, "keyconf",      X_INV,  &invalid_arg,                          0,0,0, 0        },
  {   0, "sleepparm",    X_INT,  &invalid_arg,                          0,0,0, 0        },
  {   0, "videodrv",     X_INV,  &invalid_arg,                          0,0,0, 0        },
  {   0, "audiodrv",     X_INV,  &invalid_arg,                          0,0,0, 0        },

  /* ü */
  {   0, NULL,           X_INV,                                       0,0,0,0, 0        },
};



/***********************************************************************
 * ᥤ
 ************************************************************************/
static	void	finish(void);

int	main(void)
{
    /* Ϣ */

    /* ĥ륹åΥ        ɤݤ٤ʤΡ	*/
    SetApplLimit(GetApplLimit() - 65536*2);	/* åĥ	*/
    MaxApplZone();				/* ҡΰĥ	*/
    MoreMasters();				/* ʤΤޤʤ	*/



    /* νͤ (Ϥʤʡ) */
    romaji_type = 1;			/* ޻Ѵε§ MS-IME */


    if (config_init(0, NULL,		/* Ķ &  */
		    classic_options,
		    NULL)) {

	mac_init();			/* CLASSICϢν */

	{   /* CLASSICĶ˺Ŭ() ͤ˽񤭴Ƥ */
	    vsync_freq_hz  = 60.0;  /* ַвη¬1/60ñ̸ʤΤ */
	    file_coding = 1;        /* SJIS */
	}

	quasi88_atexit(finish);		/* quasi88() ¹˶λݤ
					   ХåؿϿ */
	quasi88();			/* PC-8801 ߥ졼 */

	mac_exit();			/* CLASSICϢ */

	config_exit();			/*  */
    }

    return 0;
}



/*
 * λΥХåؿ (quasi88_exit()ƽлˡ)
 */
static	void	finish(void)
{
    mac_exit();				/* CLASSICϢ */
    config_exit();			/*  */
}








/***********************************************************************
 * ơȥɡơȥ
 ************************************************************************/

/*	¾ξ󤹤٤Ƥ or ֤줿˸ƤӽФ롣
 *	ɬפ˱ơƥͭξղäƤ⤤ȡ
 */

int	stateload_system( void )
{
  return TRUE;
}
int	statesave_system( void )
{
  return TRUE;
}



/***********************************************************************
 * ˥塼̤ɽ롢ƥͭå
 ************************************************************************/

int	menu_about_osd_msg(int        req_japanese,
			   int        *result_code,
			   const char *message[])
{
    static const char *about_en =
    {
	"Mouse and joystick are not supported.\n"
	"\n"
	"Many many menu items are not available.\n"
    };

    static const char *about_jp =
    {
	"®٤˴ؤѹǤޤ\n"
	"ޥ祤ƥåϻѤǤޤ\n"
	"ޥɽϥݡȤƤޤ\n"
	"եȥ NumLock ϥݡȤƤޤ\n"
	"եɤ߹ߤϥݡȤƤޤ\n"
    };


    *result_code = -1;				/* ʸɻʤ */

    if (req_japanese == FALSE) {
	*message = about_en;
    } else {
	*message = about_jp;
    }

    return TRUE;
}
